/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cias.vsmp.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CaculateUtil {
    public static String formatDate(Object obj, String format) {
        if (obj == null) {
            return "";
        }
        String s = String.valueOf(obj);
        if (format == null || "".equals(format.trim())) {
            format = "yyyy-MM-dd";
        }
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            s = dateFormat.format(obj);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s;
    }

    public static String formatNumber(Object obj, String format) {
        if (obj == null) {
            return "";
        }
        String s = String.valueOf(obj);
        if (format == null || "".equals(format.trim())) {
            format = "#.00";
        }
        try {
            if (obj instanceof Double || obj instanceof Float) {
                if (format.contains("%")) {
                    NumberFormat numberFormat = NumberFormat.getPercentInstance();
                    s = numberFormat.format(obj);
                } else {
                    DecimalFormat decimalFormat = new DecimalFormat(format);
                    s = decimalFormat.format(obj);
                }
            } else {
                NumberFormat numberFormat = NumberFormat.getInstance();
                s = numberFormat.format(obj);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s;
    }

    public static String computeString(String string) {
        String regexCheck = "[\\(\\)\\d\\+\\-\\*/\\.]*";
        if (!Pattern.matches(regexCheck, string = string.replaceAll(" ", ""))) {
            return string;
        }
        Matcher matcher = null;
        String temp = "";
        int index = -1;
        String regex = "\\([\\d\\.\\+\\-\\*/]+\\)";
        string = string.replaceAll("\\s", "");
        try {
            Pattern pattern = Pattern.compile(regex);
            while (pattern.matcher(string).find()) {
                matcher = pattern.matcher(string);
                while (matcher.find()) {
                    temp = matcher.group();
                    index = string.indexOf(temp);
                    string = string.substring(0, index) + CaculateUtil.computeStirngNoBracket(temp) + string.substring(index + temp.length());
                }
            }
            string = CaculateUtil.computeStirngNoBracket(string);
        }
        catch (NumberFormatException e) {
            return e.getMessage();
        }
        return string;
    }

    private static String computeStirngNoBracket(String string) {
        string = string.replaceAll("(^\\()|(\\)$)", "");
        String regexMultiAndDivision = "[\\d\\.]+(\\*|\\/)[\\d\\.]+";
        String regexAdditionAndSubtraction = "(^\\-)?[\\d\\.]+(\\+|\\-)[\\d\\.]+";
        String temp = "";
        int index = -1;
        Pattern pattern = Pattern.compile(regexMultiAndDivision);
        Matcher matcher = null;
        while (pattern.matcher(string).find()) {
            matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            temp = matcher.group();
            index = string.indexOf(temp);
            string = string.substring(0, index) + CaculateUtil.doMultiAndDivision(temp) + string.substring(index + temp.length());
        }
        pattern = Pattern.compile(regexAdditionAndSubtraction);
        while (pattern.matcher(string).find()) {
            matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            temp = matcher.group();
            index = string.indexOf(temp);
            if (temp.startsWith("-")) {
                string = string.substring(0, index) + CaculateUtil.doNegativeOperation(temp) + string.substring(index + temp.length());
                continue;
            }
            string = string.substring(0, index) + CaculateUtil.doAdditionAndSubtraction(temp) + string.substring(index + temp.length());
        }
        return string;
    }

    private static String doMultiAndDivision(String string) {
        String value = "";
        double d1 = 0.0;
        double d2 = 0.0;
        String[] temp = null;
        temp = string.contains("*") ? string.split("\\*") : string.split("/");
        if (temp.length < 2) {
            return string;
        }
        d1 = Double.valueOf(temp[0]);
        d2 = Double.valueOf(temp[1]);
        value = string.contains("*") ? String.valueOf(d1 * d2) : String.valueOf(d1 / d2);
        return value;
    }

    private static String doAdditionAndSubtraction(String string) {
        double d1 = 0.0;
        double d2 = 0.0;
        String[] temp = null;
        String value = "";
        temp = string.contains("+") ? string.split("\\+") : string.split("\\-");
        if (temp.length < 2) {
            return string;
        }
        d1 = Double.valueOf(temp[0]);
        d2 = Double.valueOf(temp[1]);
        value = string.contains("+") ? String.valueOf(d1 + d2) : String.valueOf(d1 - d2);
        return value;
    }

    public static double parsePercentFromString(String strPercent) {
        if (strPercent != null && !strPercent.equals("")) {
            try {
                NumberFormat format = NumberFormat.getPercentInstance();
                return format.parse(strPercent).doubleValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0.0;
    }

    public static String percentFormat(double number) throws Exception {
        NumberFormat format = NumberFormat.getPercentInstance();
        return format.format(number);
    }

    private static String doNegativeOperation(String string) {
        String temp = string.substring(1);
        temp = temp.contains("+") ? temp.replace("+", "-") : temp.replace("-", "+");
        temp = CaculateUtil.doAdditionAndSubtraction(temp);
        temp = temp.startsWith("-") ? temp.substring(1) : "-" + temp;
        return temp;
    }

    public static String doDivision(long res, long arg) {
        BigDecimal bdRes = new BigDecimal(res);
        if (arg != 0L) {
            BigDecimal bdArg = new BigDecimal(arg);
            BigDecimal bdDiv = bdRes.divide(bdArg, 3, 6);
            return bdDiv.toPlainString();
        }
        return null;
    }
}

