/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cias.vsmp.util;

import com.xdja.cias.vsmp.util.ByteUtils;
import com.xdja.cias.vsmp.util.JceKeyPairUtil;
import io.netty.util.CharsetUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.RSAPrivateKeyStructure;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Encoder;

public class CertUtil {
    private static Logger log = LoggerFactory.getLogger(CertUtil.class);
    public static final String CERT_HEAD = "-----BEGIN CERTIFICATE-----";
    public static final String CERT_TAIL = "-----END CERTIFICATE-----";
    public static final String SIGN_CERT_CN_TESTKEY = "_testkey";
    public static final String SIGN_CERT_CN_PLATFORM = "_platform";
    public static final String SIGN_CERT_CN_SHARED = "_shared";
    public static final String SIGN_CERT_CN_MEDIA = "_media";
    public static final String CERT_USEAGE_GW = "enc";
    public static final String CERT_USEAGE_SIGN = "sign";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate getCertFromStandFile(File file) {
        CertificateFactory cf = null;
        FileInputStream fis = null;
        X509Certificate x509Cert = null;
        try {
            fis = new FileInputStream(file);
            cf = CertificateFactory.getInstance("X.509", "BC");
            X509Certificate x509Certificate = x509Cert = (X509Certificate)cf.generateCertificate(fis);
            return x509Certificate;
        }
        catch (Exception e) {
            log.error("getCertFromStandFile " + file.getName() + " error: " + e.toString());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    log.error("CertUtil# X509Certificate have IOException.", (Throwable)e);
                }
            }
        }
        return null;
    }

    public static X509Certificate getCertFromFullStr(String str) {
        CertificateFactory cf = null;
        X509Certificate x509Cert = null;
        try {
            cf = CertificateFactory.getInstance("X.509", "BC");
            ByteArrayInputStream inStream = new ByteArrayInputStream(str.getBytes(CharsetUtil.UTF_8));
            x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Cert;
        }
        catch (Exception e) {
            log.error("getCertFromFullStr error: " + e.toString());
            return null;
        }
    }

    public static X509Certificate getCertFromBytes(byte[] bsCert) {
        CertificateFactory cf = null;
        X509Certificate x509Cert = null;
        try {
            cf = CertificateFactory.getInstance("X.509", "BC");
            ByteArrayInputStream inStream = new ByteArrayInputStream(bsCert);
            x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Cert;
        }
        catch (Exception e) {
            log.error("getCertFromB64 error: " + e.toString());
            return null;
        }
    }

    public static String fullB64toStr(String fullB64Cert) {
        String b64Cert = null;
        if (fullB64Cert == null || fullB64Cert.length() == 0) {
            return null;
        }
        try {
            b64Cert = fullB64Cert.replace(CERT_HEAD, "");
            b64Cert = b64Cert.replace(CERT_TAIL, "");
            b64Cert = b64Cert.replace("\r", "");
            b64Cert = b64Cert.replace("\n", "");
            return b64Cert;
        }
        catch (Exception e) {
            log.error("fullB64ToBytes error:" + e.toString());
            return null;
        }
    }

    public static String certToFullB64(Certificate cert) {
        String certb64 = null;
        try {
            certb64 = CertUtil.bytesToFullB64(cert.getEncoded());
        }
        catch (Exception e) {
            log.error("certToFullB64 error:" + e.toString());
        }
        return certb64;
    }

    public static String strToFullB64(String cert) {
        StringBuffer sb = new StringBuffer();
        String certb64tmp = "";
        try {
            int i;
            certb64tmp = cert;
            boolean flag = certb64tmp.length() % 64 != 0;
            for (i = 0; i < certb64tmp.length() / 64; ++i) {
                sb.append(certb64tmp.substring(i * 64, (i + 1) * 64) + "\r\n");
            }
            sb.append(certb64tmp.substring(i * 64));
            if (!flag) {
                sb.insert(0, "-----BEGIN CERTIFICATE-----\r\n");
                sb.append(CERT_TAIL);
            } else {
                sb.insert(0, "-----BEGIN CERTIFICATE-----\r\n");
                sb.append("\r\n-----END CERTIFICATE-----");
            }
            return sb.toString();
        }
        catch (Exception e) {
            log.error("certToFullB64 error:" + e.toString());
            return null;
        }
    }

    public static String bytesToFullB64(byte[] certder) {
        String certb64 = null;
        try {
            BASE64Encoder encoder = new BASE64Encoder();
            certb64 = encoder.encode(certder);
            certb64 = "-----BEGIN CERTIFICATE-----\r\n" + certb64 + "\r\n" + CERT_TAIL;
            return certb64;
        }
        catch (Exception e) {
            log.error("certDerToFullB64 error:" + e.toString());
            return null;
        }
    }

    public static String convertCardNo2DN(String cardNo, String o, String ou, String caAlg) {
        String certDN = null;
        String title = "";
        if (cardNo != null && cardNo.length() > 0) {
            certDN = CertUtil.buildDN(cardNo, o, ou, caAlg, title);
        }
        return certDN;
    }

    public static String buildDN(String cardNo, String o, String ou, String caAlg, String title) {
        StringBuilder certDN = new StringBuilder("CN=").append(cardNo);
        if (StringUtils.isNotBlank((CharSequence)title)) {
            certDN.append("_").append(title);
        }
        certDN.append(",O=").append(o);
        certDN.append(",OU=").append(ou);
        certDN.append(",C=cn");
        return certDN.toString();
    }

    public static String getSn(String certBase64Str) {
        X509Certificate cert = CertUtil.getCertFromB64(certBase64Str);
        if (cert != null) {
            return CertUtil.getSn(cert);
        }
        return null;
    }

    public static X509Certificate getCertFromB64(String b64) {
        b64 = StringUtils.replace((String)b64, (String)CERT_HEAD, (String)"");
        b64 = StringUtils.replace((String)b64, (String)"\r", (String)"");
        b64 = StringUtils.replace((String)b64, (String)"\n", (String)"");
        b64 = StringUtils.replace((String)b64, (String)CERT_TAIL, (String)"");
        CertificateFactory cf = null;
        X509Certificate x509Cert = null;
        try {
            cf = CertificateFactory.getInstance("X.509", "BC");
            byte[] bsCert = org.bouncycastle.util.encoders.Base64.decode((String)b64);
            ByteArrayInputStream inStream = new ByteArrayInputStream(bsCert);
            x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Cert;
        }
        catch (Exception e) {
            log.error("getCertFromB64 error: " + e.toString());
            return null;
        }
    }

    public static String getSn(X509Certificate cert) {
        String sn = cert.getSerialNumber().toString(16).toLowerCase();
        if (sn.length() % 2 != 0) {
            return "0" + sn;
        }
        return cert.getSerialNumber().toString(16).toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String extractPrivateKey(PrivateKey key) {
        String result = null;
        ASN1InputStream in = null;
        ASN1InputStream asn1InputStream = null;
        try {
            DEROctetString derOctetString;
            DERObject obj;
            in = new ASN1InputStream(key.getEncoded());
            DEREncodable encode = null;
            while ((obj = in.readObject()) != null) {
                ASN1Sequence seq = ASN1Sequence.getInstance((Object)obj);
                encode = seq.getObjectAt(2);
            }
            if (encode != null && (derOctetString = (DEROctetString)encode.getDERObject()) != null) {
                DERObject obj1;
                asn1InputStream = new ASN1InputStream(derOctetString.getOctets());
                byte[] privateKeyBytes = null;
                while ((obj1 = asn1InputStream.readObject()) != null) {
                    ASN1Sequence seq = DERSequence.getInstance((Object)obj1);
                    privateKeyBytes = seq.getObjectAt(1).getDERObject().getDEREncoded();
                }
                if (privateKeyBytes != null) {
                    byte[] keyBytes = new byte[32];
                    if (keyBytes.length == 34) {
                        System.arraycopy(privateKeyBytes, 2, keyBytes, 0, 32);
                    } else {
                        keyBytes[0] = 0;
                        System.arraycopy(privateKeyBytes, 2, keyBytes, 1, 31);
                    }
                    result = Base64.encodeBase64String((byte[])keyBytes);
                }
            }
        }
        catch (Exception e) {
            log.error("CertUtil.extractPrivateKey()===>", (Throwable)e);
            result = null;
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error("", (Throwable)e);
                }
            }
            if (null != asn1InputStream) {
                try {
                    asn1InputStream.close();
                }
                catch (IOException e) {
                    log.error("", (Throwable)e);
                }
            }
        }
        log.debug("private key,base64Value:" + result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String extractPrivateKeyForRsa(PrivateKey key) {
        String result = null;
        ASN1InputStream in = null;
        ASN1InputStream asn1InputStream = null;
        try {
            DERObject obj1;
            DEROctetString derOctetString;
            DERObject obj;
            in = new ASN1InputStream(key.getEncoded());
            DEREncodable encode = null;
            while ((obj = in.readObject()) != null) {
                ASN1Sequence seq = ASN1Sequence.getInstance((Object)obj);
                encode = seq.getObjectAt(2);
            }
            if (encode != null && (derOctetString = (DEROctetString)encode.getDERObject()) != null && (obj1 = (asn1InputStream = new ASN1InputStream(derOctetString.getOctets())).readObject()) != null) {
                ASN1Sequence seq = DERSequence.getInstance((Object)obj1);
                String str = CertUtil.getPrivateKeyUnit5(seq);
                log.info("size:{},getPrivateKeyUnit5:{}", (Object)str.length(), (Object)str);
                String string = str;
                return string;
            }
        }
        catch (Exception e) {
            log.error("CertUtil.extractPrivateKey()===>", (Throwable)e);
            result = null;
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error("", (Throwable)e);
                }
            }
            if (null != asn1InputStream) {
                try {
                    asn1InputStream.close();
                }
                catch (IOException e) {
                    log.error("", (Throwable)e);
                }
            }
        }
        log.debug("private key,base64Value:" + result);
        return result;
    }

    private static String getPrivateKeyUnit5(ASN1Sequence seq) {
        String result = "";
        RSAPrivateKeyStructure s = new RSAPrivateKeyStructure(seq);
        byte[] prime1 = s.getPrime1().toByteArray();
        String prime1Str = ByteUtils.bytes2Hex(prime1);
        byte[] prime2 = s.getPrime2().toByteArray();
        String prime2Str = ByteUtils.bytes2Hex(prime2);
        byte[] exponent1 = s.getExponent1().toByteArray();
        String exponent1Str = ByteUtils.bytes2Hex(exponent1);
        byte[] exponent2 = s.getExponent2().toByteArray();
        String exponent2Str = ByteUtils.bytes2Hex(exponent2);
        byte[] coefficient = s.getCoefficient().toByteArray();
        String coefficientStr = ByteUtils.bytes2Hex(coefficient);
        Object[] arr = new String[]{prime1Str, prime2Str, exponent1Str, exponent2Str, coefficientStr};
        result = StringUtils.join((Object[])arr, (String)"");
        return result;
    }

    public static String extractPublicKeyForRsa(PublicKey key) {
        String result = null;
        if (key != null) {
            result = Hex.encodeHexString((byte[])key.getEncoded());
        }
        return result;
    }

    public static String getPublicKeyAndPrivateKeyForRsa(int keySize) {
        String result = null;
        KeyPair keyPair = JceKeyPairUtil.createKeypairForRSA(keySize);
        String publicKey = CertUtil.extractPublicKeyForRsa(keyPair.getPublic());
        String privateKey = CertUtil.extractPrivateKeyForRsa(keyPair.getPrivate());
        System.out.println("size:" + privateKey.length() + ",privateKey:" + privateKey + "");
        if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{publicKey, privateKey})) {
            result = publicKey + "," + privateKey;
        }
        return result;
    }

    public static byte hexToByte(String inHex) {
        return (byte)Integer.parseInt(inHex, 16);
    }

    public static byte[] hexToByteArray(String inHex) {
        byte[] result;
        int hexlen = inHex.length();
        if (hexlen % 2 == 1) {
            result = new byte[++hexlen / 2];
            inHex = "0" + inHex;
        } else {
            result = new byte[hexlen / 2];
        }
        int j = 0;
        for (int i = 0; i < hexlen; i += 2) {
            result[j] = CertUtil.hexToByte(inHex.substring(i, i + 2));
            ++j;
        }
        return result;
    }

    public static void analyzeCert(String cert) {
        switch (cert) {
            case "0": {
                log.debug("SQY42-D\u8fd4\u56de\u7801[0]\u8bf4\u660e\uff1a\u6ca1\u6709\u64cd\u4f5c\u6743\u9650");
                break;
            }
            case "1": {
                log.debug("SQY42-D\u8fd4\u56de\u7801[1]\u8bf4\u660e\uff1a\u6210\u529f");
                break;
            }
            case "2": {
                log.debug("SQY42-D\u8fd4\u56de\u7801[2]\u8bf4\u660e\uff1a\u5931\u8d25");
                break;
            }
            case "3": {
                log.debug("SQY42-D\u8fd4\u56de\u7801[3]\u8bf4\u660e\uff1a\u8bc1\u4e66\u5df2\u5b58\u5728");
                break;
            }
            case "4": {
                log.debug("SQY42-D\u8fd4\u56de\u7801[4]\u8bf4\u660e\uff1a\u8bc1\u4e66\u4e0d\u5b58\u5728");
                break;
            }
            case "5": {
                log.debug("SQY42-D\u8fd4\u56de\u7801[5]\u8bf4\u660e\uff1a\u4e0d\u652f\u6301\u7684CA\u7c7b\u578b");
                break;
            }
            case "6": {
                log.debug("SQY42-D\u8fd4\u56de\u7801[6]\u8bf4\u660e\uff1aCA\u9519\u8bef");
                break;
            }
            case "7": {
                log.debug("SQY42-D\u8fd4\u56de\u7801[7]\u8bf4\u660e\uff1a\u5361\u7c7b\u578b\u9519\u8bef");
                break;
            }
            case "8": {
                log.debug("SQY42-D\u8fd4\u56de\u7801[8]\u8bf4\u660e\uff1a\u5361\u53f7\u4e3a\u7a7a");
                break;
            }
            case "9": {
                log.debug("SQY42-D\u8fd4\u56de\u7801[9]\u8bf4\u660e\uff1a\u64cd\u4f5c\u8005\u4e3a\u7a7a");
                break;
            }
            case "10": {
                log.debug("SQY42-D\u8fd4\u56de\u7801[10]\u8bf4\u660e\uff1a\u516c\u94a5\u9519\u8bef");
                break;
            }
            case "11": {
                log.debug("SQY42-D\u8fd4\u56de\u7801[11]\u8bf4\u660e\uff1aP10\u9519\u8bef");
                break;
            }
            case "12": {
                log.debug("SQY42-D\u8fd4\u56de\u7801[12]\u8bf4\u660e\uff1a\u4eceP7\u4e2d\u83b7\u53d6\u8bc1\u4e66\u65f6\u9519\u8bef");
                break;
            }
            case "13": {
                log.debug("SQY42-D\u8fd4\u56de\u7801[13]\u8bf4\u660e\uff1a\u6570\u636e\u5e93\u9519\u8bef");
                break;
            }
            case "14": {
                log.debug("SQY42-D\u8fd4\u56de\u7801[14]\u8bf4\u660e\uff1a\u8bc1\u4e66\u5df2\u88ab\u51bb\u7ed3");
                break;
            }
            case "15": {
                log.debug("SQY42-D\u8fd4\u56de\u7801[15]\u8bf4\u660e\uff1a\u8bc1\u4e66\u5df2\u88ab\u540a\u9500");
                break;
            }
            case "16": {
                log.debug("SQY42-D\u8fd4\u56de\u7801[16]\u8bf4\u660e\uff1a\u8bc1\u4e66\u5df2\u8fc7\u671f");
                break;
            }
            case "17": {
                log.debug("SQY42-D\u8fd4\u56de\u7801[17]\u8bf4\u660e\uff1a\u72b6\u6001\u6b63\u5e38\u7684\u8bc1\u4e66");
                break;
            }
            case "18": {
                log.debug("SQY42-D\u8fd4\u56de\u7801[18]\u8bf4\u660e\uff1a\u65e0\u6548\u7684\u8bc1\u4e66");
                break;
            }
            case "19": {
                log.debug("SQY42-D\u8fd4\u56de\u7801[19]\u8bf4\u660e\uff1a\u63a5\u53e3\u7248\u672c\u53f7\u9519\u8bef");
                break;
            }
            case "20": {
                log.debug("SQY42-D\u8fd4\u56de\u7801[20]\u8bf4\u660e\uff1aLicense\u6587\u4ef6\u4e0d\u5b58\u5728");
                break;
            }
            case "21": {
                log.debug("SQY42-D\u8fd4\u56de\u7801[21]\u8bf4\u660e\uff1alisense\u6587\u4ef6\u6709\u6548\u671f\u9519\u8bef");
                break;
            }
            case "22": {
                log.debug("SQY42-D\u8fd4\u56de\u7801[22]\u8bf4\u660e\uff1alisense\u6587\u4ef6\u5176\u4ed6\u9519\u8bef");
                break;
            }
            case "23": {
                log.debug("SQY42-D\u8fd4\u56de\u7801[23]\u8bf4\u660e\uff1a\u8bc1\u4e66\u6570\u91cf\u8d85\u8fc7lisense\u6587\u4ef6\u9650\u5236");
                break;
            }
            case "24": {
                log.debug("SQY42-D\u8fd4\u56de\u7801[24]\u8bf4\u660e\uff1a\u5176\u5b83\u9519\u8bef");
                break;
            }
            case "25": {
                log.debug("SQY42-D\u8fd4\u56de\u7801[25]\u8bf4\u660e\uff1aCA\u8bc1\u4e66\u4e0d\u5b58\u5728");
                break;
            }
            case "26": {
                log.debug("SQY42-D\u8fd4\u56de\u7801[26]\u8bf4\u660e\uff1aRA\u5f02\u5e38");
                break;
            }
            case "27": {
                log.debug("SQY42-D\u8fd4\u56de\u7801[27]\u8bf4\u660e\uff1a\u6ca1\u6709\u4f7f\u7528HTTPS");
                break;
            }
            case "28": {
                log.debug("SQY42-D\u8fd4\u56de\u7801[28]\u8bf4\u660e\uff1a\u8bbe\u5907\u540d\u548c\u8bc1\u4e66\u4e0d\u914d\u5957");
                break;
            }
            case "29": {
                log.debug("SQY42-D\u8fd4\u56de\u7801[29]\u8bf4\u660e\uff1aCA\u672a\u521d\u59cb\u5316");
                break;
            }
            default: {
                log.debug("SQY42-D\u8fd4\u56de\u7801[]\u8bf4\u660e\uff1a\u4e0d\u5b58\u5728\u7684\u8fd4\u56de\u7801");
            }
        }
    }

    public static void main(String[] args) {
        String certStr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
        byte[] bytes = ByteUtils.hex2bytes(certStr);
        X509Certificate x509 = CertUtil.getCertFromBytes(bytes);
        String str = CertUtil.certToFullB64(x509);
        String hex = ByteUtils.bytes2Hex(str.getBytes());
        System.out.println(hex);
        System.out.println(new String(ByteUtils.hex2bytes(hex)));
        System.out.println(new String(ByteUtils.hex2bytes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
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

