/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cias.vsmp.util;

import cn.com.infosec.jce.provider.InfosecProvider;
import com.xdja.cias.vsmp.util.CertUtil;
import io.netty.util.CharsetUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CreateP10 {
    private static Logger log = LoggerFactory.getLogger(CreateP10.class);

    public static String createP10(String pubkeyBase64, String cn, String o, String ou, int cardType) {
        String p10 = "";
        try {
            int i = 0;
            byte[] pubdata0 = null;
            try {
                pubdata0 = Base64.decode((String)pubkeyBase64);
            }
            catch (Exception e) {
                return null;
            }
            int pub0len = pubdata0.length;
            if (pub0len != 128) {
                if (pub0len == 256) {
                    p10 = CreateP10.createP10Rsa2048(pubkeyBase64, cn, o, ou, cardType);
                    return p10;
                }
                System.out.println("\u516c\u94a5\u4e0d\u5bf9" + pub0len);
                return null;
            }
            byte[] pubhead = new byte[]{48, -127, -119, 2, -127, -127, 0};
            byte[] pubtile = new byte[]{2, 3, 1, 0, 1};
            int pubheadlen = pubhead.length;
            int pubtilelen = pubtile.length;
            int publen = pubheadlen + pubtilelen + pub0len;
            byte[] pubdata = new byte[publen];
            for (i = 0; i < pubheadlen; ++i) {
                pubdata[i] = pubhead[i];
            }
            for (i = 0; i < pub0len; ++i) {
                pubdata[i + pubheadlen] = pubdata0[i];
            }
            for (i = 0; i < pubtilelen; ++i) {
                pubdata[i + pubheadlen + pub0len] = pubtile[i];
            }
            SubjectPublicKeyInfo spi = new SubjectPublicKeyInfo(new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.113549.1.1.1")), pubdata);
            CertificationRequestInfo cf1 = new CertificationRequestInfo(new X509Name(CertUtil.convertCardNo2DN(cn, o, ou, "1.0")), spi, null);
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            DEROutputStream derOutStream = new DEROutputStream((OutputStream)outStream);
            derOutStream.writeObject((Object)cf1);
            byte[] tbsdata = outStream.toByteArray();
            DERBitString dbs = new DERBitString(tbsdata);
            CertificationRequest cr = new CertificationRequest(cf1, new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.113549.1.1.5")), dbs);
            ByteArrayOutputStream outStream1 = new ByteArrayOutputStream();
            DEROutputStream derOutStream1 = new DEROutputStream((OutputStream)outStream1);
            derOutStream1.writeObject((Object)cr);
            byte[] p10data = outStream1.toByteArray();
            p10 = new String(Base64.encode((byte[])p10data)).replace("\n", "").replaceAll("\r", "");
        }
        catch (Exception e) {
            System.out.println("\u751f\u6210p10\u65f6\u9519\u8bef\u3002cn= " + cn);
            e.printStackTrace();
            p10 = "";
        }
        return p10;
    }

    private static String createP10Rsa2048(String pubkey, String cn, String o, String ou, int cardType) {
        String p10 = "";
        try {
            int i = 0;
            Security.addProvider((Provider)new InfosecProvider());
            byte[] pubdata0 = Base64.decode((String)pubkey);
            byte[] pubhead = new byte[]{48, -126, 1, 10, 2, -126, 1, 1, 0};
            byte[] pubtile = new byte[]{2, 3, 1, 0, 1};
            int pubheadlen = pubhead.length;
            int pubtilelen = pubtile.length;
            int pub0len = pubdata0.length;
            int publen = pubheadlen + pubtilelen + pub0len;
            byte[] pubdata = new byte[publen];
            for (i = 0; i < pubheadlen; ++i) {
                pubdata[i] = pubhead[i];
            }
            for (i = 0; i < pub0len; ++i) {
                pubdata[i + pubheadlen] = pubdata0[i];
            }
            for (i = 0; i < pubtilelen; ++i) {
                pubdata[i + pubheadlen + pub0len] = pubtile[i];
            }
            SubjectPublicKeyInfo spi = new SubjectPublicKeyInfo(new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.113549.1.1.1")), pubdata);
            CertificationRequestInfo cf1 = new CertificationRequestInfo(new X509Name(CertUtil.convertCardNo2DN(cn, o, ou, "1.0")), spi, null);
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            DEROutputStream derOutStream = new DEROutputStream((OutputStream)outStream);
            derOutStream.writeObject((Object)cf1);
            byte[] tbsdata = outStream.toByteArray();
            DERBitString dbs = new DERBitString(tbsdata);
            CertificationRequest cr = new CertificationRequest(cf1, new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.113549.1.1.11")), dbs);
            ByteArrayOutputStream outStream1 = new ByteArrayOutputStream();
            DEROutputStream derOutStream1 = new DEROutputStream((OutputStream)outStream1);
            derOutStream1.writeObject((Object)cr);
            byte[] p10data = outStream1.toByteArray();
            p10 = new String(Base64.encode((byte[])p10data)).replace("\n", "").replaceAll("\r", "");
        }
        catch (Exception e) {
            System.out.println("\u751f\u6210p10\u65f6\u9519\u8bef\u3002cn= " + cn);
            e.printStackTrace();
            p10 = "";
        }
        return p10;
    }

    public static String createP10FromPubkeyDer(byte[] pubDer, String cn, String o, String ou, int cardType, String caAlg) {
        String dn = CertUtil.convertCardNo2DN(cn, o, ou, caAlg);
        return CreateP10.createP10FromPubkeyDer(pubDer, dn, caAlg);
    }

    public static String createP10FromPubkeyDer(String b64PublicKey, String dn, String caAlg) {
        byte[] pubDer = Base64.decode((byte[])b64PublicKey.getBytes(CharsetUtil.UTF_8));
        return CreateP10.createP10FromPubkeyDer(pubDer, dn, caAlg);
    }

    public static String createP10FromPubkeyDer(byte[] pubDer, String dn, String caAlg) {
        String p10 = "";
        try {
            ASN1Sequence seq = ASN1Sequence.getInstance((Object)pubDer);
            SubjectPublicKeyInfo spi = new SubjectPublicKeyInfo(seq);
            CertificationRequestInfo cf1 = new CertificationRequestInfo(new X509Name(dn), spi, null);
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            DEROutputStream derOutStream = new DEROutputStream((OutputStream)outStream);
            derOutStream.writeObject((Object)cf1);
            byte[] tbsdata = outStream.toByteArray();
            DERBitString dbs = new DERBitString(tbsdata);
            CertificationRequest cr = new CertificationRequest(cf1, new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.113549.1.1.4")), dbs);
            ByteArrayOutputStream outStream1 = new ByteArrayOutputStream();
            DEROutputStream derOutStream1 = new DEROutputStream((OutputStream)outStream1);
            derOutStream1.writeObject((Object)cr);
            byte[] p10data = outStream1.toByteArray();
            p10 = new String(Base64.encode((byte[])p10data), CharsetUtil.UTF_8).replace("\n", "").replaceAll("\r", "");
        }
        catch (Exception e) {
            log.error("error,dn=" + dn, (Throwable)e);
            p10 = "";
        }
        return p10;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

