/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cias.vsmp.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public final class DateUtil {
    public static final int ONE_MINUTE_TIME_SECOND = 60;
    public static final int ONE_HOUR_TIME_SECOND = 3600;
    public static final int ONE_DAY_TIME_SECOND = 86400;

    public static boolean checkInMoth(Date startTime) {
        if (startTime == null) {
            return false;
        }
        Calendar monthFirstDay = DateUtil.getMonthFirstDay();
        Date monthLastDay = DateUtil.getMonthLastDay(monthFirstDay).getTime();
        return startTime.compareTo(monthFirstDay.getTime()) >= 0 && startTime.compareTo(monthLastDay) <= 0;
    }

    public static boolean checkInWeek(Date startTime) {
        if (startTime == null) {
            return false;
        }
        Calendar weekFirstDay = DateUtil.getWeekFirstDay();
        Date weekLastDay = DateUtil.getWeekLastDay(weekFirstDay).getTime();
        return startTime.compareTo(weekFirstDay.getTime()) >= 0 && startTime.compareTo(weekLastDay) <= 0;
    }

    public static Calendar getWeekFirstDay() {
        Calendar now = Calendar.getInstance();
        DateUtil.resetTime(now);
        int day_of_week = now.get(7) - 2;
        now.add(5, -day_of_week);
        return now;
    }

    public static Calendar getWeekLastDay(Calendar weekFirstDay) {
        weekFirstDay.add(5, 6);
        DateUtil.setMaxTime(weekFirstDay);
        return weekFirstDay;
    }

    public static Calendar getMonthFirstDay() {
        Calendar now = Calendar.getInstance();
        now.set(5, 1);
        DateUtil.resetTime(now);
        return now;
    }

    public static Calendar getYearFirstDay() {
        Calendar now = Calendar.getInstance();
        now.set(5, 1);
        now.set(2, 0);
        DateUtil.resetTime(now);
        return now;
    }

    public static Calendar getYearLastDay(Calendar yearFirstDay) {
        yearFirstDay.add(1, 1);
        yearFirstDay.add(2, 0);
        yearFirstDay.set(5, 0);
        DateUtil.setMaxTime(yearFirstDay);
        return yearFirstDay;
    }

    public static Calendar getMonthLastDay(Calendar monthFirstDay) {
        monthFirstDay.add(2, 1);
        monthFirstDay.set(5, 0);
        DateUtil.setMaxTime(monthFirstDay);
        return monthFirstDay;
    }

    public static void resetTime(Calendar time) {
        time.set(11, 0);
        time.set(12, 0);
        time.set(13, 0);
        time.set(14, 0);
    }

    public static void setMaxTime(Calendar time) {
        time.set(11, 23);
        time.set(12, 59);
        time.set(13, 59);
        time.set(14, 999);
    }

    public static String timeIntervalToStr(long time) {
        long seconds;
        long minutes;
        long hours;
        String result = "";
        long days = time / 86400L;
        if (days > 0L) {
            result = result + days + "\u5929";
        }
        if ((hours = (time - days * 86400L) / 3600L) > 0L) {
            result = result + hours + "\u5c0f\u65f6";
        }
        if ((minutes = (time - days * 86400L - hours * 60L * 60L) / 60L) > 0L) {
            result = result + minutes + "\u5206";
        }
        if ((seconds = time - days * 86400L - hours * 60L * 60L - minutes * 60L) > 0L) {
            result = result + seconds + "\u79d2";
        }
        return StringUtils.isBlank((CharSequence)result) ? "0\u79d2" : result;
    }

    public static long getPreDay() {
        long time = 0L;
        Calendar c = Calendar.getInstance();
        DateUtil.resetTime(c);
        c.add(5, -1);
        time = c.getTimeInMillis();
        return time;
    }

    public static long getPreHours(int hour) {
        long time = 0L;
        Calendar c = Calendar.getInstance();
        c.add(11, hour);
        time = c.getTimeInMillis();
        return time;
    }

    public static String getIntervalTimeStr(long timeInterval) {
        long hours;
        String timeStr = "";
        long minute = timeInterval / 1000L / 60L;
        timeStr = minute < 1L ? "\u5c0f\u4e8e1\u5206\u949f" : (minute < 60L ? minute + "\u5206\u949f" : ((hours = minute / 60L) < 24L ? hours + "\u5c0f\u65f6" + minute % 60L + "\u5206\u949f" : hours / 24L + "\u5929" + hours % 24L + "\u5c0f\u65f6" + minute % 60L + "\u5206\u949f"));
        return timeStr;
    }

    public static String getTimeStr(long timeInterval) {
        Long second = 0L;
        Long minute = 0L;
        Long hour = 0L;
        Long day = 0L;
        Long year = 0L;
        second = timeInterval % 60L;
        minute = timeInterval / 60L;
        if (minute == 0L) {
            return String.format("%d\u79d2", second);
        }
        if (minute < 60L) {
            return String.format("%d\u5206%d\u79d2", minute, second);
        }
        hour = minute / 60L;
        minute = minute % 60L;
        if (hour < 24L) {
            return String.format("%d\u65f6%d\u5206%d\u79d2", hour, minute, second);
        }
        day = hour / 24L;
        hour = hour % 24L;
        if (day < 365L) {
            return String.format("%d\u5929%d\u65f6%d\u5206%d\u79d2", day, hour, minute, second);
        }
        year = day / 365L;
        day = day % 365L;
        return String.format("%d\u5e74%d\u5929%d\u65f6%d\u5206%d\u79d2", year, day, hour, minute, second);
    }

    public static String getTimeStr1(long timeInterval) {
        Long second = 0L;
        Long minute = 0L;
        Long hour = 0L;
        Long day = 0L;
        Long year = 0L;
        minute = timeInterval / 60L;
        if (minute == 0L) {
            return String.format("%d\u79d2", 0);
        }
        if (minute < 60L) {
            return String.format("%d\u5206", minute);
        }
        hour = minute / 60L;
        minute = minute % 60L;
        if (hour < 24L) {
            return String.format("%d\u65f6%d\u5206", hour, minute);
        }
        day = hour / 24L;
        hour = hour % 24L;
        if (day < 365L) {
            return String.format("%d\u5929%d\u65f6%d\u5206", day, hour, minute);
        }
        year = day / 365L;
        day = day % 365L;
        return String.format("%d\u5e74%d\u5929%d\u65f6%d\u5206", year, day, hour, minute);
    }

    public static String getDateTimeStr(long time) {
        Date d = new Date(time);
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sd.format(d);
    }

    public static String getChineseDateStr(long time) {
        Date d = new Date(time);
        SimpleDateFormat sd = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        return sd.format(d);
    }

    public static String getDateStr(long time) {
        Date d = new Date(time);
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        return sd.format(d);
    }

    public static String getChineseMonthStr(long time) {
        Date d = new Date(time);
        SimpleDateFormat sd = new SimpleDateFormat("yyyy\u5e74MM\u6708");
        return sd.format(d);
    }

    public static String getMonthStr(long time) {
        Date d = new Date(time);
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM");
        return sd.format(d);
    }

    public static String getChineseDate(int i) {
        Date d = new Date();
        if (i == 2) {
            d = new Date(System.currentTimeMillis() - 86400000L);
        } else if (i == 3) {
            d = new Date(System.currentTimeMillis() - 172800000L);
        }
        SimpleDateFormat sd = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        return sd.format(d);
    }

    public static String getChineseMonth(int i) {
        Date d = new Date();
        Calendar c = Calendar.getInstance();
        if (i == 2) {
            c.add(2, -1);
            d = c.getTime();
        } else if (i == 3) {
            c.add(2, -2);
            d = c.getTime();
        }
        SimpleDateFormat sd = new SimpleDateFormat("yyyy\u5e74MM\u6708");
        return sd.format(d);
    }

    public static long getPreDayTime() {
        Calendar c = Calendar.getInstance();
        c.add(5, -1);
        return c.getTimeInMillis();
    }

    public static String getPreDayStr() {
        Calendar c = Calendar.getInstance();
        c.add(5, -1);
        Date d = c.getTime();
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        return sd.format(d);
    }

    public static long getTime(String timeStr) {
        Date date = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            date = formatter.parse(timeStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date.getTime();
    }

    public static Long toTimestamp(String params) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date date = new Date();
        try {
            date = simpleDateFormat.parse(params);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date.getTime();
    }
}

