/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cias.vsmp.util;

import com.xdja.cias.vsmp.util.ExcelStyle;
import com.xdja.platform.log.Logger;
import com.xdja.platform.log.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellRangeAddress;

public class ExcelExport {
    public Logger logger = LoggerFactory.getLogger(this.getClass());
    private int sheetIndex = 1;
    private HSSFWorkbook workbook;
    private String fileName;
    private OutputStream stream;

    public static ExcelExport creatWorkbook() {
        HSSFWorkbook workbook = new HSSFWorkbook();
        ExcelExport exp = new ExcelExport();
        exp.workbook = workbook;
        exp.workbook.createCellStyle();
        return exp;
    }

    public static ExcelExport creatWorkbook(OutputStream out) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        ExcelExport exp = new ExcelExport();
        exp.workbook = workbook;
        exp.stream = out;
        exp.workbook.createCellStyle();
        return exp;
    }

    public static ExcelExport creatWorkbook(String FileName) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        ExcelExport exp = new ExcelExport();
        exp.workbook = workbook;
        exp.fileName = FileName;
        exp.workbook.createCellStyle();
        return exp;
    }

    private ExcelExport() {
    }

    private void adjustColumnSize(HSSFSheet sheet, int length) {
        for (int i = 0; i < length + 1; ++i) {
            sheet.autoSizeColumn(i, false);
        }
    }

    public byte[] export(List<List<Column>> data) throws IOException {
        if (data == null || data.size() == 0) {
            return null;
        }
        try {
            this.generator(data);
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faexcel\u5f02\u5e38", (Throwable)e);
            return null;
        }
        if (this.stream != null) {
            this.workbook.write(this.stream);
            this.stream.close();
        } else if (this.fileName != null && !this.fileName.trim().equals("")) {
            FileOutputStream fos = new FileOutputStream(this.fileName, true);
            this.workbook.write((OutputStream)fos);
            fos.close();
        } else {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.workbook.write((OutputStream)os);
            return os.toByteArray();
        }
        return null;
    }

    private void generator(List<List<Column>> data) throws Exception {
        List<Column> merges = null;
        String sheetName = "sheet" + this.sheetIndex;
        HSSFSheet sheet = this.workbook.createSheet(sheetName);
        int rowCount = 0;
        int rowIndex = 0;
        int rowSize = data.size();
        for (int i = 0; i < rowSize; ++i) {
            if (i - rowCount > 65000) {
                sheetName = "sheet" + ++this.sheetIndex;
                sheet = this.workbook.createSheet(sheetName);
                rowCount = 65000 * (this.sheetIndex - 1);
                this.createRow(sheet, 0, data.get(0));
            }
            merges = data.get(i);
            rowIndex = i - rowCount;
            this.createRow(sheet, rowIndex, merges);
        }
    }

    private void createRow(HSSFSheet sheet, int rowIndex, List<Column> merges) {
        int height = 0;
        Column merge = null;
        HSSFRow row = sheet.createRow(rowIndex);
        int colSize = merges.size();
        for (int j = 0; j < colSize; ++j) {
            HSSFCell cell = row.createCell(j);
            merge = merges.get(j);
            CellStyle style = merge.getCellStyle();
            if (style != null) {
                cell.setCellStyle(merge.getCellStyle());
            }
            if (j == 0) {
                height = merge.getHeight();
            }
            if (merge.getRowspan() != 0 || merge.getColspan() != 0) {
                sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex + merge.getRowspan(), j, j + merge.getColspan()));
            }
            cell.setCellValue(merge.getRichText());
        }
        if (height != 0) {
            row.setHeight((short)height);
        }
    }

    public class Column {
        private int colspan;
        private int height;
        private int rowspan;
        private CellStyle cellStyle;
        private RichTextString richText;

        public Column(RichTextString richText) {
            this.richText = richText;
        }

        public Column(String value) {
            this.setRichText((RichTextString)new HSSFRichTextString(value));
        }

        public Column(String value, int colspan, int rowspan) {
            this.setRichText((RichTextString)new HSSFRichTextString(value));
            this.colspan = colspan > 0 ? colspan : 0;
            this.rowspan = rowspan > 0 ? colspan : 0;
        }

        public CellStyle getCellStyle() {
            return this.cellStyle;
        }

        public int getColspan() {
            return this.colspan;
        }

        public int getHeight() {
            return this.height;
        }

        public RichTextString getRichText() {
            return this.richText;
        }

        public int getRowspan() {
            return this.rowspan;
        }

        public Column setCellStyle(ExcelStyle style) {
            this.cellStyle = ExcelExport.this.workbook.createCellStyle();
            style.fillStyle(this.cellStyle, ExcelExport.this.workbook);
            return this;
        }

        public Column setColspan(int colspan) {
            this.colspan = colspan > 0 ? colspan : 0;
            return this;
        }

        public Column setHeight(int height) {
            this.height = height;
            return this;
        }

        public Column setRichText(RichTextString richText) {
            this.richText = richText;
            return this;
        }

        public Column setRowspan(int rowspan) {
            this.rowspan = rowspan >= 0 ? rowspan : 0;
            return this;
        }

        public String toString() {
            return "Merge [value= colspan=" + this.colspan + ", rowspan=" + this.rowspan + "]";
        }
    }
}

