/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cias.vsmp.util;

import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelSheetParser {
    private Logger logger = LoggerFactory.getLogger(ExcelSheetParser.class);
    private HSSFWorkbook workbook;
    private int sheetNumber = 0;
    private int rowLenth = 0;

    public ExcelSheetParser(InputStream ins, int rowLenth) {
        this.rowLenth = rowLenth;
        try {
            this.workbook = new HSSFWorkbook(ins);
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u53d6\u6587\u4ef6\u51fa\u9519\uff01", (Throwable)e);
            throw new IllegalArgumentException("\u8bfb\u53d6\u6587\u4ef6\u51fa\u9519!");
        }
    }

    public List<Object[]> getDatasInSheet() throws IllegalArgumentException {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        HSSFSheet sheet = this.workbook.getSheetAt(this.sheetNumber);
        int rowCount = sheet.getLastRowNum();
        this.logger.info("found excel rows count:" + rowCount);
        if (rowCount < 1) {
            this.logger.debug("EXCEL\u6587\u4ef6\u4e2d\u4e0d\u5305\u542b\u6570\u636e!");
            throw new IllegalArgumentException("\u5bfc\u5165\u7684\u6587\u4ef6\u4e2d\u6ca1\u6709\u6570\u636e");
        }
        if (rowCount > 1000) {
            this.logger.debug("EXCEL\u6587\u4ef6\u4e2d\u6570\u636e\u5927\u4e8e1000\u6761!");
            throw new IllegalArgumentException("EXCEL\u6587\u4ef6\u4e2d\u6570\u636e\u5927\u4e8e1000\u6761!\u8bf7\u5206\u6279\u5bfc\u5165");
        }
        for (int rowIndex = 1; rowIndex <= rowCount; ++rowIndex) {
            HSSFRow row = sheet.getRow(rowIndex);
            if (null == row) continue;
            Object[] rowData = new Object[this.rowLenth + 1];
            int cellCount = row.getLastCellNum();
            if (cellCount == 0) continue;
            this.logger.debug("EXCEL\u6587\u4ef6\u4e2d\u7b2c" + (rowIndex + 1) + "\u884c\u7684\u6570\u636e\u89e3\u6790\u957f\u5ea6\u4e3a\uff1a" + cellCount);
            cellCount = this.rowLenth;
            boolean isNull = true;
            for (int cellIndex = 0; cellIndex < cellCount; ++cellIndex) {
                HSSFCell cell = row.getCell(cellIndex);
                Object cellStr = this.getCellString(cell);
                if (null != cellStr && !cellStr.equals("")) {
                    isNull = false;
                }
                rowData[cellIndex] = cellStr;
            }
            rowData[this.rowLenth] = String.valueOf(rowIndex + 1);
            if (isNull) continue;
            result.add(rowData);
        }
        return result;
    }

    private Object getCellString(HSSFCell cell) {
        Object result = null;
        if (cell != null) {
            DecimalFormat format = new DecimalFormat("0");
            int cellType = cell.getCellType();
            switch (cellType) {
                case 1: {
                    result = cell.getStringCellValue();
                    break;
                }
                case 0: {
                    result = format.format(cell.getNumericCellValue());
                    break;
                }
                case 2: {
                    result = cell.getStringCellValue().trim();
                    break;
                }
                case 4: {
                    result = cell.getBooleanCellValue();
                    break;
                }
                case 3: {
                    result = null;
                    break;
                }
                case 5: {
                    result = null;
                    break;
                }
                default: {
                    this.logger.debug("\u679a\u4e3e\u4e86\u6240\u6709\u7c7b\u578b");
                }
            }
        }
        return result;
    }
}

