/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cias.vsmp.util;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import org.bouncycastle.asn1.sm2.SM2ObjectIdentifiers;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JceKeyPairUtil {
    private static Logger log = LoggerFactory.getLogger(JceKeyPairUtil.class);

    public static KeyPair createKeypairForSm2() {
        KeyPairGenerator kpg = null;
        KeyPair keypair = null;
        try {
            SecureRandom sr = new SecureRandom();
            kpg = KeyPairGenerator.getInstance("ECSM2", "BC");
            kpg.initialize(new ECGenParameterSpec(SM2ObjectIdentifiers.sm2256.getId()), sr);
            keypair = kpg.generateKeyPair();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return keypair;
    }

    public static KeyPair createKeypairForRSA(int keySize) {
        KeyPairGenerator kpg = null;
        KeyPair keypair = null;
        try {
            SecureRandom sr = new SecureRandom();
            kpg = KeyPairGenerator.getInstance("RSA", "BC");
            kpg.initialize(new RSAKeyGenParameterSpec(keySize, RSAKeyGenParameterSpec.F4), sr);
            keypair = kpg.generateKeyPair();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return keypair;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

