package com.xdja.cssp.account.service.api.bean;

import java.io.Serializable;

/**
 * 账户信息
 * 
 * @date 2015-7-20
 * @author rrx
 * 
 */
public class Account implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 账号
	 */
	private String account;
	/**
	 * 头像地址
	 */
	private String avatar;
	/**
	 * 头像缩略图地址
	 */
	private String thumbnail;
	/**
	 * 头像下载地址
	 */
	private String avatarDownloadUrl;
	/**
	 * 缩略图下载地址
	 */
	private String thumbnailDownloadUrl;
	/**
	 * 昵称
	 */
	private String nickname;
	/**
	 * 昵称的拼音简拼
	 */
	private String nicknamePy;
	/**
	 * 昵称的拼音全拼
	 */
	private String nicknamePinyin;
	/**
	 * 绑定的手机号
	 */
	private String phone;
	/**
	 * 绑定的邮箱
	 */
	private String mail;
	/**
	 * 第一次登录时间
	 */
	private Long firstLoginTime;
	
	/**
	 * 激活状态：1-未激活，2-已激活
	 */
	private String activateStatus;

	public String getAccount() {
		return account;
	}

	public void setAccount(String account) {
		this.account = account;
	}

	public String getAvatar() {
		return avatar;
	}

	public void setAvatar(String avatar) {
		this.avatar = avatar;
	}

	public String getThumbnail() {
		return thumbnail;
	}

	public void setThumbnail(String thumbnail) {
		this.thumbnail = thumbnail;
	}

	public String getNickname() {
		return nickname;
	}

	public void setNickname(String nickname) {
		this.nickname = nickname;
	}

	public String getNicknamePy() {
		return nicknamePy;
	}

	public void setNicknamePy(String nicknamePy) {
		this.nicknamePy = nicknamePy;
	}

	public String getNicknamePinyin() {
		return nicknamePinyin;
	}

	public void setNicknamePinyin(String nicknamePinyin) {
		this.nicknamePinyin = nicknamePinyin;
	}

	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	public String getMail() {
		return mail;
	}

	public void setMail(String mail) {
		this.mail = mail;
	}

	public Long getFirstLoginTime() {
		return firstLoginTime;
	}

	public void setFirstLoginTime(Long firstLoginTime) {
		this.firstLoginTime = firstLoginTime;
	}

	/**
	 * @return 返回{@linkplain #avatarDownloadUrl}
	 */
	public String getAvatarDownloadUrl() {
		return avatarDownloadUrl;
	}

	/**
	 * @param 设定{@linkplain #avatarDownloadUrl}
	 */
	public void setAvatarDownloadUrl(String avatarDownloadUrl) {
		this.avatarDownloadUrl = avatarDownloadUrl;
	}

	/**
	 * @return 返回{@linkplain #thumbnailDownloadUrl}
	 */
	public String getThumbnailDownloadUrl() {
		return thumbnailDownloadUrl;
	}

	/**
	 * @param 设定{@linkplain #thumbnailDownloadUrl}
	 */
	public void setThumbnailDownloadUrl(String thumbnailDownloadUrl) {
		this.thumbnailDownloadUrl = thumbnailDownloadUrl;
	}

	/**
	 * @return 返回{@linkplain #activateStatus}
	 */
	public String getActivateStatus() {
		return activateStatus;
	}

	/**
	 * @param 设定{@linkplain #activateStatus}
	 */
	public void setActivateStatus(String activateStatus) {
		this.activateStatus = activateStatus;
	}

}
