package com.xdja.cssp.account.service.api.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 
 * 账户更新结果
 * 
 * @date 2015-7-20
 * @author rrx
 * 
 */
public class UpdateResult implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 本批次获取到的所有变更账户的最大更新标识，作为下一（批）次更新的lastUpdateId
	 */
	private Long lastUpdateId;
	/**
	 * 本批次获取到的所有变更账户信息
	 */
	private List<Account> accounts = new ArrayList<Account>();

	public Long getLastUpdateId() {
		return lastUpdateId;
	}

	public void setLastUpdateId(Long lastUpdateId) {
		this.lastUpdateId = lastUpdateId;
	}

	public List<Account> getAccounts() {
		return accounts;
	}

	public void setAccounts(List<Account> accounts) {
		if (null != accounts) {
			this.accounts.addAll(accounts);
		}
	}
	
	public void addAccount(Account account) {
		this.accounts.add(account);
	}
	
	@JsonIgnore
	public int getAccountSize() {
		return this.accounts.size();
	}

}
