package com.xdja.cssp.account.service;

import java.util.HashMap;
import java.util.Map;

public class Constants {
	
	/**
	 * 数据源标识 ACCOUNT 主库标识
	 */
	public static final String DB_ACCOUNT_MASTER = "db::account::master";
	/**
	 * 数据源标识 ACCOUNT 从库标识
	 */
	public static final String DB_ACCOUNT_SLAVE = "db::account::slave";
	
	/**
	 * 服务标识
	 */
	public static String HOST_ID;
	/**
	 * 应用标识
	 */
	public static String APP_ID;
	
	/**
	 * PN消息推送方式 1-直接推送消息，并缓存，消息内容会直接推送到要目标客户端，包含消息内容
	 */
	public final static int PN_MODEL_1 = 1;
	/**
	 * PN消息推送方式 2-间接推送，服务端会给目标客户端发送“new
	 * msg”通知，目标客户端收到通知后调用getpsmsg获取消息。可以不包含消息内容
	 */
	public final static int PN_MODEL_2 = 2;
	/**
	 * PN消息推送方式 3-切换mqtt server，可以不包含消息内容，发送该消息成功后，发送方需要重新调用getServer获取新的mqtt
	 * server。同时服务端会断掉老的mqtt和客户端的连接
	 */
	public final static int PN_MODEL_3 = 3;
	/**
	 * PN消息推送方式 4-直接推送消息，不缓存，包含消息内容
	 */
	public final static int PN_MODEL_4 = 4;
	
	/**
	 * 设备登录状态 0-离线
	 */
	public final static int DEVICE_STATUS_OFFLINE = 0;
	/**
	 * 设备登录状态 1-在线
	 */
	public final static int DEVICE_STATUS_ONLINE = 1;
	
	/**
	 * PN主题标识 主框架标识
	 */
	public final static String PN_TOPIC_FRAME = "/atp_frm";
	
	/**
	 * PN消息 forceLogout-强制终端下线
	 */
	public final static String PN_MSG_FORCE_LOGOUT = "forceLogout";
	/**
	 * PN消息 loginNotice-上线通知
	 */
	public final static String PN_MSG_LOGIN_NOTICE = "loginNotice";
	/**
	 * PN消息 bindDevice-绑定设备
	 */
	public final static String PN_MSG_BIND_DEVICE = "bindDevice";
	/**
	 * PN消息 unBindDevice-解绑设备
	 */
	public final static String PN_MSG_UN_BIND_DEVICE = "unBindDevice";
	
	/**
	 * topic前缀
	 */
	public final static String TOPIC_PREFIX = "xdja/d/";
	/**
	 * topic分隔符
	 */
	public final static String TOPIC_SEPARATOR = "/";
	
	/**
	 * 客户端类型列表
	 */
	public static final Map<Integer, String> CLIENT_TYPES = new HashMap<Integer, String>();
	/**
	 * 登录类型列表
	 */
	public static final Map<Integer, String> LOGIN_TYPES = new HashMap<Integer, String>();
	/**
	 * 操作系统名称列表
	 */
	public static final Map<Integer, String> OS_NAMES = new HashMap<Integer, String>();
	
	static {
		CLIENT_TYPES.put(1, "手机");
		CLIENT_TYPES.put(2, "平板");
		CLIENT_TYPES.put(3, "PC");
		CLIENT_TYPES.put(4, "其他");
		CLIENT_TYPES.put(5, "车载");
		
		LOGIN_TYPES.put(1, "芯片");
		LOGIN_TYPES.put(2, "TF卡");
		LOGIN_TYPES.put(3, "USBKey");
		
		OS_NAMES.put(1, "Android");
		OS_NAMES.put(2, "IOS");
		OS_NAMES.put(3, "Windows");
		OS_NAMES.put(4, "MAC");
		OS_NAMES.put(5, "其他");
	}
	
	/**
	 * 设备注册账号规则 
	 * 		<p>格式：当年最大注册次数|当月最大注册次数|当日最大注册次数
	 */
	public static String DEVICE_REGISTER_RULE;
	/**
	 * 账号正则表达式 系统生成
	 */
	public static String REGEX_ACCOUNT_SYSTEM;
	/**
	 * 账号正则表达式 自定义
	 */
	public static String REGEX_ACCOUNT_CUSTOMIZE;
	/**
	 * 手机号正则表达式
	 */
	public static String REGEX_MOBILE;
	/**
	 * 内部验证码有效时间，单位：分钟
	 */
	public static int AUTH_CODE_INNER_VALID_TIME;
	/**
	 * 短信验证码有效时间，单位：分钟
	 */
	public static int AUTH_CODE_SMS_VALID_TIME;
	/**
	 * 授权信息有效时间，单位：分钟
	 */
	public static int AUTHORIZE_ID_VALID_TIME;
	/**
	 * 短信验证码长度
	 */
	public static int AUTH_CODE_SMS_LENGTH;
	/**
	 * 授信id长度
	 */
	public static int AUTHORIZE_ID_LENGTH;
	/**
	 * 获取账号次数
	 */
	public static int ACCOUNT_GET_TIMES;
	/**
	 * 每天允许登录失败次数
	 */
	public static int LOGIN_FAIL_TIMES;
	/**
	 * 短信验证码模版ID
	 */
	public static String SMS_TEMPLATE_ID;
	/**
	 * 验证好友手机号个数
	 */
	public static int CHECK_FRIEND_MOBILE_COUNT;
	/**
	 * 重置密码每天验证好友手机号失败次数
	 */
	public static int CHECK_FRIEND_MOBILE_FAIL_TIMES;
	/**
	 * 授信设备每天验证好友手机号失败次数
	 */
	public static int ACCREDIT_CHECK_FRIEND_MOBILE_FAIL_TIMES;
	/**
	 * CRON表达式 清除登录失败次数
	 */
	public static String CRON_CLEAR_LOGIN_FAILS;
	
	/**
	 * CKMS服务生成的secretKey
	 */
	public static String CKMS_SECRETKEY;
	
	/**
	 * 异常代码 账号不一致
	 */
	public final static String ERROR_CODE_ACCOUNT_NOT_ACCORDANCE = "account_not_accordance";
	/**
	 * 异常代码 设备不一致
	 */
	public final static String ERROR_CODE_DEVICE_NOT_ACCORDANCE = "device_not_accordance";
	/**
	 * 异常代码 手机号不一致
	 */
	public final static String ERROR_CODE_MOBILE_NOT_ACCORDANCE = "mobile_not_accordance";
	/**
	 * 异常代码 手机号未注册
	 */
	public final static String ERROR_CODE_MOBILE_NOT_REGISTER = "mobile_not_register";
	/**
	 * 异常代码 账号设备无对应关系
	 */
	public final static String ERROR_CODE_ACCOUNT_DEVICE_NOT_RELATION = "account_device_not_relation";
	/**
	 * 异常代码 内部验证码无效
	 */
	public final static String ERROR_CODE_INNER_AUTHCODE_INVALID = "inner_authCode_invalid";
	
	/**
	 * 异常代码 短信验证码无效
	 */
	public final static String ERROR_CODE_SMS_AUTHCODE_INVALID = "authCode_error";
	/**
	 * 异常代码 账号已设置过手机号
	 */
	public final static String ERROR_CODE_ACCOUNT_ALREADY_SET_MOBILE = "account_already_set_mobile";
	
	/**
	 * 自定义账号异常代码  already_set_customize_account-已设置自定义账号
	 */
	public final static String ERROR_CUSTOMIZE_ACCOUNT_ALREADY_SET = "already_set_customize_account";
	/**
	 * 自定义账号异常代码  customize_account_exists-已设置自定义账号
	 */
	public final static String ERROR_CUSTOMIZE_ACCOUNT_EXIST = "customize_account_exists";
	
	/**
	 * 获取注册账号绑定短信验证码  account_not_exists—账号不存在
	 */
	public final static String ERROR_GET_MOBILE_AUTH_CODE_ACCOUNT_NOT_EXITS = "account_not_exists";
	/**
	 * 获取注册账号绑定短信验证码  account_device_not_relation—账号设备无对应关系
	 */
	public final static String ERROR_GET_MOBILE_AUTH_CODE_ACCOUNT_DEVICE_UNRELATION = "account_device_not_relation";
	/**
	 * 获取注册账号绑定短信验证码  account_already_bind_mobile—账号手机号已绑定
	 */
	public final static String ERROR_GET_MOBILE_AUTH_CODE_ACCOUNT_MOBILE_ALREADY_BIND = "account_already_bind_mobile";
	/**
	 * 获取注册账号绑定短信验证码  transcend_send_times—短信发送次数超限
	 */
	public final static String ERROR_GET_MOBILE_AUTH_CODE_TRANSCEND_SEND_TIMES = "transcend_send_times";
	/**
	 * 获取注册账号绑定短信验证码  fail_send_message—短信发送失败
	 */
	public final static String ERROR_GET_MOBILE_AUTH_CODE_SEND_FAIL = "fail_send_message";
	
	
	/**
	 * 获取授信设备短信验证码  账号、手机号未绑定
	 */
	public final static String ERROR_GET_ACCREDIT_AUTH_CODE_ACCOUNT_MOBILE_UNBIND = "account_mobile_not_bind";
	
	/**
	 * 获取登录、重置密码短信验证码  手机号为注册
	 */
	public final static String ERROR_GET_LOGIN_RESET_PWD_AUTH_CODE_MOBILE_NOT_REGISTER = "mobile_not_register";
	
	/**
	 * 账号密码登录 账号密码错误
	 */
	public final static String ERROR_ACCOUNT_LOGIN_PASSWORD_ERROR = "account_or_pwd_error";
	/**
	 * 账号密码登录 账号被封停
	 */
	public final static String ERROR_ACCOUNT_LOGIN_ACCOUNT_SEAL = "account_seal";
	/**
	 * 账号密码登录 账号被冻结
	 */
	public final static String ERROR_ACCOUNT_LOGIN_ACCOUNT_FREEZE = "account_freeze";
	/**
	 * 账号密码登录 账号被注销
	 */
	public final static String ERROR_ACCOUNT_LOGIN_ACCOUNT_LOGOUT = "account_logout";
	
	/**
	 * 登录后绑定手机号 账号已注册
	 */
	public final static String ERROR_BIND_MOBILE_MOBILE_ALREADY_REGISTER = "mobile_already_register";
	
	/**
	 * 更换手机号 账号未设置 手机号
	 */
	public final static String ERROR_MODIFY_MOBILE_ACCOUNT_NOT_SET_MOBILE = "account_not_set_mobile";
	
	/**
	 * 退出登录 退出与登录时设备不一致
	 */
	public final static String ERROR_LOGOUT_AND_LOGIN_DEVICE_NOT_ACCORDANCE = "logout_and_login_device_not_accordance";
	
	/**
	 * 验证好友手机号 设备未授信
	 */
	public final static String ERROR_CHECK_FRIEND_MOBILE_DEVICE_UN_AUTHORIZE = "device_is_un_authorize";
	
	/**
	 * 解除设备 设备不存在
	 */
	public final static String ERROR_RELIEVE_DEVICE_NOT_EXIST = "device_not_register";
	/**
	 * 解除设备 账号设备无对应关系
	 */
	public final static String ERROR_RELIEVE_DEVICE_ACCOUNT_NOT_RELATION = "account_or_device_not_relations";
	/**
	 * 推送通知  账号不存在
	 */
	public final static String ERROR_PUSH_ACCOUNT_NOT_EXIST = "account_not_register";
	/**
	 * 推送通知  设备不存在
	 */
	public final static String ERROR_PUSH_DEVICE_NOT_EXIST = "device_not_register";
	/**
	 * 获取授信信息 账号与授权Id无对应关系
	 */
	public final static String GET_AUTHORIZE_INFO_NOT_RELATION = "account_authorizeld_not_relation";
	/**
	 * 获取授信信息 授权信息无效
	 */
	public final static String GET_AUTHORIZE_INFO_ID_INVALID = "authorizeld_invalid";
	
	/**
	 * 授信设备 待授信设备卡号不一致
	 */
	public final static String ACCREDIT_DEVICE_CARD_NO_NOT_ACCORDANCE = "cardno_not_accordance";
	/**
	 * 授信设备 设备已授信
	 */
	public final static String ACCREDIT_DEVICE_ALREADY_AUTHORIZE = "device_accout_already_authorize";
	
	/**
	 * 验证好友手机号 账号与手机号对应账号不是好友关系
	 */
	public final static String CHECK_FRIEND_ACCREDIT_ACCOUNT_NOT_FRIEND = "mobile_and_account_not_friend";

	/**
	 * 查询账户信息  没有搜索到账户信息
	 */
	public final static String ERROR_CODE_NO_USERS_FOUND = "no_users_found"; 
	
	/**
	 * 获取上线通知消息 没有消息
	 */
	public final static String ERROR_CODE_NO_MSG = "no_message";
	
	/**
	 * 执行结果 0-成功
	 */
	public final static int RESULT_SUCCESS = 0;
	
	//==========注册账号=====================
	/**
	 * 注册账号执行结果 1-当天注册账号次数超限
	 */
	public final static int REGISTER_COUNT_DAY_OVERRUN = 1;
	/**
	 * 注册账号执行结果 2-当月注册账号次数超限
	 */
	public final static int REGISTER_COUNT_MONTH_OVERRUN = 2;
	/**
	 * 注册账号执行结果 3-当年注册账号次数超限
	 */
	public final static int REGISTER_COUNT_YEAR_OVERRUN = 3;
	
	//==========获取账号=====================
	/**
	 * 获取新账号结果 1-次数超限
	 */
	public final static int  GET_ACCOUNT_TIMES_OVERRUN = 1;
	/**
	 * 获取新账号结果 2-账号不一致
	 */
	public final static int  GET_ACCOUNT_NOT_ACCORDANCE = 2;
	/**
	 * 获取新账号结果 3-设备不一致
	 */
	public final static int  GET_ACCOUNT_DEVICE_NOT_ACCORDANCE = 3;
	/**
	 * 获取新账号结果 4-账号设备无对应关系
	 */
	public final static int  GET_ACCOUNT_DEVICE_NOT_RELATION = 4;
	/**
	 * 获取新账号结果 5-内部验证码无效
	 */
	public final static int  GET_ACCOUNT_INNER_AUTH_CODE_INVALID = 5;
	
	//==========更换账号=====================
	/**
	 * 更换账号结果 1-账号不一致
	 */
	public final static int  MODIFY_ACCOUNT_NOT_ACCORDANCE = 1;
	/**
	 * 更换账号结果 2-设备不一致
	 */
	public final static int  MODIFY_ACCOUNT_DEVICE_NOT_ACCORDANCE = 2;
	/**
	 * 更换账号结果 3-旧账号设备无对应关系
	 */
	public final static int  MODIFY_ACCOUNT_DEVICE_NOT_RELATION = 3;
	/**
	 * 更换账号结果 4-内部验证码无效
	 */
	public final static int  MODIFY_ACCOUNT_INNER_AUTH_CODE_INVALID = 4;
	
	//==========更换账号=====================
	/**
	 * 自定义账号结果 1-账号不一致
	 */
	public final static int  CUSTOMIZE_ACCOUNT_NOT_ACCORDANCE = 1;
	/**
	 * 自定义账号结果 2-设备不一致
	 */
	public final static int  CUSTOMIZE_ACCOUNT_DEVICE_NOT_ACCORDANCE = 2;
	/**
	 * 自定义账号结果 3-旧账号设备无对应关系
	 */
	public final static int  CUSTOMIZE_ACCOUNT_DEVICE_NOT_RELATION = 3;
	/**
	 * 自定义账号结果 4-内部验证码无效
	 */
	public final static int  CUSTOMIZE_ACCOUNT_INNER_AUTH_CODE_INVALID = 4;
	/**
	 * 自定义账号结果 5-已设置自定义账号
	 */
	public final static int  CUSTOMIZE_ACCOUNT_ALREADY_SET = 5;
	/**
	 * 自定义账号结果 6-自定义账号已存在
	 */
	public final static int  CUSTOMIZE_ACCOUNT_ALREADY_EXISTS = 6;
	
	//==========获取注册账号手机验证码=====================
	/**
	 * 获取注册账号手机验证码 1-账号不存在
	 */
	public final static int GET_MOBILE_AUTH_CODE_ACCOUNT_NOT_EXIST = 1;
	/**
	 * 获取注册账号手机验证码 2-账号设备无对应关系
	 */
	public final static int GET_MOBILE_AUTH_CODE_ACCOUNT_DEVICE_UNRELATION = 2;
	/**
	 * 获取注册账号手机验证码 3-账号已经绑定该手机号
	 */
	public final static int GET_MOBILE_AUTH_CODE_ACCOUNT_MOBILE_ALREADY_BIND = 3;
	/**
	 * 获取注册账号手机验证码 4-发送短信次数超限
	 */
	public final static int GET_MOBILE_AUTH_CODE_SEND_SMS_TIMES_OVERRUN = 4;
	/**
	 * 获取注册账号手机验证码 5-短信发送失败
	 */
	public final static int GET_MOBILE_AUTH_CODE_SEND_SMS_FAIL = 5;
	
	//==========绑定手机号=====================
	/**
	 * 绑定手机号结果 1-手机号已注册
	 */
	public final static int BIND_MOBILE_ALREADY_REGISTER = 1;
	/**
	 * 绑定手机号结果 2-账号不一致
	 */
	public final static int BIND_MOBILE_ACCOUNT_NOT_ACCORDANCE = 2;
	/**
	 * 绑定手机号结果 3-设备不一致
	 */
	public final static int BIND_MOBILE_DEVICE_NOT_ACCORDANCE = 3;
	/**
	 * 绑定手机号结果 4-手机号不一致
	 */
	public final static int BIND_MOBILE_NOT_ACCORDANCE = 4;
	/**
	 * 绑定手机号结果 5-账号设备无对应关系
	 */
	public final static int BIND_MOBILE_ACCOUNT_DEVICE_NOT_RELATION = 5;
	/**
	 * 绑定手机号结果 6-短信验证码无效
	 */
	public final static int  BIND_MOBILE_SMS_AUTH_CODE_INVALID = 6;
	/**
	 * 绑定手机号结果 7-内部验证码无效
	 */
	public final static int  BIND_MOBILE_INNER_AUTH_CODE_INVALID = 7;
	/**
	 * 绑定手机号结果 8-账号已经设置手机号
	 */
	public final static int BIND_MOBILE_ACCOUNT_ALREADY_SET_MOBILE = 8;
	
	//==========强制绑定手机号=====================
	/**
	 * 绑定手机号结果 1-账号不一致
	 */
	public final static int FORCE_BIND_MOBILE_ACCOUNT_NOT_ACCORDANCE = 1;
	/**
	 * 绑定手机号结果 2-设备不一致
	 */
	public final static int FORCE_BIND_MOBILE_DEVICE_NOT_ACCORDANCE = 2;
	/**
	 * 绑定手机号结果 3-手机号不一致
	 */
	public final static int FORCE_BIND_MOBILE_NOT_ACCORDANCE = 3;
	/**
	 * 绑定手机号结果 4-账号设备无对应关系
	 */
	public final static int FORCE_BIND_MOBILE_ACCOUNT_DEVICE_NOT_RELATION = 4;
	/**
	 * 绑定手机号结果 5-内部验证码无效
	 */
	public final static int FORCE_BIND_MOBILE_INNER_AUTH_CODE_INVALID = 5;
	
	//==========获取授信设备短信验证码=====================
	/**
	 * 获取授信设备短信验证码 1-账号不存在
	 */
	public final static int GET_ACCREDIT_AUTH_CODE_ACCOUNT_NOT_EXIST = 1;
	/**
	 * 获取授信设备短信验证码 2-账号、手机号未绑定
	 */
	public final static int GET_ACCREDIT_AUTH_CODE_ACCOUNT_MOBILE_UNBIND = 2;
	/**
	 * 获取授信设备短信验证码 3-短信发送次数超限
	 */
	public final static int GET_ACCREDIT_AUTH_CODE_SEND_SMS_TIMES_OVERRUN = 3;
	/**
	 * 获取授信设备短信验证码 4-短信发送失败
	 */
	public final static int GET_ACCREDIT_AUTH_CODE_SEND_SMS_FAIL = 4;
	
	//==========获取登录、重置密码短信验证码=====================
	/**
	 * 获取授信设备短信验证码 1-手机号未注册
	 */
	public final static int GET_LOGIN_RESET_PWD_AUTH_CODE_MOBILE_NOT_REGISTER = 1;
	/**
	 * 获取授信设备短信验证码 2-短信发送次数超限
	 */
	public final static int GET_LOGIN_RESET_PWD_AUTH_CODE_SEND_SMS_TIMES_OVERRUN = 2;
	/**
	 * 获取授信设备短信验证码 3-短信发送失败
	 */
	public final static int GET_LOGIN_RESET_PWD_AUTH_CODE_SEND_SMS_FAIL = 3;
	
	//==========账号密码登录=====================
	/**
	 * 账号密码登录 1-登录次数达到上线
	 */
	public final static int ACCOUNT_LOGIN_TIMES_OVERRUN = 1;
	/**
	 * 账号密码登录 2-非授信设备
	 */
	public final static int ACCOUNT_LOGIN_UN_ACCREDIT = 2;
	/**
	 * 账号密码登录 3-无受信设备
	 */
	public final static int ACCOUNT_LOGIN_NOT_HAVE_ACCREDIT = 3;
	/**
	 * 账号密码登录 4-账号不存在
	 */
	public final static int ACCOUNT_LOGIN_UN_EXIST = 4;
	/**
	 * 账号密码登录 5-账号密码错误
	 */
	public final static int ACCOUNT_LOGIN_PASSWORD_ERROR = 5;
	/**
	 * 账号密码登录 6-账号被封停
	 */
	public final static int ACCOUNT_LOGIN_SEAL = 6;
	/**
	 * 账号密码登录 7-账号被冻结
	 */
	public final static int ACCOUNT_LOGIN_FREEZE = 7;
	/**
	 * 账号密码登录 8-账号被注销
	 */
	public final static int ACCOUNT_LOGIN_LOGOUT = 8;
	
	//==========手机验证码登录=====================
	/**
	 * 手机验证码登录 1-登录次数达到上线
	 */
	public final static int MOBILE_LOGIN_TIMES_OVERRUN = 1;
	/**
	 * 账号密码登录 2-非授信设备
	 */
	public final static int MOBILE_LOGIN_UN_ACCREDIT = 2;
	/**
	 * 手机验证码登录 3-无受信设备
	 */
	public final static int MOBILE_LOGIN_NOT_HAVE_ACCREDIT = 3;
	/**
	 * 手机验证码登录 4-手机号不一致
	 */
	public final static int MOBILE_LOGIN_MOBILE_NOT_ACCORDANCE = 4;
	/**
	 * 手机验证码登录 5-设备不一致
	 */
	public final static int MOBILE_LOGIN_DEVICE_NOT_ACCORDANCE = 5;
	/**
	 * 手机验证码登录 6-短信验证码不正确
	 */
	public final static int MOBILE_LOGIN_SMS_AUTH_CODE_ERROR = 6;
	/**
	 * 手机验证码登录 7-内部验证码无效
	 */
	public final static int MOBILE_LOGIN_INNER_AUTH_CODE_INVALID = 7;
	/**
	 * 手机验证码登录8-账号被封停
	 */
	public final static int MOBILE_LOGIN_SEAL = 8;
	/**
	 * 手机验证码登录 9-账号被冻结
	 */
	public final static int MOBILE_LOGIN_FREEZE = 9;
	/**
	 * 手机验证码登录 10-账号被注销
	 */
	public final static int MOBILE_LOGIN_LOGOUT = 10;
	/**
	 * 手机验证码登录 11-手机号未注册
	 */
	public final static int MOBILE_LOGIN_NOT_REGISTER = 11;
	
	//==========获取绑定、更换手机号验证码=====================
	/**
	 * 获取绑定、更换手机号验证码 1-发送短信次数超限
	 */
	public final static int GET_BIND_MODIFY_MOBILE_AUTH_CODE_SEND_SMS_OVERRUN = 1;
	/**
	 * 获取绑定、更换手机号验证码 2-短信发送失败
	 */
	public final static int GET_BIND_MODIFY_MOBILE_AUTH_CODE_SEND_SMS_FAIL = 2;
	/**
	 * 获取绑定、更换手机号验证码 3-账号已绑定该手机号
	 */
	public final static int GET_BIND_MODIFY_MOBILE_AUTH_CODE_ACCOUNT_MOBILE_ALREADY_BIND = 3;
	
	//==========绑定手机号=====================
	/**
	 * 绑定手机号 1-短信验证码不正确
	 */
	public final static int BIND_MOBILE_SMS_AUTH_CODE_ERROR = 1;
	/**
	 * 绑定手机号 2-手机号已注册
	 */
	public final static int BIND_MOBILE_REGISTER = 2;
	/**
	 * 绑定手机号 3-已设置过手机号
	 */
	public final static int BIND_MOBILE_ALREADY_SET_MOBILE = 3;
	
	//==========自定义账号=====================
	/**
	 * 自定义账号 1-已设置自定义账号
	 */
	public final static int CUSTOMIZE_ACCOUNT_LOGIN_ALREADY_SET = 1;
	/**
	 * 自定义账号 2-自定义账号已存在
	 */
	public final static int CUSTOMIZE_ACCOUNT_LOGIN_EXIST = 2;
	
	//==========更换手机号=====================
	/**
	 * 更换手机号 1-短信验证码不正确
	 */
	public final static int MODIFY_MOBILE_SMS_AUTH_CODE_ERROR = 1;
	/**
	 * 更换手机号 2-手机号已注册
	 */
	public final static int MODIFY_MOBILE_REGISTER = 2;
	/**
	 * 更换手机号 3-账号未设置手机号
	 */
	public final static int MODIFY_MOBILE_NOT_SET_MOBILE = 3;
	
	//==========解绑手机号=====================
	/**
	 * 解绑手机号 1-账号手机号无绑定关系
	 */
	public final static int UN_BIND_MOBILE_ACCOUNT_NOT_RELATION = 1;
	
	//==========退出登录=====================
	/**
	 * 退出登录 1-退出与登录时设备不一致
	 */
	public final static int LOGOUT_AND_LOGIN_DEVICE_NOT_ACCORDANCE = 1;
	
	//==========检测短信验证码=====================
	/**
	 * 检测短信验证码 1-手机号不一致
	 */
	public final static int CHECK_SMS_AUTH_CODE_MOBILE_NOT_ACCORDANCE = 1;
	/**
	 * 检测短信验证码 2-设备不一致
	 */
	public final static int CHECK_SMS_AUTH_CODE_DEVICE_NOT_ACCORDANCE = 2;
	/**
	 * 检测短信验证码 3-短信验证码不正确
	 */
	public final static int CHECK_SMS_AUTH_CODE_ERROR = 3;
	/**
	 * 检测短信验证码 4-内部验证码无效
	 */
	public final static int CHECK_SMS_AUTH_CODE_INNER_INVALID = 4;
	
	//==========验证短信重置密码=====================
	/**
	 * 验证短信重置密码 1-手机号不一致
	 */
	public final static int CHECK_SMS_MOBILE_NOT_ACCORDANCE = 1;
	/**
	 * 验证短信重置密码 2-设备不一致
	 */
	public final static int CHECK_SMS_DEVICE_NOT_ACCORDANCE = 2;
	/**
	 * 验证短信重置密码 3-内部验证码无效
	 */
	public final static int CHECK_SMS_INNER_INVALID = 3;
	
	//==========验证好友手机号重置密码=====================
	/**
	 * 验证好友手机号重置密码 1-账号不存在
	 */
	public final static int CHECK_FRIEND_MOBILE_ACCOUNT_UNEXIST = 1;
	/**
	 * 验证好友手机号重置密码 2-账号不一致
	 */
	public final static int CHECK_FRIEND_MOBILE_ACCOUNT_NOT_ACCORDANCE = 2;
	/**
	 * 验证好友手机号重置密码 3-设备不一致
	 */
	public final static int CHECK_FRIEND_MOBILE_DEVICE_NOT_ACCORDANCE = 3;
	/**
	 * 验证好友手机号重置密码 4-内部验证码无效
	 */
	public final static int CHECK_FRIEND_MOBILE_INNER_INVALID = 4;
	
	//==========验证好友手机号=====================
	/**
	 * 验证好友手机号 1-账号与手机号对应帐号不是好友关系
	 */
	public final static int CHECK_FRIEND_AND_ACCOUNT_NOT_RELATION = 1;
	/**
	 * 验证好友手机号 2-账号不存在
	 */
	public final static int CHECK_FRIEND_ACCOUNT_UNEXIST = 2;
	/**
	 * 验证好友手机号 3-设备未授信
	 */
	public final static int CHECK_FRIEND_DEVICE_UNAUTHORIZE = 3;
	
	//==========验证好友手机号=====================
	/**
	 * 解除设备 1-设备不存在
	 */
	public final static int RELIEVE_DEVICE_NOT_EXIST = 1;
	/**
	 * 解除设备 2-账号设备无对应关系
	 */
	public final static int RELIEVE_DEVICE_ACCOUNT_UN_BIND = 2;
	
	//==========推送通知=====================
	/**
	 * 推送通知 1-账号不存在
	 */
	public final static int PUSH_ACCOUNT_NOT_EXIST = 1;
	/**
	 * 推送通知 2-设备不存在
	 */
	public final static int PUSH_DEVICE_NOT_EXIST = 2;
	
	//==========修改设备名称=====================
	/**
	 * 修改设备名称 1-设备不存在
	 */
	public final static int MODIFY_DEVICE_NAME_DEVICE_NOT_EXIST = 1;
	/**
	 * 修改设备名称 2-账号设备无对应关系
	 */
	public final static int MODIFY_DEVICE_NAME_ACCOUNT_DEVICE_UN_BIND = 2;
	
	//==========重新生成授信信息=====================
	/**
	 * 重新生成授信信息 1-账号不一致
	 */
	public final static int CREATE_AUTHORIZE_ID_ACCOUNT_NOT_ACCORDANCE = 1;
	/**
	 * 重新生成授信信息 2-设备不一致
	 */
	public final static int CREATE_AUTHORIZE_ID_DEVICE_NOT_ACCORDANCE = 2;
	/**
	 * 重新生成授信信息 3-内部验证码无效
	 */
	public final static int CREATE_AUTHORIZE_ID_INNER_CODE_INVALID = 3;
	
	//==========获取授信信息=====================
	/**
	 * 获取授信信息 1-账号与授权Id无对应关系
	 */
	public final static int GET_AUTHORIZE_INFO_ACCOUNT_NOT_RELATION = 1;
	/**
	 * 获取授信信息 2-授权信息无效
	 */
	public final static int GET_AUTHORIZE_INFO_INVALID = 2;
	
	//==========授信设备=====================
	/**
	 * 授信设备 1-授信信息无效
	 */
	public final static int ACCREDIT_DEVICE_AUTHORIZE_INVALID = 1;
	/**
	 * 授信设备 2-账号与授权id无对应关系
	 */
	public final static int ACCREDIT_DEVICE_ACCOUNT_AUTHORIZE_ID_NOT_RELATION = 2;
	/**
	 * 授信设备 3-待授信设备卡号不一致
	 */
	public final static int ACCREDIT_DEVICE_CARDNO_NOT_ACCORDANCE = 3;
	/**
	 * 授信设备 4-设备已授信
	 */
	public final static int ACCREDIT_DEVICE_ACCOUNT_ALREADY_AUTHORIZE = 4;
	
	//==========验证好友手机号授信设备=====================
	/**
	 * 验证好友手机号授信设备 1-账号不一致
	 */
	public final static int CHECK_FRIEND_ACCREDIT_ACCOUNT_NOT_ACCORDANCE = 1;
	/**
	 * 验证好友手机号授信设备 2-设备不一致
	 */
	public final static int CHECK_FRIEND_ACCREDIT_DEVICE_NOT_ACCORDANCE = 2;
	/**
	 * 验证好友手机号授信设备 3-账号与手机号对应账号不是好友关系
	 */
	public final static int CHECK_FRIEND_ACCREDIT_NOT_FRIEND = 3;
	/**
	 * 验证好友手机号授信设备 4-内部验证码无效
	 */
	public final static int CHECK_FRIEND_ACCREDIT_INNER_INVALID = 4;
	/**
	 * 验证好友手机号授信设备 5-手机号对应账号无效
	 */
	public final static int CHECK_FRIEND_ACCREDIT_INVALID = 5;
	
	//==========验证短信验证码授信设备=====================
	/**
	 * 验证短信验证码授信设备 1-账号不一致
	 */
	public final static int CHECK_SMS_ACCREDIT_ACCOUNT_NOT_ACCORDANCE = 1;
	/**
	 * 验证短信验证码授信设备 2-设备不一致
	 */
	public final static int CHECK_SMS_ACCREDIT_DEVICE_NOT_ACCORDANCE = 2;
	/**
	 * 验证短信验证码授信设备 3-手机号不一致
	 */
	public final static int CHECK_SMS_ACCREDIT_MOBILE_NOT_ACCORDANCE = 3;
	/**
	 * 验证短信验证码授信设备 4-账号、手机号未绑定
	 */
	public final static int CHECK_SMS_ACCREDIT_ACCOUNT_MOBILE_UN_BIND = 4;
	/**
	 * 验证短信验证码授信设备 5-短信验证码不正确
	 */
	public final static int CHECK_SMS_ACCREDIT_SMS_ERROR = 5;
	/**
	 * 验证短信验证码授信设备 6-内部验证码无效
	 */
	public final static int CHECK_SMS_ACCREDIT_INNER_INVALID = 6;

}
