package com.xdja.cssp.account.service;

import java.util.List;
import java.util.Map;

import com.xdja.cssp.account.service.pojo.AccountInfoExtendBean;
import com.xdja.cssp.account.service.pojo.AccreditDeviceReq;
import com.xdja.cssp.account.service.pojo.Device;
import com.xdja.cssp.account.service.pojo.LoginBindMobileReq;
import com.xdja.cssp.account.service.pojo.LoginCommonReq;
import com.xdja.cssp.account.service.pojo.PushNoticeReq;
import com.xdja.cssp.account.service.pojo.ResultBean;
import com.xdja.cssp.account.service.pojo.SmsType;

/**
 * 账号管理业务接口
 * @author wyf
 *
 */
public interface IAccountManageService {
	
	/**
	 * 获取绑定、更换手机号验证码
	 * @param account 账号
	 * @param mobile 手机号
	 * @param cardNo 登录设备卡号
	 * @param sn 登录设备签名证书SN
	 * @param type 短信验证码业务类型
	 * @return 执行结果 0-成功;1-发送短信次数超限;2-短信发送失败;3-账号已绑定该手机号
	 */
	int getBindOrModifyMobileAuthCode(String account, String mobile, String cardNo, String sn, SmsType type);

	/**
	 * 绑定手机号
	 * @param account 账号
	 * @param req 请求信息
	 * @param cardNo 卡号
	 * @param sn 签名证书SN
	 * @return 执行结果 0-成功；1-短信验证码不正确；2-手机号已注册
	 */
	int bindMobile(String account, LoginBindMobileReq req, String cardNo, String sn);

	/**
	 * 强制绑定手机号
	 * @param account 账号
	 * @param mobile 手机号
	 * @return 
	 */
	boolean forceBindMobile(String account, String mobile);

	/**
	 * 自定义账号
	 * @param account 账号
	 * @param customizeAccount 自定义账号
	 * @return 执行结果 0-成功；1-已设置过自定义账号；2-自定义账号已存在
	 */
	int customizeAccount(String account, String customizeAccount);

	/**
	 * 更换手机号
	 * @param account 账号
	 * @param req 请求参数
	 * @param cardNo 卡号
	 * @return 执行结果 0-成功；1-短信验证码不正确；2-手机号已注册;3-账号未设置手机号
	 */
	int modifyMobile(String account, LoginBindMobileReq req, String cardNo);

	/**
	 * 解绑手机号
	 * @param account 账号
	 * @param mobile 手机号
	 * @return 执行结果 0-成功；1-账号手机号无绑定关系
	 */
	int unBindMobile(String account, String mobile);

	/**
	 * 修改密码
	 * @param account 账号
	 * @param passwd 密码
	 */
	void modifyPasswd(String account, String passwd);

	/**
	 * 检测账号密码
	 * @param account 账号
	 * @param passwd 密码
	 * @return true-通过；false-未通过
	 */
	boolean checkPasswd(String account, String passwd);

	/**
	 * 修改昵称
	 * @param account 账号
	 * @param nickName 昵称
	 * @return 昵称对应拼音简、全拼
	 */
	Map<String, String> modifyNickName(String account, String nickName);

	/**
	 * 查询设备列表
	 * @param account 账号
	 * @return 已绑定设备列表
	 */
	List<Device> queryDevices(String account);

	/**
	 * 解除设备
	 * @param account 账号
	 * @param currentLogin 当前登录设备信息
	 * @param currentCardNo 当前设备卡号
	 * @param cardNo 设备卡号
	 * @return 执行结果 0-成功；1-设备不存在；2-账号设备无对应关系
	 */
	int relieveDevice(String account, LoginCommonReq currentLogin, String currentCardNo, String cardNo);
	
	/**
	 * 推送通知
	 * @param  req 请求信息
	 * @return 执行结果 0-成功；1-设备不存在；2-账号设备无对应关系
	 */
	int pnNotice(List<String> dstAccount, String msg, String topic);

	/**
	 * 修改设备名称
	 * @param account 账号
	 * @param req 请求信息
	 * @return 执行结果 0-成功；1-设备不存在；2-账号设备无对应关系
	 */
	int modifyDeviceName(String account, Device req);

	/**
	 * 获取授信信息
	 * @param account 账号
	 * @param authorizeId 授信信息Id
	 * @param cardNo 卡号
	 * @return 执行结果，resultStatus状态描述：
	 * 		<br/>0-成功
	 * 		<br/>1-账号与授权id无对应关系
	 * 		<br/>2-受权id无效
	 */
	ResultBean getAuthorizeInfo(String account, String authorizeId, String cardNo);

	/**
	 * 授信设备
	 * @param account 账号
	 * @param req 请求参数
	 * @return 执行结果 
	 * 		<br/>0-成功
	 * 		<br/>1-授权信息无效
	 * 		<br/>2-账号、授权id无对应关系
	 * 		<br/>3-待授信设备卡号不一致
	 * 		<br/>4-设备已授信
	 */
	int accreditDevice(String account, AccreditDeviceReq req);

	/**
	 * 查询账号信息
	 * @param account 账号
	 * @param identify 自增标识
	 * @return 账号信息
	 */
	AccountInfoExtendBean getAccountInfo(String account, long identify);

}
