package com.xdja.cssp.account.service;

import java.util.List;
import java.util.Map;

import com.xdja.cssp.account.service.pojo.Account;
import com.xdja.cssp.account.service.pojo.RegisterResult;
import com.xdja.platform.rpc.RemoteService;

/**
 * 账号对外业务接口
 * @author wyf
 *
 */
@RemoteService(serviceCode="account")
public interface IAccountQueryService {
	
	/**
	 * 查询账号在线PN标识列表
	 * @param accounts 账号列表
	 * @return 账号在线PN标识列表
	 */
	List<String> queryOnlinePnToken(String... accounts);
	
	/**
	 * 查询账号在线设备列表
	 * @param accounts 账号列表
	 * @return 对应在线设备列表
	 */
	Map<String, List<Map<String, Object>>> queryOnlineDevice(String... accounts);
	
	/**
	 * 批量检测账号是否存在
	 * @param account 账号列表
	 * @return 不存在账号列表
	 */
	List<String> checkAccountExist(String... accounts);
	
	/**
	 * 注册账号信息
	 * @param accounts 账号信息
	 * @return 注册成功账号
	 */
	List<RegisterResult> registerAccounts(List<Account> accounts);
	
	/**
	 * 获取我的数字账号
	 * @param account 我的账号（数字、手机号、自定义）
	 * @return 对应的数字账号
	 */
	String fetchMyDigitalAccount(String account);
	
	/**
	 * 取得配置管理信息
	 * @return 配置信息
	 */
	String getConfigManage();
	
	/**
	 * 设置配置管理
	 * @param values 配置管理信息字符串
	 */
	void setConfigManage(String values);
	
	/**
	 * 解绑设备
	 * @param account 账号
	 * @param cardNo  设备卡号
	 */
	boolean relieveDevice(String account,String cardNo);

}
