package com.xdja.cssp.account.service;

import java.util.List;

import com.xdja.cssp.account.service.pojo.AccountIncrementResBean;
import com.xdja.cssp.account.service.pojo.AccountInfoBean;
import com.xdja.cssp.account.service.pojo.AccountJudgeBean;
import com.xdja.cssp.account.service.pojo.ForceOfflineMsg;
import com.xdja.cssp.account.service.pojo.JudgeCompleteReq;
import com.xdja.cssp.account.service.pojo.ModifyAvatarReq;
import com.xdja.cssp.account.service.pojo.OnLineNoticeBean;
import com.xdja.cssp.account.service.pojo.UnBindDeviceBean;

/**
 * 账户服务接口
 * @author zhouyj
 *
 */
public interface IAccountService {
	
	/**
	 * 根据账号或者手机号查询账户信息
	 * @param condition 查询条件
	 * @return 账户信息
	 */
	AccountInfoBean queryAccount(String condition);
	
	/**
	 * 根据账号批量查询账户信息
	 * @param accounts 账户信息
	 * @return 账户信息列表
	 */
	List<AccountInfoBean> queryAccountsBatch(List<String> accounts);
	
	/**
	 * 增量查询账户信息
	 * @param account 账号
	 * @param lastUpdateId 上次更新的id
	 * @param batchSize 批量的记录数
	 * @return 批量的账户信息
	 */
	AccountIncrementResBean queryAccountsIncrement(String account, long lastUpdateId, int batchSize);
	
	/**
	 * 修改头像
	 * @param account 账号
	 * @param modifyAvatarReq 头像请求信息
	 */
	void modifyAvatar(String account, ModifyAvatarReq modifyAvatarReq);
	
	
	/**
	 * 获取上线通知消息，多设备情况下，账号下一个设备登录后要通知其他类型在线设备，
	 * 其他在线设备收到上线消息后，向后台拉取上线通知消息
	 * @param account
	 * @return
	 */
	OnLineNoticeBean getOnlineNotice(String account);
	
	/**
	 * 获取强制下线消息
	 * @param account 账号
	 * @param clientType 终端类型
	 * @return 强制下线消息
	 */
	ForceOfflineMsg getForceOnfflineMsg(String account, int clientType);
	
	
	/**
	 * 获取解绑设备消息
	 * @param account 解绑的账号
	 * @param cardNo 解绑的卡号
	 * @return
	 */
	UnBindDeviceBean getUnBindDeviceMsg(String account, String cardNo);
	
	/**
	 *  新老账号判断
	 * @param cardNo 卡号
	 * @return
	 */
	AccountJudgeBean judgeAccount(String cardNo);
	
	/**
	 *  已完成老账号迁移
	 * @param cardNo 卡号
	 * @return
	 */
	void judgeComplete(String cardNo, String sn, JudgeCompleteReq req);
}
