package com.xdja.cssp.account.service;

import com.xdja.cssp.account.service.pojo.AccountLoginReq;
import com.xdja.cssp.account.service.pojo.CheckFriendAccreditDeviceReq;
import com.xdja.cssp.account.service.pojo.CheckFriendMobileReq;
import com.xdja.cssp.account.service.pojo.CheckFriendMobileResetPwdReq;
import com.xdja.cssp.account.service.pojo.CheckSmsAccreditDevice;
import com.xdja.cssp.account.service.pojo.CheckSmsAuthCodeReq;
import com.xdja.cssp.account.service.pojo.CheckSmsResetPwdReq;
import com.xdja.cssp.account.service.pojo.CreateAuthorizeIdReq;
import com.xdja.cssp.account.service.pojo.MobileLoginReq;
import com.xdja.cssp.account.service.pojo.ResultBean;
import com.xdja.cssp.account.service.pojo.SmsType;

/**
 * 登录业务接口
 * @author wyf
 *
 */
public interface ILoginService {
	
	/**
	 * 账号密码登录
	 * @param cardNo 卡号
	 * @param sn 签名证书SN
	 * @param req 请求参数 
	 * @return 执行结果，resultStatus状态描述：
	 * 		<br/>0-成功
	 * 		<br/>1-登录次数达到上线
	 * 		<br/>2-非受信设备
	 * 		<br/>3-无任何受信设备
	 * 		<br/>4-账号不存在
	 * 		<br/>5-账号密码错误
	 * 		<br/>6-账号被封停
	 * 		<br/>7-账号被冻结
	 * 		<br/>8-账号被注销
	 */
	ResultBean accountLogin(String cardNo, String sn, AccountLoginReq req);
	
	/**
	 * 手机验证码登录
	 * @param cardNo 卡号
	 * @param sn 签名证书SN
	 * @param req 请求参数 
	 * @return 执行结果，resultStatus状态描述：
	 * 		<br/>0-成功
	 * 		<br/>1-登录次数达到上线
	 * 		<br/>2-非受信设备
	 * 		<br/>3-无任何受信设备
	 * 		<br/>4-手机号不一致
	 * 		<br/>5-设备不一致
	 * 		<br/>6-短信验证码不正确
	 * 		<br/>7-内部验证码无效
	 * 		<br/>8-账号被封停
	 * 		<br/>9-账号被冻结
	 * 		<br/>10-账号被注销
	 * 		<br/>11-手机号未注册
	 */
	ResultBean mobileLogin(String cardNo, String sn, MobileLoginReq req);
	
	/**
	 * 获取授信设备验证码
	 * @param cardNo 卡号
	 * @param sn 签名证书SN
	 * @param account 账号
	 * @param mobile 手机号
	 * @return 执行结果，resultStatus状态描述：
	 * 		<br/>0-成功
	 * 		<br/>1-账号不存在
	 * 		<br/>2-账号手机号未绑定
	 * 		<br/>3-发送短信次数超限
	 * 		<br/>4-短信发送失败 
	 */
	ResultBean getAccreditAuthCode(String cardNo, String sn, String account, String mobile);

	/**
	 * 获取登录、重置短信验证码
	 * @param cardNo 卡号
	 * @param sn 签名证书SN
	 * @param mobile 手机号
	 * @param type 短信验证码业务类型
	 * @return 执行结果，resultStatus状态描述：
	 * 		<br/>0-成功
	 * 		<br/>1-手机号未注册
	 * 		<br/>2-发送短信次数超限
	 * 		<br/>3-短信发送失败 
	 */
	ResultBean getLoginOrResetPwdAuthCode(String cardNo, String sn, String mobile, SmsType type);

	/**
	 * 退出登录
	 * @param account 账号
	 * @param clientType 客户端类型
	 * @param pnToken Pn标识
	 * @param cardNo 卡号
	 * @return 执行结果 0-成功；1-退出与登录时设备不一致
	 */
	int logout(String account, int clientType, String pnToken, String cardNo);

	/**
	 * 检测重置密码短信验证码
	 * @param req 请求参数
	 * @param cardNo 卡号
	 * @param sn 签名证书SN
	 * @return 执行结果，resultStatus状态描述：
	 * 		<br/>0-成功
	 * 		<br/>1-手机号不一致
	 * 		<br/>2-设备不一致
	 * 		<br/>3-短信验证码不正确
	 * 		<br/>4-内部验证码无效
	 */
	ResultBean checkSmsAuthCode(CheckSmsAuthCodeReq req, String cardNo, String sn);

	/**
	 * 验证短信重置密码
	 * @param req 请求参数
	 * @param cardNo 卡号
	 * @return 执行结果  0-成功；1-手机号不一致；2-设备不一致；3-内部验证码无效
	 */
	int checkSmsResetPwd(CheckSmsResetPwdReq req, String cardNo);

	/**
	 * 验证好友手机号重置密码
	 * @param req
	 * @param cardNo
	 * @return
	 */
	int checkFriendMobileResetPwd(CheckFriendMobileResetPwdReq req, String cardNo);

	/**
	 * 验证好友手机号
	 * @param req 请求参数
	 * @param cardNo 卡号
	 * @param sn 签名证书sn
	 * @return 执行结果，resultStatus状态描述：
	 * 		<br/>0-成功
	 * 		<br/>1-账号与手机号对应帐号不是好友关系
	 * 		<br/>2-账号不存在
	 * 		<br/>3-设备未授信
	 */
	ResultBean checkFriendMobile(CheckFriendMobileReq req, String cardNo, String sn);

	/**
	 * 重新生成授信信息
	 * @param req 请求参数
	 * @param cardNo 卡号
	 * @param sn 签名证书SN
	 * @return 执行结果，resultStatus状态描述：
	 * 		<br/>0-成功
	 * 		<br/>1-账号不一致
	 * 		<br/>2-设备不一致
	 * 		<br/>3-内部验证码无效
	 */
	ResultBean createAuthorizeId(CreateAuthorizeIdReq req, String cardNo, String sn);

	/**
	 * 检测好友手机号授信设备
	 * @param req 请求参数
	 * @param cardNo 卡号
	 * @param sn 签名证书sn
	 * @return 执行结果
	 * 		<br/>0-成功
	 * 		<br/>1-账号不一致
	 * 		<br/>2-设备不一致
	 * 		<br/>3-账号与手机号对应账号不是好友关系
	 * 		<br/>4-内部验证码无效
	 */
	ResultBean checkFriendAccreditDevice(CheckFriendAccreditDeviceReq req, String cardNo, String sn);

	/**
	 * 验证短信验证码授信设备
	 * @param req 请求信息
	 * @param cardNo 卡号
	 * @param sn 签名证书sn
	 * @return 执行结果
	 * 		<br/>0-成功
	 * 		<br/>1-账号不一致
	 * 		<br/>2-设备不一致
	 * 		<br/>3-手机号不一致
	 * 		<br/>4-账号、手机号未绑定
	 * 		<br/>5-验证码不正确
	 * 		<br/>6-内部验证码无效
	 */
	int checkSmsAccreditDevice(CheckSmsAccreditDevice req, String cardNo, String sn);
	
}
