package com.xdja.cssp.account.service;

import com.xdja.cssp.account.service.pojo.BindMobileReq;
import com.xdja.cssp.account.service.pojo.CustomizeAccountReq;
import com.xdja.cssp.account.service.pojo.ForceBindMobile;
import com.xdja.cssp.account.service.pojo.ModifyAccountReq;
import com.xdja.cssp.account.service.pojo.RegisterReq;
import com.xdja.cssp.account.service.pojo.ResultBean;

/**
 * 账号注册业务接口
 * @author wyf
 *
 */
public interface IRegisterService {
	
	/**
	 * 注册账号
	 * @param cardNo 安全卡号
	 * @param sn 签名证书SN
	 * @param req 登录请求信息
	 * @return 执行结果，resultStatus状态描述：
	 * 		<br/>0-成功
	 * 		<br/>1-注册账号次数超过当天最大限制
	 * 		<br/>2-注册账号超过当月最大限制
	 * 		<br/>3-注册账号超过当年最大限制
	 */
	ResultBean registerAccount(String cardNo, String sn, RegisterReq req);
	
	/**
	 * 获取新账号
	 * @param cardNo 卡号
	 * @param sn 签名证书SN
	 * @param oldAccount 旧账号
	 * @param innerAuthCode 内部验证码
	 * @return 执行结果，resultStatus状态描述：
	 * 		<br/>0-成功
	 * 		<br/>1-获取账号次数超限
	 * 		<br/>2-账号不一致
	 * 		<br/>3-设备不一致
	 * 		<br/>4-账号设备无对应关系
	 * 		<br/>5-内部验证码无效
	 */
	ResultBean getAccount(String cardNo, String sn, String oldAccount, String innerAuthCode);
	
	/**
	 * 更换账号
	 * @param cardNo 卡号
	 * @param sn 签名证书SN
	 * @param req 请求参数
	 * @return 执行结果：
	 * 		<br/>0-成功
	 * 		<br/>1-账号不一致
	 * 		<br/>2-设备不一致
	 * 		<br/>3-旧账号设备无对应关系
	 * 		<br/>4-内部验证码无效
	 */
	int modifyAccount(String cardNo, String sn, ModifyAccountReq req);
	
	/**
	 * 自定义账号
	 * @param cardNo 卡号
	 * @param sn 签名证书SN
	 * @param req 请求参数
	 * @return 执行结果：
	 * 		<br/>0-成功
	 * 		<br/>1-账号不一致
	 * 		<br/>2-设备不一致
	 * 		<br/>3-旧账号设备无对应关系
	 * 		<br/>4-内部验证码无效
	 * 		<br/>5-已经设置过自定义帐号
	 * 		<br/>6-自定义帐号已存在
	 */
	int customizeAccount(String cardNo, String sn, CustomizeAccountReq req);
	
	/**
	 * 获取注册绑定手机号验证码
	 * @param cardNo 卡号
	 * @param sn 签名证书SN
	 * @param account 账号
	 * @param mobile 手机号
	 * @return 执行结果，resultStatus状态描述：
	 * 		<br/>0-成功
	 * 		<br/>1-账号不存在
	 * 		<br/>2-账号设备无对应关系
	 * 		<br/>3-账号已绑定该手机号
	 * 		<br/>4-发送短信次数超限
	 * 		<br/>5-短信发送失败
	 */
	ResultBean getMobileAuthCode(String cardNo, String sn, String account, String mobile);
	
	/**
	 * 绑定手机号
	 * @param cardNo 卡号
	 * @param sn 签名证书SN
	 * @param req 请求参数
	 * @return 执行结果，resultStatus状态描述：
	 * 		<br/>0-成功
	 * 		<br/>1-手机号已注册
	 * 		<br/>2-账号不一致
	 * 		<br/>3-设备不一致
	 * 		<br/>4-手机号不一致
	 * 		<br/>5-账号设备无对应关系
	 * 		<br/>6-短信验证码无效
	 * 		<br/>7-内部验证码无效
	 * 		<br/>8-账号已经绑定手机号
	 */
	ResultBean bindMobile(String cardNo, String sn, BindMobileReq req);
	
	/**
	 * 强制绑定手机号
	 * @param cardNo 卡号
	 * @param sn 签名证书SN
	 * @param req 请求参数
	 * @return 执行结果：
	 * 		<br/>0-成功
	 * 		<br/>1-账号不一致
	 * 		<br/>2-设备不一致
	 * 		<br/>3-手机号不一致
	 * 		<br/>4-账号设备无对应关系
	 * 		<br/>5-内部验证码无效
	 */
	int forceBindMobile(String cardNo, String sn, ForceBindMobile req);

}
