package com.xdja.cssp.acs;

import java.util.List;

import com.xdja.cssp.acs.bean.asset.Asset;
import com.xdja.platform.rpc.RemoteService;

/**
 * 资产服务接口
 * @date 2015-2-3
 * @author rrx
 * 
 */
@RemoteService(serviceCode=ACS.SERVICE_CODE)
public interface IAssetService {

	/**
	 * 
	 * 检查指定的资产是否存在
	 * @param assetIdentity 资产标识
	 * @return true-存在；false-不存在
	 */
	boolean exists(String assetIdentity);
	
	/**
	 * 
	 * 查询指定的资产基本信息
	 * @param assetIdentity 资产标识列表
	 * @return 未找到设备或无传入参数时返回  java.util.Collections.emptyList()
	 */
	List<Asset> queryAssets(String... assetIdentity);
	
	/**
	 * 
	 * 查询指定资产关联的资产标识
	 * @param assetIdentity 资产标识
	 * @return 关联的资产标识，如果未找到则返回空串
	 */
	String queryRelatedByIdentity(String assetIdentity);
	
	/**
	 * 
	 * 根据安全卡UID查询其加密解锁码
	 * @param uId 安全卡UId
	 * @return 如果未找到则返回null
	 */
	String queryUnlockByUId(String uId);
}
