package com.xdja.cssp.acs;

import java.util.List;
import java.util.Map;

import com.xdja.cssp.acs.bean.cert.Cert;
import com.xdja.cssp.acs.bean.cert.CertStatus;
import com.xdja.cssp.acs.bean.cert.PublicKey;
import com.xdja.platform.rpc.RemoteService;

/**
 * 证书服务接口
 * @date 2015-2-3
 * @author rrx
 * 
 */
@RemoteService(serviceCode=ACS.SERVICE_CODE)
public interface ICertService {

	/**
	 * 
	 * 验证指定的证书状态
	 * @param cardNo    卡号
	 * @param sn        证书sn
	 * @param caAlg     证书算法：1-RSA；2-SM2
	 * @return
	 */
	CertStatus checkCertStatus(String cardNo, String sn, int caAlg);

	/**
	 * 
	 * 以SN查询对应证书公钥信息
	 * @param snList    证书sn列表
	 * @param caAlg     证书算法：0-不区分；1-RSA；2-SM2
	 * @return
	 */
	List<PublicKey> queryPublicKeyBySnList(List<String> snList, int caAlg);
	
	/**
	 * 
	 * 以卡号、算法、证书类型查询对应的公钥信息
	 * @param cardNoList 卡号列表
	 * @param caAlg      证书算法：0-不区分；1-RSA；2-SM2
	 * @param certType   证书类型：0-不区分；1-加密证书；2-签名证书
	 * @return
	 */
	Map<String, List<PublicKey>> queryPublicKeyByCardNos(List<String> cardNoList, int caAlg, int certType);
	
	/**
	 * 
	 * 以SN查询对应的证书信息
	 * @param snList    证书sn列表
	 * @param caAlg     证书算法：0-不区分；1-RSA；2-SM2
	 * @return
	 */
	List<Cert> queryCertBySnList(List<String> snList, int caAlg);
	
	/**
	 * 
	 * 以卡号、算法、证书类型查询对应的证书信息
	 * @param cardNoList 卡号列表
	 * @param caAlg      证书算法：0-不区分；1-RSA；2-SM2
	 * @param certType   证书类型：0-不区分；1-加密证书；2-签名证书
	 * @return
	 */
	Map<String, List<Cert>> queryCertByCardNos(List<String> cardNoList, int caAlg, int certType);
}
