package com.xdja.cssp.acs.bean.asset;

import java.io.Serializable;
import java.util.Map;

/**
 * 
 * 资产信息
 * @date 2015-2-3
 * @author rrx
 *
 */
public class Asset implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 资产唯一标识
	 */
	private String identity;
	/**
	 * 资产类型
	 */
	private Type type;
	/**
	 * 设备芯片卡号
	 */
	private String cardNo;
	/**
	 * 设备序列号
	 */
	private String serialCode;
	/**
	 * 出厂时间
	 */
	private Long time;
	/**
	 * 关联设备标识
	 */
	private String relatedAsset;
	/**
	 * 资产私有属性 
	 */
	private Map<String, Object> info;
	
	/**
	 * @return 返回{@linkplain #identity}
	 */
	public String getIdentity() {
		return identity;
	}

	/**
	 * @param identity 要设置的 {@linkplain #identity}
	 */
	public void setIdentity(String identity) {
		this.identity = identity;
	}

	/**
	 * @return 返回{@linkplain #type}
	 */
	public Type getType() {
		return type;
	}
	
	/**
	 * @param type 要设置的 {@linkplain #type}
	 */
	public void setType(Type type) {
		this.type = type;
	}

	/**
	 * @return 返回{@linkplain #cardNo}
	 */
	public String getCardNo() {
		return cardNo;
	}

	/**
	 * @param cardNo 要设置的 {@linkplain #cardNo}
	 */
	public void setCardNo(String cardNo) {
		this.cardNo = cardNo;
	}

	/**
	 * @return 返回{@linkplain #serialCode}
	 */
	public String getSerialCode() {
		return serialCode;
	}

	/**
	 * @param serialCode 要设置的 {@linkplain #serialCode}
	 */
	public void setSerialCode(String serialCode) {
		this.serialCode = serialCode;
	}

	/**
	 * @return 返回{@linkplain #time}
	 */
	public Long getTime() {
		return time;
	}

	/**
	 * @param time 要设置的 {@linkplain #time}
	 */
	public void setTime(Long time) {
		this.time = time;
	}

	/**
	 * @return 返回{@linkplain #relatedAsset}
	 */
	public String getRelatedAsset() {
		return relatedAsset;
	}

	/**
	 * @param relatedAsset 要设置的 {@linkplain #relatedAsset}
	 */
	public void setRelatedAsset(String relatedAsset) {
		this.relatedAsset = relatedAsset;
	}

	/**
	 * @return 返回{@linkplain #info}
	 */
	public Map<String, Object> getInfo() {
		return info;
	}

	/**
	 * @param info 要设置的 {@linkplain #info}
	 */
	public void setInfo(Map<String, Object> info) {
		this.info = info;
	}

}
