package com.xdja.cssp.acs.bean.asset;

/**
 * 资产类型定义
 * @date 2015-2-3
 * @author rrx
 * 
 */
public enum Type {
	/**
	 * 手机
	 */
	PHONE(1),
	/**
	 * 平板
	 */
	PAD(2),
	/**
	 * 路由器
	 */
	ROUTE(3),
	/**
	 * Mini USBKey
	 */
	USBKey(4),
	/**
	 * TF卡
	 */
	TF(5);
	
	public int value;
	
	private Type(int value) {
		this.value = value;
	}
	
	/**
	 * 
	 * 获取value指定的资产类型枚举
	 * @param value 资产类型枚举值
	 * @return
	 * @throws IllegalArgumentException
	 */
	public static Type valueOf(int value) throws IllegalArgumentException {
		for (Type type : Type.values()) {
			if (type.value == value) return type;
		}
		
		throw new IllegalArgumentException(String.format("值\"%d\"对应的枚举值不存在", value));
	}
}