package com.xdja.cssp.acs.bean.cert;

import java.io.Serializable;

/**
 * 公钥信息
 * @date 2015-2-5
 * @author rrx
 * 
 */
public class PublicKey implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 卡号
	 */
	private String cardNo;
	/**
	 * 证书SN
	 */
	private String sn;
	/**
	 * 证书算法；1-RSA，2-SM2
	 */
	private CaAlg caAlg = CaAlg.RSA;
	/**
	 * 证书类型；1-加密证书，2-签名证书
	 */
	private CertType certType = CertType.ENCRYPT;
	/**
	 * 公钥信息
	 */
	public String publicKey;
	
	/**
	 * @return 返回{@linkplain #cardNo}
	 */
	public String getCardNo() {
		return cardNo;
	}

	/**
	 * @param cardNo 要设置的 {@linkplain #cardNo}
	 */
	public void setCardNo(String cardNo) {
		this.cardNo = cardNo;
	}

	/**
	 * @return 返回{@linkplain #sn}
	 */
	public String getSn() {
		return sn;
	}

	/**
	 * @param sn 要设置的 {@linkplain #sn}
	 */
	public void setSn(String sn) {
		this.sn = sn;
	}

	/**
	 * @return 返回{@linkplain #caAlg}
	 */
	public CaAlg getCaAlg() {
		return caAlg;
	}

	/**
	 * @param caAlg 要设置的 {@linkplain #caAlg}
	 */
	public void setCaAlg(CaAlg caAlg) {
		this.caAlg = caAlg;
	}

	/**
	 * @return 返回{@linkplain #certType}
	 */
	public CertType getCertType() {
		return certType;
	}

	/**
	 * @param certType 要设置的 {@linkplain #certType}
	 */
	public void setCertType(CertType certType) {
		this.certType = certType;
	}

	/**
	 * @return 返回{@linkplain #publicKey}
	 */
	public String getPublicKey() {
		return publicKey;
	}

	/**
	 * @param publicKey 要设置的 {@linkplain #publicKey}
	 */
	public void setPublicKey(String publicKey) {
		this.publicKey = publicKey;
	}

	/**
	 * 
	 * 证书算法
	 * @date 2015-2-5
	 * @author rrx
	 *
	 */
	public enum CaAlg {
		/**
		 * 1-RSA
		 */
		RSA(1), 
		/**
		 * 2-SM2
		 */
		SM2(2);
		
		public int value;
		
		private CaAlg(int value) {
			this.value = value;
		}
		
		/**
		 * 
		 * 获取value指定的证书算法枚举
		 * @param value 证书算法枚举值
		 * @return
		 * @throws IllegalArgumentException
		 */
		public static CaAlg valueOf(int value) throws IllegalArgumentException {
			for (CaAlg type : CaAlg.values()) {
				if (type.value == value) return type;
			}
			
			throw new IllegalArgumentException(String.format("值\"%d\"对应的枚举值不存在", value));
		}
	}
	
	/**
	 * 
	 * 证书类型
	 * @date 2015-2-5
	 * @author rrx
	 *
	 */
	public enum CertType {
		/**
		 * 1-加密证书
		 */
		ENCRYPT(1), 
		/**
		 * 2-签名证书
		 */
		SIGN(2);

		public int value;
		
		private CertType(int value) {
			this.value = value;
		}
		
		/**
		 * 
		 * 获取value指定的证书类型枚举
		 * @param value 证书类型枚举值
		 * @return
		 * @throws IllegalArgumentException
		 */
		public static CertType valueOf(int value) throws IllegalArgumentException {
			for (CertType type : CertType.values()) {
				if (type.value == value) return type;
			}
			
			throw new IllegalArgumentException(String.format("值\"%d\"对应的枚举值不存在", value));
		}
	}
}
