package com.xdja.cssp.acs.service;

import java.net.BindException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xdja.platform.common.lite.kit.StrKit;
import com.xdja.platform.common.lite.kit.prop.Prop;
import com.xdja.platform.common.lite.kit.prop.PropKit;
import com.xdja.platform.microservice.ServiceException;
import com.xdja.platform.microservice.config.MicroServiceConfig;
import com.xdja.platform.microservice.db.DbUtilsPlugin;
import com.xdja.platform.microservice.db.druid.DruidPlugin;
import com.xdja.platform.microservice.plugin.Plugins;
import com.xdja.platform.microservice.spring.SpringPlugin;
import com.xdja.platform.rpc.provider.ProviderStarter;

/**
 * 
 * acs系统启动入口
 * @date 2015-2-2
 * @author rrx
 *
 */
public class ACSConfig extends MicroServiceConfig {

	private Logger logger = LoggerFactory.getLogger(getClass());
	
	@Override
	public void configPlugin(Plugins me) {
		Prop systemProp = PropKit.use("system.properties");
		
		String url = systemProp.get("jdbc.url");
		if (StrKit.isBlank(url)) {
			throw ServiceException.create("请在配置文件system.properties中添加jdbc.url的配置");
		}
		String userName = systemProp.get("jdbc.username");
		if (StrKit.isBlank(userName)) {
			throw ServiceException.create("请在配置文件system.properties中添加jdbc.username的配置");
		}
		String password = systemProp.get("jdbc.password");
		
		DruidPlugin dbPlugin = new DruidPlugin(url, userName, password);
		me.add(dbPlugin);
		
		me.add(new DbUtilsPlugin(Constants.DB_ACS, dbPlugin));
		
		String[] configLocations = new String[]{
				"classpath*:/META-INF/spring/applicationContext-*.xml",
				"classpath*:/applicationContext.xml"
		};
		me.add(new SpringPlugin(configLocations));
	}
	
	@Override
	public void afterStart() {
		Prop systemProp = PropKit.use("system.properties");
		
		String ip = systemProp.get("rpc.ip", Constants.IP);
		int port = systemProp.getInt("rpc.port", Constants.PORT);
		int maxWorkThread = systemProp.getInt("rpc.maxWorkThread", Constants.MAXWORKTHREAD);
		
		try {
			ProviderStarter.NETTY.setMaxWorkThread(maxWorkThread).start(ip, port);
			
			logger.info("====>ACS服务{}:{}启动成功，最大工作线程数为{}个！", ip, port, maxWorkThread);
		} catch (BindException e) {
			logger.error("服务绑定异常", e.getMessage());
		} catch (InterruptedException e) {
			logger.error("线程异常", e.getMessage());
		}
	}

}
