package com.xdja.cssp.acs.service.handler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.dbutils.ResultSetHandler;

import com.xdja.cssp.acs.bean.asset.Asset;
import com.xdja.cssp.acs.bean.asset.Type;

/**
 * 资产信息处理类，负责把查询到的资产信息封装为Map&lt;Long, Asset&gt;
 * <P>
 * Map中的key为n_id
 * @date 2015-2-6
 * @author rrx
 * 
 */
public class AssetBeanMapHandler implements ResultSetHandler<Map<Long, Asset>> {

	@Override
	public Map<Long, Asset> handle(ResultSet rs) throws SQLException {
		Map<Long, Asset> results = new HashMap<Long, Asset>();

        if (!rs.next()) {
            return results;
        }
        
        Asset asset = null;
        do {
        	asset = new Asset();
        	asset.setIdentity(rs.getString("identity"));
        	asset.setType(Type.valueOf(rs.getInt("type")));
        	asset.setCardNo(rs.getString("cardNo"));
        	asset.setSerialCode(rs.getString("serialCode"));
        	asset.setTime(rs.getLong("time"));
        	asset.setRelatedAsset(rs.getString("relatedAsset"));
        	asset.setStatus(rs.getInt("status"));
        	
            results.put(rs.getLong("id"), asset);
        } while (rs.next());

        return results;
	}

}
