package com.xdja.cssp.acs.service.handler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.dbutils.ResultSetHandler;

import com.xdja.cssp.acs.bean.asset.BackupCard;

/**
 * 备份卡信息处理类
 * 
 * Project Name：acs-service
 * ClassName：BackupCardBeanMapHandler
 * Description：
 * @author: shaoyuehua
 * @date: 2016-11-8 下午7:29:12
 * note:
 *
 */
public class BackupCardBeanMapHandler implements ResultSetHandler<Map<Long, BackupCard>> {

	@Override
	public Map<Long, BackupCard> handle(ResultSet rs) throws SQLException {
		Map<Long, BackupCard> results = new HashMap<Long, BackupCard>();

        if (!rs.next()) {
            return results;
        }
        
        BackupCard card = null;
        do {
        	card = new BackupCard();
        	card.setBakCardSn(rs.getString("bakCardSn"));
			card.setPublicKey(rs.getString("publicKey"));
			card.setPrivateKey(rs.getString("privateKey"));
			card.setVerifyCode(rs.getString("verifyCode"));
			card.setRecoveryCode(rs.getString("recoveryCode"));
			card.setBakCardStatus(rs.getInt("bakCardStatus"));
			card.setbKeyPairAlg(rs.getInt("bKeyPairAlg"));
			card.setEncBkeyPairAlg(rs.getInt("encBkeyPairAlg"));
			
            results.put(rs.getLong("id"), card);
        } while (rs.next());

        return results;
	}

}
