package com.xdja.cssp.acs.service.handler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.dbutils.ResultSetHandler;

import com.xdja.cssp.acs.bean.cert.Cert;
import com.xdja.cssp.acs.bean.cert.Cert.CaAlg;
import com.xdja.cssp.acs.bean.cert.Cert.CertType;

/**
 * 证书信息处理类，负责把查询到的证书信息封装为List&lt;Cert&gt;
 * @date 2015-2-9
 * @author rrx
 * 
 */
public class CertBeanListHandler implements ResultSetHandler<List<Cert>> {

	@Override
	public List<Cert> handle(ResultSet rs) throws SQLException {
		List<Cert> results = new ArrayList<Cert>();

        if (!rs.next()) {
            return results;
        }
        
        Cert cert = null;
        do {
        	cert = new Cert();
        	cert.setCardNo(rs.getString("cardNo"));
        	cert.setSn(rs.getString("sn"));
        	cert.setCaAlg(CaAlg.valueOf(rs.getInt("caAlg")));
        	cert.setCertType(CertType.valueOf(rs.getInt("certType")));
        	cert.setCert(rs.getString("cert"));
        	results.add(cert);
        } while (rs.next());

        return results;
	}

}
