package com.xdja.cssp.acs.service.handler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.dbutils.ResultSetHandler;

import com.xdja.cssp.acs.bean.cert.Cert;
import com.xdja.cssp.acs.bean.cert.Cert.CaAlg;
import com.xdja.cssp.acs.bean.cert.Cert.CertType;

/**
 * 证书信息处理类，负责把查询到的证书信息封装为Map&lt;String, List&lt;Cert&gt;&gt;
 * <P>
 * Map中的key为卡号（c_card_no）
 * @date 2015-2-9
 * @author rrx
 * 
 */
public class CertBeanMapHandler implements ResultSetHandler<Map<String, List<Cert>>> {

	@Override
	public Map<String, List<Cert>> handle(ResultSet rs) throws SQLException {
		Map<String, List<Cert>> results = new HashMap<String, List<Cert>>();

        if (!rs.next()) {
            return results;
        }
        
        List<Cert> certs = null;
        Cert cert = null;
        do {
        	certs = results.get(rs.getString("cardNo"));
        	if (null == certs) {
        		certs = new ArrayList<Cert>();
        		results.put(rs.getString("cardNo"), certs);
        	}
        	
        	cert = new Cert();
        	cert.setCardNo(rs.getString("cardNo"));
        	cert.setSn(rs.getString("sn"));
        	cert.setCaAlg(CaAlg.valueOf(rs.getInt("caAlg")));
        	cert.setCertType(CertType.valueOf(rs.getInt("certType")));
        	cert.setCert(rs.getString("cert"));
        	certs.add(cert);
        } while (rs.next());

        return results;
	}

}
