package com.xdja.cssp.acs.service.handler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.dbutils.ResultSetHandler;

import com.xdja.cssp.acs.service.bean.CheckStateCert;

/**
 * 证书状态查询结果处理类，负责把查询到的证书状态封装为Map&lt;String, CheckStateCert&gt;
 * <P>
 * Map中的key为c_cert_sn
 * @date 2015-2-10
 * @author rrx
 * 
 */
public class CheckStateCertMapHandler implements ResultSetHandler<Map<String, CheckStateCert>> {

	@Override
	public Map<String, CheckStateCert> handle(ResultSet rs) throws SQLException {
		Map<String, CheckStateCert> results = new HashMap<String, CheckStateCert>();

        if (!rs.next()) {
            return results;
        }
        
        CheckStateCert state = null;
        do {
        	state = new CheckStateCert();
        	state.setSn(rs.getString("sn"));
        	state.setState(rs.getInt("state"));
        	results.put(state.getSn(), state);
        } while (rs.next());

        return results;
	}

}
