package com.xdja.cssp.acs.service.handler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.dbutils.ResultSetHandler;

import com.xdja.cssp.acs.bean.cert.PublicKey;
import com.xdja.cssp.acs.bean.cert.PublicKey.CaAlg;
import com.xdja.cssp.acs.bean.cert.PublicKey.CertType;

/**
 * 公钥信息处理类，负责把查询到的公钥信息封装为List&lt;PublicKey&gt;
 * @date 2015-2-9
 * @author rrx
 * 
 */
public class PublicKeyBeanListHandler implements ResultSetHandler<List<PublicKey>> {

	@Override
	public List<PublicKey> handle(ResultSet rs) throws SQLException {
		List<PublicKey> results = new ArrayList<PublicKey>();

        if (!rs.next()) {
            return results;
        }
        
        PublicKey pk = null;
        do {
        	pk = new PublicKey();
        	pk.setCardNo(rs.getString("cardNo"));
        	pk.setSn(rs.getString("sn"));
        	pk.setCaAlg(CaAlg.valueOf(rs.getInt("caAlg")));
        	pk.setCertType(CertType.valueOf(rs.getInt("certType")));
        	pk.setPublicKey(rs.getString("publicKey"));
        	results.add(pk);
        } while (rs.next());

        return results;
	}

}
