package com.xdja.cssp.acs.service.handler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.dbutils.ResultSetHandler;

import com.xdja.cssp.acs.bean.cert.PublicKey;
import com.xdja.cssp.acs.bean.cert.PublicKey.CaAlg;
import com.xdja.cssp.acs.bean.cert.PublicKey.CertType;

/**
 * 公钥信息处理类，负责把查询到的公钥信息封装为Map&lt;String, List&lt;PublicKey&gt;&gt;
 * <P>
 * Map中的key为卡号（c_card_no）
 * @date 2015-2-6
 * @author rrx
 * 
 */
public class PublicKeyBeanMapHandler implements ResultSetHandler<Map<String, List<PublicKey>>> {

	@Override
	public Map<String, List<PublicKey>> handle(ResultSet rs) throws SQLException {
		Map<String, List<PublicKey>> results = new HashMap<String, List<PublicKey>>();

        if (!rs.next()) {
            return results;
        }
        
        List<PublicKey> pks = null;
        PublicKey pk = null;
        do {
        	pks = results.get(rs.getString("cardNo"));
        	if (null == pks) {
        		pks = new ArrayList<PublicKey>();
        		results.put(rs.getString("cardNo"), pks);
        	}
        	
        	pk = new PublicKey();
        	pk.setCardNo(rs.getString("cardNo"));
        	pk.setSn(rs.getString("sn"));
        	pk.setCaAlg(CaAlg.valueOf(rs.getInt("caAlg")));
        	pk.setCertType(CertType.valueOf(rs.getInt("certType")));
        	pk.setPublicKey(rs.getString("publicKey"));
        	pks.add(pk);
        } while (rs.next());

        return results;
	}

}
