package com.xdja.cssp.acs.service.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

import com.xdja.cssp.acs.IBackupCardService;
import com.xdja.cssp.acs.bean.asset.BackupCard;
import com.xdja.cssp.acs.service.Constants;
import com.xdja.cssp.acs.service.handler.BackupCardBeanMapHandler;
import com.xdja.cssp.acs.service.handler.CheckBackupMapHandler;
import com.xdja.platform.common.lite.kit.StrKit;
import com.xdja.platform.common.lite.kit.prop.Prop;
import com.xdja.platform.common.lite.kit.prop.PropKit;
import com.xdja.platform.microservice.ServiceException;
import com.xdja.platform.microservice.db.Dao;
import com.xdja.platform.microservice.db.SqlHelper;

/**
 * 备份卡服务实现
 * 
 * Project Name：acs-service
 * ClassName：BackupCardServiceImpl
 * Description：
 * @author: shaoyuehua
 * @date: 2016-11-3 上午10:13:57
 * note:
 *
 */
@Component
public class BackupCardServiceImpl implements IBackupCardService, InitializingBean {

	private final Dao amsDao = Dao.use(Constants.DB_AMSCORE);
	
	/**
	 * 查询备份卡信息sql
	 */
	private static String QUERY_BACKUPCARD_SQL = null;
	
	/**
	 * 检测备份卡是否存在sql
	 */
	private static String CHECK_BACKUPCARD_SN_SQL = null;
	
	@Override
	public List<BackupCard> queryBakCards(String... bakCardSn) {
		if (null == bakCardSn || bakCardSn.length <= 0) {
			return Collections.emptyList();
		}
		
		Map<Long, BackupCard> assetMap = null;
		try {
			String sql = SqlHelper.prepare(QUERY_BACKUPCARD_SQL, "#bakcardSn", bakCardSn.length);
			assetMap = amsDao.queryForMap(sql, new BackupCardBeanMapHandler(), Arrays.asList(bakCardSn).toArray());
		} catch (SQLException e) {
			throw ServiceException.create(String.format("查询指定备份卡信息（%s）时出现异常", Arrays.toString(bakCardSn)), e);
		}
		
		List<BackupCard> result = new ArrayList<BackupCard>();
		if (null != assetMap && !assetMap.isEmpty()) {
			result.addAll(assetMap.values());
		}
		
		return result;
	}

	@Override
	public Map<String, Boolean> checkBakCardsExists(String... bakCardSn) {
		if (null == bakCardSn || bakCardSn.length <= 0) {
			return Collections.emptyMap();
		}
		
		Map<String, Boolean> result = new HashMap<String, Boolean>();
		Map<String, Integer> cardSnMap = new HashMap<String, Integer>();
		boolean isexists;
		
		try {
			String sql = SqlHelper.prepare(CHECK_BACKUPCARD_SN_SQL, "#bakcardSn", bakCardSn.length);
			cardSnMap = amsDao.queryForMap(sql, new CheckBackupMapHandler(), Arrays.asList(bakCardSn).toArray());
		} catch (SQLException e) {
			throw ServiceException.create(String.format("检测备份卡信息（%s）是否存在时出现异常", Arrays.toString(bakCardSn)), e);
		}

		for (int i = 0; i < bakCardSn.length; i++) {
			isexists = false;
			if (cardSnMap.containsKey(bakCardSn[i].toLowerCase())) {
				isexists = true;
			}
			result.put(bakCardSn[i], isexists);
		}
		return result;
	}
	
	@Override
	public void afterPropertiesSet() throws Exception {
		Prop sqlProp = PropKit.use("sql/asset");
		
		QUERY_BACKUPCARD_SQL = sqlProp.get("query.bakcard");
		if (StrKit.isBlank(QUERY_BACKUPCARD_SQL)) {
			throw ServiceException.create(String.format("sql语句%s不存在", "query.bakcard"));
		}
		
		CHECK_BACKUPCARD_SN_SQL = sqlProp.get("check.bakcard");
		if (StrKit.isBlank(CHECK_BACKUPCARD_SN_SQL)) {
			throw ServiceException.create(String.format("sql语句%s不存在", "check.bakcard"));
		}
	}
}
