/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.acs.service;

import com.xdja.platform.common.lite.kit.StrKit;
import com.xdja.platform.common.lite.kit.prop.Prop;
import com.xdja.platform.common.lite.kit.prop.PropKit;
import com.xdja.platform.microservice.ServiceException;
import com.xdja.platform.microservice.config.MicroServiceConfig;
import com.xdja.platform.microservice.db.DataSourceProvider;
import com.xdja.platform.microservice.db.DbUtilsPlugin;
import com.xdja.platform.microservice.db.druid.DruidPlugin;
import com.xdja.platform.microservice.plugin.IPlugin;
import com.xdja.platform.microservice.plugin.Plugins;
import com.xdja.platform.microservice.spring.SpringPlugin;
import com.xdja.platform.rpc.provider.ProviderStarter;
import java.net.BindException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACSConfig
extends MicroServiceConfig {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public void configPlugin(Plugins me) {
        Prop systemProp = PropKit.use((String)"system.properties");
        String url = systemProp.get("jdbc.url");
        if (StrKit.isBlank((String)url)) {
            throw ServiceException.create((String)"\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6system.properties\u4e2d\u6dfb\u52a0jdbc.url\u7684\u914d\u7f6e");
        }
        String userName = systemProp.get("jdbc.username");
        if (StrKit.isBlank((String)userName)) {
            throw ServiceException.create((String)"\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6system.properties\u4e2d\u6dfb\u52a0jdbc.username\u7684\u914d\u7f6e");
        }
        String password = systemProp.get("jdbc.password");
        DruidPlugin dbPlugin = new DruidPlugin(url, userName, password);
        me.add((IPlugin)dbPlugin);
        me.add((IPlugin)new DbUtilsPlugin("db::acs", (DataSourceProvider)dbPlugin));
        String[] configLocations = new String[]{"classpath*:/META-INF/spring/applicationContext-*.xml", "classpath*:/applicationContext.xml"};
        me.add((IPlugin)new SpringPlugin(configLocations));
    }

    public void afterStart() {
        Prop systemProp = PropKit.use((String)"system.properties");
        String ip = systemProp.get("rpc.ip", "127.0.0.1");
        int port = systemProp.getInt("rpc.port", Integer.valueOf(6666));
        int maxWorkThread = systemProp.getInt("rpc.maxWorkThread", Integer.valueOf(100));
        try {
            ProviderStarter.NETTY.setMaxWorkThread(maxWorkThread).start(ip, port);
            this.logger.info("====>ACS\u670d\u52a1{}:{}\u542f\u52a8\u6210\u529f\uff0c\u6700\u5927\u5de5\u4f5c\u7ebf\u7a0b\u6570\u4e3a{}\u4e2a\uff01", new Object[]{ip, port, maxWorkThread});
        }
        catch (BindException e) {
            this.logger.error("\u670d\u52a1\u7ed1\u5b9a\u5f02\u5e38", (Object)e.getMessage());
        }
        catch (InterruptedException e) {
            this.logger.error("\u7ebf\u7a0b\u5f02\u5e38", (Object)e.getMessage());
        }
    }
}

