/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.acs.service.impl;

import com.xdja.cssp.acs.IAssetService;
import com.xdja.cssp.acs.bean.asset.Asset;
import com.xdja.cssp.acs.bean.asset.ProductAsset;
import com.xdja.cssp.acs.bean.asset.SearchBean;
import com.xdja.cssp.acs.bean.asset.Type;
import com.xdja.cssp.acs.service.handler.AssetBeanMapHandler;
import com.xdja.platform.common.lite.kit.StrKit;
import com.xdja.platform.common.lite.kit.prop.Prop;
import com.xdja.platform.common.lite.kit.prop.PropKit;
import com.xdja.platform.microservice.ServiceException;
import com.xdja.platform.microservice.db.Dao;
import com.xdja.platform.microservice.db.SqlHelper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class AssetServiceImpl
implements IAssetService,
InitializingBean {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Dao acsDao = Dao.use((String)"db::acs");
    private final Dao amsDao = Dao.use((String)"db::amscore");
    private static String ASSET_EXISTS_SQL = null;
    private static String QUERY_ASSET_SQL = null;
    private static List<String> QUERY_ASSET_PROP_SQLS = new ArrayList<String>();
    private static String QUERY_RELATED_SQL = null;
    private static String QUERY_USBKEY_TYPE = null;

    public boolean exists(String assetIdentity) {
        if (StrKit.isBlank((String)assetIdentity)) {
            throw new IllegalArgumentException("\u53c2\u6570assetIdentity\u4e3a\u7a7a");
        }
        try {
            return this.acsDao.queryForLong(ASSET_EXISTS_SQL, new Object[]{assetIdentity}) > 0L;
        }
        catch (SQLException e) {
            throw ServiceException.create((String)String.format("\u5224\u65ad\u6807\u8bc6\u4e3a%s\u7684\u8d44\u4ea7\u662f\u5426\u5b58\u5728\u65f6\u51fa\u73b0\u5f02\u5e38", assetIdentity), (Exception)e);
        }
    }

    public List<Asset> queryAssets(String ... assetIdentity) {
        if (null == assetIdentity || assetIdentity.length <= 0) {
            return Collections.emptyList();
        }
        Map assetMap = null;
        try {
            String sql = SqlHelper.prepare((String)QUERY_ASSET_SQL, (String)"#identity", (int)assetIdentity.length);
            assetMap = this.acsDao.queryForMap(sql, (ResultSetHandler)new AssetBeanMapHandler(), Arrays.asList(assetIdentity).toArray());
        }
        catch (SQLException e) {
            throw ServiceException.create((String)String.format("\u67e5\u8be2\u6307\u5b9a\u8d44\u4ea7\u4fe1\u606f\uff08%s\uff09\u65f6\u51fa\u73b0\u5f02\u5e38", Arrays.toString(assetIdentity)), (Exception)e);
        }
        try {
            if (null != assetMap && !assetMap.isEmpty()) {
                for (String sql : QUERY_ASSET_PROP_SQLS) {
                    sql = SqlHelper.prepare((String)sql, (String)"#assetId", (int)assetMap.size());
                    for (Map assetProp : this.acsDao.queryForList(sql, assetMap.keySet().toArray())) {
                        ((Asset)assetMap.get(assetProp.get("assetId"))).setInfo(assetProp);
                    }
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw ServiceException.create((String)String.format("\u67e5\u8be2\u6307\u5b9a\u8d44\u4ea7\u4fe1\u606f\uff08%s\uff09\u65f6\u51fa\u73b0\u5f02\u5e38", Arrays.toString(assetIdentity)), (Exception)e);
        }
        ArrayList<Asset> result = new ArrayList<Asset>();
        if (null != assetMap && !assetMap.isEmpty()) {
            result.addAll(assetMap.values());
        }
        return result;
    }

    public String queryRelatedByIdentity(String assetIdentity) {
        if (StrKit.isBlank((String)assetIdentity)) {
            throw new IllegalArgumentException("\u53c2\u6570assetIdentity\u4e3a\u7a7a");
        }
        String related = null;
        try {
            related = this.acsDao.queryForStr(QUERY_RELATED_SQL, new Object[]{assetIdentity});
        }
        catch (SQLException e) {
            throw ServiceException.create((String)String.format("\u67e5\u8be2\u6307\u5b9a\u8d44\u4ea7\uff08%s\uff09\u5173\u8054\u7684\u8d44\u4ea7\u6807\u8bc6\u65f6\u51fa\u73b0\u5f02\u5e38", assetIdentity), (Exception)e);
        }
        if (null == related) {
            related = "";
        }
        return related;
    }

    public String queryUnlockByUId(String uId) {
        if (StrKit.isBlank((String)uId)) {
            throw new IllegalArgumentException("\u53c2\u6570uId\u4e3a\u7a7a");
        }
        try {
            return this.acsDao.queryForStr("SELECT c_unlock_code FROM t_terminal_unlock_code WHERE c_card_uid=?", new Object[]{uId});
        }
        catch (SQLException e) {
            throw ServiceException.create((String)String.format("\u6839\u636e\u5b89\u5168\u5361UID=%s\u67e5\u8be2\u52a0\u5bc6\u89e3\u9501\u7801\u65f6\u51fa\u73b0\u5f02\u5e38", uId), (Exception)e);
        }
    }

    public String queryUnlockByCardNo(String cardNo) {
        if (StrKit.isBlank((String)cardNo)) {
            throw new IllegalArgumentException("\u53c2\u6570cardNo\u4e3a\u7a7a");
        }
        try {
            return this.acsDao.queryForStr("SELECT c_unlock_code FROM t_terminal_unlock_code WHERE c_card_no=?", new Object[]{cardNo});
        }
        catch (SQLException e) {
            throw ServiceException.create((String)String.format("\u6839\u636e\u5b89\u5168\u5361cardNo=%s\u67e5\u8be2\u52a0\u5bc6\u89e3\u9501\u7801\u65f6\u51fa\u73b0\u5f02\u5e38", cardNo), (Exception)e);
        }
    }

    public String queryCardNoByUId(String uId) {
        if (StrKit.isBlank((String)uId)) {
            throw new IllegalArgumentException("\u53c2\u6570uId\u4e3a\u7a7a");
        }
        try {
            return this.acsDao.queryForStr("SELECT c_card_no FROM t_terminal_unlock_code WHERE c_card_uid=?", new Object[]{uId});
        }
        catch (SQLException e) {
            throw ServiceException.create((String)String.format("\u6839\u636eUID\u67e5\u8be2\u52a0\u5bc6\u89e3\u9501\u7801\u65f6\u51fa\u73b0\u5f02\u5e38,uId=%s", uId), (Exception)e);
        }
    }

    public List<Asset> queryAssets(SearchBean searchBean) {
        if (null == searchBean || StringUtils.isBlank((CharSequence)searchBean.getSn()) && StringUtils.isBlank((CharSequence)searchBean.getImei()) && StringUtils.isBlank((CharSequence)searchBean.getSerialCode())) {
            return Collections.emptyList();
        }
        try {
            ArrayList<String> params = new ArrayList<String>();
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT info.n_id AS id, info.c_asset_identify AS identity, info.n_asset_type AS type, info.c_card_no AS cardNo,");
            sql.append(" info.c_serial_code AS serialCode, info.n_time AS time, info.c_relation_asset_identify AS relatedAsset,");
            sql.append(" info.n_status AS status, mobile.n_asset_id AS assetId, mobile.c_model AS model, mobile.c_chip_code AS chipCode,");
            sql.append(" mobile.c_os_name AS osName, mobile.c_os_version AS osVersion, mobile.c_imei AS imei, mobile.c_sn_no AS snNo");
            sql.append(" FROM t_asset_info info");
            sql.append(" JOIN t_asset_mobiles_info mobile ON info.n_id = mobile.n_asset_id WHERE 1=1");
            if (StringUtils.isNotBlank((CharSequence)searchBean.getSn())) {
                sql.append(" AND mobile.c_sn_no LIKE ?");
                params.add("%" + searchBean.getSn() + "%");
            }
            if (StringUtils.isNotBlank((CharSequence)searchBean.getImei())) {
                sql.append(" AND mobile.c_imei LIKE ?");
                params.add("%" + searchBean.getImei() + "%");
            }
            if (StringUtils.isNotBlank((CharSequence)searchBean.getSerialCode())) {
                sql.append(" OR info.c_serial_code LIKE ?");
                params.add("%" + searchBean.getSerialCode() + "%");
            }
            return this.acsDao.queryForList(sql.toString(), (ResultSetHandler)new ResultSetHandler<List<Asset>>(){

                public List<Asset> handle(ResultSet rs) throws SQLException {
                    ArrayList<Asset> result = new ArrayList<Asset>();
                    HashMap<String, String> info = null;
                    Asset asset = null;
                    while (rs.next()) {
                        asset = new Asset();
                        asset.setIdentity(rs.getString("identity"));
                        asset.setType(Type.valueOf((int)rs.getInt("type")));
                        asset.setCardNo(rs.getString("cardNo"));
                        asset.setSerialCode(rs.getString("serialCode"));
                        asset.setTime(Long.valueOf(rs.getLong("time")));
                        asset.setRelatedAsset(rs.getString("relatedAsset"));
                        asset.setStatus(rs.getInt("status"));
                        if (StringUtils.isNotBlank((CharSequence)rs.getString("snNo"))) {
                            info = new HashMap<String, String>();
                            info.put("model", rs.getString("model"));
                            info.put("chipCode", rs.getString("chipCode"));
                            info.put("osName", rs.getString("osName"));
                            info.put("osVersion", rs.getString("osVersion"));
                            info.put("imei", rs.getString("imei"));
                            info.put("snNo", rs.getString("snNo"));
                            asset.setInfo(info);
                        }
                        result.add(asset);
                    }
                    return result;
                }
            }, params.toArray());
        }
        catch (Exception e) {
            throw ServiceException.create((String)"\u6839\u636e\u8bbe\u5907\u6269\u5c55\u5c5e\u6027\u67e5\u8be2\u8bbe\u5907\u4fe1\u606f\u65f6\u51fa\u73b0\u5f02\u5e38", (Exception)e);
        }
    }

    public Map<String, Object> queryUnLockInfo(String cardNo, String uId) {
        if (StringUtils.isBlank((CharSequence)cardNo) && StringUtils.isBlank((CharSequence)uId)) {
            throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5\uff0ccardNo,uId\u81f3\u5c11\u6709\u4e00\u4e2a\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT c_card_no cardNo, c_card_uid uId, c_unlock_code unLockCode, c_disk_code diskCode");
            sql.append(" FROM t_terminal_unlock_code WHERE 1=1");
            ArrayList<String> params = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)cardNo)) {
                sql.append(" AND c_card_no = ?");
                params.add(cardNo);
            }
            if (StringUtils.isNotBlank((CharSequence)uId)) {
                sql.append(" AND c_card_uid = ?");
                params.add(uId);
            }
            return this.acsDao.queryForMap(sql.toString(), params.toArray());
        }
        catch (Exception e) {
            throw ServiceException.create((String)String.format("\u67e5\u8be2\u89e3\u9501\u7801\u4fe1\u606f\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u6c42\u53c2\u6570cardNo=%s , uId=%s", cardNo, uId), (Exception)e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        Prop sqlProp = PropKit.use((String)"sql/asset");
        ASSET_EXISTS_SQL = sqlProp.get("asset.exists");
        if (StrKit.isBlank((String)ASSET_EXISTS_SQL)) {
            throw ServiceException.create((String)String.format("sql\u8bed\u53e5%s\u4e0d\u5b58\u5728", "asset.exists"));
        }
        QUERY_ASSET_SQL = sqlProp.get("query.asset");
        if (StrKit.isBlank((String)QUERY_ASSET_SQL)) {
            throw ServiceException.create((String)String.format("sql\u8bed\u53e5%s\u4e0d\u5b58\u5728", "query.asset"));
        }
        QUERY_RELATED_SQL = sqlProp.get("query.related");
        if (StrKit.isBlank((String)QUERY_RELATED_SQL)) {
            throw ServiceException.create((String)String.format("sql\u8bed\u53e5%s\u4e0d\u5b58\u5728", "query.related"));
        }
        for (Object key : sqlProp.getProperties().keySet()) {
            if (!key.toString().startsWith("query.asset.")) continue;
            QUERY_ASSET_PROP_SQLS.add(sqlProp.get(key.toString()));
        }
        QUERY_USBKEY_TYPE = sqlProp.get("query.usbkey.type");
        if (StrKit.isBlank((String)QUERY_USBKEY_TYPE)) {
            throw ServiceException.create((String)String.format("sql\u8bed\u53e5%s\u4e0d\u5b58\u5728", "query.usbkey.type"));
        }
    }

    public boolean queryUsbkeyIsBC(String sn, Integer caAlg) {
        if (StrKit.isBlank((String)sn) || null == caAlg) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            return this.acsDao.queryForLong(QUERY_USBKEY_TYPE, new Object[]{sn, caAlg}) > 0L;
        }
        catch (SQLException e) {
            throw ServiceException.create((String)String.format("\u5224\u65adsn\u4e3a%s\u7684\u8d44\u4ea7\u662f\u5426\u5177\u6709\u5907\u4efd\u6062\u590d\u529f\u80fd\u65f6\u51fa\u73b0\u5f02\u5e38", sn), (Exception)e);
        }
    }

    public ProductAsset queryAssetByIdentity(String assetIdentify) {
        if (StringUtils.isBlank((CharSequence)assetIdentify)) {
            throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5");
        }
        try {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("SELECT ai.c_asset_identify AS identity, ai.c_asset_type AS type, ai.c_card_no AS cardNo, ai.c_serial_code AS serialCode, ai.n_status AS status, ");
            sqlBuffer.append("tp.c_name AS projectName, tc.c_name AS customerName, tc.c_customer_tax AS customerTax, tor.c_name AS orderName, ");
            sqlBuffer.append("tpi.c_product_category AS productCategory, tpi.c_product_name AS productName, tpi.c_product_model AS productModel, tpi.c_program_version AS programVersion, tpi.c_system_version AS systemVersion ");
            sqlBuffer.append("FROM t_asset_info ai ");
            sqlBuffer.append("LEFT JOIN t_project tp ON ai.n_customer_id = tp.n_customer_id ");
            sqlBuffer.append("LEFT JOIN t_customer tc ON ai.n_customer_id = tc.n_id ");
            sqlBuffer.append("LEFT JOIN t_order tor ON ai.n_customer_id = tor.n_customer_id ");
            sqlBuffer.append("LEFT JOIN t_product_info tpi ON ai.c_asset_identify = tpi.c_asset_identify WHERE 1=1 ");
            sqlBuffer.append("AND (ai.c_asset_identify = ? OR ai.c_serial_code = ?) ");
            ArrayList<String> params = new ArrayList<String>();
            params.add(assetIdentify);
            params.add(assetIdentify);
            return (ProductAsset)this.amsDao.queryForObject(ProductAsset.class, sqlBuffer.toString(), params.toArray());
        }
        catch (Exception e) {
            throw ServiceException.create((String)MessageFormat.format("\u67e5\u8be2\u8d44\u4ea7\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u6c42\u53c2\u6570assetIdentify = {0}", assetIdentify), (Exception)e);
        }
    }

    public ProductAsset queryAssetByCustomerInfo(String customerName, String customerTax) {
        if (StringUtils.isBlank((CharSequence)customerName) && StringUtils.isBlank((CharSequence)customerTax)) {
            throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5, \u5ba2\u6237\u540d\u79f0\u548c\u5ba2\u6237\u7a0e\u53f7\u81f3\u5c11\u4e00\u4e2a\u4e0d\u4e3a\u7a7a");
        }
        try {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("SELECT ai.c_asset_identify AS identity, ai.c_asset_type AS type, ai.c_card_no AS cardNo, ai.c_serial_code AS serialCode, ai.n_status AS status, ");
            sqlBuffer.append("tp.c_name AS projectName, tc.c_name AS customerName, tc.c_customer_tax AS customerTax, tor.c_name AS orderName, ");
            sqlBuffer.append("tpi.c_product_category AS productCategory, tpi.c_product_name AS productName, tpi.c_product_model AS productModel, tpi.c_program_version AS programVersion, tpi.c_system_version AS systemVersion ");
            sqlBuffer.append("FROM t_customer tc ");
            sqlBuffer.append("LEFT JOIN t_project tp ON tc.n_id = tp.n_customer_id ");
            sqlBuffer.append("LEFT JOIN t_asset_info ai ON ai.n_customer_id = tc.n_id ");
            sqlBuffer.append("LEFT JOIN t_order tor ON tc.n_id = tor.n_customer_id ");
            sqlBuffer.append("LEFT JOIN t_product_info tpi ON tc.n_id = tpi.n_customer_id WHERE 1=1 ");
            ArrayList<String> params = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)customerName)) {
                sqlBuffer.append("AND tc.c_name = ? ");
                params.add(customerName);
            }
            if (StringUtils.isNotBlank((CharSequence)customerTax)) {
                sqlBuffer.append("AND tc.c_customer_tax = ? ");
                params.add(customerTax);
            }
            return (ProductAsset)this.amsDao.queryForObject(ProductAsset.class, sqlBuffer.toString(), params.toArray());
        }
        catch (Exception e) {
            throw ServiceException.create((String)MessageFormat.format("\u67e5\u8be2\u8d44\u4ea7\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u6c42\u53c2\u6570customerName = {0}, customerTax = {1}", customerName, customerTax), (Exception)e);
        }
    }
}

