/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.acs.service.impl;

import com.xdja.cssp.acs.IBackupCardService;
import com.xdja.cssp.acs.bean.asset.BackupCard;
import com.xdja.cssp.acs.service.handler.BackupCardBeanMapHandler;
import com.xdja.cssp.acs.service.handler.CheckBackupMapHandler;
import com.xdja.platform.common.lite.kit.StrKit;
import com.xdja.platform.common.lite.kit.prop.Prop;
import com.xdja.platform.common.lite.kit.prop.PropKit;
import com.xdja.platform.microservice.ServiceException;
import com.xdja.platform.microservice.db.Dao;
import com.xdja.platform.microservice.db.SqlHelper;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.ResultSetHandler;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class BackupCardServiceImpl
implements IBackupCardService,
InitializingBean {
    private final Dao amsDao = Dao.use((String)"db::amscore");
    private static String QUERY_BACKUPCARD_SQL = null;
    private static String CHECK_BACKUPCARD_SN_SQL = null;

    public List<BackupCard> queryBakCards(String ... bakCardSn) {
        if (null == bakCardSn || bakCardSn.length <= 0) {
            return Collections.emptyList();
        }
        Map assetMap = null;
        try {
            String sql = SqlHelper.prepare((String)QUERY_BACKUPCARD_SQL, (String)"#bakcardSn", (int)bakCardSn.length);
            assetMap = this.amsDao.queryForMap(sql, (ResultSetHandler)new BackupCardBeanMapHandler(), Arrays.asList(bakCardSn).toArray());
        }
        catch (SQLException e) {
            throw ServiceException.create((String)String.format("\u67e5\u8be2\u6307\u5b9a\u5907\u4efd\u5361\u4fe1\u606f\uff08%s\uff09\u65f6\u51fa\u73b0\u5f02\u5e38", Arrays.toString(bakCardSn)), (Exception)e);
        }
        ArrayList<BackupCard> result = new ArrayList<BackupCard>();
        if (null != assetMap && !assetMap.isEmpty()) {
            result.addAll(assetMap.values());
        }
        return result;
    }

    public Map<String, Boolean> checkBakCardsExists(String ... bakCardSn) {
        if (null == bakCardSn || bakCardSn.length <= 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        Map cardSnMap = new HashMap();
        try {
            String sql = SqlHelper.prepare((String)CHECK_BACKUPCARD_SN_SQL, (String)"#bakcardSn", (int)bakCardSn.length);
            cardSnMap = this.amsDao.queryForMap(sql, (ResultSetHandler)new CheckBackupMapHandler(), Arrays.asList(bakCardSn).toArray());
        }
        catch (SQLException e) {
            throw ServiceException.create((String)String.format("\u68c0\u6d4b\u5907\u4efd\u5361\u4fe1\u606f\uff08%s\uff09\u662f\u5426\u5b58\u5728\u65f6\u51fa\u73b0\u5f02\u5e38", Arrays.toString(bakCardSn)), (Exception)e);
        }
        for (int i = 0; i < bakCardSn.length; ++i) {
            boolean isexists = false;
            if (cardSnMap.containsKey(bakCardSn[i].toLowerCase())) {
                isexists = true;
            }
            result.put(bakCardSn[i], isexists);
        }
        return result;
    }

    public void afterPropertiesSet() throws Exception {
        Prop sqlProp = PropKit.use((String)"sql/asset");
        QUERY_BACKUPCARD_SQL = sqlProp.get("query.bakcard");
        if (StrKit.isBlank((String)QUERY_BACKUPCARD_SQL)) {
            throw ServiceException.create((String)String.format("sql\u8bed\u53e5%s\u4e0d\u5b58\u5728", "query.bakcard"));
        }
        CHECK_BACKUPCARD_SN_SQL = sqlProp.get("check.bakcard");
        if (StrKit.isBlank((String)CHECK_BACKUPCARD_SN_SQL)) {
            throw ServiceException.create((String)String.format("sql\u8bed\u53e5%s\u4e0d\u5b58\u5728", "check.bakcard"));
        }
    }
}

