/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.acs.service.impl;

import com.xdja.cssp.acs.ICertService;
import com.xdja.cssp.acs.bean.cert.Cert;
import com.xdja.cssp.acs.bean.cert.CertStatus;
import com.xdja.cssp.acs.bean.cert.PublicKey;
import com.xdja.cssp.acs.service.bean.CheckStateCert;
import com.xdja.cssp.acs.service.handler.CertBeanListHandler;
import com.xdja.cssp.acs.service.handler.CertBeanMapHandler;
import com.xdja.cssp.acs.service.handler.CheckStateCertMapHandler;
import com.xdja.cssp.acs.service.handler.PublicKeyBeanListHandler;
import com.xdja.cssp.acs.service.handler.PublicKeyBeanMapHandler;
import com.xdja.platform.common.lite.kit.StrKit;
import com.xdja.platform.common.lite.kit.prop.Prop;
import com.xdja.platform.common.lite.kit.prop.PropKit;
import com.xdja.platform.microservice.ServiceException;
import com.xdja.platform.microservice.db.Dao;
import com.xdja.platform.microservice.db.SqlHelper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class CertServiceImpl
implements ICertService,
InitializingBean {
    private final Dao acsDao = Dao.use((String)"db::acs");
    private final Dao amsDao = Dao.use((String)"db::amscore");
    private static String CHECK_CERT_BY_CARDNO_SQL = null;
    private static String QUERY_PUBLICKEY_BY_SNLIST_SQL = null;
    private static String QUERY_PUBLICKEY_BY_CARDNOLIST_SQL = null;
    private static String QUERY_CERT_BY_SNLIST_SQL = null;
    private static String QUERY_CERT_BY_CARDNOLIST_SQL = null;
    private static String QUERY_HIS_CERT_BY_SNLIST_SQL = null;

    public CertStatus checkCertStatus(String cardNo, String sn, int caAlg) {
        if (StrKit.isBlank((String)cardNo)) {
            throw new IllegalArgumentException("\u53c2\u6570cardNo\u4e3a\u7a7a");
        }
        if (StrKit.isBlank((String)sn)) {
            throw new IllegalArgumentException("\u53c2\u6570sn\u4e3a\u7a7a");
        }
        if (caAlg <= 0 || caAlg > 2) {
            throw new IllegalArgumentException("\u53c2\u6570caAlg\u7684\u53d6\u503c\u8303\u56f4\u4e3a[1-RSA\uff0c2-SM2]");
        }
        CertStatus certStatus = CertStatus.SUCCESS;
        try {
            Map certStateMap = this.acsDao.queryForMap(CHECK_CERT_BY_CARDNO_SQL, (ResultSetHandler)new CheckStateCertMapHandler(), new Object[]{cardNo, caAlg});
            if (null == certStateMap || certStateMap.isEmpty()) {
                certStatus = CertStatus.CARD_NOT_EXISTS;
            } else if (!certStateMap.containsKey(sn)) {
                certStatus = CertStatus.CARD_SN_DISACCORD;
            } else if (2 == ((CheckStateCert)certStateMap.get(sn)).getState()) {
                certStatus = CertStatus.CERT_FREEZE;
            }
        }
        catch (SQLException e) {
            throw ServiceException.create((String)String.format("\u6839\u636e\u5361\u53f7%s\u67e5\u8be2\u5bf9\u5e94\u7684\u8bc1\u4e66\u4fe1\u606f\u51fa\u9519", cardNo), (Exception)e);
        }
        return certStatus;
    }

    public List<PublicKey> queryPublicKeyBySnList(List<String> snList, int caAlg) {
        if (null == snList || snList.isEmpty()) {
            throw new IllegalArgumentException("\u53c2\u6570snList\u4e3a\u7a7a");
        }
        Object[] params = new Object[]{};
        StringBuffer sql = new StringBuffer(QUERY_PUBLICKEY_BY_SNLIST_SQL).append(" WHERE ");
        if (caAlg != 0) {
            params = ArrayUtils.add((Object[])params, (Object)caAlg);
            sql.append("n_ca_alg=? AND ");
        }
        params = ArrayUtils.addAll((Object[])params, (Object[])snList.toArray());
        sql.append(SqlHelper.prepare((String)"c_cert_sn IN (#snList)", (String)"#snList", (int)snList.size()));
        try {
            return this.acsDao.queryForList(sql.toString(), (ResultSetHandler)new PublicKeyBeanListHandler(), params);
        }
        catch (SQLException e) {
            throw ServiceException.create((String)"\u6839\u636e\u8bc1\u4e66\u5217\u8868\u67e5\u8be2\u6307\u5b9a\u7b97\u6cd5\u548c\u7c7b\u578b\u7684\u516c\u94a5\u4fe1\u606f\u65f6\u51fa\u9519", (Exception)e);
        }
    }

    public Map<String, List<PublicKey>> queryPublicKeyByCardNos(List<String> cardNoList, int caAlg, int certType) {
        if (null == cardNoList || cardNoList.isEmpty()) {
            throw new IllegalArgumentException("\u53c2\u6570cardNoList\u4e3a\u7a7a");
        }
        Object[] params = new Object[]{};
        StringBuffer sql = new StringBuffer(QUERY_PUBLICKEY_BY_CARDNOLIST_SQL).append(" WHERE ");
        if (caAlg != 0) {
            params = ArrayUtils.add((Object[])params, (Object)caAlg);
            sql.append("n_ca_alg=? AND ");
        }
        if (certType != 0) {
            params = ArrayUtils.add((Object[])params, (Object)certType);
            params = ArrayUtils.add((Object[])params, (Object)PublicKey.CertType.SINGLE.value);
            sql.append("(n_cert_type=? OR n_cert_type=?) AND ");
        }
        params = ArrayUtils.addAll((Object[])params, (Object[])cardNoList.toArray());
        sql.append(SqlHelper.prepare((String)"c_card_no IN (#cardNoList)", (String)"#cardNoList", (int)cardNoList.size()));
        try {
            return this.acsDao.queryForMap(sql.toString(), (ResultSetHandler)new PublicKeyBeanMapHandler(), params);
        }
        catch (SQLException e) {
            throw ServiceException.create((String)"\u6839\u636e\u8bc1\u4e66\u5217\u8868\u67e5\u8be2\u6307\u5b9a\u7b97\u6cd5\u548c\u7c7b\u578b\u7684\u516c\u94a5\u4fe1\u606f\u65f6\u51fa\u9519", (Exception)e);
        }
    }

    public List<Cert> queryCertBySnList(List<String> snList, int caAlg) {
        if (null == snList || snList.isEmpty()) {
            throw new IllegalArgumentException("\u53c2\u6570snList\u4e3a\u7a7a");
        }
        Object[] params = new Object[]{};
        StringBuffer sql = new StringBuffer(QUERY_CERT_BY_SNLIST_SQL).append(" WHERE ");
        if (caAlg != 0) {
            params = ArrayUtils.add((Object[])params, (Object)caAlg);
            sql.append("n_ca_alg=? AND ");
        }
        params = ArrayUtils.addAll((Object[])params, (Object[])snList.toArray());
        sql.append(SqlHelper.prepare((String)"c_cert_sn IN (#snList)", (String)"#snList", (int)snList.size()));
        try {
            return this.acsDao.queryForList(sql.toString(), (ResultSetHandler)new CertBeanListHandler(), params);
        }
        catch (SQLException e) {
            throw ServiceException.create((String)"\u6839\u636e\u8bc1\u4e66\u5217\u8868\u67e5\u8be2\u6307\u5b9a\u7b97\u6cd5\u548c\u7c7b\u578b\u7684\u516c\u94a5\u4fe1\u606f\u65f6\u51fa\u9519", (Exception)e);
        }
    }

    public Map<String, List<Cert>> queryCertByCardNos(List<String> cardNoList, int caAlg, int certType) {
        if (null == cardNoList || cardNoList.isEmpty()) {
            throw new IllegalArgumentException("\u53c2\u6570cardNoList\u4e3a\u7a7a");
        }
        Object[] params = new Object[]{};
        StringBuffer sql = new StringBuffer(QUERY_CERT_BY_CARDNOLIST_SQL).append(" WHERE ");
        if (caAlg != 0) {
            params = ArrayUtils.add((Object[])params, (Object)caAlg);
            sql.append("n_ca_alg=? AND ");
        }
        if (certType != 0) {
            params = ArrayUtils.add((Object[])params, (Object)certType);
            params = ArrayUtils.add((Object[])params, (Object)Cert.CertType.SINGLE.value);
            sql.append("n_cert_type IN (?,?) AND ");
        }
        params = ArrayUtils.addAll((Object[])params, (Object[])cardNoList.toArray());
        sql.append(SqlHelper.prepare((String)"c_card_no IN (#cardNoList)", (String)"#cardNoList", (int)cardNoList.size()));
        try {
            return this.acsDao.queryForMap(sql.toString(), (ResultSetHandler)new CertBeanMapHandler(), params);
        }
        catch (SQLException e) {
            throw ServiceException.create((String)"\u6839\u636e\u8bc1\u4e66\u5217\u8868\u67e5\u8be2\u6307\u5b9a\u7b97\u6cd5\u548c\u7c7b\u578b\u7684\u516c\u94a5\u4fe1\u606f\u65f6\u51fa\u9519", (Exception)e);
        }
    }

    public List<Cert> queryHisCertBySnList(final List<String> snList, final int caAlg) {
        if (null == snList || snList.isEmpty()) {
            throw new IllegalArgumentException("\u53c2\u6570snList\u4e3a\u7a7a");
        }
        Object[] params = new Object[]{};
        StringBuffer sql = new StringBuffer(QUERY_HIS_CERT_BY_SNLIST_SQL).append(" WHERE ");
        switch (caAlg) {
            case 0: {
                sql.append(SqlHelper.prepare((String)"c_sm2_sign_sn IN (#snList) OR c_sm2_enc_sn IN (#snList) OR c_rsa_sign_sn IN (#snList) OR c_rsa_enc_sn IN (#snList)", (String)"#snList", (int)snList.size()));
                params = ArrayUtils.addAll((Object[])params, (Object[])snList.toArray());
                params = ArrayUtils.addAll((Object[])params, (Object[])snList.toArray());
                params = ArrayUtils.addAll((Object[])params, (Object[])snList.toArray());
                params = ArrayUtils.addAll((Object[])params, (Object[])snList.toArray());
                break;
            }
            case 2: {
                sql.append(SqlHelper.prepare((String)"c_sm2_sign_sn IN (#snList) OR c_sm2_enc_sn IN (#snList)", (String)"#snList", (int)snList.size()));
                params = ArrayUtils.addAll((Object[])params, (Object[])snList.toArray());
                params = ArrayUtils.addAll((Object[])params, (Object[])snList.toArray());
                break;
            }
            case 1: {
                sql.append(SqlHelper.prepare((String)"c_rsa_sign_sn IN (#snList) OR c_rsa_enc_sn IN (#snList)", (String)"#snList", (int)snList.size()));
                params = ArrayUtils.addAll((Object[])params, (Object[])snList.toArray());
                params = ArrayUtils.addAll((Object[])params, (Object[])snList.toArray());
            }
        }
        try {
            return this.amsDao.queryForList(sql.toString(), (ResultSetHandler)new ResultSetHandler<List<Cert>>(){

                public List<Cert> handle(ResultSet rs) throws SQLException {
                    ArrayList<Cert> results = new ArrayList<Cert>();
                    if (!rs.next()) {
                        return results;
                    }
                    Cert cert = null;
                    do {
                        switch (caAlg) {
                            case 0: {
                                if (snList.contains(rs.getString("c_sm2_sign_sn"))) {
                                    cert = new Cert(rs.getString("c_card_no"), Cert.CaAlg.valueOf((int)2), Cert.CertType.valueOf((int)2));
                                    cert.setSn(rs.getString("c_sm2_sign_sn"));
                                    cert.setCert(rs.getString("c_sm2_sign"));
                                    results.add(cert);
                                }
                                if (snList.contains(rs.getString("c_sm2_enc_sn"))) {
                                    cert = new Cert(rs.getString("c_card_no"), Cert.CaAlg.valueOf((int)2), Cert.CertType.valueOf((int)1));
                                    cert.setSn(rs.getString("c_sm2_enc_sn"));
                                    cert.setCert(rs.getString("c_sm2_enc"));
                                    results.add(cert);
                                }
                                if (snList.contains(rs.getString("c_rsa_sign_sn"))) {
                                    cert = new Cert(rs.getString("c_card_no"), Cert.CaAlg.valueOf((int)1), Cert.CertType.valueOf((int)2));
                                    cert.setSn(rs.getString("c_rsa_sign_sn"));
                                    cert.setCert(rs.getString("c_rsa_sign"));
                                    results.add(cert);
                                }
                                if (!snList.contains(rs.getString("c_rsa_enc_sn"))) break;
                                cert = new Cert(rs.getString("c_card_no"), Cert.CaAlg.valueOf((int)1), Cert.CertType.valueOf((int)1));
                                cert.setSn(rs.getString("c_rsa_enc_sn"));
                                cert.setCert(rs.getString("c_rsa_enc"));
                                results.add(cert);
                                break;
                            }
                            case 2: {
                                if (snList.contains(rs.getString("c_sm2_sign_sn"))) {
                                    cert = new Cert(rs.getString("c_card_no"), Cert.CaAlg.valueOf((int)2), Cert.CertType.valueOf((int)2));
                                    cert.setSn(rs.getString("c_sm2_sign_sn"));
                                    cert.setCert(rs.getString("c_sm2_sign"));
                                    results.add(cert);
                                }
                                if (!snList.contains(rs.getString("c_sm2_enc_sn"))) break;
                                cert = new Cert(rs.getString("c_card_no"), Cert.CaAlg.valueOf((int)2), Cert.CertType.valueOf((int)1));
                                cert.setSn(rs.getString("c_sm2_enc_sn"));
                                cert.setCert(rs.getString("c_sm2_enc"));
                                results.add(cert);
                                break;
                            }
                            case 1: {
                                if (snList.contains(rs.getString("c_rsa_sign_sn"))) {
                                    cert = new Cert(rs.getString("c_card_no"), Cert.CaAlg.valueOf((int)1), Cert.CertType.valueOf((int)2));
                                    cert.setSn(rs.getString("c_rsa_sign_sn"));
                                    cert.setCert(rs.getString("c_rsa_sign"));
                                    results.add(cert);
                                }
                                if (!snList.contains(rs.getString("c_rsa_enc_sn"))) break;
                                cert = new Cert(rs.getString("c_card_no"), Cert.CaAlg.valueOf((int)1), Cert.CertType.valueOf((int)1));
                                cert.setSn(rs.getString("c_rsa_enc_sn"));
                                cert.setCert(rs.getString("c_rsa_enc"));
                                results.add(cert);
                            }
                        }
                    } while (rs.next());
                    return results;
                }
            }, params);
        }
        catch (Exception e) {
            throw ServiceException.create((String)"\u6839\u636e\u8bc1\u4e66\u5217\u8868\u67e5\u8be2\u6307\u5b9a\u7b97\u6cd5\u548c\u7c7b\u578b\u7684\u516c\u94a5\u4fe1\u606f\u65f6\u51fa\u9519", (Exception)e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        Prop sqlProp = PropKit.use((String)"sql/cert");
        CHECK_CERT_BY_CARDNO_SQL = sqlProp.get("check.cert_byCardNo");
        if (StrKit.isBlank((String)CHECK_CERT_BY_CARDNO_SQL)) {
            throw ServiceException.create((String)String.format("sql\u8bed\u53e5%s\u4e0d\u5b58\u5728", "check.cert_byCardNo"));
        }
        QUERY_PUBLICKEY_BY_CARDNOLIST_SQL = sqlProp.get("query.cert.publickey");
        if (StrKit.isBlank((String)QUERY_PUBLICKEY_BY_CARDNOLIST_SQL)) {
            throw ServiceException.create((String)String.format("sql\u8bed\u53e5%s\u4e0d\u5b58\u5728", "query.cert.publickey"));
        }
        QUERY_PUBLICKEY_BY_SNLIST_SQL = sqlProp.get("query.cert.publickey");
        if (StrKit.isBlank((String)QUERY_PUBLICKEY_BY_SNLIST_SQL)) {
            throw ServiceException.create((String)String.format("sql\u8bed\u53e5%s\u4e0d\u5b58\u5728", "query.cert.publickey"));
        }
        QUERY_CERT_BY_CARDNOLIST_SQL = sqlProp.get("query.cert.cert");
        if (StrKit.isBlank((String)QUERY_CERT_BY_CARDNOLIST_SQL)) {
            throw ServiceException.create((String)String.format("sql\u8bed\u53e5%s\u4e0d\u5b58\u5728", "query.cert.cert"));
        }
        QUERY_CERT_BY_SNLIST_SQL = sqlProp.get("query.cert.cert");
        if (StrKit.isBlank((String)QUERY_CERT_BY_SNLIST_SQL)) {
            throw ServiceException.create((String)String.format("sql\u8bed\u53e5%s\u4e0d\u5b58\u5728", "query.cert.cert"));
        }
        QUERY_HIS_CERT_BY_SNLIST_SQL = sqlProp.get("query.cert.hisCert");
        if (StrKit.isBlank((String)QUERY_HIS_CERT_BY_SNLIST_SQL)) {
            throw ServiceException.create((String)String.format("sql\u8bed\u53e5%s\u4e0d\u5b58\u5728", "query.cert.cert"));
        }
    }
}

