/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.assetmanager.entity;

import java.io.Serializable;

public class Cert
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String cardNo;
    private String sn;
    private int caAlg;
    private int certType;
    private String cert;
    private CaAlg caAlgs = CaAlg.RSA;
    private CertType certTypes = CertType.ENCRYPT;

    public String getCardNo() {
        return this.cardNo;
    }

    public void setCardNo(String cardNo) {
        this.cardNo = cardNo;
    }

    public String getSn() {
        return this.sn;
    }

    public void setSn(String sn) {
        this.sn = sn;
    }

    public int getCaAlg() {
        return this.caAlg;
    }

    public void setCaAlg(int caAlg) {
        this.caAlg = caAlg;
    }

    public int getCertType() {
        return this.certType;
    }

    public void setCertType(int certType) {
        this.certType = certType;
    }

    public String getCert() {
        return this.cert;
    }

    public void setCert(String cert) {
        this.cert = cert;
    }

    public Cert() {
    }

    public Cert(String cardNo, CaAlg caAlgs, CertType certTypes) {
        this.cardNo = cardNo;
        this.caAlgs = caAlgs;
        this.certTypes = certTypes;
    }

    public CaAlg getCaAlgs() {
        return this.caAlgs;
    }

    public void setCaAlgs(CaAlg caAlgs) {
        this.caAlgs = caAlgs;
    }

    public CertType getCertTypes() {
        return this.certTypes;
    }

    public void setCertTypes(CertType certTypes) {
        this.certTypes = certTypes;
    }

    public static enum CertType {
        ENCRYPT(1),
        SIGN(2),
        SINGLE(3);

        public int value;

        private CertType(int value) {
            this.value = value;
        }

        public static CertType valueOf(int value) throws IllegalArgumentException {
            for (CertType type : CertType.values()) {
                if (type.value != value) continue;
                return type;
            }
            throw new IllegalArgumentException(String.format("\u503c\"%d\"\u5bf9\u5e94\u7684\u679a\u4e3e\u503c\u4e0d\u5b58\u5728", value));
        }
    }

    public static enum CaAlg {
        RSA(1),
        SM2(2);

        public int value;

        private CaAlg(int value) {
            this.value = value;
        }

        public static CaAlg valueOf(int value) throws IllegalArgumentException {
            for (CaAlg type : CaAlg.values()) {
                if (type.value != value) continue;
                return type;
            }
            throw new IllegalArgumentException(String.format("\u503c\"%d\"\u5bf9\u5e94\u7684\u679a\u4e3e\u503c\u4e0d\u5b58\u5728", value));
        }
    }
}

