/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.assetmanager.business.impl;

import com.xdja.cssp.ams.assetmanager.bean.AmsAsset;
import com.xdja.cssp.ams.assetmanager.bean.AmsAssetMobilesInfo;
import com.xdja.cssp.ams.assetmanager.bean.AmsCertInfo;
import com.xdja.cssp.ams.assetmanager.bean.AmsTerminalUnlockCode;
import com.xdja.cssp.ams.assetmanager.bean.CertInfo;
import com.xdja.cssp.ams.assetmanager.business.AssetManagerBusiness;
import com.xdja.cssp.ams.assetmanager.business.ILoadRecordManagerBusiness;
import com.xdja.cssp.ams.assetmanager.dao.AmsAssetDao;
import com.xdja.cssp.ams.assetmanager.dao.AssetDataJdbcDao;
import com.xdja.cssp.ams.assetmanager.dao.AssetHistoryJPADao;
import com.xdja.cssp.ams.assetmanager.dao.AssetManagerJdbcDao;
import com.xdja.cssp.ams.assetmanager.dao.BakcardHistoryJPADao;
import com.xdja.cssp.ams.assetmanager.dao.LoadRecordManagerDao;
import com.xdja.cssp.ams.assetmanager.dao.LoadRecordManagerJPADao;
import com.xdja.cssp.ams.assetmanager.dao.TpomsDataJdbcDao;
import com.xdja.cssp.ams.assetmanager.entity.BackupCardScBean;
import com.xdja.cssp.ams.assetmanager.entity.BakcardCondition;
import com.xdja.cssp.ams.assetmanager.entity.CertBean;
import com.xdja.cssp.ams.assetmanager.entity.TAssetHistory;
import com.xdja.cssp.ams.assetmanager.entity.TBakcardInfoHistory;
import com.xdja.cssp.ams.assetmanager.utils.AMSLogRecord;
import com.xdja.cssp.ams.assetmanager.utils.ResultStatus;
import com.xdja.cssp.ams.core.sc.EcssMessage;
import com.xdja.cssp.ams.customer.util.CertUtil;
import com.xdja.cssp.u8db.ams.entity.TpomsUserInfo;
import com.xdja.cssp.u8db.ams.service.IU8AmsInfoService;
import com.xdja.platform.log.Logger;
import com.xdja.platform.log.LoggerFactory;
import com.xdja.platform.redis.core.RedisClient;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.platform.util.json.JSONUtil;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AssetManagerBusinessImpl
implements AssetManagerBusiness {
    private IU8AmsInfoService u8AmsInfoService = (IU8AmsInfoService)DefaultServiceRefer.getServiceRefer(IU8AmsInfoService.class);
    private Logger logger = LoggerFactory.getLogger(AssetManagerBusinessImpl.class);
    @Autowired
    AssetManagerJdbcDao assetManagerJdbcDao;
    @Autowired
    AmsAssetDao amsAssetDao;
    @Autowired
    LoadRecordManagerDao loadRecordManagerDao;
    @Autowired
    LoadRecordManagerJPADao loadRecordManagerJPADao;
    @Autowired
    ILoadRecordManagerBusiness loadRecordManagerBusiness;
    @Autowired
    AssetHistoryJPADao assetHistoryJPADao;
    @Autowired
    BakcardHistoryJPADao bakcardHistoryJPADao;
    @Autowired
    AssetDataJdbcDao assetDataJdbcDao;
    @Resource
    RedisClient redisClient;
    @Autowired
    TpomsDataJdbcDao tpomsDataJdbcDao;

    @Override
    public List<AmsAsset> findunSyncAssetInfoCardnos() {
        return this.assetManagerJdbcDao.findunSyncAssetInfoCardnos();
    }

    @Override
    public List<AmsAssetMobilesInfo> findAmsAssetMobilesByCardNos(List<String> unSyncCardNos) {
        return this.assetManagerJdbcDao.findAmsAssetMobilesByCardNos(unSyncCardNos);
    }

    @Override
    public List<AmsCertInfo> findCertsByCardNos(List<String> unSyncCardNos) {
        return this.assetManagerJdbcDao.findCertsByCardNos(unSyncCardNos);
    }

    @Override
    public List<AmsTerminalUnlockCode> findTerminalUnlockCodeByCardNos(List<String> unSyncCardNos) {
        return this.assetManagerJdbcDao.findTerminalUnlockCodeByCardNos(unSyncCardNos);
    }

    public void doSaveRemoteAssetInfos(List<String> cardNos) throws Exception {
        this.logger.info(".........\u5f00\u59cb\u66f4\u65b0\u8fd0\u884c\u5e93\u8d44\u4ea7\u6570\u636e........");
        List<AmsAsset> list = this.findunSyncAssetProInfoCardnos(cardNos);
        List<AmsAssetMobilesInfo> mobiles = this.findAmsAssetMobilesByCardNos(cardNos);
        List<AmsCertInfo> certs = this.findCertsByCardNos(cardNos);
        try {
            this.amsAssetDao.saveAssetInfo(list, mobiles, certs);
            this.logger.info(".........\u66f4\u65b0\u8fd0\u884c\u5e93\u8d44\u4ea7\u6570\u636e\u6210\u529f........");
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u8fd0\u884c\u5e93\u8d44\u4ea7\u6570\u636e\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("\u66f4\u65b0\u8fd0\u884c\u5e93\u8d44\u4ea7\u6570\u636e\u5f02\u5e38");
        }
    }

    @Override
    public void updateStatus(List<AmsAsset> list) {
        ArrayList<String> cardNos = new ArrayList<String>();
        for (AmsAsset asset : list) {
            cardNos.add(asset.getCardNo());
        }
        this.assetManagerJdbcDao.updateActivateLogStatus(cardNos);
        this.assetManagerJdbcDao.updateAssetInfoStatus(cardNos);
        try {
            this.amsAssetDao.updateAmsStatus(list);
        }
        catch (Exception e) {
            this.logger.error("\u5411AMS\u8fd0\u884c\u5e93\u540c\u6b65\u82af\u7247\u6fc0\u6d3b\u72b6\u6001\u5f02\u5e38.", (Throwable)e);
            throw new RuntimeException("\u5411AMS\u8fd0\u884c\u5e93\u540c\u6b65\u82af\u7247\u6fc0\u6d3b\u72b6\u6001\u5f02\u5e38.");
        }
    }

    @Override
    public void updateCerts(Map<String, List<CertBean>> datas, List<String> cardNoList) {
        if (!datas.isEmpty()) {
            TAssetHistory[] history = new TAssetHistory[datas.size()];
            this.assetHistoryJPADao.save(this.assetManagerJdbcDao.queryHisAsset(new ArrayList<String>(datas.keySet()), null).values().toArray(history));
            Map<String, CertInfo> certMap = this.assetManagerJdbcDao.findCertInfos(cardNoList, null);
            this.assetManagerJdbcDao.deleteCerts(cardNoList, null);
            try {
                this.amsAssetDao.updateAmsCerts(this.assetManagerJdbcDao.updateCerts(datas, certMap));
            }
            catch (Exception e) {
                this.logger.error("\u8bc1\u4e66\u53d8\u66f4\u65f6\u5411AMS\u8fd0\u884c\u5e93\u540c\u6b65\u8bc1\u4e66\u4fe1\u606f\u65f6\u5f02\u5e38.", (Throwable)e);
                throw new RuntimeException("\u8bc1\u4e66\u53d8\u66f4\u65f6\u5411AMS\u8fd0\u884c\u5e93\u540c\u6b65\u8bc1\u4e66\u4fe1\u606f\u65f6\u5f02\u5e38.");
            }
        }
    }

    public void updateCerts(Map<String, List<CertBean>> datas, List<String> cardNoList, Integer algType) {
        if (!datas.isEmpty()) {
            TAssetHistory[] history = new TAssetHistory[datas.size()];
            this.assetHistoryJPADao.save(this.assetManagerJdbcDao.queryHisAsset(new ArrayList<String>(datas.keySet()), algType).values().toArray(history));
            Map<String, CertInfo> certMap = this.assetManagerJdbcDao.findCertInfos(cardNoList, algType);
            this.assetManagerJdbcDao.deleteCerts(cardNoList, algType);
            try {
                this.amsAssetDao.updateAmsCerts(this.assetManagerJdbcDao.updateCerts(datas, certMap));
            }
            catch (Exception e) {
                this.logger.error("\u8bc1\u4e66\u53d8\u66f4\u65f6\u5411AMS\u8fd0\u884c\u5e93\u540c\u6b65\u8bc1\u4e66\u4fe1\u606f\u65f6\u5f02\u5e38.", (Throwable)e);
                throw new RuntimeException("\u8bc1\u4e66\u53d8\u66f4\u65f6\u5411AMS\u8fd0\u884c\u5e93\u540c\u6b65\u8bc1\u4e66\u4fe1\u606f\u65f6\u5f02\u5e38.");
            }
        }
    }

    @Override
    public List<AmsCertInfo> findunSyncCertInfo() {
        return this.assetManagerJdbcDao.findunSyncCertInfo();
    }

    @Override
    public void updateAmsCerts(List<AmsCertInfo> list) {
        this.amsAssetDao.updateAmsCerts(list);
    }

    @Override
    public void updateCertSyncStatus(List<AmsCertInfo> list) {
        this.assetManagerJdbcDao.updateCertSyncStatus(list);
    }

    @Override
    public List<String> checkAssetExist(List<String> identifyList) {
        return this.assetManagerJdbcDao.checkAssetExist(identifyList);
    }

    @Override
    public void saveMobiles(List<String[]> datas, Map<String, String[]> temp, Map<String, String[]> tempUsbKey, int type, boolean status, String failureName, int successCount, int failureCount, Map<String, String> correctOrderProjectMap, Map<String, String> correctOrderStateMap, Map<String, String> correctOrderCustomerMap, Map<String, String> orderTypeMap) {
        ArrayList relationList = new ArrayList();
        HashMap<String, String> relationMap = null;
        String[] item = null;
        long recordId = this.loadRecordManagerJPADao.saveRecord(status, successCount, failureCount, type, failureName);
        switch (type) {
            case 1: 
            case 2: {
                try {
                    ArrayList<String> mobileCardNoList = new ArrayList<String>(temp.keySet());
                    this.syncActiveAsset(this.assetManagerJdbcDao.saveMobiles(datas, temp, tempUsbKey, type), mobileCardNoList, this.loadRecordManagerDao.queryAmsAssetMobilesInfoList(mobileCardNoList));
                }
                catch (Exception e) {
                    this.logger.error("\u5411AMS\u8fd0\u884c\u5e93\u540c\u6b65\u624b\u673a\u7c7b\u578b\u8d44\u4ea7\u4fe1\u606f\u5f02\u5e38.", (Throwable)e);
                    throw new RuntimeException("\u5411AMS\u8fd0\u884c\u5e93\u540c\u6b65\u624b\u673a\u7c7b\u578b\u8d44\u4ea7\u4fe1\u606f\u5f02\u5e38.");
                }
                if (tempUsbKey == null || tempUsbKey.isEmpty()) break;
                for (String key : tempUsbKey.keySet()) {
                    item = tempUsbKey.get(key);
                    relationMap = new HashMap<String, String>();
                    relationMap.put("phoneCardno", item[0].toLowerCase());
                    relationMap.put("usbCardno", key.toLowerCase());
                    relationList.add(relationMap);
                }
                try {
                    EcssMessage ecssMessage = new EcssMessage("relationAssetImport", (Object)JSONUtil.toJSONString(relationList));
                    ecssMessage.sendMessage();
                    break;
                }
                catch (Exception e) {
                    this.logger.error("\u5bfc\u5165\u914d\u5bf9\u8d44\u4ea7\u65f6\u53d1\u9001SC\u4e3b\u9898\u5f02\u5e38.", (Throwable)e);
                    throw new RuntimeException("\u5bfc\u5165\u914d\u5bf9\u8d44\u4ea7\u65f6\u53d1\u9001SC\u4e3b\u9898\u5f02\u5e38.");
                }
            }
            case 4: 
            case 5: 
            case 10: {
                try {
                    this.syncActiveAsset(this.assetManagerJdbcDao.updateAssetInfo(datas, type, recordId), null, null);
                    break;
                }
                catch (Exception e) {
                    this.logger.error("\u5411AMS\u8fd0\u884c\u5e93\u540c\u6b65USBKEY/TF\u7c7b\u578b\u8d44\u4ea7\u4fe1\u606f\u5f02\u5e38.", (Throwable)e);
                    throw new RuntimeException("\u5411AMS\u8fd0\u884c\u5e93\u540c\u6b65USBKEY/TF\u7c7b\u578b\u8d44\u4ea7\u4fe1\u606f\u5f02\u5e38.");
                }
            }
            case 6: {
                if (null == correctOrderProjectMap || correctOrderProjectMap.size() <= 0) break;
                HashMap<String, Integer> customerMap = new HashMap<String, Integer>();
                for (String orderName : correctOrderCustomerMap.keySet()) {
                    customerMap.put(correctOrderCustomerMap.get(orderName), 1);
                }
                Map<String, Long> customerInfo = this.assetManagerJdbcDao.saveCustomerInfo(customerMap);
                Map<String, Long> projectInfo = this.assetManagerJdbcDao.saveProjectInfo(correctOrderProjectMap, correctOrderCustomerMap, customerInfo);
                Map<String, Long> orderInfo = this.assetManagerJdbcDao.saveOrderInfo(correctOrderProjectMap, correctOrderStateMap, correctOrderCustomerMap, customerInfo, projectInfo, new HashMap<String, Integer>());
                this.assetManagerJdbcDao.saveChipAsset(datas, temp, orderInfo, customerInfo, type, status, recordId, orderTypeMap, correctOrderStateMap);
                try {
                    this.syncActiveChip(recordId);
                    break;
                }
                catch (Exception e) {
                    this.logger.error("\u5411AMS\u8fd0\u884c\u5e93\u540c\u6b65\u82af\u7247\u7c7b\u578b\u8d44\u4ea7\u4fe1\u606f\u5f02\u5e38.", (Throwable)e);
                    throw new RuntimeException("\u5411AMS\u8fd0\u884c\u5e93\u540c\u6b65\u82af\u7247\u7c7b\u578b\u8d44\u4ea7\u4fe1\u606f\u5f02\u5e38.");
                }
            }
            case 9: {
                if (null == correctOrderProjectMap || correctOrderProjectMap.size() <= 0) break;
                HashMap<String, Integer> customerMap = new HashMap<String, Integer>();
                for (String orderName : correctOrderCustomerMap.keySet()) {
                    customerMap.put(correctOrderCustomerMap.get(orderName), 1);
                }
                Map<String, Long> customerInfo = this.assetManagerJdbcDao.saveCustomerInfo(customerMap);
                Map<String, Long> projectInfo = this.assetManagerJdbcDao.saveProjectInfo(correctOrderProjectMap, correctOrderCustomerMap, customerInfo);
                Map<String, Long> orderInfo = this.assetManagerJdbcDao.saveOrderInfo(correctOrderProjectMap, correctOrderStateMap, correctOrderCustomerMap, customerInfo, projectInfo, new HashMap<String, Integer>());
                this.assetManagerJdbcDao.saveBakcardInfo(datas, temp, orderInfo, customerInfo, BakcardCondition.BAKCARDTYPEINT, status, recordId, orderTypeMap, correctOrderStateMap);
                break;
            }
            case 8: {
                try {
                    this.doSaveRemoteUnlock(this.assetManagerJdbcDao.saveUnLock(datas, recordId));
                    break;
                }
                catch (Exception e) {
                    this.logger.error("\u5411AMS\u8fd0\u884c\u5e93\u540c\u6b65\u89e3\u9501\u7801\u4fe1\u606f\u5f02\u5e38.", (Throwable)e);
                    throw new RuntimeException("\u5411AMS\u8fd0\u884c\u5e93\u540c\u6b65\u89e3\u9501\u7801\u4fe1\u606f\u5f02\u5e38.");
                }
            }
        }
    }

    public void doSaveRemoteUnlock(List<AmsTerminalUnlockCode> terminalUnlockCodeList) {
        this.amsAssetDao.doSaveRemoteUnlock(terminalUnlockCodeList);
    }

    public void syncActiveAsset(List<String> cardNoList, List<String> assetMobileIdenList, List<AmsAssetMobilesInfo> assetMobileInfoList) {
        if (!cardNoList.isEmpty() && cardNoList.size() > 0) {
            this.amsAssetDao.doSaveRemoteAssetInfo(this.loadRecordManagerDao.queryAmsAssetList(cardNoList), assetMobileIdenList, assetMobileInfoList);
        }
    }

    public void syncActiveChip(Long recordId) {
        this.amsAssetDao.doSaveRemoteAssetInfo(this.loadRecordManagerDao.queryAmsAssetList(recordId));
    }

    @Override
    public List<String> checkUnLockExist(List<String> cardNoList) {
        return this.assetManagerJdbcDao.checkUnLockExist(cardNoList);
    }

    @Override
    public void saveCert(Map<String, List<CertBean>> datas, int type, boolean status, String failureName, int successCount, int failureCount) {
        long recordId = this.loadRecordManagerJPADao.saveRecord(status, successCount, failureCount, type, failureName);
        List<AmsCertInfo> certList = this.assetManagerJdbcDao.saveCert(datas, recordId);
        try {
            this.loadRecordManagerBusiness.doSaveRemoteCert(certList);
        }
        catch (Exception e) {
            this.logger.error("\u5411AMS\u8fd0\u884c\u5e93\u540c\u6b65\u8bc1\u4e66\u4fe1\u606f\u5f02\u5e38.", (Throwable)e);
            throw new RuntimeException("\u5411AMS\u8fd0\u884c\u5e93\u540c\u6b65\u8bc1\u4e66\u4fe1\u606f\u5f02\u5e38.");
        }
    }

    @Override
    public List<String> checkCertExist(List<String> cardNoList) {
        return this.assetManagerJdbcDao.checkCertExist(cardNoList);
    }

    @Override
    public List<String> checkRelationExist(List<String> relationCardNo) {
        return this.assetManagerJdbcDao.checkRelationExist(relationCardNo);
    }

    @Override
    public List<String> checkRelationCardNoExist(List<String> relationCardNo) {
        return this.assetManagerJdbcDao.checkRelationCardNoExist(relationCardNo);
    }

    @Override
    public List<String> checkUidExist(ArrayList<String> uidList) {
        return this.assetManagerJdbcDao.checkUidExist(uidList);
    }

    @Override
    public List<String> checkMobileSnExist(ArrayList<String> snList) {
        return this.assetManagerJdbcDao.checkMobileSnExist(snList);
    }

    @Override
    public Map<String, Integer> queryAssetChip(ArrayList<String> identifyList) {
        return this.assetManagerJdbcDao.queryAssetChip(identifyList);
    }

    @Override
    public List<String> checkAssetUnChipExist(ArrayList<String> identifyList) {
        return this.assetManagerJdbcDao.checkAssetUnChipExist(identifyList);
    }

    @Override
    public Map<String, Integer> queryAssetCert(ArrayList<String> identifyList) {
        return this.assetManagerJdbcDao.queryAssetCert(identifyList);
    }

    @Override
    public List<String> checkCertSnExist(List<String> arrayList) {
        return this.assetManagerJdbcDao.checkCertSnExist(arrayList);
    }

    @Override
    public List<CertBean> getCertSnExist(List<String> cardNoList) {
        return this.assetManagerJdbcDao.getCertSnExist(cardNoList);
    }

    @Override
    public Map<String, Integer> queryAssetForMap(Map<String, Integer> identifyMap) {
        Map<String, Integer> returnMap = new HashMap<String, Integer>();
        ArrayList<String> identifyList = new ArrayList<String>();
        if (!identifyMap.isEmpty()) {
            for (String cardNo : identifyMap.keySet()) {
                identifyList.add(cardNo);
            }
            returnMap = this.assetManagerJdbcDao.queryAssetForMap(identifyList);
        }
        return returnMap;
    }

    @Override
    public Map<String, Integer> queryAssetCertForMap(Map<String, Integer> identifyMap) {
        Map<String, Integer> returnMap = new HashMap<String, Integer>();
        ArrayList<String> identifyList = new ArrayList<String>();
        if (!identifyMap.isEmpty()) {
            for (String cardNo : identifyMap.keySet()) {
                identifyList.add(cardNo);
            }
            returnMap = this.assetManagerJdbcDao.queryAssetCertForMap(identifyList);
        }
        return returnMap;
    }

    @Override
    public List<AmsAsset> findunSyncAssetProInfoCardnos(List<String> cardNoList) {
        return this.assetManagerJdbcDao.findunSyncAssetProInfoCardnos(cardNoList);
    }

    @Override
    public List<String> queryExistSn(List<String> snList) {
        return this.assetManagerJdbcDao.queryExistSn(snList);
    }

    @Override
    public List<String> checkMobileImeiExist(ArrayList<String> arrayList) {
        return this.assetManagerJdbcDao.checkMobileImeiExist(arrayList);
    }

    @Override
    public Map<String, String> queryCustomerInfo(ArrayList<String> arrayList) {
        return this.assetManagerJdbcDao.queryCustomerInfo(arrayList);
    }

    @Override
    public Map<String, Integer> queryAssetByCardNos(ArrayList<String> arrayList) {
        return this.assetManagerJdbcDao.queryAssetForMap(arrayList);
    }

    @Override
    public void saveFormats(List<String[]> datas, Map<String, String[]> temp) {
        TAssetHistory[] history = new TAssetHistory[temp.size()];
        this.assetHistoryJPADao.save(this.assetManagerJdbcDao.queryHisAsset(new ArrayList<String>(temp.keySet()), null).values().toArray(history));
        this.assetManagerJdbcDao.deleteAssetFormat(new ArrayList<String>(temp.keySet()));
        try {
            this.amsAssetDao.deleteAssetFormatList(new ArrayList<String>(temp.keySet()));
        }
        catch (Exception e) {
            this.logger.error("\u8d44\u4ea7\u683c\u5f0f\u5316\u6e05\u9664AMS\u8fd0\u884c\u5e93\u8d44\u4ea7\u4fe1\u606f\u65f6\u5f02\u5e38.", (Throwable)e);
            throw new RuntimeException("\u8d44\u4ea7\u683c\u5f0f\u5316\u6e05\u9664AMS\u8fd0\u884c\u5e93\u8d44\u4ea7\u4fe1\u606f\u65f6\u5f02\u5e38.");
        }
        for (String cardNo : temp.keySet()) {
            HashMap<String, Object> logMap = new HashMap<String, Object>();
            logMap.put("logType", 5);
            logMap.put("AssetId", cardNo);
            AMSLogRecord.logRecord(logMap);
        }
    }

    @Override
    public void saveInfoChange(Map<String, String[]> assetMap, Map<String, String> imeiMap, Map<String, String> snMap) {
        if (!snMap.isEmpty() || !imeiMap.isEmpty()) {
            this.assetManagerJdbcDao.updateSnAndImeiInfo(snMap, imeiMap);
        }
        this.assetManagerJdbcDao.updateAssetInfo(assetMap);
        try {
            this.amsAssetDao.updateAssetInfoList(assetMap, imeiMap, snMap);
        }
        catch (Exception e) {
            this.logger.error("\u8d44\u4ea7\u53d8\u66f4-\u5176\u5b83\u4fe1\u606f\u53d8\u66f4\u65f6\u64cd\u4f5cAMS\u8fd0\u884c\u5e93\u66f4\u65b0\u4fe1\u606f\u65f6\u5f02\u5e38.", (Throwable)e);
            throw new RuntimeException("\u8d44\u4ea7\u53d8\u66f4-\u5176\u5b83\u4fe1\u606f\u53d8\u66f4\u65f6\u64cd\u4f5cAMS\u8fd0\u884c\u5e93\u66f4\u65b0\u4fe1\u606f\u65f6\u5f02\u5e38.");
        }
    }

    @Override
    public void saveCardChange(String originalCardNo, String sourceCardNo, String[] cardInfoArr, List<CertBean> certList, List<String[]> unCodes) {
        String recordId = this.assetManagerJdbcDao.findCertInfoRecordId(originalCardNo);
        if (StringUtils.isBlank((CharSequence)recordId)) {
            this.logger.error("\u8d44\u4ea7\u53d8\u66f4-\u82af\u7247\u4fe1\u606f\u53d8\u66f4\u65f6\u67e5\u8be2\u539f\u8d44\u4ea7\u8bc1\u4e66\u65f6\u4e3a\u7a7a.");
            throw new RuntimeException("\u8d44\u4ea7\u53d8\u66f4-\u82af\u7247\u4fe1\u606f\u53d8\u66f4\u65f6\u67e5\u8be2\u539f\u8d44\u4ea7\u8bc1\u4e66\u65f6\u4e3a\u7a7a.");
        }
        TAssetHistory[] history = new TAssetHistory[1];
        this.assetHistoryJPADao.save(this.assetManagerJdbcDao.queryHisAsset(Arrays.asList(originalCardNo), null).values().toArray(history));
        this.assetManagerJdbcDao.updateCardsInfo(originalCardNo, cardInfoArr);
        this.assetManagerJdbcDao.updateUnLockCode(originalCardNo, sourceCardNo, unCodes);
        this.assetManagerJdbcDao.updateCertAndRelation(originalCardNo, sourceCardNo, recordId, certList);
        try {
            this.amsAssetDao.updateCardInfo(originalCardNo, sourceCardNo, cardInfoArr, certList, unCodes);
        }
        catch (Exception e) {
            this.logger.error("\u8d44\u4ea7\u53d8\u66f4-\u82af\u7247\u4fe1\u606f\u53d8\u66f4\u65f6\u64cd\u4f5cAMS\u8fd0\u884c\u5e93\u66f4\u65b0\u4fe1\u606f\u65f6\u5f02\u5e38.", (Throwable)e);
            throw new RuntimeException("\u8d44\u4ea7\u53d8\u66f4-\u82af\u7247\u4fe1\u606f\u53d8\u66f4\u65f6\u64cd\u4f5cAMS\u8fd0\u884c\u5e93\u66f4\u65b0\u4fe1\u606f\u65f6\u5f02\u5e38.");
        }
    }

    @Override
    public List<String> queryCardNoByUid(String uid) {
        return this.assetManagerJdbcDao.queryCardNoByUid(uid);
    }

    @Override
    public void saveSyncAsset(List<Map<String, Object>> cardList, List<Map<String, Object>> mobileList, List<Map<String, Object>> backupCardList, List<String> cardNos, Map<String, String> relationCardNoMap) {
        this.logger.debug(".........\u5f00\u59cb\u4fdd\u5b58\u8d44\u4ea7\u4fe1\u606f........");
        ArrayList<String> syncCardNos = new ArrayList<String>();
        if (!cardList.isEmpty()) {
            cardNos.addAll(this.assetManagerJdbcDao.saveCardAsset(cardList));
        }
        syncCardNos.addAll(cardNos);
        if (!mobileList.isEmpty()) {
            syncCardNos.addAll(this.assetManagerJdbcDao.saveMobileAsset(mobileList, relationCardNoMap));
        }
        this.logger.debug(".........\u4fdd\u5b58\u8d44\u4ea7\u4fe1\u606f\u6210\u529f........");
        if (!syncCardNos.isEmpty()) {
            try {
                this.doSaveRemoteAssetInfos(syncCardNos);
                this.logger.debug(".........\u540c\u6b65\u8fd0\u884c\u5e93\u8d44\u4ea7\u6570\u636e\u6210\u529f........");
            }
            catch (Exception e) {
                this.logger.error("\u4fdd\u5b58\u8d44\u4ea7\u4fe1\u606f\u81f3\u8fd0\u884c\u5e93\u65f6\u5f02\u5e38", (Throwable)e);
                throw new RuntimeException("\u4fdd\u5b58\u8d44\u4ea7\u4fe1\u606f\u81f3\u8fd0\u884c\u5e93\u65f6\u5f02\u5e38");
            }
        }
        if (!backupCardList.isEmpty()) {
            this.assetManagerJdbcDao.saveBackupCard(backupCardList);
        }
    }

    private CertBean constructData(String cardNo, int caAlg, int certType, String cert) {
        X509Certificate x509 = CertUtil.getCertFromStr((String)cert);
        CertBean certBean = new CertBean();
        certBean.setCardNo(cardNo);
        certBean.setSn(CertUtil.getSn((X509Certificate)x509));
        certBean.setCaAlg(Integer.valueOf(caAlg));
        certBean.setCertType(Integer.valueOf(certType));
        certBean.setCertState(CertBean.ENUM_CERT_STATE.normal.value);
        certBean.setCert(CertUtil.certToFullB64((Certificate)x509).replace("\r", "\\r").replace("\n", "\\n"));
        certBean.setPublicKey(CertUtil.getPubKey((String)cert, (int)caAlg));
        certBean.setBefore(Long.valueOf(x509.getNotBefore().getTime()));
        certBean.setAfter(Long.valueOf(x509.getNotAfter().getTime()));
        return certBean;
    }

    private CertBean constructCertData(String cardNo, int caAlg, int certType, String cert) {
        if (cert.startsWith("-----BEGIN CERTIFICATE-----")) {
            cert = cert.substring("-----BEGIN CERTIFICATE-----".length());
        }
        if (cert.endsWith("-----END CERTIFICATE-----")) {
            cert = cert.substring(0, cert.length() - "-----END CERTIFICATE-----".length());
        }
        X509Certificate x509 = CertUtil.getCertFromB64((String)cert);
        CertBean certBean = new CertBean();
        certBean.setCardNo(cardNo);
        certBean.setSn(CertUtil.getSn((X509Certificate)x509));
        certBean.setCaAlg(Integer.valueOf(caAlg));
        certBean.setCertType(Integer.valueOf(certType));
        certBean.setCertState(CertBean.ENUM_CERT_STATE.normal.value);
        certBean.setCert(CertUtil.certToFullB64((Certificate)x509).replace("\r", "\\r").replace("\n", "\\n"));
        certBean.setPublicKey(CertUtil.getPubKey((String)cert, (int)caAlg));
        certBean.setBefore(Long.valueOf(x509.getNotBefore().getTime()));
        certBean.setAfter(Long.valueOf(x509.getNotAfter().getTime()));
        return certBean;
    }

    private void constructCerts(List<Map<String, Object>> cardList, Map<String, List<CertBean>> certDatas, List<String> certCardNoList, Map<String, String> cardNoScMap) {
        for (Map<String, Object> data : cardList) {
            ArrayList<CertBean> certList = new ArrayList<CertBean>();
            String cardNo = ((String)data.get("cardNo")).toLowerCase();
            if (!cardNoScMap.containsKey(cardNo)) continue;
            certList.add(this.constructData(cardNo, 1, 2, (String)data.get("rsaSignCert")));
            certList.add(this.constructData(cardNo, 1, 1, (String)data.get("rsaEncCert")));
            certList.add(this.constructData(cardNo, 2, 2, (String)data.get("sm2SignCert")));
            certList.add(this.constructData(cardNo, 2, 1, (String)data.get("sm2EncCert")));
            certCardNoList.add(cardNo);
            certDatas.put(cardNo, certList);
        }
    }

    @Override
    public void updateSyncAsset(List<Map<String, Object>> cardList, List<Map<String, Object>> mobileList, Map<String, String> cardNoScMap, Map<String, String> relationCardNoMap) {
        this.logger.debug(".........\u5f00\u59cb\u66f4\u65b0\u8d44\u4ea7\u7ba1\u7406\u5e93\u8d44\u4ea7\u4fe1\u606f........");
        HashMap<String, List<CertBean>> certDatas = new HashMap<String, List<CertBean>>();
        ArrayList<String> certCardNoList = new ArrayList<String>();
        ArrayList<String> cardNos = new ArrayList<String>();
        if (!cardList.isEmpty()) {
            this.constructCerts(cardList, certDatas, certCardNoList, cardNoScMap);
            this.updateCerts(certDatas, certCardNoList);
            ArrayList<Map<String, Object>> chipList = new ArrayList<Map<String, Object>>();
            ArrayList<Map<String, Object>> noChipList = new ArrayList<Map<String, Object>>();
            for (int i = 0; i < cardList.size(); ++i) {
                Map<String, Object> chipInfoMap = cardList.get(i);
                Integer type = (Integer)chipInfoMap.get("type");
                if (type == 6) {
                    chipList.add(chipInfoMap);
                    continue;
                }
                noChipList.add(chipInfoMap);
            }
            if (noChipList.size() != 0) {
                cardNos.addAll(this.assetManagerJdbcDao.updateCardAsset(noChipList));
            }
            if (chipList.size() != 0) {
                cardNos.addAll(this.assetManagerJdbcDao.updateCardAssetStatus(chipList));
            }
        }
        if (!mobileList.isEmpty()) {
            cardNos.addAll(this.assetManagerJdbcDao.updateMobileAsset(mobileList, relationCardNoMap));
        }
        this.logger.debug(".........\u66f4\u65b0\u8d44\u4ea7\u7ba1\u7406\u5e93\u8d44\u4ea7\u4fe1\u606f\u6210\u529f........");
        if (!cardNos.isEmpty()) {
            try {
                this.doSaveRemoteAssetInfos(cardNos);
                this.logger.debug(".........\u540c\u6b65\u8fd0\u884c\u5e93\u8d44\u4ea7\u6570\u636e\u6210\u529f........");
            }
            catch (Exception e) {
                this.logger.error("\u66f4\u65b0\u8fd0\u884c\u5e93\u8d44\u4ea7\u6570\u636e\u5f02\u5e38", (Throwable)e);
                throw new RuntimeException("\u66f4\u65b0\u8fd0\u884c\u5e93\u8d44\u4ea7\u6570\u636e\u5f02\u5e38");
            }
        }
    }

    @Override
    public Map<String, String> checkUidCardNoExist(ArrayList<String> uidList) {
        return this.assetManagerJdbcDao.checkUidCardNoExist(uidList);
    }

    @Override
    public Map<String, String> checkMobileSnCardNoExist(ArrayList<String> snList) {
        return this.assetManagerJdbcDao.checkMobileSnCardNoExist(snList);
    }

    @Override
    public Map<String, String> checkMobileImeiCardNoExist(ArrayList<String> imeiList) {
        return this.assetManagerJdbcDao.checkMobileImeiCardNoExist(imeiList);
    }

    @Override
    public Map<String, String> checkAssetTypeExist(ArrayList<String> cardNoList) {
        return this.assetManagerJdbcDao.checkAssetTypeExist(cardNoList);
    }

    @Override
    public void saveSyncProducts(List<Map<String, Object>> cardList, List<Map<String, Object>> mobileList, List<Map<String, Object>> backupCardList, Map<String, String> correctOrderProjectMap, Map<String, String> correctOrderStateMap, Map<String, String> correctOrderCustomerMap, Map<String, String> orderTypeMap, Map<String, Integer> orderNameUfMap, Map<String, Integer> correctOrderOriginMap) {
        this.logger.debug(".........\u5f00\u59cb\u4fdd\u5b58\u8d44\u4ea7\u51fa\u5382\u4fe1\u606f........");
        HashMap<String, String> customerU8Map = new HashMap();
        HashMap<String, Long> customerInfo = new HashMap();
        HashMap<String, Long> projectInfo = new HashMap();
        Map<String, Long> orderInfo = new HashMap<String, Long>();
        ArrayList<String> cardNos = new ArrayList<String>();
        HashMap<String, Integer> customerMap = new HashMap<String, Integer>();
        for (String orderName : correctOrderCustomerMap.keySet()) {
            customerMap.put(correctOrderCustomerMap.get(orderName), 1);
        }
        if (!customerMap.isEmpty()) {
            customerInfo = this.assetManagerJdbcDao.saveCustomerInfo(customerMap);
            projectInfo = this.assetManagerJdbcDao.saveProjectInfo(correctOrderProjectMap, correctOrderCustomerMap, customerInfo);
            orderInfo = this.assetManagerJdbcDao.saveOrderInfo(correctOrderProjectMap, correctOrderStateMap, correctOrderCustomerMap, customerInfo, projectInfo, correctOrderOriginMap);
        }
        if (!orderNameUfMap.isEmpty()) {
            HashMap<String, Integer> correctOrderLicenseMap = new HashMap();
            Map u8Map = this.u8AmsInfoService.queryufDbByOrderCodes(customerU8Map, orderNameUfMap, correctOrderProjectMap, correctOrderCustomerMap, correctOrderLicenseMap, correctOrderStateMap);
            customerU8Map = (Map)u8Map.get("customerU8Map");
            orderNameUfMap = (Map)u8Map.get("orderNameUfMap");
            correctOrderProjectMap = (Map)u8Map.get("correctOrderProjectMap");
            correctOrderCustomerMap = (Map)u8Map.get("correctOrderCustomerMap");
            correctOrderLicenseMap = (Map)u8Map.get("correctOrderLicenseMap");
            correctOrderStateMap = (Map)u8Map.get("correctOrderStateMap");
            this.assetManagerJdbcDao.saveCustomerInfoU8(customerInfo, customerU8Map);
            Map<String, Long> projectInfoU8 = this.assetManagerJdbcDao.saveProjectInfo(correctOrderProjectMap, correctOrderCustomerMap, customerInfo);
            projectInfo.putAll(projectInfoU8);
            this.assetManagerJdbcDao.saveOrderInfoU8(correctOrderProjectMap, correctOrderStateMap, correctOrderCustomerMap, customerInfo, projectInfo, orderInfo, correctOrderLicenseMap);
        }
        if (!mobileList.isEmpty()) {
            cardList.addAll(mobileList);
        }
        if (!cardList.isEmpty()) {
            this.assetManagerJdbcDao.updateProducts(cardList, customerInfo, orderInfo, orderTypeMap, cardNos, correctOrderCustomerMap);
            this.logger.debug(".........\u4fdd\u5b58\u8d44\u4ea7\u51fa\u5382\u4fe1\u606f\u6210\u529f........");
            try {
                this.doSaveRemoteAssetInfos(cardNos);
                this.logger.debug(".........\u540c\u6b65\u8fd0\u884c\u5e93\u8d44\u4ea7\u6570\u636e\u6210\u529f........");
            }
            catch (Exception e) {
                this.logger.error("\u4fdd\u5b58\u51fa\u5382\u4fe1\u606f\u81f3\u8fd0\u884c\u5e93\u65f6\u5f02\u5e38", (Throwable)e);
                throw new RuntimeException("\u4fdd\u5b58\u51fa\u5382\u4fe1\u606f\u81f3\u8fd0\u884c\u5e93\u65f6\u5f02\u5e38");
            }
        }
        if (!backupCardList.isEmpty()) {
            this.assetManagerJdbcDao.updateBakProducts(backupCardList, customerInfo, orderInfo, orderTypeMap, correctOrderCustomerMap);
        }
    }

    @Override
    public Map<String, String> queryCertSn(List<String> snList) {
        return this.assetManagerJdbcDao.queryCertSn(snList);
    }

    @Override
    public void queryOrderProject(ArrayList<String> orderList, Map<String, String> orderProjectMap, Map<String, String> orderActiveMap) {
        this.assetManagerJdbcDao.queryOrderProject(orderList, orderProjectMap, orderActiveMap);
    }

    @Override
    public void queryOrderCustomer(ArrayList<String> orderList, Map<String, String> orderCustomerMap) {
        this.assetManagerJdbcDao.queryOrderCustomer(orderList, orderCustomerMap);
    }

    @Override
    public List<String> checkBakcardExist(ArrayList<String> arrayList) {
        return this.assetManagerJdbcDao.checkBakcardExist(arrayList);
    }

    @Override
    public Map<String, Integer> queryBakcardByCardNo(ArrayList<String> arrayList) {
        return this.assetManagerJdbcDao.queryBakcardForMap(arrayList);
    }

    @Override
    public void saveBakcardFormats(List<String[]> datas, Map<String, String[]> temp) {
        TBakcardInfoHistory[] history = new TBakcardInfoHistory[temp.size()];
        this.bakcardHistoryJPADao.save(this.assetManagerJdbcDao.queryHisBakcard(new ArrayList<String>(temp.keySet())).values().toArray(history));
        this.assetManagerJdbcDao.deleteBakcardFormat(new ArrayList<String>(temp.keySet()));
        for (String cardNo : temp.keySet()) {
            HashMap<String, Object> logMap = new HashMap<String, Object>();
            logMap.put("logType", 9);
            logMap.put("BakcardId", cardNo);
            AMSLogRecord.logRecord(logMap);
        }
    }

    @Override
    public Map<String, Integer> queryBakcardUseByCardNo(ArrayList<String> bakcardList) {
        return this.assetManagerJdbcDao.queryBakcardUseByCardNo(bakcardList);
    }

    @Override
    public void updateBackupCardStatus(List<BackupCardScBean> backupCardList) {
        this.assetManagerJdbcDao.updateBackupCardStatus(backupCardList);
    }

    @Override
    public void updateSyncProducts(List<Map<String, Object>> cardList, List<Map<String, Object>> mobileList, Map<String, String> correctOrderProjectMap, Map<String, String> correctOrderCustomerMap, Map<String, String> orderTypeMap) {
        this.logger.debug(".........\u5f00\u59cb\u66f4\u65b0\u8d44\u4ea7\u51fa\u5382\u4fe1\u606f........");
        ArrayList<String> cardNos = new ArrayList<String>();
        HashMap<String, Integer> customerMap = new HashMap<String, Integer>();
        for (String orderName : correctOrderCustomerMap.keySet()) {
            customerMap.put(correctOrderCustomerMap.get(orderName), 1);
        }
        Map<String, Long> customerInfo = this.assetManagerJdbcDao.saveOrUpdateCustomerInfo(customerMap);
        Map<String, Long> projectInfo = this.assetManagerJdbcDao.saveProjectInfo(correctOrderProjectMap, correctOrderCustomerMap, customerInfo);
        Map<String, Long> orderInfo = this.assetManagerJdbcDao.updateOrderInfo(correctOrderProjectMap, correctOrderCustomerMap, customerInfo, projectInfo);
        if (!mobileList.isEmpty()) {
            cardList.addAll(mobileList);
        }
        if (!cardList.isEmpty()) {
            this.assetManagerJdbcDao.updateProductsInfo(cardList, customerInfo, orderInfo, orderTypeMap, cardNos, correctOrderCustomerMap);
        }
        this.logger.debug(".........\u66f4\u65b0\u8d44\u4ea7\u51fa\u5382\u4fe1\u606f\u6210\u529f........");
    }

    @Override
    public List<String> checkOrderExist(ArrayList<String> orderNameList) {
        return this.assetManagerJdbcDao.checkOrderExist(orderNameList);
    }

    @Override
    public List<String> checkProductsExist(ArrayList<String> identifyList) {
        return this.assetManagerJdbcDao.checkProductsExist(identifyList);
    }

    @Override
    public void queryOrderAsset(List<String> cardListTemp, Map<String, String> orderAssetMap) {
        this.assetManagerJdbcDao.queryOrderAsset(cardListTemp, orderAssetMap);
    }

    @Override
    public Map<String, String> queryufOrdersDb() {
        return this.assetManagerJdbcDao.queryufOrdersDb();
    }

    @Override
    public List<Map<String, Object>> checkOutProducts(List<Map<String, Object>> cardList, List<Map<String, Object>> mobileList, List<Map<String, Object>> backupCardList) {
        String cardDBNo;
        String cardNo;
        boolean flag;
        ArrayList<Map<String, Object>> failureList = new ArrayList<Map<String, Object>>();
        if (null != mobileList && mobileList.size() != 0) {
            List<Map<String, Object>> mobileResultList = this.assetManagerJdbcDao.checkMobileProducts(mobileList);
            for (Map<String, Object> cardMap : mobileList) {
                String imei = (String)cardMap.get("imei");
                flag = true;
                for (Map<String, Object> map : mobileResultList) {
                    String imeiNo = (String)map.get("cardNo");
                    if (!imei.equalsIgnoreCase(imeiNo)) continue;
                    flag = false;
                    if (null != map.get("customerId")) continue;
                    cardMap.put("cardNo", imei);
                    cardMap.put("desc", "\u624b\u673a\u6216\u5e73\u677f\u672a\u51fa\u5382");
                    failureList.add(cardMap);
                }
                if (!flag) continue;
                cardMap.put("cardNo", imei);
                cardMap.put("desc", "\u624b\u673a\u6216\u5e73\u677f\u672a\u5165\u5e93");
                failureList.add(cardMap);
            }
        }
        if (null != backupCardList && backupCardList.size() != 0) {
            List<Map<String, Object>> backupResultList = this.assetManagerJdbcDao.checkbackupProducts(backupCardList);
            for (Map<String, Object> cardMap : backupCardList) {
                cardNo = (String)cardMap.get("cardNo");
                flag = true;
                for (Map<String, Object> map : backupResultList) {
                    cardDBNo = (String)map.get("cardNo");
                    if (!cardNo.equalsIgnoreCase(cardDBNo)) continue;
                    flag = false;
                    if (null != map.get("customerId")) continue;
                    cardMap.put("desc", "\u5907\u4efd\u5361\u672a\u51fa\u5382");
                    failureList.add(cardMap);
                }
                if (!flag) continue;
                cardMap.put("desc", "\u5907\u4efd\u5361\u672a\u5165\u5e93");
                failureList.add(cardMap);
            }
        }
        if (null != cardList && cardList.size() != 0) {
            List<Map<String, Object>> cardResutList = this.assetManagerJdbcDao.checkCardProducts(cardList);
            for (Map<String, Object> cardMap : cardList) {
                cardNo = (String)cardMap.get("cardNo");
                flag = true;
                for (Map<String, Object> map : cardResutList) {
                    cardDBNo = (String)map.get("cardNo");
                    if (!cardNo.equalsIgnoreCase(cardDBNo)) continue;
                    flag = false;
                    if (null != map.get("customerId")) continue;
                    cardMap.put("desc", "\u82af\u7247\u672a\u51fa\u5382");
                    failureList.add(cardMap);
                }
                if (!flag) continue;
                cardMap.put("desc", "\u82af\u7247\u672a\u5165\u5e93");
                failureList.add(cardMap);
            }
        }
        return failureList;
    }

    private Map<String, Object> bulidFailureResult(String key, Integer type, String desc) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("cardNo", key);
        result.put("type", type);
        result.put("desc", desc);
        return result;
    }

    @Override
    public int updateAssetCerts(String cardNo, String rsaSignCert, String rsaEncCert, String sm2SignCert, String sm2EncCert, Integer type) {
        this.logger.debug("\u6536\u5230\u66f4\u65b0\u8bc1\u4e66\u4fe1\u606f\u6570\u636e\uff1acardNo=" + cardNo + ",rsaSignCert=" + rsaSignCert + ",rsaEncCert=" + rsaEncCert + ",sm2SignCert=" + sm2SignCert + ",sm2EncCert=" + sm2EncCert + ",type=" + type);
        if (StringUtils.isBlank((CharSequence)cardNo) || null == type) {
            this.logger.debug("\u6536\u5230\u66f4\u65b0\u8bc1\u4e66\u4fe1\u606f\u6570\u636e,cardNo\u548ctype\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            return 101;
        }
        if (type == ResultStatus.CERT_TYPE_CODE.FlourCert.key && StringUtils.isBlank((CharSequence)rsaEncCert) && StringUtils.isBlank((CharSequence)rsaSignCert) && StringUtils.isBlank((CharSequence)sm2EncCert) && StringUtils.isBlank((CharSequence)sm2SignCert)) {
            this.logger.info("\u6536\u5230\u8bc1\u4e66\u66f4\u65b0\u8bf7\u6c42,\u8fd4\u56de\u7801:101");
            return 101;
        }
        ArrayList<String> snList = new ArrayList<String>();
        ArrayList<String> certCardNoList = new ArrayList<String>();
        certCardNoList.add(cardNo);
        HashMap<String, List<CertBean>> certDatas = new HashMap<String, List<CertBean>>();
        HashMap<String, Object> certMap = new HashMap<String, Object>();
        Integer dbAlgType = ResultStatus.getCertAlg(type);
        Long certCount = this.assetManagerJdbcDao.queryCertTypeByCardNo(cardNo, dbAlgType);
        this.logger.debug("\u6536\u5230\u8bc1\u4e66\u66f4\u65b0\u8bf7\u6c42,cardNo=" + cardNo + ",\u82af\u7247\u7b97\u6cd5\u7c7b\u578b\u4e3a" + dbAlgType);
        if (certCount == 0L) {
            this.logger.info("\u6536\u5230\u8bc1\u4e66\u66f4\u65b0\u8bf7\u6c42\uff0ccardNO=" + cardNo + ",\u82af\u7247\u7b97\u6cd5\u7c7b\u578b\u4e3a" + dbAlgType + ",\u6570\u636e\u5e93\u4e2d\u82af\u7247\u8be5\u7b97\u6cd5\u7c7b\u578b\u7684\u4e2a\u6570\u4e3a0\uff0c\u8fd4\u56de\u7801\uff1a" + ResultStatus.CERT_TYPE_ERROR);
            return ResultStatus.CERT_TYPE_ERROR;
        }
        if (type == ResultStatus.CERT_TYPE_CODE.FlourCert.key) {
            if (certCount != 4L) {
                this.logger.info("\u6536\u5230\u8bc1\u4e66\u66f4\u65b0\u8bf7\u6c42\uff0ccardNO=" + cardNo + ",\u82af\u7247\u7b97\u6cd5\u7c7b\u578b\u4e3a" + dbAlgType + "\uff0c\u8fd4\u56de\u7801\uff1a" + ResultStatus.CERT_TYPE_ERROR);
                return ResultStatus.CERT_TYPE_ERROR;
            }
            if (StringUtils.isNotBlank((CharSequence)sm2EncCert)) {
                certMap.put("sm2EncCert", sm2EncCert);
            }
            if (StringUtils.isNotBlank((CharSequence)sm2SignCert)) {
                certMap.put("sm2SignCert", sm2SignCert);
            }
            if (StringUtils.isNotBlank((CharSequence)rsaEncCert)) {
                certMap.put("rsaEncCert", rsaEncCert);
            }
            if (StringUtils.isNotBlank((CharSequence)rsaSignCert)) {
                certMap.put("rsaSignCert", rsaSignCert);
            }
        } else {
            this.logger.error("\u66f4\u65b0\u8bc1\u4e66\u7c7b\u578b\u4e0d\u4e3a5");
            return ResultStatus.SERVER_INTER_ERROR;
        }
        List<CertBean> certsList = this.constructUpdateCerts(snList, certMap, cardNo);
        certDatas.put(cardNo, certsList);
        try {
            List<String> dbCerts = this.assetManagerJdbcDao.checkCertSnExist(snList);
            if (null != dbCerts && dbCerts.size() > 0) {
                this.logger.debug("\u8bc1\u4e66\u4fe1\u606f\u5728\u6570\u636e\u5e93\u4e2d\u5df2\u7ecf\u5b58\u5728");
                this.logger.info("\u6536\u5230\u8bc1\u4e66\u66f4\u65b0\u8bf7\u6c42\uff0ccardNO=" + cardNo + ",\u82af\u7247\u7b97\u6cd5\u7c7b\u578b\u4e3a" + dbAlgType + "\uff0c\u8fd4\u56de\u7801\uff1a" + ResultStatus.CERT_DB_REPEAT);
                return ResultStatus.CERT_DB_REPEAT;
            }
            this.updateCerts(certDatas, certCardNoList, dbAlgType);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("\u6536\u5230\u8bc1\u4e66\u66f4\u65b0\u8bf7\u6c42\uff0ccardNO=" + cardNo + ",\u82af\u7247\u7b97\u6cd5\u7c7b\u578b\u4e3a" + dbAlgType + "\uff0c\u8fd4\u56de\u7801\uff1a" + ResultStatus.SERVER_INTER_ERROR);
            return ResultStatus.SERVER_INTER_ERROR;
        }
        if (!certCardNoList.isEmpty()) {
            try {
                EcssMessage ecssMessage = new EcssMessage("certChange", certCardNoList);
                ecssMessage.sendMessage();
            }
            catch (Exception e) {
                this.logger.error("\u8bc1\u4e66\u53d8\u66f4\u65f6\u53d1\u9001\u6d88\u606f\u5f02\u5e38.", (Throwable)e);
                throw new RuntimeException("\u8bc1\u4e66\u53d8\u66f4\u65f6\u53d1\u9001\u6d88\u606f\u5f02\u5e38.");
            }
        }
        return 100;
    }

    private List<CertBean> constructUpdateCerts(List<String> snList, Map<String, Object> certMap, String cardNo) {
        ArrayList<CertBean> certList = new ArrayList<CertBean>();
        if (null != certMap.get("rsaSignCert")) {
            CertBean rsaSignCertBean = this.constructCertData(cardNo, 1, 2, (String)certMap.get("rsaSignCert"));
            snList.add(rsaSignCertBean.getSn());
            certList.add(rsaSignCertBean);
        }
        if (null != certMap.get("rsaEncCert")) {
            CertBean rsaEncCertBean = this.constructCertData(cardNo, 1, 1, (String)certMap.get("rsaEncCert"));
            snList.add(rsaEncCertBean.getSn());
            certList.add(rsaEncCertBean);
        }
        if (null != certMap.get("sm2SignCert")) {
            CertBean sm2SignCertBean = this.constructCertData(cardNo, 2, 2, (String)certMap.get("sm2SignCert"));
            snList.add(sm2SignCertBean.getSn());
            certList.add(sm2SignCertBean);
        }
        if (null != certMap.get("sm2EncCert")) {
            CertBean sm2EncCertBean = this.constructCertData(cardNo, 2, 1, (String)certMap.get("sm2EncCert"));
            snList.add(sm2EncCertBean.getSn());
            certList.add(sm2EncCertBean);
        }
        return certList;
    }

    @Override
    public int checkAssetAuthority(String mangeCardId, String localCardId) {
        this.logger.debug("\u83b7\u53d6\u8d44\u4ea7\u6743\u9650\u5224\u65ad\u8bf7\u6c42,\u7ba1\u7406key:" + mangeCardId + ", \u6821\u9a8c\u8d44\u4ea7\uff1a" + localCardId);
        if (StringUtils.isBlank((CharSequence)mangeCardId) || StringUtils.isBlank((CharSequence)localCardId)) {
            this.logger.debug("\u83b7\u53d6\u5224\u65ad\u8d44\u4ea7\u6743\u9650\u5224\u65ad\u8bf7\u6c42,\u8fd4\u56de\u7801\u4e3a101,\u7ba1\u7406key:" + mangeCardId + ", \u6821\u9a8c\u8d44\u4ea7\uff1a" + localCardId);
            return 101;
        }
        this.logger.info("\u83b7\u53d6\u8d44\u4ea7\u6743\u9650\u5224\u65ad\u8bf7\u6c42,\u7ba1\u7406key:" + mangeCardId + ", \u6821\u9a8c\u8d44\u4ea7\uff1a" + localCardId);
        String resultCode = this.redisClient.get(mangeCardId + "_" + localCardId);
        if (StringUtils.isNotBlank((CharSequence)resultCode)) {
            this.logger.info("\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u8d44\u4ea7\u6743\u9650\u5224\u65ad:\u8fd4\u56de\u7801\u4e3a" + resultCode + ",\u5176\u4e2dmangeCardId\u4e3a" + mangeCardId + ",localCardId\u4e3a" + localCardId);
            return Integer.parseInt(resultCode);
        }
        try {
            TpomsUserInfo tpomsUserInfo = this.u8AmsInfoService.getUserByCardId(mangeCardId);
            Long customerId = null;
            if (null == tpomsUserInfo) {
                tpomsUserInfo = new TpomsUserInfo();
                customerId = this.tpomsDataJdbcDao.queryCustomerIdByCardId(mangeCardId);
            }
            if (StringUtils.isBlank((CharSequence)tpomsUserInfo.getCustomerId()) && null == customerId) {
                this.redisClient.setex(mangeCardId + "_" + localCardId, 60, String.valueOf(ResultStatus.ASSET_AUTHORITY_ERROR));
                this.logger.info("\u7ba1\u7406Ukey\uff1a" + mangeCardId + ",\u6ca1\u6709\u7ed1\u5b9a\u4efb\u4f55\u5382\u5546");
                return ResultStatus.ASSET_AUTHORITY_ERROR;
            }
            this.logger.debug("\u7ba1\u7406UKey\u5c5e\u4e8e\u7684\u5ba2\u6237code\u4e3a" + tpomsUserInfo.getCustomerId() + ",\u6216\u8be5Ukey\u5c5e\u4e8e\u7684\u5ba2\u6237ID\u4e3a\uff1a" + customerId);
            Boolean flag = this.assetDataJdbcDao.checkAssetAuthority(tpomsUserInfo.getCustomerId(), customerId, localCardId);
            if (flag.booleanValue()) {
                this.redisClient.setex(mangeCardId + "_" + localCardId, 60, String.valueOf(100));
                this.logger.info("\u83b7\u53d6\u5224\u65ad\u8d44\u4ea7\u6743\u9650\u5224\u65ad\u8bf7\u6c42:\u8fd4\u56de\u7801\u4e3a100,\u5176\u4e2dmangeCardId\u4e3a" + mangeCardId + ",localCardId\u4e3a" + localCardId);
                return 100;
            }
            if (!this.assetDataJdbcDao.checkAssetIsExist(localCardId)) {
                this.redisClient.setex(mangeCardId + "_" + localCardId, 60, String.valueOf(102));
                this.logger.info("\u83b7\u53d6\u5224\u65ad\u8d44\u4ea7\u6743\u9650\u5224\u65ad\u8bf7\u6c42:\u8fd4\u56de\u7801\u4e3a102,\u5176\u4e2dmangeCardId\u4e3a" + mangeCardId + ",localCardId\u4e3a" + localCardId);
                return 102;
            }
            this.redisClient.setex(mangeCardId + "_" + localCardId, 60, String.valueOf(ResultStatus.ASSET_AUTHORITY_ERROR));
            this.logger.info("\u83b7\u53d6\u5224\u65ad\u8d44\u4ea7\u6743\u9650\u5224\u65ad\u8bf7\u6c42:\u8fd4\u56de\u7801\u4e3a" + ResultStatus.ASSET_AUTHORITY_ERROR + ",\u5176\u4e2dmangeCardId\u4e3a" + mangeCardId + ",localCardId\u4e3a" + localCardId);
            return ResultStatus.ASSET_AUTHORITY_ERROR;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("\u83b7\u53d6\u5224\u65ad\u8d44\u4ea7\u6743\u9650\u5224\u65ad\u8bf7\u6c42:\u8fd4\u56de\u7801\u4e3a" + ResultStatus.SERVER_INTER_ERROR + ",\u5176\u4e2dmangeCardId\u4e3a" + mangeCardId + ",localCardId\u4e3a" + localCardId);
            return ResultStatus.SERVER_INTER_ERROR;
        }
    }
}

