/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.assetmanager.dao;

import com.xdja.cssp.ams.assetmanager.bean.AmsAsset;
import com.xdja.cssp.ams.assetmanager.bean.AmsAssetMobilesInfo;
import com.xdja.cssp.ams.assetmanager.bean.AmsCertInfo;
import com.xdja.cssp.ams.assetmanager.bean.AmsTerminalUnlockCode;
import com.xdja.cssp.ams.assetmanager.entity.Asset;
import com.xdja.cssp.ams.assetmanager.entity.Cert;
import com.xdja.cssp.ams.assetmanager.entity.CertBean;
import com.xdja.cssp.ams.assetmanager.entity.Type;
import com.xdja.platform.microservice.db.nutz.Dao;
import com.xdja.platform.util.DateTimeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nutz.dao.Sqls;
import org.nutz.dao.sql.Sql;
import org.nutz.trans.Atom;
import org.nutz.trans.Trans;
import org.springframework.stereotype.Repository;

@Repository
public class AmsAssetDao {
    private Dao dao = Dao.use((String)"db::ams");

    public List<Map<String, Object>> findAssetsIdByCardnos(List<AmsAsset> unSyncAssets) {
        StringBuffer sqlBuffer = new StringBuffer("SELECT n_id AS id, c_card_no AS cardNo FROM t_asset_info");
        sqlBuffer.append(" WHERE c_card_no IN (");
        for (AmsAsset asset : unSyncAssets) {
            sqlBuffer.append("'" + asset.getCardNo() + "'").append(",");
        }
        String sql = sqlBuffer.substring(0, sqlBuffer.lastIndexOf(",")) + ")";
        return this.dao.queryForList(sql);
    }

    public List<Map<String, Object>> findMobileAssetsIdByCardnos(List<String> cardNos) {
        StringBuffer sqlBuffer = new StringBuffer("SELECT n_id AS id, c_card_no AS cardNo FROM t_asset_info");
        sqlBuffer.append(" WHERE c_card_no IN (");
        for (String cardNo : cardNos) {
            sqlBuffer.append("'" + cardNo + "'").append(",");
        }
        String sql = sqlBuffer.substring(0, sqlBuffer.lastIndexOf(",")) + ")";
        return this.dao.queryForList(sql);
    }

    private void getAssetMobiles(List<AmsAsset> unSyncAssets, List<AmsAssetMobilesInfo> mobiles) {
        List<Map<String, Object>> assetList = this.findAssetsIdByCardnos(unSyncAssets);
        HashMap<String, Long> assetMap = new HashMap<String, Long>();
        for (Map<String, Object> assetItem : assetList) {
            assetMap.put((String)assetItem.get("cardNo"), (Long)assetItem.get("id"));
        }
        for (AmsAssetMobilesInfo mobile : mobiles) {
            mobile.setAssetId((Long)assetMap.get(mobile.getCardno()));
        }
    }

    private void getAssetMobilesChip(List<String> assetMobileIdenList, List<AmsAssetMobilesInfo> mobiles) {
        List<Map<String, Object>> assetList = this.findMobileAssetsIdByCardnos(assetMobileIdenList);
        HashMap<String, Long> assetMap = new HashMap<String, Long>();
        for (Map<String, Object> assetItem : assetList) {
            assetMap.put((String)assetItem.get("cardNo"), (Long)assetItem.get("id"));
        }
        for (AmsAssetMobilesInfo mobile : mobiles) {
            mobile.setAssetId((Long)assetMap.get(mobile.getCardno()));
        }
    }

    public void saveAssetInfo(final List<AmsAsset> unSyncAssets, final List<AmsAssetMobilesInfo> mobiles, final List<AmsCertInfo> certs) {
        Trans.exec((Atom[])new Atom[]{new Atom(){

            public void run() {
                AmsAssetDao.this.deleteAmsList(unSyncAssets);
                AmsAssetDao.this.insertAssetInfo(unSyncAssets, mobiles);
                AmsAssetDao.this.insertCertInfo(certs);
            }
        }});
    }

    public void insertAssetInfo(List<AmsAsset> unSyncAssets, List<AmsAssetMobilesInfo> mobiles) {
        StringBuffer insertAsset = new StringBuffer("INSERT INTO t_asset_info").append(" (c_asset_identify, n_asset_type, c_card_no, c_serial_code, n_time, c_relation_asset_identify, n_status, c_cos_version, c_norms, c_firmware_version, c_init_script, c_senior_public, n_chip_type)").append(" VALUES (@assetIdentify, @assetType, @cardNo, @serialCode, @time, @relationAssetIdentify, @status, @cosVersion, @norms, @firmwareVersion, @initScript, @seniorPublic, @chipType)");
        Sql sqlObjInsertAsset = Sqls.create((String)insertAsset.toString());
        if (unSyncAssets != null && unSyncAssets.size() > 0) {
            for (AmsAsset info : unSyncAssets) {
                sqlObjInsertAsset.params().set("assetIdentify", (Object)info.getAssetIdentify()).set("assetType", (Object)info.getAssetType()).set("cardNo", (Object)info.getCardNo()).set("serialCode", (Object)info.getSerialCode()).set("time", (Object)info.getTime()).set("relationAssetIdentify", (Object)info.getRelationAssetIdentify()).set("status", (Object)info.getStatus()).set("cosVersion", (Object)info.getCosVersion()).set("norms", (Object)info.getNorms()).set("firmwareVersion", (Object)info.getFirmwareVersion()).set("initScript", (Object)info.getInitScript()).set("seniorPublic", (Object)info.getSeniorPublic()).set("chipType", (Object)info.getChipType());
                sqlObjInsertAsset.addBatch();
            }
            this.dao.execute(new Sql[]{sqlObjInsertAsset});
        }
        StringBuffer insertMobile = new StringBuffer("INSERT INTO t_asset_mobiles_info").append(" (n_asset_id, c_model, c_os_name, c_os_version, c_chip_code, c_imei, c_sn_no)").append(" VALUES (@assetId, @model, @osName, @osVersion, @chipCode, @imei, @snNo)");
        Sql sqlObjinsertMobile = Sqls.create((String)insertMobile.toString());
        if (mobiles != null && mobiles.size() > 0) {
            this.getAssetMobiles(unSyncAssets, mobiles);
            for (AmsAssetMobilesInfo info : mobiles) {
                sqlObjinsertMobile.params().set("assetId", (Object)info.getAssetId()).set("model", (Object)info.getModel()).set("osName", (Object)info.getOsName()).set("osVersion", (Object)info.getOsVersion()).set("chipCode", (Object)info.getChipCode()).set("imei", (Object)info.getImei()).set("snNo", (Object)info.getSnNo());
                sqlObjinsertMobile.addBatch();
            }
            this.dao.execute(new Sql[]{sqlObjinsertMobile});
        }
    }

    public void insertUnCodeInfo(List<AmsTerminalUnlockCode> unlockCodes) {
        StringBuffer sqlCode = new StringBuffer("INSERT INTO t_terminal_unlock_code(c_card_no, c_card_uid, c_unlock_code, c_disk_code, n_time)").append(" VALUES (@cardno, @cardUid, @unlockCode, @diskCode, @time)");
        Sql sqlObjinsertCode = Sqls.create((String)sqlCode.toString());
        if (unlockCodes != null && unlockCodes.size() > 0) {
            for (AmsTerminalUnlockCode info : unlockCodes) {
                sqlObjinsertCode.params().set("cardno", (Object)info.getCardNo()).set("cardUid", (Object)info.getCardUid()).set("unlockCode", (Object)info.getUnlockCode()).set("diskCode", (Object)info.getDiskCode()).set("time", (Object)info.getTime());
                sqlObjinsertCode.addBatch();
            }
            this.dao.execute(new Sql[]{sqlObjinsertCode});
        }
    }

    public void insertCertInfo(List<AmsCertInfo> certs) {
        StringBuffer sqlCert = new StringBuffer("INSERT INTO t_cert_info").append(" (c_card_no, c_cert_sn, n_ca_alg, n_cert_type, n_cert_state, c_cert, c_public_key, n_not_before, n_not_after)").append(" VALUES (@cardno, @certSn, @caAlg, @certType, @certState, @cert, @publicKey, @notBefore, @notAfter)");
        Sql sqlObjInsert = Sqls.create((String)sqlCert.toString());
        if (certs != null && certs.size() > 0) {
            for (AmsCertInfo info : certs) {
                sqlObjInsert.params().set("cardno", (Object)info.getCardNo()).set("certSn", (Object)info.getCertSn()).set("caAlg", (Object)info.getCaAlg()).set("certType", (Object)info.getCertType()).set("certState", (Object)info.getCertState()).set("cert", (Object)info.getCert()).set("publicKey", (Object)info.getPublicKey()).set("notBefore", (Object)info.getNotBefore()).set("notAfter", (Object)info.getNotAfter());
                sqlObjInsert.addBatch();
            }
            this.dao.execute(new Sql[]{sqlObjInsert});
        }
    }

    public void updateAmsCerts(final List<AmsCertInfo> list) {
        Trans.exec((Atom[])new Atom[]{new Atom(){

            public void run() {
                AmsAssetDao.this.deleteCertList(list);
                StringBuffer sql = new StringBuffer("INSERT INTO t_cert_info").append(" (c_card_no, c_cert_sn, n_ca_alg, n_cert_type, n_cert_state, c_cert, c_public_key, n_not_before, n_not_after)").append(" VALUES (@cardno, @certSn, @caAlg, @certType, @certState, @cert, @publicKey, @notBefore, @notAfter)");
                Sql sqlObjInsert = Sqls.create((String)sql.toString());
                for (AmsCertInfo info : list) {
                    sqlObjInsert.params().set("cardno", (Object)info.getCardNo()).set("certSn", (Object)info.getCertSn()).set("caAlg", (Object)info.getCaAlg()).set("certType", (Object)info.getCertType()).set("certState", (Object)info.getCertState()).set("cert", (Object)info.getCert()).set("publicKey", (Object)info.getPublicKey()).set("notBefore", (Object)info.getNotBefore()).set("notAfter", (Object)info.getNotAfter());
                    sqlObjInsert.addBatch();
                }
                AmsAssetDao.this.dao.execute(new Sql[]{sqlObjInsert});
            }
        }});
    }

    public void deleteCertList(List<AmsCertInfo> list) {
        StringBuffer sql3 = new StringBuffer("DELETE FROM t_cert_info WHERE 1=0");
        StringBuffer cardNosBuffer = new StringBuffer("");
        for (AmsCertInfo info : list) {
            cardNosBuffer.append("'" + info.getCardNo() + "'").append(",");
        }
        if (StringUtils.isNotBlank((CharSequence)cardNosBuffer)) {
            String cardNos = cardNosBuffer.substring(0, cardNosBuffer.lastIndexOf(","));
            sql3.append(" OR c_card_no IN (").append(cardNos).append(")");
        }
        Sql sqlObj = Sqls.create((String)sql3.toString());
        this.dao.execute(new Sql[]{sqlObj});
    }

    public void deleteAmsList(List<AmsAsset> unSyncAssets) {
        Sql[] sqlArr = new Sql[4];
        StringBuffer sql1 = new StringBuffer("DELETE FROM t_asset_mobiles_info WHERE 1=0");
        StringBuffer sql2 = new StringBuffer("DELETE FROM t_asset_info WHERE 1=0");
        StringBuffer sql3 = new StringBuffer("DELETE FROM t_cert_info WHERE 1=0");
        Sql sqlObj1 = Sqls.create((String)sql1.toString());
        Sql sqlObj2 = null;
        Sql sqlObj3 = null;
        if (unSyncAssets != null && unSyncAssets.size() > 0) {
            StringBuffer certNosBuffer = new StringBuffer("");
            for (AmsAsset asset : unSyncAssets) {
                certNosBuffer.append("'" + asset.getCardNo() + "'").append(",");
            }
            String cardNos = certNosBuffer.substring(0, certNosBuffer.lastIndexOf(","));
            String assetIds = this.getAmsAssetIdByCardNo(cardNos);
            if (StringUtils.isNotBlank((CharSequence)assetIds)) {
                sql1.append(" OR n_asset_id IN (").append(assetIds).append(")");
                sqlObj1 = Sqls.create((String)sql1.toString());
            }
            sqlArr[0] = sqlObj1;
            sql2.append(" OR c_card_no IN (").append(cardNos).append(")");
            sqlArr[1] = sqlObj2 = Sqls.create((String)sql2.toString());
            sql3.append(" OR c_card_no IN (").append(cardNos).append(")");
            sqlArr[2] = sqlObj3 = Sqls.create((String)sql3.toString());
            this.dao.execute(sqlArr);
        }
    }

    public void doSaveRemoteCert(final List<AmsCertInfo> certInfoList) {
        Trans.exec((Atom[])new Atom[]{new Atom(){

            public void run() {
                Sql[] sqlArr = new Sql[2];
                StringBuffer sql1 = new StringBuffer("DELETE FROM t_cert_info WHERE 1=0");
                StringBuffer sql2 = new StringBuffer("INSERT INTO t_cert_info").append(" (c_card_no, c_cert_sn, n_ca_alg, n_cert_type, n_cert_state, c_cert, c_public_key, n_not_before, n_not_after)").append(" VALUES (@cardno, @certSn, @caAlg, @certType, @certState, @cert, @publicKey, @notBefore, @notAfter)");
                Sql sqlObjDelete = Sqls.create((String)sql1.toString());
                Sql sqlObjInsert = Sqls.create((String)sql2.toString());
                if (certInfoList != null && certInfoList.size() > 0) {
                    StringBuffer sqlBufferCardNos = new StringBuffer("");
                    for (AmsCertInfo info : certInfoList) {
                        sqlBufferCardNos.append("'" + info.getCardNo() + "'").append(",");
                        sqlObjInsert.params().set("cardno", (Object)info.getCardNo()).set("certSn", (Object)info.getCertSn()).set("caAlg", (Object)info.getCaAlg()).set("certType", (Object)info.getCertType()).set("certState", (Object)info.getCertState()).set("cert", (Object)info.getCert()).set("publicKey", (Object)info.getPublicKey()).set("notBefore", (Object)info.getNotBefore()).set("notAfter", (Object)info.getNotAfter());
                        sqlObjInsert.addBatch();
                    }
                    String cardNos = sqlBufferCardNos.substring(0, sqlBufferCardNos.lastIndexOf(","));
                    sql1.append(" OR c_card_no IN (").append(cardNos).append(")");
                    sqlArr[0] = sqlObjDelete = Sqls.create((String)sql1.toString());
                    sqlArr[1] = sqlObjInsert;
                    AmsAssetDao.this.dao.execute(sqlArr);
                }
            }
        }});
    }

    public void doSaveRemoteUnlock(final List<AmsTerminalUnlockCode> terminalUnlockCodeList) {
        Trans.exec((Atom[])new Atom[]{new Atom(){

            public void run() {
                Sql[] sqlArr = new Sql[2];
                StringBuffer sql1 = new StringBuffer("DELETE FROM t_terminal_unlock_code WHERE 1=0");
                StringBuffer sql2 = new StringBuffer("INSERT INTO t_terminal_unlock_code(c_card_no, c_card_uid, c_unlock_code, c_disk_code, n_time)").append(" VALUES (@cardno, @cardUid, @unlockCode, @diskCode, @time)");
                Sql sqlObjDelete = null;
                Sql sqlObjInsert = Sqls.create((String)sql2.toString());
                if (terminalUnlockCodeList != null && terminalUnlockCodeList.size() > 0) {
                    StringBuffer sqlBufferCardNos = new StringBuffer("");
                    for (AmsTerminalUnlockCode info : terminalUnlockCodeList) {
                        sqlBufferCardNos.append("'" + info.getCardNo() + "'").append(",");
                        sqlObjInsert.params().set("cardno", (Object)info.getCardNo()).set("cardUid", (Object)info.getCardUid()).set("unlockCode", (Object)info.getUnlockCode()).set("diskCode", (Object)info.getDiskCode()).set("time", (Object)info.getTime());
                        sqlObjInsert.addBatch();
                    }
                    String cardNos = sqlBufferCardNos.substring(0, sqlBufferCardNos.lastIndexOf(","));
                    sql1.append(" OR c_card_no IN (").append(cardNos).append(")");
                    sqlArr[0] = sqlObjDelete = Sqls.create((String)sql1.toString());
                    sqlArr[1] = sqlObjInsert;
                    AmsAssetDao.this.dao.execute(sqlArr);
                }
            }
        }});
    }

    public void doSaveRemoteAssetInfo(final List<AmsAsset> assetInfoList, final List<String> assetMobileIdenList, final List<AmsAssetMobilesInfo> assetMobileInfoList) {
        Trans.exec((Atom[])new Atom[]{new Atom(){

            public void run() {
                Sql[] sqlArr = null;
                Sql[] sqlArrMobile = new Sql[1];
                StringBuffer sqlMobile = new StringBuffer("DELETE FROM t_asset_mobiles_info WHERE 1=0");
                StringBuffer sqlAsset = new StringBuffer("DELETE FROM t_asset_info WHERE 1=0");
                StringBuffer insertAsset = new StringBuffer("INSERT INTO t_asset_info").append(" (c_asset_identify, n_asset_type, c_card_no, c_serial_code, n_time, c_relation_asset_identify, n_status,").append(" c_norms, c_firmware_version, c_init_script, c_senior_public, c_cos_version)").append(" VALUES (@assetIdentify, @assetType, @cardNo, @serialCode, @time, @relationAssetIdentify, @status,").append(" @norms, @firmwareVersion, @initScript, @seniorPublic, @cosVersion)");
                StringBuffer insertMobile = new StringBuffer("INSERT INTO t_asset_mobiles_info").append(" (n_asset_id, c_model, c_os_name, c_os_version, c_chip_code, c_imei, c_sn_no)").append(" VALUES (@assetId, @model, @osName, @osVersion, @chipCode, @imei, @snNo)");
                Sql sqlObjDeleteMobile = null;
                Sql sqlObjDeleteAsset = null;
                Sql sqlObjInsertAsset = Sqls.create((String)insertAsset.toString());
                Sql sqlObjinsertMobile = Sqls.create((String)insertMobile.toString());
                if (assetInfoList != null && assetInfoList.size() > 0) {
                    for (Object info : assetInfoList) {
                        sqlObjInsertAsset.params().set("assetIdentify", (Object)((AmsAsset)info).getAssetIdentify()).set("assetType", (Object)((AmsAsset)info).getAssetType()).set("cardNo", (Object)((AmsAsset)info).getCardNo()).set("serialCode", (Object)((AmsAsset)info).getSerialCode()).set("time", (Object)((AmsAsset)info).getTime()).set("relationAssetIdentify", (Object)((AmsAsset)info).getRelationAssetIdentify()).set("status", (Object)((AmsAsset)info).getStatus()).set("norms", (Object)((AmsAsset)info).getNorms()).set("firmwareVersion", (Object)((AmsAsset)info).getFirmwareVersion()).set("initScript", (Object)((AmsAsset)info).getInitScript()).set("seniorPublic", (Object)((AmsAsset)info).getSeniorPublic()).set("cosVersion", (Object)((AmsAsset)info).getCosVersion());
                        sqlObjInsertAsset.addBatch();
                    }
                    String assetIds = AmsAssetDao.this.getAmsMobileAssetId(assetInfoList);
                    if (StringUtils.isNotBlank((CharSequence)assetIds)) {
                        sqlMobile.append(" OR n_asset_id IN (").append(assetIds).append(")");
                        sqlObjDeleteMobile = Sqls.create((String)sqlMobile.toString());
                        sqlAsset.append(" OR n_id IN (").append(assetIds).append(")");
                        sqlObjDeleteAsset = Sqls.create((String)sqlAsset.toString());
                        sqlArr = new Sql[]{sqlObjDeleteMobile, sqlObjDeleteAsset, sqlObjInsertAsset};
                    } else {
                        sqlArr = new Sql[]{sqlObjInsertAsset};
                    }
                    AmsAssetDao.this.dao.execute(sqlArr);
                }
                if (assetMobileInfoList != null && assetMobileInfoList.size() > 0) {
                    AmsAssetDao.this.getAssetMobilesChip(assetMobileIdenList, assetMobileInfoList);
                    for (Object info : assetMobileInfoList) {
                        sqlObjinsertMobile.params().set("assetId", (Object)((AmsAssetMobilesInfo)info).getAssetId()).set("model", (Object)((AmsAssetMobilesInfo)info).getModel()).set("osName", (Object)((AmsAssetMobilesInfo)info).getOsName()).set("osVersion", (Object)((AmsAssetMobilesInfo)info).getOsVersion()).set("chipCode", (Object)((AmsAssetMobilesInfo)info).getChipCode()).set("imei", (Object)((AmsAssetMobilesInfo)info).getImei()).set("snNo", (Object)((AmsAssetMobilesInfo)info).getSnNo());
                        sqlObjinsertMobile.addBatch();
                    }
                    sqlArrMobile[0] = sqlObjinsertMobile;
                    AmsAssetDao.this.dao.execute(sqlArrMobile);
                }
            }
        }});
    }

    protected String getAmsMobileAssetId(List<AmsAsset> assetInfoList) {
        StringBuffer assetIds = new StringBuffer();
        StringBuffer sqlBuffer = new StringBuffer("SELECT n_id AS id FROM t_asset_info");
        sqlBuffer.append(" WHERE c_card_no IN (");
        for (AmsAsset asset : assetInfoList) {
            sqlBuffer.append("'" + asset.getCardNo() + "'").append(",");
        }
        String sql = sqlBuffer.substring(0, sqlBuffer.lastIndexOf(",")) + ")";
        List list = this.dao.queryForList(sql);
        if (list != null && list.size() > 0) {
            for (Map assetItem : list) {
                assetIds.append((Long)assetItem.get("id")).append(",");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)assetIds)) {
            return assetIds.substring(0, assetIds.lastIndexOf(","));
        }
        return assetIds.toString();
    }

    protected String getAmsAssetIdByCardNo(String cardNos) {
        StringBuffer assetIds = new StringBuffer();
        StringBuffer sqlBuffer = new StringBuffer("SELECT n_id AS id FROM t_asset_info");
        sqlBuffer.append(" WHERE c_card_no IN (").append(cardNos).append(")");
        List list = this.dao.queryForList(sqlBuffer.toString());
        if (list != null && list.size() > 0) {
            for (Map assetItem : list) {
                assetIds.append((Long)assetItem.get("id")).append(",");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)assetIds)) {
            return assetIds.substring(0, assetIds.lastIndexOf(","));
        }
        return assetIds.toString();
    }

    public void doSaveRemoteAssetInfo(final List<AmsAsset> assetInfoList) {
        Trans.exec((Atom[])new Atom[]{new Atom(){

            public void run() {
                Sql[] sqlArr = new Sql[2];
                StringBuffer sql1 = new StringBuffer("DELETE FROM t_asset_info WHERE 1=0");
                StringBuffer sql2 = new StringBuffer("INSERT INTO t_asset_info").append(" (c_asset_identify, n_asset_type, c_card_no, c_serial_code, n_time, c_relation_asset_identify, n_status,").append(" c_norms, c_firmware_version, c_init_script, c_senior_public, c_cos_version)").append(" VALUES (@assetIdentify, @assetType, @cardNo, @serialCode, @time, @relationAssetIdentify, @status,").append(" @norms, @firmwareVersion, @initScript, @seniorPublic, @cosVersion)");
                Sql sqlObjDelete = null;
                Sql sqlObjInsert = Sqls.create((String)sql2.toString());
                StringBuffer sqlBufferCardNos = new StringBuffer("");
                if (assetInfoList != null && assetInfoList.size() > 0) {
                    for (AmsAsset info : assetInfoList) {
                        sqlBufferCardNos.append("'" + info.getCardNo() + "'").append(",");
                        sqlObjInsert.params().set("assetIdentify", (Object)info.getAssetIdentify()).set("assetType", (Object)info.getAssetType()).set("cardNo", (Object)info.getCardNo()).set("serialCode", (Object)info.getSerialCode()).set("time", (Object)info.getTime()).set("relationAssetIdentify", (Object)info.getRelationAssetIdentify()).set("status", (Object)info.getStatus()).set("norms", (Object)info.getNorms()).set("firmwareVersion", (Object)info.getFirmwareVersion()).set("initScript", (Object)info.getInitScript()).set("seniorPublic", (Object)info.getSeniorPublic()).set("cosVersion", (Object)info.getCosVersion());
                        sqlObjInsert.addBatch();
                    }
                    String cardNos = sqlBufferCardNos.substring(0, sqlBufferCardNos.lastIndexOf(","));
                    sql1.append(" OR c_card_no IN (").append(cardNos).append(")");
                    sqlArr[0] = sqlObjDelete = Sqls.create((String)sql1.toString());
                    sqlArr[1] = sqlObjInsert;
                    AmsAssetDao.this.dao.execute(sqlArr);
                }
            }
        }});
    }

    public void deleteAssetFormatList(final List<String> cardNos) {
        Trans.exec((Atom[])new Atom[]{new Atom(){

            public void run() {
                Sql[] sqlArr = new Sql[5];
                StringBuffer sql1 = new StringBuffer("DELETE FROM t_asset_mobiles_info WHERE 1=0");
                StringBuffer sql2 = new StringBuffer("DELETE FROM t_asset_info WHERE 1=0");
                StringBuffer sql3 = new StringBuffer("DELETE FROM t_cert_info WHERE 1=0");
                StringBuffer sql4 = new StringBuffer("DELETE FROM t_terminal_unlock_code WHERE 1=0");
                StringBuffer sql5 = new StringBuffer("UPDATE t_asset_info SET c_relation_asset_identify = NULL WHERE 1=0");
                Sql sqlObj1 = Sqls.create((String)sql1.toString());
                Sql sqlObj2 = null;
                Sql sqlObj3 = null;
                Sql sqlObj4 = null;
                Sql sqlObj5 = null;
                if (cardNos != null && cardNos.size() > 0) {
                    StringBuffer certNosBuffer = new StringBuffer("");
                    for (String cardNo : cardNos) {
                        certNosBuffer.append("'" + cardNo + "'").append(",");
                    }
                    String cardNos2 = certNosBuffer.substring(0, certNosBuffer.lastIndexOf(","));
                    String assetIds = AmsAssetDao.this.getAmsAssetIdByCardNo(cardNos2);
                    if (StringUtils.isNotBlank((CharSequence)assetIds)) {
                        sql1.append(" OR n_asset_id IN (").append(assetIds).append(")");
                        sqlObj1 = Sqls.create((String)sql1.toString());
                    }
                    sqlArr[0] = sqlObj1;
                    sql2.append(" OR c_card_no IN (").append(cardNos2).append(")");
                    sqlArr[1] = sqlObj2 = Sqls.create((String)sql2.toString());
                    sql3.append(" OR c_card_no IN (").append(cardNos2).append(")");
                    sqlArr[2] = sqlObj3 = Sqls.create((String)sql3.toString());
                    sql4.append(" OR c_card_no IN (").append(cardNos2).append(")");
                    sqlArr[3] = sqlObj4 = Sqls.create((String)sql4.toString());
                    sql5.append(" OR c_relation_asset_identify IN (").append(cardNos2).append(")");
                    sqlArr[4] = sqlObj5 = Sqls.create((String)sql5.toString());
                    AmsAssetDao.this.dao.execute(sqlArr);
                }
            }
        }});
    }

    public void updateAssetInfoList(final Map<String, String[]> assetMap, final Map<String, String> imeiMap, final Map<String, String> snMap) {
        Trans.exec((Atom[])new Atom[]{new Atom(){

            public void run() {
                Sql sqlObjInsert;
                HashMap<String, Long> cardNoIdMap = new HashMap<String, Long>();
                StringBuffer sql = new StringBuffer();
                String[] assetInfo = null;
                if (!assetMap.isEmpty()) {
                    sql.append("UPDATE t_asset_info SET c_cos_version = @cosVersion, c_serial_code = @serialCode,").append(" c_senior_public = @seniorPublic, c_firmware_version = @firmwareVersion, c_init_script = @initScript").append(" WHERE c_asset_identify = @identify");
                    sqlObjInsert = Sqls.create((String)sql.toString());
                    for (String cardNo : assetMap.keySet()) {
                        assetInfo = (String[])assetMap.get(cardNo);
                        sqlObjInsert.params().set("cosVersion", (Object)assetInfo[1]).set("serialCode", (Object)assetInfo[4]).set("seniorPublic", (Object)assetInfo[5]).set("firmwareVersion", (Object)assetInfo[6]).set("initScript", (Object)assetInfo[7]).set("identify", (Object)cardNo);
                        sqlObjInsert.addBatch();
                    }
                    AmsAssetDao.this.dao.execute(new Sql[]{sqlObjInsert});
                }
                if (!imeiMap.isEmpty() || !snMap.isEmpty()) {
                    AmsAssetDao.this.findAssetIdByCardNos(cardNoIdMap, new ArrayList<String>(imeiMap.keySet()));
                    sql = new StringBuffer();
                    sql.append("UPDATE t_asset_mobiles_info SET c_imei = @imei, c_sn_no = @sn WHERE n_asset_id = @assetId");
                    sqlObjInsert = Sqls.create((String)sql.toString());
                    for (String cardNo : imeiMap.keySet()) {
                        sqlObjInsert.params().set("imei", imeiMap.get(cardNo)).set("sn", snMap.get(cardNo)).set("assetId", cardNoIdMap.get(cardNo));
                        sqlObjInsert.addBatch();
                    }
                    AmsAssetDao.this.dao.execute(new Sql[]{sqlObjInsert});
                }
            }
        }});
    }

    public void updateCardInfo(final String originalCardNo, final String sourceCardNo, final String[] cardInfoArr, final List<CertBean> certList, final List<String[]> unCodes) {
        Trans.exec((Atom[])new Atom[]{new Atom(){

            public void run() {
                StringBuffer sql = new StringBuffer();
                Sql sqlObjInsert = null;
                sql.append("UPDATE t_asset_info SET c_asset_identify = @sourceCardNo, c_card_no = @sourceCardNo, c_cos_version = @cosVersion,").append(" n_time = @time, c_firmware_version = @firmwareVersion, c_init_script = @initScript,").append(" c_senior_public = @seniorPublic WHERE c_asset_identify = @originalCardNo");
                sqlObjInsert = Sqls.create((String)sql.toString());
                sqlObjInsert.params().set("sourceCardNo", (Object)sourceCardNo).set("cosVersion", (Object)cardInfoArr[1]).set("time", (Object)DateTimeUtil.getStartTime((String)cardInfoArr[3])).set("originalCardNo", (Object)originalCardNo).set("seniorPublic", (Object)cardInfoArr[4]).set("firmwareVersion", (Object)cardInfoArr[5]).set("initScript", (Object)cardInfoArr[6]);
                AmsAssetDao.this.dao.execute(new Sql[]{sqlObjInsert});
                sql = new StringBuffer();
                sql.append("UPDATE t_asset_info SET c_relation_asset_identify = @sourceCardNo").append(" WHERE c_relation_asset_identify = @originalCardNo");
                sqlObjInsert = Sqls.create((String)sql.toString());
                sqlObjInsert.params().set("sourceCardNo", (Object)sourceCardNo).set("originalCardNo", (Object)originalCardNo);
                AmsAssetDao.this.dao.execute(new Sql[]{sqlObjInsert});
                sql = new StringBuffer();
                sql.append("DELETE FROM t_terminal_unlock_code WHERE c_card_no = @sourceCardNo OR c_card_no = @originalCardNo");
                sqlObjInsert = Sqls.create((String)sql.toString());
                sqlObjInsert.params().set("sourceCardNo", (Object)sourceCardNo).set("originalCardNo", (Object)originalCardNo);
                AmsAssetDao.this.dao.execute(new Sql[]{sqlObjInsert});
                if (!unCodes.isEmpty()) {
                    String[] unlockCodeArr = (String[])unCodes.get(0);
                    sql = new StringBuffer();
                    sql.append("INSERT INTO t_terminal_unlock_code(c_card_no, c_card_uid, c_unlock_code, c_disk_code, n_time)").append(" VALUES (@sourceCardNo, @cardUid, @unlockCode, @diskCode, @time)");
                    sqlObjInsert = Sqls.create((String)sql.toString());
                    sqlObjInsert.params().set("sourceCardNo", (Object)sourceCardNo).set("cardUid", (Object)unlockCodeArr[1]).set("unlockCode", (Object)unlockCodeArr[2]).set("diskCode", (Object)unlockCodeArr[3]).set("time", (Object)System.currentTimeMillis());
                    AmsAssetDao.this.dao.execute(new Sql[]{sqlObjInsert});
                }
                sql = new StringBuffer();
                sql.append("DELETE FROM t_cert_info WHERE c_card_no = @originalCardNo");
                sqlObjInsert = Sqls.create((String)sql.toString());
                sqlObjInsert.params().set("originalCardNo", (Object)originalCardNo);
                AmsAssetDao.this.dao.execute(new Sql[]{sqlObjInsert});
                sql = new StringBuffer();
                sql.append("INSERT INTO t_cert_info").append(" (c_card_no, c_cert_sn, n_ca_alg, n_cert_type, n_cert_state, c_cert, c_public_key, n_not_before, n_not_after)").append(" VALUES (@cardno, @certSn, @caAlg, @certType, @certState, @cert, @publicKey, @notBefore, @notAfter)");
                sqlObjInsert = Sqls.create((String)sql.toString());
                if (certList != null && certList.size() > 0) {
                    for (CertBean info : certList) {
                        sqlObjInsert.params().set("cardno", (Object)sourceCardNo).set("certSn", (Object)info.getSn()).set("caAlg", (Object)info.getCaAlg()).set("certType", (Object)info.getCertType()).set("certState", (Object)info.getCertState()).set("cert", (Object)info.getCert()).set("publicKey", (Object)info.getPublicKey()).set("notBefore", (Object)info.getBefore()).set("notAfter", (Object)info.getAfter());
                        sqlObjInsert.addBatch();
                    }
                    AmsAssetDao.this.dao.execute(new Sql[]{sqlObjInsert});
                }
            }
        }});
    }

    public void findAssetIdByCardNos(Map<String, Long> cardNoIdMap, List<String> cardNoList) {
        StringBuffer sqlBuffer = new StringBuffer("SELECT n_id AS id, c_card_no AS cardNo FROM t_asset_info");
        sqlBuffer.append(" WHERE c_card_no IN (");
        for (String cardNo : cardNoList) {
            sqlBuffer.append("'" + cardNo + "'").append(",");
        }
        String sql = sqlBuffer.substring(0, sqlBuffer.lastIndexOf(",")) + ")";
        List list = this.dao.queryForList(sql);
        if (null != list && !list.isEmpty()) {
            for (Map assetItem : list) {
                cardNoIdMap.put((String)assetItem.get("cardNo"), (Long)assetItem.get("id"));
            }
        }
    }

    public void updateAmsStatus(final List<AmsAsset> list) {
        Trans.exec((Atom[])new Atom[]{new Atom(){

            public void run() {
                StringBuffer sql = new StringBuffer("UPDATE t_asset_info SET n_status = @status WHERE c_asset_identify = @cardno");
                Sql sqlObjInsert = Sqls.create((String)sql.toString());
                for (AmsAsset info : list) {
                    sqlObjInsert.params().set("status", (Object)"1").set("cardno", (Object)info.getAssetIdentify());
                    sqlObjInsert.addBatch();
                }
                AmsAssetDao.this.dao.execute(new Sql[]{sqlObjInsert});
            }
        }});
    }

    public boolean exists(String assetIdentity) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT COUNT(n_id) FROM t_asset_info WHERE c_asset_identify= @assetIdentity ");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("assetIdentity", assetIdentity);
        return this.dao.queryForLong(sqlBuffer.toString(), params) > 0L;
    }

    public List<Asset> queryForAssetList(String[] assetIdentity) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT n_id AS id, c_asset_identify AS identity, n_asset_type AS typeId, c_card_no AS cardNo, c_serial_code AS serialCode, n_time AS time, c_relation_asset_identify AS relatedAsset, n_status AS status, c_cos_version AS cosVersion, c_firmware_version AS firmwareVersion, c_init_script AS initScript FROM t_asset_info WHERE c_asset_identify in (@identity) ");
        String assetIds = StringUtils.join((Object[])assetIdentity, (String)",");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("identity", assetIds);
        List assetList = this.dao.queryForList(Asset.class, sqlBuffer.toString(), params);
        for (int i = 0; i < assetList.size(); ++i) {
            Asset asset = (Asset)assetList.get(i);
            asset.setType(Type.valueOf((int)asset.getTypeId()));
        }
        return assetList;
    }

    public Map<String, Object> queryForPrivateMap(Long id) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT n_asset_id AS assetId, c_model AS model, c_chip_code AS chipCode, c_os_name AS osName, c_os_version AS osVersion, c_imei AS imei, c_sn_no AS snNo FROM t_asset_mobiles_info WHERE n_asset_id = @assetId ");
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("assetId", id);
        return this.dao.queryForMap(sqlBuffer.toString(), params);
    }

    public String queryForStr(String assetIdentity) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT c_relation_asset_identify FROM t_asset_info WHERE c_asset_identify= @identify ");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("identify", assetIdentity);
        return this.dao.queryForStr(sqlBuffer.toString(), params);
    }

    public Map<String, List<Cert>> queryCertByCardNos(String cardNo) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT c_card_no AS cardNo, c_cert_sn AS sn, n_ca_alg AS caAlg, n_cert_type AS certType, c_cert AS cert FROM t_cert_info ").append("WHERE c_card_no = @cardNo ");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("cardNo", cardNo);
        List certList = this.dao.queryForList(Cert.class, sqlBuffer.toString(), params);
        HashMap<String, List<Cert>> certMap = new HashMap<String, List<Cert>>();
        if (null != certList && certList.size() != 0) {
            certMap.put(cardNo, certList);
        }
        return certMap;
    }

    public List<Cert> queryCertBySnList(List<String> certList, int caAlg) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT c_card_no AS cardNo, c_cert_sn AS sn, ").append("n_ca_alg AS caAlg, n_cert_type AS certType, c_cert AS cert FROM t_cert_info ").append("WHERE n_ca_alg = @caAlg AND c_cert_sn IN (@certs) ");
        HashMap<String, Object> params = new HashMap<String, Object>();
        String certs = StringUtils.join(certList, (String)",");
        params.put("caAlg", caAlg);
        params.put("certs", certs);
        return this.dao.queryForList(Cert.class, sqlBuffer.toString(), params);
    }
}

