/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.assetmanager.dao;

import com.xdja.cssp.ams.assetmanager.entity.AssetCondition;
import com.xdja.cssp.ams.assetmanager.entity.AssetDetails;
import com.xdja.cssp.ams.assetmanager.entity.TAssetInfo;
import com.xdja.platform.datacenter.jpa.dao.BaseJdbcDao;
import com.xdja.platform.datacenter.jpa.page.Pagination;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class AssetDataJdbcDao
extends BaseJdbcDao {
    public Pagination<TAssetInfo> queryDataAssets(AssetCondition condition, int page, int length, String orderColName, String orderDir) {
        StringBuffer sqlBuffer = new StringBuffer("SELECT ").append("asset.c_asset_identify AS assetIdentify, ").append("asset.c_card_no AS cardNo, ").append("asset.c_asset_type AS assetType, ").append("asset.c_relation_asset_identify AS relationAssetIdentify, ").append("n_production_time AS productionTime, ").append("asset.n_id AS id ").append("FROM t_asset_info asset ");
        if (condition != null && (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{condition.getImei()}) || StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{condition.getSnNo()}))) {
            sqlBuffer.append(" LEFT JOIN t_asset_mobiles_info mobile ON mobile.n_asset_id = asset.n_id ");
        }
        sqlBuffer.append(" WHERE asset.n_customer_id is NULL ");
        MapSqlParameterSource param = new MapSqlParameterSource();
        if (condition != null) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{condition.getAssetIdentify()})) {
                sqlBuffer.append(" AND asset.c_asset_identify LIKE :assetIdentify ");
                param.addValue("assetIdentify", (Object)('%' + condition.getAssetIdentify() + '%'));
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{condition.getCustomerName()})) {
                sqlBuffer.append(" AND cus.c_name LIKE :customerName ");
                param.addValue("customerName", (Object)('%' + condition.getCustomerName() + '%'));
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{condition.getAssetType()})) {
                sqlBuffer.append(" AND asset.c_asset_type = :assetType ");
                param.addValue("assetType", (Object)condition.getAssetType());
            }
            if (StringUtils.isNotBlank((CharSequence)condition.getRelationAssetIdentify())) {
                sqlBuffer.append(" AND asset.c_relation_asset_identify LIKE :relationAssetIdentify ");
                param.addValue("relationAssetIdentify", (Object)('%' + condition.getRelationAssetIdentify() + '%'));
            }
            if (condition.getStartCreateTime() != null) {
                System.out.println(condition.getStartCreateTime());
                sqlBuffer.append(" AND asset.n_production_time >= :startCreateTime ");
                param.addValue("startCreateTime", (Object)condition.getStartCreateTime());
            }
            if (condition.getEndCreateTime() != null) {
                System.out.println(condition.getEndCreateTime());
                sqlBuffer.append(" AND asset.n_production_time < :endCreateTime ");
                param.addValue("endCreateTime", (Object)condition.getEndCreateTime());
            }
            if (StringUtils.isNotBlank((CharSequence)condition.getOrderName())) {
                sqlBuffer.append(" AND oder.c_name LIKE :orderName");
                param.addValue("orderName", (Object)("%" + condition.getOrderName() + "%"));
            }
            if (StringUtils.isNotBlank((CharSequence)condition.getImei())) {
                sqlBuffer.append(" AND mobile.c_imei LIKE :imei");
                param.addValue("imei", (Object)("%" + condition.getImei() + "%"));
            }
            if (StringUtils.isNotBlank((CharSequence)condition.getSnNo())) {
                sqlBuffer.append(" AND mobile.c_sn_no LIKE :snNo");
                param.addValue("snNo", (Object)("%" + condition.getSnNo() + "%"));
            }
            if (StringUtils.isNotBlank((CharSequence)condition.getSerialCode())) {
                sqlBuffer.append(" AND asset.c_serial_code LIKE :serialCode");
                param.addValue("serialCode", (Object)("%" + condition.getSerialCode() + "%"));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)orderColName) && StringUtils.isNotEmpty((CharSequence)orderDir)) {
            sqlBuffer.append(" ORDER BY " + orderColName + " " + orderDir);
        } else {
            sqlBuffer.append(" ORDER BY n_production_time DESC ");
        }
        return this.queryForPage(sqlBuffer.toString(), length, page, param, (RowMapper)new BeanPropertyRowMapper(TAssetInfo.class));
    }

    public AssetDetails getAssetInfo(Long id) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT asset.c_asset_identify AS assetIdentify, asset.c_asset_type AS assetType, asset.c_card_no AS cardNo, asset.n_time AS time, ");
        sqlBuffer.append(" asset.c_relation_asset_identify AS relationAssetIdentify, mobile.c_imei AS imei, mobile.c_os_name AS osName,mobile.c_os_version AS osVersion,mobile.c_model AS model, ");
        sqlBuffer.append(" asset.n_production_time AS createTime, c_sn_no AS snNo, asset.c_serial_code AS serialCode, asset.c_norms AS norms ");
        sqlBuffer.append(" FROM t_asset_info asset ");
        sqlBuffer.append(" LEFT JOIN t_asset_mobiles_info mobile ON  mobile.n_asset_id = asset.n_id ");
        MapSqlParameterSource param = new MapSqlParameterSource();
        sqlBuffer.append(" WHERE asset.n_id = :id ");
        param.addValue("id", (Object)id);
        return (AssetDetails)this.queryForObject(sqlBuffer.toString(), (SqlParameterSource)param, (RowMapper)new BeanPropertyRowMapper(AssetDetails.class));
    }

    public Boolean checkAssetAuthority(String u8CusCode, Long customerId, String cardId) {
        Long n;
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT COUNT(info.n_id) FROM t_asset_info info LEFT JOIN t_order_asset orderAsset ON info.n_id = orderAsset.n_asset_id ").append("LEFT JOIN t_order orderInfo ON orderAsset.n_order_id = orderInfo.n_id LEFT JOIN t_project project ").append("ON orderInfo.n_project_id = project.n_id LEFT JOIN t_customer customer ON project.n_customer_id = customer.n_id ").append("WHERE info.c_card_no = :cardId ");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("cardId", (Object)cardId);
        if (null != customerId) {
            sqlBuffer.append("AND customer.n_id = :customerId ");
            params.addValue("customerId", (Object)customerId);
        }
        if (StringUtils.isNotBlank((CharSequence)u8CusCode)) {
            sqlBuffer.append("AND customer.c_code = :u8CusCode ");
            params.addValue("u8CusCode", (Object)u8CusCode);
        }
        if ((n = Long.valueOf(this.queryForLong(sqlBuffer.toString(), (SqlParameterSource)params))) > 0L) {
            return true;
        }
        return false;
    }

    public boolean checkAssetIsExist(String localCardId) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT COUNT(n_id) FROM t_asset_info WHERE c_asset_identify = :cardNo ");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("cardNo", (Object)localCardId);
        Long n = this.queryForLong(sqlBuffer.toString(), (SqlParameterSource)params);
        return n > 0L;
    }
}

