/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.assetmanager.service.impl;

import com.xdja.cssp.ams.assetmanager.business.AssetInfoBusiness;
import com.xdja.cssp.ams.assetmanager.entity.Asset;
import com.xdja.cssp.ams.assetmanager.entity.AssetBean;
import com.xdja.cssp.ams.assetmanager.entity.AssetCondition;
import com.xdja.cssp.ams.assetmanager.entity.AssetDetails;
import com.xdja.cssp.ams.assetmanager.entity.AssetInfo;
import com.xdja.cssp.ams.assetmanager.entity.Cert;
import com.xdja.cssp.ams.assetmanager.entity.ChipBean;
import com.xdja.cssp.ams.assetmanager.entity.DeviceInfo;
import com.xdja.cssp.ams.assetmanager.entity.TAssetInfo;
import com.xdja.cssp.ams.assetmanager.entity.Type;
import com.xdja.cssp.ams.assetmanager.service.IAssetInfoService;
import com.xdja.platform.common.lite.kit.StrKit;
import com.xdja.platform.microservice.ServiceException;
import com.xdja.platform.rpc.proxy.page.LitePaging;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AssetInfoServiceImpl
implements IAssetInfoService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private AssetInfoBusiness assetInfoBusiness;

    public LitePaging<TAssetInfo> queryAllAssets(AssetCondition condition, int page, int length, String orderColName, String orderDir) {
        return this.assetInfoBusiness.queryAllAssets(condition, page, length, orderColName, orderDir);
    }

    public AssetDetails getAssetInfo(Long id) {
        return this.assetInfoBusiness.getAssetInfo(id);
    }

    public AssetDetails getAssetInfo(AssetDetails assetInfo) {
        return this.assetInfoBusiness.getAssetInfo(assetInfo);
    }

    public LitePaging<TAssetInfo> queryDataAssets(AssetCondition condition, int page, int length, String orderColName, String orderDir) {
        return this.assetInfoBusiness.queryDataAssets(condition, page, length, orderColName, orderDir);
    }

    public AssetDetails getAssetData(Long id) {
        return this.assetInfoBusiness.getAssetData(id);
    }

    public AssetBean isExistsAsset(String cardNo) {
        AssetBean assetBean = new AssetBean();
        if (this.exists(cardNo)) {
            assetBean.setCardExist(AssetBean.CHECK_SUCCESS);
        } else {
            assetBean.setCardExist(AssetBean.CHECK_FAIL);
        }
        return assetBean;
    }

    public boolean exists(String assetIdentity) {
        if (StrKit.isBlank((String)assetIdentity)) {
            throw new IllegalArgumentException("\u53c2\u6570assetIdentity\u4e3a\u7a7a");
        }
        try {
            return this.assetInfoBusiness.exists(assetIdentity);
        }
        catch (Exception e) {
            throw ServiceException.create((String)String.format("\u5224\u65ad\u6807\u8bc6\u4e3a%s\u7684\u8d44\u4ea7\u662f\u5426\u5b58\u5728\u65f6\u51fa\u73b0\u5f02\u5e38", assetIdentity), (Exception)e);
        }
    }

    public AssetBean checkAsset(AssetInfo asset) {
        AssetBean assetBean = new AssetBean();
        assetBean.setCardExist(AssetBean.CHECK_SUCCESS);
        assetBean.setVerifySignature(AssetBean.CHECK_FAIL);
        assetBean.setVerifyCert(AssetBean.CHECK_FAIL);
        assetBean.setVerifyImei(AssetBean.CHECK_FAIL);
        assetBean.setIsIdentical(AssetBean.CHECK_FAIL);
        assetBean.setVerifyCos(AssetBean.CHECK_FAIL);
        assetBean.setVerifyFirmwareVersion(AssetBean.CHECK_FAIL);
        assetBean.setVerifyInitScript(AssetBean.CHECK_FAIL);
        ArrayList<String> clientSnList = new ArrayList<String>();
        ArrayList<String> dataSnList = new ArrayList<String>();
        ArrayList<String> cardNoList = new ArrayList<String>();
        Map<String, List<Cert>> certList = null;
        Object imei = null;
        Integer status = null;
        String cosVersion = null;
        String firmwareVersion = null;
        String initScript = null;
        String cardNo = asset.getCardNo().toLowerCase();
        DeviceInfo deviceInfo = this.queryDeviceByCardNo(cardNo);
        String relatedCardNo = deviceInfo.getRelatedAsset();
        if (StringUtils.isNotBlank((CharSequence)relatedCardNo)) {
            deviceInfo.setDevice(this.queryDeviceByCardNo(relatedCardNo));
        }
        if ((imei = (Object)deviceInfo.getInfo().get("imei")).toString().startsWith("IMEI") || imei.toString().startsWith("imei")) {
            imei = imei.toString().replace("IMEI", "").replace("imei", "");
        }
        if (null != imei && StringUtils.isNotBlank((CharSequence)imei.toString()) && imei.toString().equalsIgnoreCase(asset.getImei())) {
            assetBean.setVerifyImei(AssetBean.CHECK_SUCCESS);
        }
        if (null != (status = Integer.valueOf(deviceInfo.getStatus())) && (status == AssetBean.BUSI_ACTIVATE_STATUS && asset.getActivateStatus() == AssetBean.CLIENT_ACTIVATE_STATUS || status == AssetBean.BUSI_UNACTIVATE_STATUS && asset.getActivateStatus() == AssetBean.CLIENT_UNACTIVATE_STATUS)) {
            assetBean.setIsIdentical(AssetBean.CHECK_SUCCESS);
        }
        if (null != (cosVersion = deviceInfo.getCosVersion()) && StringUtils.isNotBlank((CharSequence)cosVersion.toString()) && cosVersion.toString().equalsIgnoreCase(asset.getCos())) {
            assetBean.setVerifyCos(AssetBean.CHECK_SUCCESS);
        }
        if (null != (firmwareVersion = deviceInfo.getFirmwareVersion()) && StringUtils.isNotBlank((CharSequence)firmwareVersion.toString()) && firmwareVersion.toString().equalsIgnoreCase(asset.getFirmwareVersion())) {
            assetBean.setVerifyFirmwareVersion(AssetBean.CHECK_SUCCESS);
        }
        if (null != (initScript = deviceInfo.getInitScript()) && StringUtils.isNotBlank((CharSequence)initScript.toString()) && initScript.toString().equalsIgnoreCase(asset.getInitScript())) {
            assetBean.setVerifyInitScript(AssetBean.CHECK_SUCCESS);
        }
        if (assetBean.getIsIdentical() == AssetBean.CHECK_FAIL) {
            return assetBean;
        }
        if (StringUtils.isNotBlank((CharSequence)asset.getRsaEncSn()) && StringUtils.isNotBlank((CharSequence)asset.getRsaSignSn()) && StringUtils.isNotBlank((CharSequence)asset.getSm2EncSn()) && StringUtils.isNotBlank((CharSequence)asset.getSm2SignSn())) {
            clientSnList.add(asset.getRsaEncSn());
            clientSnList.add(asset.getRsaSignSn());
            clientSnList.add(asset.getSm2EncSn());
            clientSnList.add(asset.getSm2SignSn());
            cardNoList.add(cardNo);
            certList = this.assetInfoBusiness.queryCertByCardNos(cardNo);
            if (null != certList.get(cardNo) && certList.get(cardNo).size() == 4) {
                List<Cert> certs = certList.get(cardNo);
                for (int i = 0; i < certs.size(); ++i) {
                    dataSnList.add(certs.get(i).getSn());
                }
                if (dataSnList.containsAll(clientSnList)) {
                    assetBean.setVerifyCert(AssetBean.CHECK_SUCCESS);
                }
            }
        }
        this.assembleDeviceInfo(assetBean, deviceInfo);
        return assetBean;
    }

    public DeviceInfo queryDeviceByCardNo(String cardNo) {
        if (StringUtils.isBlank((CharSequence)cardNo)) {
            throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            String[] identifyArr = new String[]{cardNo};
            Asset asset = this.queryAssets(identifyArr).get(0);
            DeviceInfo device = new DeviceInfo();
            device.setIdentity(asset.getIdentity());
            device.setType(Type.valueOf((int)asset.getType().value));
            device.setCardNo(asset.getCardNo());
            device.setSerialCode(asset.getSerialCode());
            device.setTime(asset.getTime() == null ? 0L : asset.getTime());
            device.setInfo(asset.getInfo());
            device.setStatus(asset.getStatus());
            device.setCosVersion(asset.getCosVersion());
            device.setFirmwareVersion(StringUtils.isBlank((CharSequence)asset.getFirmwareVersion()) ? "" : asset.getFirmwareVersion().replace("\t", "").replace("\t", ""));
            device.setInitScript(asset.getInitScript());
            device.setRelatedAsset(asset.getRelatedAsset());
            return device;
        }
        catch (Exception e) {
            this.logger.error(String.format("\u6839\u636e\u5361\u53f7\u67e5\u8be2\u8bbe\u5907\u4fe1\u606f\u65f6\u51fa\u9519\uff0c\u5361\u53f7\uff1a%s ", cardNo), (Throwable)e);
            throw ServiceException.create((String)String.format("\u6839\u636e\u5361\u53f7\u67e5\u8be2\u8bbe\u5907\u4fe1\u606f\u65f6\u51fa\u9519\uff0c\u5361\u53f7\uff1a%s ", cardNo), (Exception)e);
        }
    }

    public List<Asset> queryAssets(String ... assetIdentity) {
        if (null == assetIdentity || assetIdentity.length <= 0) {
            return Collections.emptyList();
        }
        HashMap<Long, Asset> assetMap = new HashMap<Long, Asset>();
        try {
            List<Asset> assetList = this.assetInfoBusiness.queryForAssetList(assetIdentity);
            if (null != assetList && assetList.size() > 0) {
                for (int i = 0; i < assetList.size(); ++i) {
                    assetMap.put(assetList.get(i).getId(), assetList.get(i));
                }
            }
        }
        catch (Exception e) {
            throw ServiceException.create((String)String.format("\u67e5\u8be2\u6307\u5b9a\u8d44\u4ea7\u4fe1\u606f\uff08%s\uff09\u65f6\u51fa\u73b0\u5f02\u5e38", Arrays.toString(assetIdentity)), (Exception)e);
        }
        if (!assetMap.isEmpty()) {
            Set setLong = assetMap.keySet();
            try {
                for (Long id : setLong) {
                    Asset asset = (Asset)assetMap.get(id);
                    if (asset.getTypeId() != 1) continue;
                    Map<String, Object> assetProp = this.assetInfoBusiness.queryForPrivateMap(id);
                    ((Asset)assetMap.get(assetProp.get("assetId"))).setInfo(assetProp);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw ServiceException.create((String)String.format("\u67e5\u8be2\u6307\u5b9a\u8d44\u4ea7\u4fe1\u606f\uff08%s\uff09\u65f6\u51fa\u73b0\u5f02\u5e38", Arrays.toString(assetIdentity)), (Exception)e);
            }
        }
        ArrayList<Asset> result = new ArrayList<Asset>();
        if (null != assetMap && !assetMap.isEmpty()) {
            result.addAll(assetMap.values());
        }
        return result;
    }

    private void assembleDeviceInfo(AssetBean assetBean, DeviceInfo deviceInfo) {
        HashMap<String, Object> selfDeviceMap = new HashMap<String, Object>();
        HashMap extendMap = new HashMap();
        HashMap<String, Object> otherDevicesMap = new HashMap<String, Object>();
        selfDeviceMap.put("cardNo", deviceInfo.getCardNo());
        selfDeviceMap.put("type", deviceInfo.getType().value);
        selfDeviceMap.put("serialCode", deviceInfo.getSerialCode());
        selfDeviceMap.put("leaveFactoryTime", deviceInfo.getTime());
        selfDeviceMap.put("cos", deviceInfo.getCosVersion());
        selfDeviceMap.put("firmwareVersion", deviceInfo.getFirmwareVersion());
        selfDeviceMap.put("initScript", deviceInfo.getInitScript());
        if (deviceInfo.getType().value == 1 || deviceInfo.getType().value == 2) {
            extendMap.put("OSNAME", deviceInfo.getInfo().get("osName"));
            extendMap.put("OSVERSION", deviceInfo.getInfo().get("osVersion"));
            extendMap.put("MODEL", deviceInfo.getInfo().get("model"));
            extendMap.put("CHIPCODE", deviceInfo.getInfo().get("chipCode"));
            extendMap.put("IMEI", deviceInfo.getInfo().get("imei"));
            extendMap.put("SNNO", deviceInfo.getInfo().get("snNo"));
        }
        selfDeviceMap.put("extend", extendMap);
        extendMap = new HashMap();
        DeviceInfo relationAsset = deviceInfo.getDevice();
        if (null != relationAsset) {
            otherDevicesMap.put("cardNo", relationAsset.getCardNo());
            otherDevicesMap.put("type", null != relationAsset.getType() ? Integer.valueOf(relationAsset.getType().value) : null);
            otherDevicesMap.put("serialCode", relationAsset.getSerialCode());
            otherDevicesMap.put("leaveFactoryTime", relationAsset.getTime());
            if (null != relationAsset.getType() && (relationAsset.getType().value == 1 || relationAsset.getType().value == 2)) {
                extendMap.put("OSNAME", relationAsset.getInfo().get("osName"));
                extendMap.put("OSVERSION", relationAsset.getInfo().get("osVersion"));
                extendMap.put("MODEL", relationAsset.getInfo().get("model"));
                extendMap.put("CHIPCODE", relationAsset.getInfo().get("chipCode"));
                extendMap.put("IMEI", relationAsset.getInfo().get("imei"));
                extendMap.put("SNNO", relationAsset.getInfo().get("snNo"));
            }
            otherDevicesMap.put("extend", extendMap);
        }
        assetBean.setSelfDevice(selfDeviceMap);
        assetBean.setOtherDevices(otherDevicesMap);
    }

    public ChipBean checkChip(AssetInfo asset) {
        TAssetInfo customerInfo;
        ChipBean assetBean = new ChipBean();
        assetBean.setCardExist(AssetBean.CHECK_SUCCESS);
        assetBean.setVerifySignature(AssetBean.CHECK_FAIL);
        assetBean.setVerifyCert(AssetBean.CHECK_FAIL);
        assetBean.setIsIdentical(AssetBean.CHECK_FAIL);
        assetBean.setVerifyCos(AssetBean.CHECK_FAIL);
        assetBean.setVerifyFirmwareVersion(AssetBean.CHECK_FAIL);
        assetBean.setVerifyInitScript(AssetBean.CHECK_FAIL);
        assetBean.setIsLeaveFactory(AssetBean.CHECK_FAIL);
        ArrayList<String> clientSnList = new ArrayList<String>();
        ArrayList<String> dataSnList = new ArrayList<String>();
        ArrayList<String> cardNoList = new ArrayList<String>();
        Map<String, List<Cert>> certList = null;
        Integer status = null;
        String cosVersion = null;
        String firmwareVersion = null;
        String initScript = null;
        String customerName = "";
        String cardNo = asset.getCardNo().toLowerCase();
        DeviceInfo deviceInfo = this.queryDeviceByCardNo(cardNo);
        String relatedCardNo = deviceInfo.getRelatedAsset();
        if (StringUtils.isNotBlank((CharSequence)relatedCardNo)) {
            deviceInfo.setDevice(this.queryDeviceByCardNo(relatedCardNo));
        }
        if (null != (customerInfo = this.assetInfoBusiness.queryCustomerByCardno(cardNo)) && StringUtils.isNotBlank((CharSequence)customerInfo.getCustomerName())) {
            customerName = customerInfo.getCustomerName();
            assetBean.setIsLeaveFactory(AssetBean.CHECK_SUCCESS);
            assetBean.setCustomerName(customerName);
        }
        if (null != (status = Integer.valueOf(deviceInfo.getStatus())) && (status == AssetBean.BUSI_ACTIVATE_STATUS && asset.getActivateStatus() == AssetBean.CLIENT_ACTIVATE_STATUS || status == AssetBean.BUSI_UNACTIVATE_STATUS && asset.getActivateStatus() == AssetBean.CLIENT_UNACTIVATE_STATUS)) {
            assetBean.setIsIdentical(AssetBean.CHECK_SUCCESS);
        }
        if (null != (cosVersion = deviceInfo.getCosVersion()) && StringUtils.isNotBlank((CharSequence)cosVersion.toString()) && cosVersion.toString().equalsIgnoreCase(asset.getCos())) {
            assetBean.setVerifyCos(AssetBean.CHECK_SUCCESS);
        }
        if (null != (firmwareVersion = deviceInfo.getFirmwareVersion()) && StringUtils.isNotBlank((CharSequence)firmwareVersion.toString()) && firmwareVersion.toString().equalsIgnoreCase(asset.getFirmwareVersion())) {
            assetBean.setVerifyFirmwareVersion(AssetBean.CHECK_SUCCESS);
        }
        if (null != (initScript = deviceInfo.getInitScript()) && StringUtils.isNotBlank((CharSequence)initScript.toString()) && initScript.toString().equalsIgnoreCase(asset.getInitScript())) {
            assetBean.setVerifyInitScript(AssetBean.CHECK_SUCCESS);
        }
        if (assetBean.getIsIdentical() == AssetBean.CHECK_FAIL) {
            return assetBean;
        }
        if (StringUtils.isNotBlank((CharSequence)asset.getRsaEncSn()) && StringUtils.isNotBlank((CharSequence)asset.getRsaSignSn()) && StringUtils.isNotBlank((CharSequence)asset.getSm2EncSn()) && StringUtils.isNotBlank((CharSequence)asset.getSm2SignSn())) {
            clientSnList.add(asset.getRsaEncSn());
            clientSnList.add(asset.getRsaSignSn());
            clientSnList.add(asset.getSm2EncSn());
            clientSnList.add(asset.getSm2SignSn());
            cardNoList.add(cardNo);
            certList = this.assetInfoBusiness.queryCertByCardNos(cardNo);
            if (null != certList.get(cardNo) && certList.get(cardNo).size() == 4) {
                List<Cert> certs = certList.get(cardNo);
                for (int i = 0; i < certs.size(); ++i) {
                    dataSnList.add(certs.get(i).getSn());
                }
                if (dataSnList.containsAll(clientSnList)) {
                    assetBean.setVerifyCert(AssetBean.CHECK_SUCCESS);
                }
            }
        }
        this.assembleDeviceInfo(assetBean, deviceInfo);
        return assetBean;
    }

    private void assembleDeviceInfo(ChipBean assetBean, DeviceInfo deviceInfo) {
        HashMap<String, Object> selfDeviceMap = new HashMap<String, Object>();
        HashMap extendMap = new HashMap();
        HashMap<String, Object> otherDevicesMap = new HashMap<String, Object>();
        selfDeviceMap.put("cardNo", deviceInfo.getCardNo());
        selfDeviceMap.put("type", deviceInfo.getType().value);
        selfDeviceMap.put("serialCode", deviceInfo.getSerialCode());
        selfDeviceMap.put("leaveFactoryTime", deviceInfo.getTime());
        selfDeviceMap.put("cos", deviceInfo.getCosVersion());
        selfDeviceMap.put("firmwareVersion", deviceInfo.getFirmwareVersion());
        selfDeviceMap.put("initScript", deviceInfo.getInitScript());
        selfDeviceMap.put("extend", extendMap);
        extendMap = new HashMap();
        DeviceInfo relationAsset = deviceInfo.getDevice();
        if (null != relationAsset) {
            otherDevicesMap.put("cardNo", relationAsset.getCardNo());
            otherDevicesMap.put("type", null != relationAsset.getType() ? Integer.valueOf(relationAsset.getType().value) : null);
            otherDevicesMap.put("serialCode", relationAsset.getSerialCode());
            otherDevicesMap.put("leaveFactoryTime", relationAsset.getTime());
            otherDevicesMap.put("cos", deviceInfo.getCosVersion());
            otherDevicesMap.put("firmwareVersion", deviceInfo.getFirmwareVersion());
            otherDevicesMap.put("initScript", deviceInfo.getInitScript());
            if (null != relationAsset.getType() && (relationAsset.getType().value == 1 || relationAsset.getType().value == 2)) {
                extendMap.put("OSNAME", relationAsset.getInfo().get("osName"));
                extendMap.put("OSVERSION", relationAsset.getInfo().get("osVersion"));
                extendMap.put("MODEL", relationAsset.getInfo().get("model"));
                extendMap.put("CHIPCODE", relationAsset.getInfo().get("chipCode"));
                extendMap.put("IMEI", relationAsset.getInfo().get("imei"));
                extendMap.put("SNNO", relationAsset.getInfo().get("snNo"));
            }
            otherDevicesMap.put("extend", extendMap);
        }
        assetBean.setSelfDevice(selfDeviceMap);
        assetBean.setOtherDevices(otherDevicesMap);
    }
}

