/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.assetmanager.service.impl;

import com.xdja.cssp.ams.assetmanager.business.BakcardInfoBusiness;
import com.xdja.cssp.ams.assetmanager.entity.BackupCardCheckBean;
import com.xdja.cssp.ams.assetmanager.entity.BackupCardScBean;
import com.xdja.cssp.ams.assetmanager.entity.BakcardCondition;
import com.xdja.cssp.ams.assetmanager.service.IBakcardInfoService;
import com.xdja.platform.rpc.proxy.page.LitePaging;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BakcardInfoServiceImpl
implements IBakcardInfoService {
    @Autowired
    private BakcardInfoBusiness bakcardInfoBusiness;

    public LitePaging<BakcardCondition> queryAllBakcards(BakcardCondition condition, int page, int length, String orderColName, String orderDir) {
        return this.bakcardInfoBusiness.queryAllBakcards(condition, page, length, orderColName, orderDir);
    }

    public BakcardCondition getBakcardInfo(Long id) {
        if (null != id) {
            return this.bakcardInfoBusiness.getBakcardInfo(id);
        }
        throw new RuntimeException("\u53c2\u6570\u9519\u8bef\uff0c\u901a\u8fc7id\u67e5\u8be2\u5907\u4efd\u6062\u590d\u5361\u8be6\u7ec6\u4fe1\u606f\u65f6id\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public LitePaging<BakcardCondition> queryDataBakcards(BakcardCondition condition, int page, int length, String orderColName, String orderDir) {
        return this.bakcardInfoBusiness.queryDataBakcards(condition, page, length, orderColName, orderDir);
    }

    public BakcardCondition getBakcardData(Long id) {
        if (null != id) {
            return this.bakcardInfoBusiness.getBakcardData(id);
        }
        throw new RuntimeException("\u53c2\u6570\u9519\u8bef\uff0c\u901a\u8fc7id\u67e5\u8be2\u5165\u5e93\u5907\u4efd\u6062\u590d\u5361\u8be6\u7ec6\u4fe1\u606f\u65f6id\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public Map<String, Object> checkBakup(BackupCardCheckBean backupCard) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        BakcardCondition bakcardData = this.bakcardInfoBusiness.getBakcardDataBySn(backupCard.getSn());
        if (bakcardData == null || StringUtils.isBlank((CharSequence)bakcardData.getBakcardSN())) {
            result.put("code", BackupCardCheckBean.ENUM_BACKUP_CARD_ERROR.unexist.status);
            result.put("info", BackupCardCheckBean.ENUM_BACKUP_CARD_ERROR.unexist.value);
            return result;
        }
        if (StringUtils.isNotBlank((CharSequence)backupCard.getbCode()) && !bakcardData.getVerifyCode().equalsIgnoreCase(backupCard.getbCode())) {
            result.put("code", BackupCardCheckBean.ENUM_BACKUP_CARD_ERROR.bcodeError.status);
            result.put("info", BackupCardCheckBean.ENUM_BACKUP_CARD_ERROR.bcodeError.value);
            return result;
        }
        if (StringUtils.isNotBlank((CharSequence)backupCard.getrCode()) && !bakcardData.getRecoverCode().equalsIgnoreCase(backupCard.getrCode())) {
            result.put("code", BackupCardCheckBean.ENUM_BACKUP_CARD_ERROR.rcodeError.status);
            result.put("info", BackupCardCheckBean.ENUM_BACKUP_CARD_ERROR.rcodeError.value);
            return result;
        }
        if (bakcardData.getStatus() == BackupCardScBean.ENUM_AMS_BACKUPCARD_STATUS.used.value) {
            result.put("code", BackupCardCheckBean.ENUM_BACKUP_CARD_ERROR.used.status);
            result.put("info", BackupCardCheckBean.ENUM_BACKUP_CARD_ERROR.used.value);
            return result;
        }
        if (bakcardData.getStatus() == BackupCardScBean.ENUM_AMS_BACKUPCARD_STATUS.unbind.value || bakcardData.getStatus() == BackupCardScBean.ENUM_AMS_BACKUPCARD_STATUS.invalid.value) {
            result.put("code", BackupCardCheckBean.ENUM_BACKUP_CARD_ERROR.invalid.status);
            result.put("info", BackupCardCheckBean.ENUM_BACKUP_CARD_ERROR.invalid.value);
            return result;
        }
        result.put("code", BackupCardCheckBean.ENUM_BACKUP_CARD_ERROR.success.status);
        result.put("info", BackupCardCheckBean.ENUM_BACKUP_CARD_ERROR.success.value);
        return result;
    }
}

