/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.assetmanager.service.impl;

import com.xdja.cssp.ams.assetmanager.business.AssetManagerBusiness;
import com.xdja.cssp.ams.assetmanager.entity.AssetImportMsg;
import com.xdja.cssp.ams.assetmanager.entity.BackupCardScBean;
import com.xdja.cssp.ams.assetmanager.entity.BakcardCondition;
import com.xdja.cssp.ams.assetmanager.entity.CertBean;
import com.xdja.cssp.ams.assetmanager.entity.ImportResultBean;
import com.xdja.cssp.ams.assetmanager.service.IAssetManagerService;
import com.xdja.cssp.ams.assetmanager.utils.AMSLogRecord;
import com.xdja.cssp.ams.assetmanager.utils.Constants;
import com.xdja.cssp.ams.core.sc.EcssMessage;
import com.xdja.cssp.ams.customer.util.CertUtil;
import com.xdja.cssp.ams.system.business.IDicBusiness;
import com.xdja.cssp.ams.system.entity.TDic;
import com.xdja.cssp.u8db.ams.service.IU8AmsInfoService;
import com.xdja.platform.log.Logger;
import com.xdja.platform.log.LoggerFactory;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.platform.util.json.JSONUtil;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AssetManagerServiceImpl
implements IAssetManagerService {
    private IU8AmsInfoService u8AmsInfoService = (IU8AmsInfoService)DefaultServiceRefer.getServiceRefer(IU8AmsInfoService.class);
    private Logger logger = LoggerFactory.getLogger(AssetManagerServiceImpl.class);
    @Autowired
    private AssetManagerBusiness assetManagerBusiness;
    @Autowired
    private IDicBusiness dicBusiness;

    private void dataFilterCertChange(Map<String, List<CertBean>> datas, List<String> cardNoList, Map<String, Integer> repetitionFail, Map<String, Integer> repetitionDataFail, Map<String, Integer> numberFail, Map<String, Integer> algorithmFail, Map<String, Integer> unExistsAssetFail, Map<String, Integer> unExistsCertFail, int type) {
        int i;
        List<String> algTypeList = this.getAlgType();
        HashMap<String, List<CertBean>> datasCopy = new HashMap<String, List<CertBean>>();
        datasCopy.putAll(datas);
        HashMap<String, String> tempSn = new HashMap<String, String>();
        HashMap<String, Integer> tempIdentity = new HashMap<String, Integer>();
        HashMap<String, Integer> localTemp = new HashMap<String, Integer>();
        Map<Object, Object> cardNoExists = new HashMap();
        ArrayList<String> tempAlgType = null;
        List<CertBean> certList = null;
        CertBean certBean = null;
        String certSn = null;
        String tempCardNo = null;
        if (!datas.isEmpty()) {
            for (String string : datas.keySet()) {
                certList = datas.get(string);
                if (certList == null || certList != null && certList.size() != 4) {
                    numberFail.put(string, 1);
                    continue;
                }
                tempIdentity.put(string, 1);
            }
            if (!numberFail.isEmpty()) {
                for (String string : numberFail.keySet()) {
                    datas.remove(string);
                }
            }
        }
        if (!datas.isEmpty()) {
            for (String string : datas.keySet()) {
                certList = datas.get(string);
                tempAlgType = new ArrayList<String>();
                for (i = 0; i < certList.size(); ++i) {
                    certBean = certList.get(i);
                    tempAlgType.add(certBean.getCertType() + "" + certBean.getCaAlg());
                }
                if (tempAlgType.containsAll(algTypeList)) continue;
                algorithmFail.put(string, 1);
            }
            if (!algorithmFail.isEmpty()) {
                for (String string : algorithmFail.keySet()) {
                    tempIdentity.remove(string);
                    datas.remove(string);
                }
            }
        }
        if (!datas.isEmpty()) {
            block5: for (String string : datas.keySet()) {
                certList = datas.get(string);
                for (i = 0; i < certList.size(); ++i) {
                    certBean = certList.get(i);
                    certSn = certBean.getSn();
                    if (null != tempSn.get(certSn)) {
                        repetitionFail.put(string, 1);
                        localTemp.put(string, 1);
                        continue block5;
                    }
                    tempSn.put(certSn, string);
                }
            }
            if (!localTemp.isEmpty()) {
                for (String string : localTemp.keySet()) {
                    tempIdentity.remove(string);
                    datas.remove(string);
                }
            }
        }
        if (!datas.isEmpty()) {
            List<String> snList = this.assetManagerBusiness.checkCertSnExist(new ArrayList<String>(tempSn.keySet()));
            for (String sn : snList) {
                tempCardNo = (String)tempSn.get(sn);
                repetitionDataFail.put(tempCardNo, 1);
                tempIdentity.remove(tempCardNo);
                datas.remove(tempCardNo);
            }
        }
        if (!datas.isEmpty()) {
            Map<String, Integer> tempExistsAsset = this.assetManagerBusiness.queryAssetForMap(tempIdentity);
            for (String cardNo : datas.keySet()) {
                if (tempExistsAsset != null && null != tempExistsAsset.get(cardNo.toLowerCase())) continue;
                unExistsAssetFail.put(cardNo, 1);
            }
            if (!unExistsAssetFail.isEmpty()) {
                for (String cardNo : unExistsAssetFail.keySet()) {
                    tempIdentity.remove(cardNo);
                    datas.remove(cardNo);
                }
            }
        }
        if (!datas.isEmpty()) {
            cardNoExists = this.assetManagerBusiness.queryAssetCertForMap(tempIdentity);
            for (String string : datas.keySet()) {
                if (cardNoExists == null || null == cardNoExists.get(string.toLowerCase())) {
                    unExistsCertFail.put(string, 1);
                    continue;
                }
                cardNoList.add(string);
            }
            if (!unExistsCertFail.isEmpty()) {
                for (String string : unExistsCertFail.keySet()) {
                    tempIdentity.remove(string);
                    datas.remove(string);
                }
            }
        }
    }

    public ImportResultBean importAssetCerts(Map<String, List<CertBean>> datas) {
        HashMap<String, Integer> repetitionFail = new HashMap<String, Integer>();
        HashMap<String, Integer> repetitionDataFail = new HashMap<String, Integer>();
        HashMap<String, Integer> numberFail = new HashMap<String, Integer>();
        HashMap<String, Integer> algorithmFail = new HashMap<String, Integer>();
        HashMap<String, Integer> unExistsAssetFail = new HashMap<String, Integer>();
        HashMap<String, Integer> unExistsCertFail = new HashMap<String, Integer>();
        ArrayList<String> cardNoList = new ArrayList<String>();
        this.dataFilterCertChange(datas, cardNoList, repetitionFail, repetitionDataFail, numberFail, algorithmFail, unExistsAssetFail, unExistsCertFail, 7);
        int failureCount = repetitionFail.size() + repetitionDataFail.size() + numberFail.size() + algorithmFail.size() + unExistsAssetFail.size() + unExistsCertFail.size();
        this.assetManagerBusiness.updateCerts(datas, cardNoList);
        if (!cardNoList.isEmpty()) {
            try {
                EcssMessage ecssMessage = new EcssMessage("certChange", cardNoList);
                ecssMessage.sendMessage();
            }
            catch (Exception e) {
                this.logger.error("\u8bc1\u4e66\u53d8\u66f4\u65f6\u53d1\u9001\u6d88\u606f\u5f02\u5e38.", (Throwable)e);
                throw new RuntimeException("\u8bc1\u4e66\u53d8\u66f4\u65f6\u53d1\u9001\u6d88\u606f\u5f02\u5e38.");
            }
        }
        List<AssetImportMsg> failResult = this.createCertFailureMsg(repetitionFail, "\u8bc1\u4e66\u4e0e\u6587\u4ef6\u4e2d\u6570\u636e\u91cd\u590d");
        failResult.addAll(this.createCertFailureMsg(repetitionDataFail, "\u8bc1\u4e66\u4e0e\u6570\u636e\u5e93\u4e2d\u6570\u636e\u91cd\u590d"));
        failResult.addAll(this.createCertFailureMsg(numberFail, "\u8d44\u4ea7\u8bc1\u4e66\u4e2a\u6570\u975e\u6cd5"));
        failResult.addAll(this.createCertFailureMsg(algorithmFail, "\u8d44\u4ea7\u8bc1\u4e66\u7b97\u6cd5\u7c7b\u578b\u975e\u6cd5"));
        failResult.addAll(this.createCertFailureMsg(unExistsAssetFail, "\u8d44\u4ea7\u4e0d\u5b58\u5728"));
        failResult.addAll(this.createCertFailureMsg(unExistsCertFail, "\u8d44\u4ea7\u8bc1\u4e66\u4e0d\u5b58\u5728"));
        ImportResultBean resultBean = new ImportResultBean();
        resultBean.setSucessCount(Integer.valueOf(datas.size()));
        resultBean.setFailCount(Integer.valueOf(failureCount));
        resultBean.setFailCardsMsg(failResult);
        resultBean.setDetail((Object[])new Integer[]{repetitionFail.size(), repetitionDataFail.size(), numberFail.size(), algorithmFail.size(), unExistsAssetFail.size(), unExistsCertFail.size()});
        return resultBean;
    }

    public ImportResultBean importAsset(List<String[]> datas, String failureName, int type, boolean status) {
        ArrayList<String[]> requiredFail = new ArrayList<String[]>();
        ArrayList<String[]> repetitionFail = new ArrayList<String[]>();
        ArrayList<String[]> repetitionDataFail = new ArrayList<String[]>();
        ArrayList<String[]> unExistsChipFail = new ArrayList<String[]>();
        ArrayList<String[]> templetIllegalFail = new ArrayList<String[]>();
        ArrayList<String[]> unExistsCertFail = new ArrayList<String[]>();
        ArrayList<String[]> orderExceptionFail = new ArrayList<String[]>();
        ArrayList<String[]> algorithmTypeFail = new ArrayList<String[]>();
        HashMap<String, String[]> temp = new HashMap<String, String[]>();
        HashMap<String, String[]> tempUsbKey = new HashMap<String, String[]>();
        HashMap<String, String> orderTypeMap = new HashMap<String, String>();
        HashMap<String, String> correctOrderProjectMap = new HashMap<String, String>();
        HashMap<String, String> correctOrderStateMap = new HashMap<String, String>();
        HashMap<String, String> correctOrderCustomerMap = new HashMap<String, String>();
        this.dataFilter(datas, temp, tempUsbKey, requiredFail, repetitionFail, repetitionDataFail, unExistsChipFail, templetIllegalFail, unExistsCertFail, algorithmTypeFail, orderExceptionFail, orderTypeMap, type, correctOrderProjectMap, correctOrderStateMap, correctOrderCustomerMap);
        int failureCount = requiredFail.size() + repetitionFail.size() + repetitionDataFail.size() + unExistsChipFail.size() + templetIllegalFail.size() + unExistsCertFail.size() + orderExceptionFail.size() + algorithmTypeFail.size();
        String string = failureName = failureCount > 0 ? failureName : "";
        if (datas != null && !datas.isEmpty()) {
            this.assetManagerBusiness.saveMobiles(datas, temp, tempUsbKey, type, status, failureName, datas.size(), failureCount, correctOrderProjectMap, correctOrderStateMap, correctOrderCustomerMap, orderTypeMap);
        }
        List<AssetImportMsg> failResult = this.createFailureMsg(requiredFail, "\u5fc5\u586b\u9879\u4e3a\u7a7a", type);
        failResult.addAll(this.createFailureMsg(repetitionFail, "excel\u6570\u636e\u91cd\u590d", type));
        failResult.addAll(this.createFailureMsg(repetitionDataFail, "\u6570\u636e\u5e93\u6570\u636e\u91cd\u590d", type));
        failResult.addAll(this.createFailureMsg(unExistsChipFail, "\u6570\u636e\u5e93\u5bf9\u5e94\u7684\u82af\u7247\u8d44\u4ea7\u4e0d\u5b58\u5728", type));
        failResult.addAll(this.createFailureMsg(templetIllegalFail, "\u6a21\u677f\u6570\u636e\u4e0d\u5408\u6cd5", type));
        failResult.addAll(this.createFailureMsg(unExistsCertFail, "\u8d44\u4ea7\u4e0d\u5b58\u5728\u8bc1\u4e66\u4fe1\u606f", type));
        failResult.addAll(this.createFailureMsg(orderExceptionFail, "\u9879\u76ee\u540d\u79f0\u6216\u5ba2\u6237\u540d\u79f0\u4e0d\u5408\u6cd5", type));
        failResult.addAll(this.createFailureMsg(algorithmTypeFail, "\u516c\u79c1\u94a5\u7b97\u6cd5\u7c7b\u578b\u6216\u4fdd\u62a4\u4fdd\u62a4\u5bc6\u94a5\u52a0\u5bc6\u79c1\u94a5\u7b97\u6cd5\u7c7b\u578b\u9519\u8bef", type));
        ImportResultBean resultBean = new ImportResultBean();
        resultBean.setSucessCount(Integer.valueOf(datas.size()));
        resultBean.setFailCount(Integer.valueOf(failureCount));
        resultBean.setFailCardsMsg(failResult);
        resultBean.setDetail((Object[])new Integer[]{requiredFail.size(), repetitionFail.size(), repetitionDataFail.size(), unExistsChipFail.size(), templetIllegalFail.size(), unExistsCertFail.size(), orderExceptionFail.size(), algorithmTypeFail.size()});
        return resultBean;
    }

    private void dataFilter(List<String[]> datas, Map<String, String[]> temp, Map<String, String[]> tempUsbKey, List<String[]> requiredFail, List<String[]> repetitionFail, List<String[]> repetitionDataFail, List<String[]> unExistsChipFail, List<String[]> templetIllegalFail, List<String[]> unExistsCertFail, List<String[]> algorithmTypeFail, List<String[]> orderExceptionFail, Map<String, String> orderTypeMap, int type, Map<String, String> correctOrderProjectMap, Map<String, String> correctOrderStateMap, Map<String, String> correctOrderCustomerMap) {
        String customerName;
        String projectName;
        String activeState;
        String orderName;
        Integer orderTypeLen;
        Integer activeIndex;
        String orderType;
        HashMap<String, String[]> tempUid = new HashMap<String, String[]>();
        HashMap<String, String[]> tempSn = new HashMap<String, String[]>();
        HashMap<String, String[]> tempImei = new HashMap<String, String[]>();
        ArrayList<String[]> tempDelete = new ArrayList<String[]>();
        Map<Object, Object> tempExistsChip = new HashMap();
        Map<Object, Object> tempExistsCert = new HashMap();
        HashMap<String, Integer> errorOrderMap = new HashMap<String, Integer>();
        HashMap<String, Integer> local = new HashMap<String, Integer>();
        block14: for (String[] item : datas) {
            switch (type) {
                case 1: 
                case 2: {
                    if (StringUtils.isBlank((CharSequence)item[0]) && StringUtils.isBlank((CharSequence)item[1]) && StringUtils.isBlank((CharSequence)item[2]) && StringUtils.isBlank((CharSequence)item[3]) && StringUtils.isBlank((CharSequence)item[4]) && StringUtils.isBlank((CharSequence)item[5]) && StringUtils.isBlank((CharSequence)item[6]) && StringUtils.isBlank((CharSequence)item[7])) {
                        tempDelete.add(item);
                        continue block14;
                    }
                    if (StringUtils.isBlank((CharSequence)item[0]) || StringUtils.isBlank((CharSequence)item[5]) || StringUtils.isBlank((CharSequence)item[6]) || StringUtils.isBlank((CharSequence)item[7])) {
                        requiredFail.add(item);
                        continue block14;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)item[2]) || !StringUtils.isBlank((CharSequence)item[3])) break;
                    templetIllegalFail.add(item);
                    break;
                }
                case 4: 
                case 5: {
                    if (StringUtils.isBlank((CharSequence)item[0]) && StringUtils.isBlank((CharSequence)item[1])) {
                        tempDelete.add(item);
                        continue block14;
                    }
                    if (!StringUtils.isBlank((CharSequence)item[0])) break;
                    requiredFail.add(item);
                    continue block14;
                }
                case 10: {
                    if (StringUtils.isBlank((CharSequence)item[0])) {
                        tempDelete.add(item);
                        continue block14;
                    }
                    if (!StringUtils.isBlank((CharSequence)item[0])) break;
                    requiredFail.add(item);
                    continue block14;
                }
                case 6: {
                    if (StringUtils.isBlank((CharSequence)item[0]) && StringUtils.isBlank((CharSequence)item[1]) && StringUtils.isBlank((CharSequence)item[2]) && StringUtils.isBlank((CharSequence)item[3]) && StringUtils.isBlank((CharSequence)item[4]) && StringUtils.isBlank((CharSequence)item[5])) {
                        tempDelete.add(item);
                        continue block14;
                    }
                    if (!StringUtils.isBlank((CharSequence)item[0]) && !StringUtils.isBlank((CharSequence)item[1]) && !StringUtils.isBlank((CharSequence)item[2]) && !StringUtils.isBlank((CharSequence)item[3]) && !StringUtils.isBlank((CharSequence)item[4]) && !StringUtils.isBlank((CharSequence)item[5])) break;
                    requiredFail.add(item);
                    continue block14;
                }
                case 8: {
                    if (StringUtils.isBlank((CharSequence)item[0]) && StringUtils.isBlank((CharSequence)item[1]) && StringUtils.isBlank((CharSequence)item[2])) {
                        tempDelete.add(item);
                        continue block14;
                    }
                    if (!StringUtils.isBlank((CharSequence)item[0]) && !StringUtils.isBlank((CharSequence)item[1]) && !StringUtils.isBlank((CharSequence)item[2])) break;
                    requiredFail.add(item);
                    continue block14;
                }
                case 9: {
                    if (StringUtils.isBlank((CharSequence)item[0]) && StringUtils.isBlank((CharSequence)item[1]) && StringUtils.isBlank((CharSequence)item[2]) && StringUtils.isBlank((CharSequence)item[3]) && StringUtils.isBlank((CharSequence)item[4]) && StringUtils.isBlank((CharSequence)item[5]) && StringUtils.isBlank((CharSequence)item[6]) && StringUtils.isBlank((CharSequence)item[7]) && StringUtils.isBlank((CharSequence)item[8]) && StringUtils.isBlank((CharSequence)item[9]) && StringUtils.isBlank((CharSequence)item[10])) {
                        tempDelete.add(item);
                        continue block14;
                    }
                    if (StringUtils.isBlank((CharSequence)item[0]) || StringUtils.isBlank((CharSequence)item[1]) || StringUtils.isBlank((CharSequence)item[2]) || StringUtils.isBlank((CharSequence)item[3]) || StringUtils.isBlank((CharSequence)item[4]) || StringUtils.isBlank((CharSequence)item[5]) || StringUtils.isBlank((CharSequence)item[6]) || StringUtils.isBlank((CharSequence)item[7]) || StringUtils.isBlank((CharSequence)item[8]) || StringUtils.isBlank((CharSequence)item[9]) || StringUtils.isBlank((CharSequence)item[10])) {
                        requiredFail.add(item);
                        continue block14;
                    }
                    BakcardCondition condition = new BakcardCondition();
                    condition.setBkeyPariAlg(item[8].trim());
                    condition.setEncBkeyAlg(item[9].trim());
                    if (condition.getBkeyPariAlgInt() == null || condition.getEncBkeyAlgInt() == null) {
                        algorithmTypeFail.add(item);
                        continue block14;
                    }
                    item[8] = condition.getBkeyPariAlgInt().toString();
                    item[9] = condition.getEncBkeyAlgInt().toString();
                }
            }
            if (null == local.get(item[0].toLowerCase())) {
                local.put(item[0].toLowerCase(), 1);
                temp.put(item[0].toLowerCase(), item);
                continue;
            }
            repetitionFail.add(item);
        }
        datas.removeAll(tempDelete);
        datas.removeAll(requiredFail);
        datas.removeAll(repetitionFail);
        datas.removeAll(templetIllegalFail);
        datas.removeAll(algorithmTypeFail);
        if (type == 6) {
            for (String[] item : datas) {
                orderType = this.checkOrderByName(item[4].trim());
                if (StringUtils.isBlank((CharSequence)orderType) || item[4].trim().length() <= orderType.length() + (Integer)Constants.CUSTOMER_ORDER_TYPE.get(orderType) + Constants.ORDER_ACTIVE_STATE_LENGTH) {
                    orderExceptionFail.add(item);
                    continue;
                }
                activeIndex = item[4].trim().indexOf("&");
                if (activeIndex < 0 || null == Constants.ACTIVE_TYPE.get(item[4].trim().substring(activeIndex + 1))) {
                    orderExceptionFail.add(item);
                    continue;
                }
                orderTypeLen = (Integer)Constants.CUSTOMER_ORDER_TYPE.get(orderType);
                orderName = item[4].trim().substring(orderType.length(), orderType.length() + orderTypeLen);
                activeState = item[4].trim().substring(item[4].trim().indexOf("&") + 1);
                projectName = item[4].trim().substring(orderType.length() + orderTypeLen, item[4].trim().indexOf("&"));
                customerName = item[5].trim();
                if (StringUtils.isNotBlank((CharSequence)correctOrderProjectMap.get(orderName))) {
                    if (!correctOrderProjectMap.get(orderName).equalsIgnoreCase(projectName)) {
                        errorOrderMap.put(orderName, 1);
                    }
                } else {
                    correctOrderProjectMap.put(orderName, projectName);
                }
                if (StringUtils.isNotBlank((CharSequence)correctOrderStateMap.get(orderName))) {
                    if (!correctOrderStateMap.get(orderName).equalsIgnoreCase(activeState)) {
                        errorOrderMap.put(orderName, 1);
                    }
                } else {
                    correctOrderStateMap.put(orderName, activeState);
                }
                if (StringUtils.isNotBlank((CharSequence)correctOrderCustomerMap.get(orderName))) {
                    if (!correctOrderCustomerMap.get(orderName).equalsIgnoreCase(customerName)) {
                        errorOrderMap.put(orderName, 1);
                    }
                } else {
                    correctOrderCustomerMap.put(orderName, customerName);
                }
                orderTypeMap.put(item[0].toLowerCase(), orderType);
            }
            datas.removeAll(orderExceptionFail);
            correctOrderProjectMap.clear();
            correctOrderStateMap.clear();
            correctOrderCustomerMap.clear();
            for (String[] item : datas) {
                orderType = orderTypeMap.get(item[0].toLowerCase());
                orderTypeLen = (Integer)Constants.CUSTOMER_ORDER_TYPE.get(orderType);
                orderName = item[4].trim().substring(orderType.length(), orderType.length() + orderTypeLen);
                activeState = item[4].trim().substring(item[4].trim().indexOf("&") + 1);
                projectName = item[4].trim().substring(orderType.length() + orderTypeLen, item[4].trim().indexOf("&"));
                customerName = item[5].trim();
                if (null != errorOrderMap.get(orderName)) {
                    orderExceptionFail.add(item);
                    temp.remove(item[0].toLowerCase());
                    continue;
                }
                correctOrderProjectMap.put(orderName, projectName);
                correctOrderStateMap.put(orderName, activeState);
                correctOrderCustomerMap.put(orderName, customerName);
            }
            datas.removeAll(orderExceptionFail);
        }
        if (type == 9) {
            for (String[] item : datas) {
                orderType = this.checkOrderByName(item[1].trim());
                if (StringUtils.isBlank((CharSequence)orderType) || item[1].trim().length() <= orderType.length() + (Integer)Constants.CUSTOMER_ORDER_TYPE.get(orderType) + Constants.ORDER_ACTIVE_STATE_LENGTH) {
                    orderExceptionFail.add(item);
                    continue;
                }
                activeIndex = item[1].trim().indexOf("&");
                if (activeIndex < 0 || null == Constants.ACTIVE_TYPE.get(item[1].trim().substring(activeIndex + 1))) {
                    orderExceptionFail.add(item);
                    continue;
                }
                orderTypeLen = (Integer)Constants.CUSTOMER_ORDER_TYPE.get(orderType);
                orderName = item[1].trim().substring(orderType.length(), orderType.length() + orderTypeLen);
                activeState = item[1].trim().substring(item[1].trim().indexOf("&") + 1);
                projectName = item[1].trim().substring(orderType.length() + orderTypeLen, item[1].trim().indexOf("&"));
                customerName = item[2].trim();
                if (StringUtils.isNotBlank((CharSequence)correctOrderProjectMap.get(orderName))) {
                    if (!correctOrderProjectMap.get(orderName).equalsIgnoreCase(projectName)) {
                        errorOrderMap.put(orderName, 1);
                    }
                } else {
                    correctOrderProjectMap.put(orderName, projectName);
                }
                if (StringUtils.isNotBlank((CharSequence)correctOrderStateMap.get(orderName))) {
                    if (!correctOrderStateMap.get(orderName).equalsIgnoreCase(activeState)) {
                        errorOrderMap.put(orderName, 1);
                    }
                } else {
                    correctOrderStateMap.put(orderName, activeState);
                }
                if (StringUtils.isNotBlank((CharSequence)correctOrderCustomerMap.get(orderName))) {
                    if (!correctOrderCustomerMap.get(orderName).equalsIgnoreCase(customerName)) {
                        errorOrderMap.put(orderName, 1);
                    }
                } else {
                    correctOrderCustomerMap.put(orderName, customerName);
                }
                orderTypeMap.put(item[0].toLowerCase(), orderType);
            }
            datas.removeAll(orderExceptionFail);
            correctOrderProjectMap.clear();
            correctOrderStateMap.clear();
            correctOrderCustomerMap.clear();
            for (String[] item : datas) {
                orderType = orderTypeMap.get(item[0].toLowerCase());
                orderTypeLen = (Integer)Constants.CUSTOMER_ORDER_TYPE.get(orderType);
                orderName = item[1].trim().substring(orderType.length(), orderType.length() + orderTypeLen);
                activeState = item[1].trim().substring(item[1].trim().indexOf("&") + 1);
                projectName = item[1].trim().substring(orderType.length() + orderTypeLen, item[1].trim().indexOf("&"));
                customerName = item[2].trim();
                if (null != errorOrderMap.get(orderName)) {
                    orderExceptionFail.add(item);
                    temp.remove(item[0].toLowerCase());
                    continue;
                }
                correctOrderProjectMap.put(orderName, projectName);
                correctOrderStateMap.put(orderName, activeState);
                correctOrderCustomerMap.put(orderName, customerName);
            }
            datas.removeAll(orderExceptionFail);
        }
        if (type == 1 || type == 2) {
            local.clear();
            for (String[] item : datas) {
                if (!StringUtils.isNotBlank((CharSequence)item[2])) continue;
                if (null == local.get(item[2].toLowerCase()) && !item[0].equalsIgnoreCase(item[2])) {
                    local.put(item[2].toLowerCase(), 1);
                    tempUsbKey.put(item[2], item);
                    continue;
                }
                repetitionFail.add(item);
                temp.remove(item[0].toLowerCase());
            }
            datas.removeAll(repetitionFail);
            local.clear();
            for (String[] item : datas) {
                if (null == local.get(item[6].toLowerCase())) {
                    local.put(item[6].toLowerCase(), 1);
                    tempSn.put(item[6], item);
                    continue;
                }
                repetitionFail.add(item);
                temp.remove(item[0].toLowerCase());
                tempUsbKey.remove(item[2]);
            }
            datas.removeAll(repetitionFail);
            local.clear();
            for (String[] item : datas) {
                if (null == local.get(item[5].toLowerCase())) {
                    local.put(item[5].toLowerCase(), 1);
                    tempImei.put(item[5], item);
                    continue;
                }
                repetitionFail.add(item);
                temp.remove(item[0].toLowerCase());
                tempUsbKey.remove(item[2]);
            }
            datas.removeAll(repetitionFail);
        }
        if (type == 8) {
            local.clear();
            for (String[] item : datas) {
                if (null == local.get(item[1].toLowerCase())) {
                    local.put(item[1].toLowerCase(), 1);
                    tempUid.put(item[1], item);
                    continue;
                }
                repetitionFail.add(item);
                temp.remove(item[0].toLowerCase());
            }
            datas.removeAll(repetitionFail);
        }
        if (!datas.isEmpty()) {
            List<String> repetitionList = null;
            String[] tempData = null;
            switch (type) {
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 10: {
                    Boolean isMobile = type == 1 || type == 2;
                    tempExistsChip = this.assetManagerBusiness.queryAssetChip(new ArrayList<String>(temp.keySet()));
                    for (String[] stringArray : datas) {
                        if (tempExistsChip != null && null != tempExistsChip.get(stringArray[0].toLowerCase())) continue;
                        tempData = temp.get(stringArray[0].toLowerCase());
                        unExistsChipFail.add(stringArray);
                        temp.remove(stringArray[0].toLowerCase());
                        if (!isMobile.booleanValue()) continue;
                        tempSn.remove(stringArray[6]);
                        tempImei.remove(stringArray[5]);
                        tempUsbKey.remove(stringArray[2]);
                    }
                    datas.removeAll(unExistsChipFail);
                    if (!datas.isEmpty()) {
                        repetitionList = this.assetManagerBusiness.checkAssetUnChipExist(new ArrayList<String>(temp.keySet()));
                        for (String string : repetitionList) {
                            tempData = temp.get(string.toLowerCase());
                            repetitionDataFail.add(tempData);
                            datas.remove(tempData);
                            temp.remove(string.toLowerCase());
                            if (!isMobile.booleanValue()) continue;
                            tempSn.remove(tempData[6]);
                            tempImei.remove(tempData[5]);
                            tempUsbKey.remove(tempData[2]);
                        }
                        datas.removeAll(repetitionDataFail);
                    }
                    if (!datas.isEmpty()) {
                        tempExistsCert = this.assetManagerBusiness.queryAssetCert(new ArrayList<String>(temp.keySet()));
                        for (String[] stringArray : datas) {
                            if (tempExistsCert != null && null != tempExistsCert.get(stringArray[0].toLowerCase())) continue;
                            tempData = temp.get(stringArray[0].toLowerCase());
                            unExistsCertFail.add(stringArray);
                            temp.remove(stringArray[0].toLowerCase());
                            if (!isMobile.booleanValue()) continue;
                            tempSn.remove(stringArray[6]);
                            tempImei.remove(stringArray[5]);
                            tempUsbKey.remove(stringArray[2]);
                        }
                        datas.removeAll(unExistsCertFail);
                    }
                    if (!isMobile.booleanValue()) break;
                    if (!datas.isEmpty() && !tempUsbKey.isEmpty()) {
                        tempExistsChip = this.assetManagerBusiness.queryAssetChip(new ArrayList<String>(tempUsbKey.keySet()));
                        for (String[] stringArray : datas) {
                            if (stringArray[2] == null || tempExistsChip != null && null != tempExistsChip.get(stringArray[2].toLowerCase())) continue;
                            tempData = temp.get(stringArray[0].toLowerCase());
                            unExistsChipFail.add(stringArray);
                            temp.remove(stringArray[0].toLowerCase());
                            tempSn.remove(stringArray[6]);
                            tempUsbKey.remove(stringArray[2]);
                            tempImei.remove(tempData[5]);
                        }
                        datas.removeAll(unExistsChipFail);
                    }
                    if (!datas.isEmpty() && !tempUsbKey.isEmpty()) {
                        repetitionList = this.assetManagerBusiness.checkAssetUnChipExist(new ArrayList<String>(tempUsbKey.keySet()));
                        for (String string : repetitionList) {
                            tempData = temp.get(string.toLowerCase());
                            repetitionDataFail.add(tempData);
                            datas.remove(tempData);
                            temp.remove(string.toLowerCase());
                            tempSn.remove(tempData[6]);
                            tempUsbKey.remove(tempData[2]);
                            tempImei.remove(tempData[5]);
                        }
                    }
                    if (!datas.isEmpty()) {
                        List<String> snList = this.assetManagerBusiness.checkMobileSnExist(new ArrayList<String>(tempSn.keySet()));
                        for (String sn : snList) {
                            tempData = (String[])tempSn.get(sn);
                            repetitionDataFail.add(tempData);
                            datas.remove(tempData);
                            temp.remove(tempData[0].toLowerCase());
                            tempUsbKey.remove(tempData[2]);
                            tempImei.remove(tempData[5]);
                        }
                    }
                    if (datas.isEmpty()) break;
                    List<String> imeiList = this.assetManagerBusiness.checkMobileImeiExist(new ArrayList<String>(tempImei.keySet()));
                    for (String imei : imeiList) {
                        tempData = (String[])tempImei.get(imei);
                        repetitionDataFail.add(tempData);
                        datas.remove(tempData);
                        temp.remove(tempData[0].toLowerCase());
                        tempUsbKey.remove(tempData[2]);
                    }
                    break;
                }
                case 6: {
                    repetitionList = this.assetManagerBusiness.checkAssetExist(new ArrayList<String>(temp.keySet()));
                    for (String string : repetitionList) {
                        tempData = temp.get(string);
                        repetitionDataFail.add(tempData);
                        datas.remove(tempData);
                        temp.remove(string);
                    }
                    if (!datas.isEmpty()) {
                        tempExistsCert = this.assetManagerBusiness.queryAssetCert(new ArrayList<String>(temp.keySet()));
                        for (String[] stringArray : datas) {
                            if (tempExistsCert != null && null != tempExistsCert.get(stringArray[0].toLowerCase())) continue;
                            tempData = temp.get(stringArray[0].toLowerCase());
                            unExistsCertFail.add(stringArray);
                            temp.remove(stringArray[0].toLowerCase());
                        }
                        datas.removeAll(unExistsCertFail);
                    }
                    HashMap<String, String> orderProjectMap = new HashMap<String, String>();
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    HashMap<String, String> orderCustomerMap = new HashMap<String, String>();
                    if (datas.isEmpty()) break;
                    this.assetManagerBusiness.queryOrderProject(new ArrayList<String>(correctOrderProjectMap.keySet()), orderProjectMap, hashMap);
                    this.assetManagerBusiness.queryOrderCustomer(new ArrayList<String>(correctOrderProjectMap.keySet()), orderCustomerMap);
                    for (String[] item : datas) {
                        orderType = orderTypeMap.get(item[0].toLowerCase());
                        orderTypeLen = (Integer)Constants.CUSTOMER_ORDER_TYPE.get(orderType);
                        orderName = item[4].trim().substring(orderType.length(), orderType.length() + orderTypeLen);
                        projectName = item[4].trim().substring(orderType.length() + orderTypeLen, item[4].trim().indexOf("&"));
                        if (orderProjectMap != null && null != orderProjectMap.get(orderName) && !((String)orderProjectMap.get(orderName)).equalsIgnoreCase(correctOrderProjectMap.get(orderName))) {
                            tempData = temp.get(item[0].toLowerCase());
                            orderExceptionFail.add(item);
                            temp.remove(item[0].toLowerCase());
                            correctOrderCustomerMap.remove(orderName);
                            correctOrderProjectMap.remove(orderName);
                            correctOrderStateMap.remove(orderName);
                            continue;
                        }
                        if (hashMap != null && null != hashMap.get(orderName) && !((String)hashMap.get(orderName)).equalsIgnoreCase(correctOrderStateMap.get(orderName))) {
                            tempData = temp.get(item[0].toLowerCase());
                            orderExceptionFail.add(item);
                            temp.remove(item[0].toLowerCase());
                            correctOrderCustomerMap.remove(orderName);
                            correctOrderProjectMap.remove(orderName);
                            correctOrderStateMap.remove(orderName);
                            continue;
                        }
                        if (orderCustomerMap == null || null == orderCustomerMap.get(orderName) || ((String)orderCustomerMap.get(orderName)).equalsIgnoreCase(correctOrderCustomerMap.get(orderName))) continue;
                        tempData = temp.get(item[0].toLowerCase());
                        orderExceptionFail.add(item);
                        temp.remove(item[0].toLowerCase());
                        correctOrderProjectMap.remove(orderName);
                        correctOrderStateMap.remove(orderName);
                        correctOrderCustomerMap.remove(orderName);
                    }
                    datas.removeAll(orderExceptionFail);
                    break;
                }
                case 9: {
                    repetitionList = this.assetManagerBusiness.checkBakcardExist(new ArrayList<String>(temp.keySet()));
                    for (String identify : repetitionList) {
                        tempData = temp.get(identify);
                        repetitionDataFail.add(tempData);
                        datas.remove(tempData);
                        temp.remove(identify);
                    }
                    HashMap<String, String> orderProjecBakcardtMap = new HashMap<String, String>();
                    HashMap<String, String> orderActiveBakcardMap = new HashMap<String, String>();
                    HashMap<String, String> bakcardOrderCustomerMap = new HashMap<String, String>();
                    if (datas.isEmpty()) break;
                    this.assetManagerBusiness.queryOrderProject(new ArrayList<String>(correctOrderProjectMap.keySet()), orderProjecBakcardtMap, orderActiveBakcardMap);
                    this.assetManagerBusiness.queryOrderCustomer(new ArrayList<String>(correctOrderProjectMap.keySet()), bakcardOrderCustomerMap);
                    for (String[] item : datas) {
                        orderType = orderTypeMap.get(item[0].toLowerCase());
                        orderTypeLen = (Integer)Constants.CUSTOMER_ORDER_TYPE.get(orderType);
                        orderName = item[1].trim().substring(orderType.length(), orderType.length() + orderTypeLen);
                        projectName = item[1].trim().substring(orderType.length() + orderTypeLen, item[1].trim().indexOf("&"));
                        if (orderProjecBakcardtMap != null && null != orderProjecBakcardtMap.get(orderName) && !((String)orderProjecBakcardtMap.get(orderName)).equalsIgnoreCase(correctOrderProjectMap.get(orderName))) {
                            tempData = temp.get(item[0].toLowerCase());
                            orderExceptionFail.add(item);
                            temp.remove(item[0].toLowerCase());
                            correctOrderProjectMap.remove(orderName);
                            correctOrderStateMap.remove(orderName);
                            continue;
                        }
                        if (orderActiveBakcardMap != null && null != orderActiveBakcardMap.get(orderName) && !((String)orderActiveBakcardMap.get(orderName)).equalsIgnoreCase(correctOrderStateMap.get(orderName))) {
                            tempData = temp.get(item[0].toLowerCase());
                            orderExceptionFail.add(item);
                            temp.remove(item[0].toLowerCase());
                            correctOrderProjectMap.remove(orderName);
                            correctOrderStateMap.remove(orderName);
                            continue;
                        }
                        if (bakcardOrderCustomerMap == null || null == bakcardOrderCustomerMap.get(orderName) || ((String)bakcardOrderCustomerMap.get(orderName)).equalsIgnoreCase(correctOrderCustomerMap.get(orderName))) continue;
                        tempData = temp.get(item[0].toLowerCase());
                        orderExceptionFail.add(item);
                        temp.remove(item[0].toLowerCase());
                        correctOrderProjectMap.remove(orderName);
                        correctOrderStateMap.remove(orderName);
                        correctOrderCustomerMap.remove(orderName);
                    }
                    datas.removeAll(orderExceptionFail);
                    break;
                }
                case 8: {
                    repetitionList = this.assetManagerBusiness.checkUnLockExist(new ArrayList<String>(temp.keySet()));
                    for (String identify : repetitionList) {
                        tempData = temp.get(identify.toLowerCase());
                        repetitionDataFail.add(tempData);
                        datas.remove(tempData);
                        temp.remove(identify.toLowerCase());
                        tempUid.remove(tempData[1]);
                    }
                    if (datas.isEmpty()) break;
                    List<String> relationList = this.assetManagerBusiness.checkUidExist(new ArrayList<String>(tempUid.keySet()));
                    for (String uid : relationList) {
                        tempData = (String[])tempUid.get(uid);
                        repetitionDataFail.add(tempData);
                        datas.remove(tempData);
                        temp.remove(tempData[0].toLowerCase());
                    }
                    break;
                }
            }
        }
    }

    private String checkOrderByName(String projectName) {
        for (String orderType : Constants.CUSTOMER_ORDER_TYPE.keySet()) {
            if (!projectName.toUpperCase().startsWith(orderType)) continue;
            return orderType;
        }
        return null;
    }

    private List<AssetImportMsg> createFailureMsg(List<String[]> failDatas, String desc, int type) {
        ArrayList<AssetImportMsg> result = new ArrayList<AssetImportMsg>();
        AssetImportMsg failure = null;
        int index = 0;
        for (String[] item : failDatas) {
            failure = new AssetImportMsg();
            failure.setCardNo(item[index]);
            failure.setFailMessage(desc + "\uff0c\u5bf9\u5e94\u6e90\u6587\u4ef6\u884c\u53f7\uff1a" + item[item.length - 1]);
            result.add(failure);
        }
        return result;
    }

    private List<AssetImportMsg> createCertFailureMsg(Map<String, Integer> failDatas, String desc) {
        ArrayList<AssetImportMsg> result = new ArrayList<AssetImportMsg>();
        AssetImportMsg failure = null;
        for (String cardNo : failDatas.keySet()) {
            failure = new AssetImportMsg();
            failure.setCardNo(cardNo);
            failure.setFailMessage(desc);
            result.add(failure);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private void dataFilterCert(Map<String, List<CertBean>> datas, Map<String, Integer> repetitionFail, Map<String, Integer> repetitionDataFail, Map<String, Integer> numberFail, Map<String, Integer> algorithmFail, Map<String, Integer> certChangeFail, int type) {
        int i;
        List<String> algTypeList = this.getAlgType();
        HashMap<String, List<CertBean>> datasCopy = new HashMap<String, List<CertBean>>();
        datasCopy.putAll(datas);
        HashMap<String, String> tempSn = new HashMap<String, String>();
        HashMap<String, Integer> localTemp = new HashMap<String, Integer>();
        ArrayList<String> cardNoList = new ArrayList<String>();
        ArrayList<String> cardNoExistsList = new ArrayList();
        ArrayList<String> tempAlgType = null;
        List<CertBean> certList = null;
        CertBean certBean = null;
        String certSn = null;
        String tempCardNo = null;
        if (!datas.isEmpty()) {
            for (String string : datas.keySet()) {
                certList = datas.get(string);
                if (certList != null && (certList == null || certList.size() == 4)) continue;
                numberFail.put(string, 1);
            }
            if (!numberFail.isEmpty()) {
                for (String string : numberFail.keySet()) {
                    datas.remove(string);
                }
            }
        }
        if (!datas.isEmpty()) {
            for (String string : datas.keySet()) {
                certList = datas.get(string);
                tempAlgType = new ArrayList<String>();
                for (i = 0; i < certList.size(); ++i) {
                    certBean = certList.get(i);
                    tempAlgType.add(certBean.getCertType() + "" + certBean.getCaAlg());
                }
                if (tempAlgType.containsAll(algTypeList)) continue;
                algorithmFail.put(string, 1);
            }
            if (!algorithmFail.isEmpty()) {
                for (String string : algorithmFail.keySet()) {
                    datas.remove(string);
                }
            }
        }
        if (!datas.isEmpty()) {
            block5: for (String string : datas.keySet()) {
                certList = datas.get(string);
                for (i = 0; i < certList.size(); ++i) {
                    certBean = certList.get(i);
                    certSn = certBean.getSn();
                    if (null != tempSn.get(certSn)) {
                        repetitionFail.put(string, 1);
                        localTemp.put(string, 1);
                        continue block5;
                    }
                    tempSn.put(certSn, string);
                }
            }
            if (!localTemp.isEmpty()) {
                for (String string : localTemp.keySet()) {
                    datas.remove(string);
                }
            }
        }
        if (!datas.isEmpty()) {
            Iterator snList = this.assetManagerBusiness.checkCertSnExist(new ArrayList<String>(tempSn.keySet()));
            Iterator iterator = snList.iterator();
            while (iterator.hasNext()) {
                String sn = (String)iterator.next();
                tempCardNo = (String)tempSn.get(sn);
                repetitionDataFail.put(tempCardNo, 1);
                datas.remove(tempCardNo);
            }
        }
        if (!datas.isEmpty()) {
            for (String string : datas.keySet()) {
                cardNoList.add(string);
            }
            cardNoExistsList = this.assetManagerBusiness.checkCertExist(cardNoList);
            for (String string : cardNoExistsList) {
                datas.remove(string);
            }
        }
        if (!cardNoExistsList.isEmpty()) {
            HashMap<String, void> existDatas = new HashMap<String, void>();
            Object var20_37 = null;
            List<CertBean> certExistList = this.assetManagerBusiness.getCertSnExist(cardNoExistsList);
            for (int i2 = 0; i2 < certExistList.size(); ++i2) {
                void var20_41;
                CertBean cert = certExistList.get(i2);
                String cardNoExist = cert.getCardNo();
                if (null == existDatas.get(cardNoExist)) {
                    ArrayList arrayList = new ArrayList();
                } else {
                    List list = (List)existDatas.get(cardNoExist);
                }
                var20_41.add(cert.getSn());
                existDatas.put(cardNoExist, var20_41);
            }
            if (!existDatas.isEmpty()) {
                for (String cardNo : existDatas.keySet()) {
                    List tempCert = (List)datasCopy.get(cardNo);
                    ArrayList<String> snList = new ArrayList<String>();
                    for (int i3 = 0; i3 < tempCert.size(); ++i3) {
                        snList.add(((CertBean)tempCert.get(i3)).getSn());
                    }
                    if (snList.containsAll((Collection)existDatas.get(cardNo))) {
                        repetitionDataFail.put(cardNo, 1);
                        continue;
                    }
                    certChangeFail.put(cardNo, 1);
                }
            }
        }
    }

    private List<String> getAlgType() {
        ArrayList<String> certAlg = new ArrayList<String>();
        certAlg.add("11");
        certAlg.add("12");
        certAlg.add("21");
        certAlg.add("22");
        return certAlg;
    }

    public ImportResultBean importCert(Map<String, List<CertBean>> datas, String failureName, int type, boolean status) {
        HashMap<String, Integer> repetitionFail = new HashMap<String, Integer>();
        HashMap<String, Integer> repetitionDataFail = new HashMap<String, Integer>();
        HashMap<String, Integer> numberFail = new HashMap<String, Integer>();
        HashMap<String, Integer> algorithmFail = new HashMap<String, Integer>();
        HashMap<String, Integer> certChangeFail = new HashMap<String, Integer>();
        this.dataFilterCert(datas, repetitionFail, repetitionDataFail, numberFail, algorithmFail, certChangeFail, type);
        int failureCount = repetitionFail.size() + repetitionDataFail.size() + numberFail.size() + algorithmFail.size() + certChangeFail.size();
        failureName = failureCount > 0 ? failureName : "";
        this.assetManagerBusiness.saveCert(datas, type, status, failureName, datas.size(), failureCount);
        if (!datas.isEmpty()) {
            try {
                EcssMessage ecssMessage = new EcssMessage("assetImport", datas.keySet());
                ecssMessage.sendMessage();
            }
            catch (Exception e) {
                this.logger.error("\u8d44\u4ea7\u5bfc\u5165\u65f6\u53d1\u9001SC\u4e3b\u9898\u5f02\u5e38.", (Throwable)e);
                throw new RuntimeException("\u8d44\u4ea7\u5bfc\u5165\u65f6\u53d1\u9001SC\u4e3b\u9898\u5f02\u5e38.");
            }
        }
        List<AssetImportMsg> failResult = this.createCertFailureMsg(repetitionFail, "\u8bc1\u4e66\u4e0e\u6587\u4ef6\u4e2d\u6570\u636e\u91cd\u590d");
        failResult.addAll(this.createCertFailureMsg(repetitionDataFail, "\u8bc1\u4e66\u4e0e\u6570\u636e\u5e93\u4e2d\u6570\u636e\u91cd\u590d"));
        failResult.addAll(this.createCertFailureMsg(numberFail, "\u8d44\u4ea7\u8bc1\u4e66\u4e2a\u6570\u975e\u6cd5"));
        failResult.addAll(this.createCertFailureMsg(algorithmFail, "\u8d44\u4ea7\u8bc1\u4e66\u7b97\u6cd5\u7c7b\u578b\u975e\u6cd5"));
        failResult.addAll(this.createCertFailureMsg(certChangeFail, "\u8d44\u4ea7\u8bc1\u4e66\u9700\u53d8\u66f4"));
        ImportResultBean resultBean = new ImportResultBean();
        resultBean.setSucessCount(Integer.valueOf(datas.size()));
        resultBean.setFailCount(Integer.valueOf(failureCount));
        resultBean.setFailCardsMsg(failResult);
        resultBean.setDetail((Object[])new Integer[]{repetitionFail.size(), repetitionDataFail.size(), numberFail.size(), algorithmFail.size(), certChangeFail.size()});
        return resultBean;
    }

    private void assembleOrderMap(String orderType, String projectName, String customerName, Map<String, String> correctOrderProjectMap, Map<String, String> correctOrderStateMap, Map<String, String> correctOrderCustomerMap, Map<String, Integer> errorOrderMap) {
        Integer orderTypeLen = (Integer)Constants.CUSTOMER_ORDER_TYPE.get(orderType);
        String orderName = projectName.trim().substring(orderType.length(), orderType.length() + orderTypeLen);
        String activeState = projectName.trim().substring(projectName.trim().indexOf("&") + 1);
        projectName = projectName.trim().substring(orderType.length() + orderTypeLen, projectName.trim().indexOf("&"));
        if (StringUtils.isNotBlank((CharSequence)correctOrderProjectMap.get(orderName))) {
            if (!correctOrderProjectMap.get(orderName).equalsIgnoreCase(projectName)) {
                errorOrderMap.put(orderName, 1);
                return;
            }
        } else {
            correctOrderProjectMap.put(orderName, projectName);
        }
        if (StringUtils.isNotBlank((CharSequence)correctOrderStateMap.get(orderName))) {
            if (!correctOrderStateMap.get(orderName).equalsIgnoreCase(activeState)) {
                errorOrderMap.put(orderName, 1);
                return;
            }
        } else {
            correctOrderStateMap.put(orderName, activeState);
        }
        if (StringUtils.isNotBlank((CharSequence)correctOrderCustomerMap.get(orderName))) {
            if (!correctOrderCustomerMap.get(orderName).equalsIgnoreCase(customerName)) {
                errorOrderMap.put(orderName, 1);
                return;
            }
        } else {
            correctOrderCustomerMap.put(orderName, customerName);
        }
    }

    private Map<String, Object> bulidFailureResult(String key, Integer type, String desc) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("cardNo", key);
        result.put("type", type);
        result.put("desc", desc);
        return result;
    }

    public void dataFilterFormat(List<String[]> datas, Map<String, String[]> temp, List<String[]> repetitionFail, List<String[]> unExistsAssetFail, List<String[]> unDistinguishKuepFail) {
        HashMap<String, Integer> local = new HashMap<String, Integer>();
        Map<Object, Object> tempExistsAsset = new HashMap();
        ArrayList<String[]> tempDelete = new ArrayList<String[]>();
        for (String[] item : datas) {
            if (!StringUtils.isBlank((CharSequence)item[0])) continue;
            tempDelete.add(item);
        }
        datas.removeAll(tempDelete);
        for (String[] item : datas) {
            if (null == local.get(item[0].toLowerCase())) {
                local.put(item[0].toLowerCase(), 1);
                temp.put(item[0].toLowerCase(), item);
                continue;
            }
            repetitionFail.add(item);
        }
        datas.removeAll(repetitionFail);
        if (!datas.isEmpty()) {
            tempExistsAsset = this.assetManagerBusiness.queryAssetByCardNos(new ArrayList<String>(temp.keySet()));
            for (String[] item : datas) {
                if (tempExistsAsset != null && null != tempExistsAsset.get(item[0].toLowerCase())) continue;
                unExistsAssetFail.add(item);
                temp.remove(item[0].toLowerCase());
            }
            datas.removeAll(unExistsAssetFail);
        }
    }

    public ImportResultBean formatAsset(List<String[]> datas) {
        HashMap<String, String[]> temp = new HashMap<String, String[]>();
        ArrayList<String[]> repetitionFail = new ArrayList<String[]>();
        ArrayList<String[]> unExistsAssetFail = new ArrayList<String[]>();
        ArrayList<String[]> unDistinguishKuepFail = new ArrayList<String[]>();
        this.dataFilterFormat(datas, temp, repetitionFail, unExistsAssetFail, unDistinguishKuepFail);
        int failureCount = repetitionFail.size() + unExistsAssetFail.size() + unDistinguishKuepFail.size();
        if (!datas.isEmpty()) {
            this.assetManagerBusiness.saveFormats(datas, temp);
            try {
                EcssMessage ecssMessage = new EcssMessage("assetFormat", temp.keySet());
                ecssMessage.sendMessage();
            }
            catch (Exception e) {
                this.logger.error("\u8d44\u4ea7\u683c\u5f0f\u5316\u65f6\u53d1\u9001SC\u4e3b\u9898\u5f02\u5e38.", (Throwable)e);
                throw new RuntimeException("\u8d44\u4ea7\u683c\u5f0f\u5316\u65f6\u53d1\u9001SC\u4e3b\u9898\u5f02\u5e38.");
            }
        }
        List<AssetImportMsg> failResult = this.createFailureMsg(repetitionFail, "excel\u6570\u636e\u91cd\u590d", 0);
        failResult.addAll(this.createFailureMsg(unExistsAssetFail, "\u6570\u636e\u5e93\u5bf9\u5e94\u7684\u8d44\u4ea7\u4e0d\u5b58\u5728", 0));
        failResult.addAll(this.createFailureMsg(unDistinguishKuepFail, "kuep\u4e1a\u52a1\u6570\u636e\u672a\u521d\u59cb\u5316", 0));
        ImportResultBean resultBean = new ImportResultBean();
        resultBean.setSucessCount(Integer.valueOf(datas.size()));
        resultBean.setFailCount(Integer.valueOf(failureCount));
        resultBean.setFailCardsMsg(failResult);
        resultBean.setDetail((Object[])new Integer[]{repetitionFail.size(), unExistsAssetFail.size(), unDistinguishKuepFail.size()});
        return resultBean;
    }

    public void dataFilterInfoChange(List<String[]> datas, Map<String, String[]> temp, List<String[]> requiredFail, List<String[]> repetitionFail, List<String[]> repetitionDataFail, List<String[]> unExistsAssetFail) {
        HashMap<String, Integer> local = new HashMap<String, Integer>();
        Map<Object, Object> tempExistsAsset = new HashMap();
        ArrayList<String[]> tempDelete = new ArrayList<String[]>();
        HashMap<String, String[]> tempImei = new HashMap<String, String[]>();
        HashMap<String, String[]> tempSn = new HashMap<String, String[]>();
        String[] tempData = null;
        for (String[] item : datas) {
            if (StringUtils.isBlank((CharSequence)item[0]) && StringUtils.isBlank((CharSequence)item[1]) && StringUtils.isBlank((CharSequence)item[2]) && StringUtils.isBlank((CharSequence)item[3]) && StringUtils.isBlank((CharSequence)item[4])) {
                tempDelete.add(item);
            }
            if (!StringUtils.isBlank((CharSequence)item[0]) || !StringUtils.isNotBlank((CharSequence)item[1]) && !StringUtils.isNotBlank((CharSequence)item[2]) && !StringUtils.isNotBlank((CharSequence)item[3]) && !StringUtils.isNotBlank((CharSequence)item[4])) continue;
            requiredFail.add(item);
        }
        datas.removeAll(tempDelete);
        datas.removeAll(requiredFail);
        for (String[] item : datas) {
            if (null == local.get(item[0].toLowerCase())) {
                local.put(item[0].toLowerCase(), 1);
                temp.put(item[0].toLowerCase(), item);
                continue;
            }
            repetitionFail.add(item);
        }
        datas.removeAll(repetitionFail);
        local.clear();
        for (String[] item : datas) {
            if (!StringUtils.isNotBlank((CharSequence)item[3])) continue;
            if (null == local.get(item[3])) {
                local.put(item[3], 1);
                temp.put(item[3], item);
                tempSn.put(item[3], item);
                continue;
            }
            repetitionFail.add(item);
        }
        datas.removeAll(repetitionFail);
        local.clear();
        for (String[] item : datas) {
            if (!StringUtils.isNotBlank((CharSequence)item[2])) continue;
            if (null == local.get(item[2])) {
                local.put(item[2], 1);
                temp.put(item[2], item);
                tempImei.put(item[2], item);
                continue;
            }
            repetitionFail.add(item);
            if (!StringUtils.isNotBlank((CharSequence)item[3])) continue;
            tempSn.remove(item[3]);
        }
        datas.removeAll(repetitionFail);
        if (!datas.isEmpty()) {
            tempExistsAsset = this.assetManagerBusiness.queryAssetByCardNos(new ArrayList<String>(temp.keySet()));
            for (String[] item : datas) {
                if (tempExistsAsset != null && null != tempExistsAsset.get(item[0].toLowerCase())) continue;
                unExistsAssetFail.add(item);
                temp.remove(item[0].toLowerCase());
            }
            datas.removeAll(unExistsAssetFail);
        }
        if (!datas.isEmpty() && !tempSn.isEmpty()) {
            List<String> snList = this.assetManagerBusiness.checkMobileSnExist(new ArrayList<String>(tempSn.keySet()));
            for (String sn : snList) {
                tempData = (String[])tempSn.get(sn);
                repetitionDataFail.add(tempData);
                datas.remove(tempData);
                temp.remove(tempData[0].toLowerCase());
                tempImei.remove(tempData[2]);
            }
            datas.removeAll(unExistsAssetFail);
        }
        if (!datas.isEmpty() && !tempImei.isEmpty()) {
            List<String> imeiList = this.assetManagerBusiness.checkMobileImeiExist(new ArrayList<String>(tempImei.keySet()));
            for (String imei : imeiList) {
                tempData = (String[])tempImei.get(imei);
                repetitionDataFail.add(tempData);
                datas.remove(tempData);
                temp.remove(tempData[0].toLowerCase());
            }
            datas.removeAll(unExistsAssetFail);
        }
    }

    public ImportResultBean infoChange(List<String[]> datas) {
        HashMap<String, String[]> temp = new HashMap<String, String[]>();
        ArrayList<String[]> requiredFail = new ArrayList<String[]>();
        ArrayList<String[]> repetitionFail = new ArrayList<String[]>();
        ArrayList<String[]> repetitionDataFail = new ArrayList<String[]>();
        ArrayList<String[]> unExistsAssetFail = new ArrayList<String[]>();
        HashMap<String, String[]> assetMap = new HashMap<String, String[]>();
        HashMap<String, String> imeiMap = new HashMap<String, String>();
        HashMap<String, String> snMap = new HashMap<String, String>();
        this.dataFilterInfoChange(datas, temp, requiredFail, repetitionFail, repetitionDataFail, unExistsAssetFail);
        int failureCount = requiredFail.size() + repetitionFail.size() + repetitionDataFail.size() + unExistsAssetFail.size();
        if (!datas.isEmpty()) {
            for (String[] item : datas) {
                String cardNo = item[0].toLowerCase();
                if (StringUtils.isNotBlank((CharSequence)item[1]) || StringUtils.isNotBlank((CharSequence)item[4]) || StringUtils.isNotBlank((CharSequence)item[5]) || StringUtils.isNotBlank((CharSequence)item[6]) || StringUtils.isNotBlank((CharSequence)item[7])) {
                    assetMap.put(cardNo, item);
                }
                if (StringUtils.isNotBlank((CharSequence)item[2]) || StringUtils.isNotBlank((CharSequence)item[3])) {
                    imeiMap.put(cardNo, item[2]);
                    snMap.put(cardNo, item[3]);
                }
                HashMap<String, Object> logMap = new HashMap<String, Object>();
                logMap.put("logType", 6);
                logMap.put("AssetId", cardNo);
                AMSLogRecord.logRecord(logMap);
            }
            this.assetManagerBusiness.saveInfoChange(assetMap, imeiMap, snMap);
        }
        List<AssetImportMsg> failResult = this.createFailureMsg(requiredFail, "\u5fc5\u586b\u9879\u4e3a\u7a7a", 0);
        failResult.addAll(this.createFailureMsg(repetitionFail, "excel\u6570\u636e\u91cd\u590d", 0));
        failResult.addAll(this.createFailureMsg(repetitionDataFail, "\u6570\u636e\u5e93\u6570\u636e\u91cd\u590d", 0));
        failResult.addAll(this.createFailureMsg(unExistsAssetFail, "\u6570\u636e\u5e93\u5bf9\u5e94\u7684\u8d44\u4ea7\u4e0d\u5b58\u5728", 0));
        ImportResultBean resultBean = new ImportResultBean();
        resultBean.setSucessCount(Integer.valueOf(datas.size()));
        resultBean.setFailCount(Integer.valueOf(failureCount));
        resultBean.setFailCardsMsg(failResult);
        resultBean.setDetail((Object[])new Integer[]{requiredFail.size(), repetitionFail.size(), repetitionDataFail.size(), unExistsAssetFail.size()});
        return resultBean;
    }

    public String cardChange(String originalCardNo, List<String[]> cards, Map<String, List<CertBean>> certs, List<String[]> unCodes) {
        EcssMessage ecssMessage;
        List<String> relationList;
        ArrayList<String> cardList = new ArrayList<String>();
        ArrayList<String> snList = new ArrayList<String>();
        List<String> algTypeList = this.getAlgType();
        String cardNo = cards.get(0)[0].toLowerCase();
        String certCardNo = null;
        List<CertBean> certList = null;
        ArrayList<String> tempAlgType = null;
        CertBean certBean = null;
        for (String cardno : certs.keySet()) {
            certCardNo = cardno.toLowerCase();
        }
        if (!unCodes.isEmpty() && !cardNo.equals(unCodes.get(0)[0].toLowerCase()) || !cardNo.equals(certCardNo)) {
            return (String)Constants.CARD_CHANGE_ERROR_TYPE.get(Constants.CARDTYPE_CARDNO_DISACCORD);
        }
        if (cardNo.equals(originalCardNo)) {
            return (String)Constants.CARD_CHANGE_ERROR_TYPE.get(Constants.CARDTYPE_CARDNO_SAME);
        }
        certList = certs.get(cardNo);
        if (certList == null || certList != null && certList.size() != 4) {
            return (String)Constants.CARD_CHANGE_ERROR_TYPE.get(Constants.CARDTYPE_CERT_NUMBER);
        }
        tempAlgType = new ArrayList<String>();
        for (int i = 0; i < certList.size(); ++i) {
            certBean = certList.get(i);
            tempAlgType.add(certBean.getCertType() + "" + certBean.getCaAlg());
            snList.add(certBean.getSn());
        }
        if (!tempAlgType.containsAll(algTypeList)) {
            return (String)Constants.CARD_CHANGE_ERROR_TYPE.get(Constants.CARDTYPE_CERT_ALGORITHM);
        }
        cardList.add(cardNo);
        List<String> checkCardNoList = this.assetManagerBusiness.checkAssetExist(cardList);
        if (!checkCardNoList.isEmpty()) {
            return (String)Constants.CARD_CHANGE_ERROR_TYPE.get(Constants.CARDTYPE_CARDNO_EXISTS);
        }
        List<String> checkSnList = this.assetManagerBusiness.checkCertSnExist(snList);
        if (!checkSnList.isEmpty()) {
            return (String)Constants.CARD_CHANGE_ERROR_TYPE.get(Constants.CARDTYPE_CERT_REPETITION);
        }
        if (!(unCodes.isEmpty() || (relationList = this.assetManagerBusiness.queryCardNoByUid(unCodes.get(0)[1])).isEmpty() || relationList.get(0).equals(cardNo))) {
            return (String)Constants.CARD_CHANGE_ERROR_TYPE.get(Constants.CARDTYPE_UNLOCKCODE_REPETITION);
        }
        this.assetManagerBusiness.saveCardChange(originalCardNo, cardNo, cards.get(0), certList, unCodes);
        try {
            ecssMessage = new EcssMessage("assetFormat", Arrays.asList(originalCardNo));
            ecssMessage.sendMessage();
        }
        catch (Exception e) {
            this.logger.error("\u82af\u7247\u53d8\u66f4\u65f6\u53d1\u9001\u6e90\u8bbe\u5907\u683c\u5f0f\u5316\u6d88\u606f\u5f02\u5e38.", (Throwable)e);
            throw new RuntimeException("\u82af\u7247\u53d8\u66f4\u65f6\u53d1\u9001\u6e90\u8bbe\u5907\u683c\u5f0f\u5316\u6d88\u606f\u5f02\u5e38.");
        }
        try {
            ecssMessage = new EcssMessage("assetImport", Arrays.asList(cardNo));
            ecssMessage.sendMessage();
        }
        catch (Exception e) {
            this.logger.error("\u82af\u7247\u53d8\u66f4\u65f6\u53d1\u9001\u65b0\u8d44\u4ea7\u5bfc\u5165\u6d88\u606f\u5f02\u5e38.", (Throwable)e);
            throw new RuntimeException("\u82af\u7247\u53d8\u66f4\u65f6\u53d1\u9001\u65b0\u8d44\u4ea7\u5bfc\u5165\u6d88\u606f\u5f02\u5e38.");
        }
        HashMap<String, Object> logMap = new HashMap<String, Object>();
        logMap.put("logType", 7);
        logMap.put("AssetId", originalCardNo);
        logMap.put("NewAssetId", cardNo);
        AMSLogRecord.logRecord(logMap);
        return "success";
    }

    public List<Map<String, Object>> saveSyncAssets(List<Map<String, Object>> cardList, List<Map<String, Object>> mobileList, List<Map<String, Object>> backupCardList) {
        ArrayList<Map<String, Object>> failureDesc = new ArrayList<Map<String, Object>>();
        HashMap<String, Integer> relationCardNoMap = new HashMap<String, Integer>();
        ArrayList<String> cardNos = new ArrayList<String>();
        HashMap<String, String> relationAndMobileCardMap = new HashMap<String, String>();
        if (cardList.isEmpty() && mobileList.isEmpty() && backupCardList.isEmpty()) {
            return failureDesc;
        }
        if (!cardList.isEmpty()) {
            this.checkCardRepeat(cardList, failureDesc, relationCardNoMap);
        }
        if (!mobileList.isEmpty()) {
            this.checkMobileRepeat(mobileList, failureDesc, relationCardNoMap);
        }
        if (!backupCardList.isEmpty()) {
            this.checkBackupCardRepeat(backupCardList, failureDesc, relationCardNoMap);
        }
        if (cardList.isEmpty() && mobileList.isEmpty() && backupCardList.isEmpty()) {
            return failureDesc;
        }
        this.assetManagerBusiness.saveSyncAsset(cardList, mobileList, backupCardList, cardNos, relationAndMobileCardMap);
        if (!cardNos.isEmpty()) {
            try {
                EcssMessage ecssMessage = new EcssMessage("assetImport", cardNos);
                ecssMessage.sendMessage();
            }
            catch (Exception e) {
                this.logger.error("\u540c\u6b65\u751f\u4ea7\u4e2d\u5fc3\u8d44\u4ea7\u6570\u636e\u65f6\u53d1\u9001\u6d88\u606f\u5f02\u5e38.", (Throwable)e);
                throw new RuntimeException("\u540c\u6b65\u751f\u4ea7\u4e2d\u5fc3\u8d44\u4ea7\u6570\u636e\u65f6\u53d1\u9001\u6d88\u606f\u5f02\u5e38.");
            }
        }
        if (!relationAndMobileCardMap.isEmpty()) {
            ArrayList relationList = new ArrayList();
            HashMap relationMap = null;
            for (String usbkeyCardNo : relationAndMobileCardMap.keySet()) {
                relationMap = new HashMap();
                relationMap.put("phoneCardno", relationAndMobileCardMap.get(usbkeyCardNo));
                relationMap.put("usbCardno", usbkeyCardNo);
                relationList.add(relationMap);
            }
            try {
                EcssMessage ecssMessage = new EcssMessage("relationAssetImport", (Object)JSONUtil.toJSONString(relationList));
                ecssMessage.sendMessage();
            }
            catch (Exception e) {
                this.logger.error("\u5bfc\u5165\u914d\u5bf9\u8d44\u4ea7\u65f6\u53d1\u9001SC\u4e3b\u9898\u5f02\u5e38.", (Throwable)e);
                throw new RuntimeException("\u5bfc\u5165\u914d\u5bf9\u8d44\u4ea7\u65f6\u53d1\u9001SC\u4e3b\u9898\u5f02\u5e38.");
            }
        }
        return failureDesc;
    }

    public List<Map<String, Object>> saveSyncProducts(List<Map<String, Object>> cardList, List<Map<String, Object>> mobileList, List<Map<String, Object>> backupCardList) {
        ArrayList<Map<String, Object>> failureDesc = new ArrayList<Map<String, Object>>();
        HashMap<String, String> correctOrderProjectMap = new HashMap<String, String>();
        HashMap<String, String> correctOrderStateMap = new HashMap<String, String>();
        HashMap<String, String> correctOrderCustomerMap = new HashMap<String, String>();
        HashMap<String, String> orderTypeMap = new HashMap<String, String>();
        HashMap<String, Integer> orderCodeMap = new HashMap<String, Integer>();
        HashMap<String, Integer> correctOrderOriginMap = new HashMap<String, Integer>();
        this.checkSyncProject(cardList, mobileList, backupCardList, failureDesc, correctOrderProjectMap, correctOrderStateMap, correctOrderCustomerMap, orderTypeMap, correctOrderOriginMap);
        if (!(cardList.isEmpty() && mobileList.isEmpty() && backupCardList.isEmpty())) {
            this.checkSaveProducts(cardList, mobileList, backupCardList, failureDesc, correctOrderProjectMap, correctOrderStateMap, correctOrderCustomerMap, orderTypeMap, orderCodeMap, correctOrderOriginMap);
        }
        if (cardList.isEmpty() && mobileList.isEmpty() && backupCardList.isEmpty()) {
            return failureDesc;
        }
        this.assetManagerBusiness.saveSyncProducts(cardList, mobileList, backupCardList, correctOrderProjectMap, correctOrderStateMap, correctOrderCustomerMap, orderTypeMap, orderCodeMap, correctOrderOriginMap);
        return failureDesc;
    }

    private void checkSyncProject(List<Map<String, Object>> cardList, List<Map<String, Object>> mobileList, List<Map<String, Object>> backupCardList, List<Map<String, Object>> failureDesc, Map<String, String> correctOrderProjectMap, Map<String, String> correctOrderStateMap, Map<String, String> correctOrderCustomerMap, Map<String, String> orderTypeMap, Map<String, Integer> correctOrderOriginMap) {
        String orderType;
        String customerName;
        String cardNo;
        String projectName;
        String deviceName;
        Integer type;
        String orderDepartment;
        ArrayList<Map<String, Object>> assetList = new ArrayList<Map<String, Object>>();
        HashMap<String, Integer> errorOrderMap = new HashMap<String, Integer>();
        ArrayList<Map> failure = new ArrayList<Map>();
        assetList.addAll(cardList);
        assetList.addAll(mobileList);
        assetList.addAll(backupCardList);
        for (Map map : assetList) {
            orderDepartment = ((String)map.get("orderOrigin")).toLowerCase();
            if (orderDepartment.equals("\u6218\u7565\u5e02\u573a\u90e8")) continue;
            type = (Integer)map.get("type");
            deviceName = (String)Constants.ASSET_TYPE.get(map.get("type"));
            projectName = (String)map.get("project");
            cardNo = ((String)map.get("cardNo")).toLowerCase();
            customerName = (String)map.get("customer");
            orderType = this.checkOrderByName(projectName);
            if (StringUtils.isBlank((CharSequence)orderType) || projectName.length() <= orderType.length() + (Integer)Constants.CUSTOMER_ORDER_TYPE.get(orderType) + Constants.ORDER_ACTIVE_STATE_LENGTH) {
                failure.add(map);
                failureDesc.add(this.bulidFailureResult(type == 1 || type == 2 ? (String)map.get("imei") : cardNo, type, deviceName + "\u9879\u76ee\u540d\u79f0\u4e2d\u8ba2\u5355\u6807\u8bc6\u6216\u957f\u5ea6\u975e\u6cd5"));
                continue;
            }
            Integer activeIndex = projectName.indexOf("&");
            if (activeIndex < 0 || null == Constants.ACTIVE_TYPE.get(projectName.substring(activeIndex + 1))) {
                failure.add(map);
                failureDesc.add(this.bulidFailureResult(type == 1 || type == 2 ? (String)map.get("imei") : cardNo, type, deviceName + "\u9879\u76ee\u540d\u79f0\u4e2d\u8ba2\u5355\u6fc0\u6d3b\u7c7b\u578b\u975e\u6cd5"));
                continue;
            }
            orderTypeMap.put(cardNo, orderType);
            this.assembleOrderMap(orderType, projectName, customerName, correctOrderProjectMap, correctOrderStateMap, correctOrderCustomerMap, errorOrderMap);
        }
        assetList.removeAll(failure);
        cardList.removeAll(failure);
        mobileList.removeAll(failure);
        backupCardList.removeAll(failure);
        if (!assetList.isEmpty()) {
            Map<String, Integer> orginMap = this.LoadOrderOrigin();
            correctOrderProjectMap.clear();
            correctOrderStateMap.clear();
            correctOrderCustomerMap.clear();
            for (Map map : assetList) {
                orderDepartment = (String)map.get("orderOrigin");
                if (orderDepartment.equals("\u6218\u7565\u5e02\u573a\u90e8")) continue;
                type = (Integer)map.get("type");
                deviceName = (String)Constants.ASSET_TYPE.get(map.get("type"));
                projectName = (String)map.get("project");
                cardNo = ((String)map.get("cardNo")).toLowerCase();
                customerName = (String)map.get("customer");
                String orderOrigin = (String)map.get("orderOrigin");
                orderType = orderTypeMap.get(cardNo);
                String orderName = projectName.trim().substring(orderType.length(), orderType.length() + (Integer)Constants.CUSTOMER_ORDER_TYPE.get(orderType));
                String activeState = projectName.trim().substring(projectName.trim().indexOf("&") + 1);
                projectName = projectName.trim().substring(orderType.length() + (Integer)Constants.CUSTOMER_ORDER_TYPE.get(orderType), projectName.trim().indexOf("&"));
                if (null != errorOrderMap.get(orderName)) {
                    failure.add(map);
                    failureDesc.add(this.bulidFailureResult(type == 1 || type == 2 ? (String)map.get("imei") : cardNo, type, deviceName + "\u9879\u76ee\u540d\u79f0\u4e2d\u8ba2\u5355\u540d\u79f0\u975e\u6cd5"));
                    continue;
                }
                if (null == orginMap.get(orderOrigin)) {
                    failure.add(map);
                    failureDesc.add(this.bulidFailureResult(type == 1 || type == 2 ? (String)map.get("imei") : cardNo, type, deviceName + "\u8ba2\u5355\u6765\u6e90\u975e\u6cd5"));
                    continue;
                }
                correctOrderProjectMap.put(orderName, projectName);
                correctOrderStateMap.put(orderName, activeState);
                correctOrderCustomerMap.put(orderName, customerName);
                correctOrderOriginMap.put(orderName, orginMap.get(orderOrigin));
            }
            assetList.removeAll(failure);
            cardList.removeAll(failure);
            mobileList.removeAll(failure);
            backupCardList.removeAll(failure);
        }
    }

    private Map<String, Integer> LoadOrderOrigin() {
        HashMap<String, Integer> orginMap = new HashMap<String, Integer>();
        List dicList = this.dicBusiness.queryAllTopDicsOrderByparentCode();
        if (dicList != null && dicList.size() > 0) {
            for (int i = 0; i < dicList.size(); ++i) {
                TDic dic = (TDic)dicList.get(i);
                if (!dic.getParentCode().equalsIgnoreCase("orderOrigin")) continue;
                orginMap.put(dic.getName(), Integer.parseInt(dic.getCode()));
            }
        }
        return orginMap;
    }

    private void checkBackupCardRepeat(List<Map<String, Object>> backupCardList, List<Map<String, Object>> failureDesc, Map<String, Integer> relationCardNoMap) {
        String cardSn;
        HashMap<String, Map<String, Object>> tempAssets = new HashMap<String, Map<String, Object>>();
        ArrayList<Map> failure = new ArrayList<Map>();
        for (Map<String, Object> item : backupCardList) {
            cardSn = ((String)item.get("cardSn")).toLowerCase();
            tempAssets.put(cardSn, item);
        }
        List<String> cardSnList = this.assetManagerBusiness.checkBakcardExist(new ArrayList<String>(tempAssets.keySet()));
        if (!cardSnList.isEmpty()) {
            for (String tempCardSn : cardSnList) {
                cardSn = tempCardSn.toLowerCase();
                Map assetInfo = (Map)tempAssets.get(cardSn);
                if (null == assetInfo) continue;
                Integer type = (Integer)assetInfo.get("type");
                failure.add(assetInfo);
                failureDesc.add(this.bulidFailureResult(cardSn, type, "\u5907\u4efd\u5361\u4fe1\u606f\u5df2\u5b58\u5728"));
            }
            backupCardList.removeAll(failure);
        }
    }

    private void checkMobileRepeat(List<Map<String, Object>> mobileList, List<Map<String, Object>> failureDesc, Map<String, Integer> cardNoMap) {
        String relationCardNo;
        String deviceName;
        Map assetInfo;
        String imei;
        Integer type;
        String cardNo;
        HashMap<String, Map<String, Object>> tempAssets = new HashMap<String, Map<String, Object>>();
        HashMap<String, Map<String, Object>> tempRelationCardNos = new HashMap<String, Map<String, Object>>();
        HashMap<String, Map<String, Object>> tempAssetSn = new HashMap<String, Map<String, Object>>();
        HashMap<String, Map<String, Object>> tempImei = new HashMap<String, Map<String, Object>>();
        ArrayList<Map> failure = new ArrayList<Map>();
        for (Map<String, Object> map : mobileList) {
            cardNo = ((String)map.get("cardNo")).toLowerCase();
            type = (Integer)map.get("type");
            imei = (String)map.get("imei");
            tempAssets.put(cardNo, map);
            tempImei.put(imei, map);
            if (StringUtils.isNotBlank((CharSequence)((String)map.get("sn")))) {
                tempAssetSn.put((String)map.get("sn"), map);
            }
            if (!StringUtils.isNotBlank((CharSequence)((String)map.get("relationCardNo")))) continue;
            tempRelationCardNos.put(((String)map.get("relationCardNo")).toLowerCase(), map);
        }
        List<String> unChipList = this.assetManagerBusiness.checkAssetUnChipExist(new ArrayList<String>(tempAssets.keySet()));
        for (String identify : unChipList) {
            assetInfo = (Map)tempAssets.get(identify);
            if (null == assetInfo) continue;
            cardNo = ((String)assetInfo.get("cardNo")).toLowerCase();
            type = (Integer)assetInfo.get("type");
            deviceName = (String)Constants.ASSET_TYPE.get(type);
            imei = (String)assetInfo.get("imei");
            tempAssets.remove(cardNo);
            tempImei.remove(imei);
            tempAssetSn.remove((String)assetInfo.get("sn"));
            if (StringUtils.isNotBlank((CharSequence)((String)assetInfo.get("relationCardNo")))) {
                tempRelationCardNos.remove(((String)assetInfo.get("relationCardNo")).toLowerCase());
            }
            failure.add(assetInfo);
            failureDesc.add(this.bulidFailureResult(imei, type, deviceName + "\u5bf9\u5e94\u7684\u8d44\u4ea7\u4fe1\u606f\u5df2\u5b58\u5728"));
        }
        mobileList.removeAll(failure);
        if (!mobileList.isEmpty()) {
            failure.clear();
            Map<String, Integer> map = this.assetManagerBusiness.queryAssetChip(new ArrayList<String>(tempAssets.keySet()));
            for (Map<String, Object> map2 : mobileList) {
                cardNo = ((String)map2.get("cardNo")).toLowerCase();
                imei = (String)map2.get("imei");
                if (map != null && null != map.get(cardNo)) continue;
                type = (Integer)map2.get("type");
                deviceName = (String)Constants.ASSET_TYPE.get(type);
                tempAssets.remove(cardNo);
                tempImei.remove(imei);
                tempAssetSn.remove((String)map2.get("sn"));
                if (StringUtils.isNotBlank((CharSequence)((String)map2.get("relationCardNo")))) {
                    tempRelationCardNos.remove(((String)map2.get("relationCardNo")).toLowerCase());
                }
                failure.add(map2);
                failureDesc.add(this.bulidFailureResult(imei, type, deviceName + "\u5bf9\u5e94\u7684\u82af\u7247\u7c7b\u578b\u8d44\u4ea7\u4e0d\u5b58\u5728"));
            }
            mobileList.removeAll(failure);
        }
        if (!mobileList.isEmpty() && !tempRelationCardNos.keySet().isEmpty()) {
            failure.clear();
            Map<String, String> map = this.assetManagerBusiness.checkAssetTypeExist(new ArrayList<String>(tempRelationCardNos.keySet()));
            for (Map map3 : mobileList) {
                cardNo = ((String)map3.get("cardNo")).toLowerCase();
                relationCardNo = ((String)map3.get("relationCardNo")).toLowerCase();
                if (StringUtils.isNotBlank((CharSequence)relationCardNo) && (map == null || map.get(relationCardNo) == null)) {
                    if (cardNoMap.containsKey(relationCardNo) && (cardNoMap.get(relationCardNo) == 4 || cardNoMap.get(relationCardNo) == 5)) break;
                    type = (Integer)map3.get("type");
                    deviceName = (String)Constants.ASSET_TYPE.get(type);
                    imei = (String)map3.get("imei");
                    tempRelationCardNos.remove(relationCardNo);
                    tempImei.remove(imei);
                    tempAssetSn.remove((String)map3.get("sn"));
                    failure.add(map3);
                    failureDesc.add(this.bulidFailureResult(imei, type, deviceName + "\u5173\u8054\u8d44\u4ea7\u5bf9\u5e94\u7684\u8d44\u4ea7\u4e0d\u5b58\u5728"));
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)relationCardNo) || map == null || map.get(relationCardNo) == null || Integer.valueOf(map.get(relationCardNo)) == 4 || Integer.valueOf(map.get(relationCardNo)) == 5) continue;
                type = (Integer)map3.get("type");
                deviceName = (String)Constants.ASSET_TYPE.get(type);
                imei = (String)map3.get("imei");
                tempRelationCardNos.remove(relationCardNo);
                tempImei.remove(imei);
                tempAssetSn.remove((String)map3.get("sn"));
                failure.add(map3);
                failureDesc.add(this.bulidFailureResult(imei, type, deviceName + "\u5173\u8054\u8d44\u4ea7\u5bf9\u5e94\u7684\u8d44\u4ea7\u7c7b\u578b\u975e\u6cd5"));
            }
            mobileList.removeAll(failure);
        }
        if (!mobileList.isEmpty() && !tempRelationCardNos.keySet().isEmpty()) {
            failure.clear();
            List<String> list = this.assetManagerBusiness.checkRelationCardNoExist(new ArrayList<String>(tempRelationCardNos.keySet()));
            for (Map map : mobileList) {
                cardNo = ((String)map.get("cardNo")).toLowerCase();
                relationCardNo = ((String)map.get("relationCardNo")).toLowerCase();
                if (!StringUtils.isNotBlank((CharSequence)relationCardNo) || list != null && list.contains(relationCardNo)) continue;
                if (cardNoMap.containsKey(relationCardNo) && (cardNoMap.get(relationCardNo) == 4 || cardNoMap.get(relationCardNo) == 5)) break;
                type = (Integer)map.get("type");
                deviceName = (String)Constants.ASSET_TYPE.get(type);
                imei = (String)map.get("imei");
                tempImei.remove(imei);
                tempAssetSn.remove((String)map.get("sn"));
                failure.add(map);
                failureDesc.add(this.bulidFailureResult(imei, type, deviceName + "\u5173\u8054\u8d44\u4ea7\u5bf9\u5e94\u7684\u5173\u8054\u8d44\u4ea7\u4e0d\u4e3a\u7a7a"));
            }
            mobileList.removeAll(failure);
        }
        if (!mobileList.isEmpty()) {
            failure.clear();
            List<String> list = this.assetManagerBusiness.checkMobileImeiExist(new ArrayList<String>(tempImei.keySet()));
            for (String string : list) {
                assetInfo = (Map)tempImei.get(string);
                if (null == assetInfo) continue;
                cardNo = (String)assetInfo.get("cardNo");
                type = (Integer)assetInfo.get("type");
                deviceName = (String)Constants.ASSET_TYPE.get(type);
                imei = (String)assetInfo.get("imei");
                tempAssetSn.remove((String)assetInfo.get("sn"));
                failure.add(assetInfo);
                failureDesc.add(this.bulidFailureResult(imei, type, deviceName + "\u8bbe\u5907IMEI\u5df2\u5b58\u5728"));
            }
            mobileList.removeAll(failure);
        }
        if (!mobileList.isEmpty()) {
            failure.clear();
            List<String> list = this.assetManagerBusiness.checkMobileSnExist(new ArrayList<String>(tempAssetSn.keySet()));
            for (String string : list) {
                assetInfo = (Map)tempAssetSn.get(string);
                if (null == assetInfo) continue;
                cardNo = (String)assetInfo.get("cardNo");
                type = (Integer)assetInfo.get("type");
                deviceName = (String)Constants.ASSET_TYPE.get(type);
                imei = (String)assetInfo.get("imei");
                failure.add(assetInfo);
                failureDesc.add(this.bulidFailureResult(imei, type, deviceName + "\u8bbe\u5907SN\u5df2\u5b58\u5728"));
            }
            mobileList.removeAll(failure);
        }
    }

    private void checkCardRepeat(List<Map<String, Object>> cardList, List<Map<String, Object>> failureDesc, Map<String, Integer> relationCardNoMap) {
        String deviceName;
        Integer type;
        String cardNo;
        HashMap<String, Map<String, Object>> tempAssets = new HashMap<String, Map<String, Object>>();
        HashMap<String, Integer> local = new HashMap<String, Integer>();
        HashMap<String, Integer> certMap = new HashMap<String, Integer>();
        HashMap<String, List<String>> certDatas = new HashMap<String, List<String>>();
        ArrayList<Map<String, Object>> failure = new ArrayList<Map<String, Object>>();
        List<String> certList = null;
        for (Map<String, Object> map : cardList) {
            cardNo = ((String)map.get("cardNo")).toLowerCase();
            tempAssets.put(cardNo, map);
        }
        List<String> cardNoList = this.assetManagerBusiness.checkAssetExist(new ArrayList<String>(tempAssets.keySet()));
        if (!cardNoList.isEmpty()) {
            for (String string : cardNoList) {
                cardNo = string.toLowerCase();
                Map assetInfo = (Map)tempAssets.get(cardNo);
                if (null == assetInfo) continue;
                type = (Integer)assetInfo.get("type");
                deviceName = (String)Constants.ASSET_TYPE.get(type);
                failure.add(assetInfo);
                failureDesc.add(this.bulidFailureResult(cardNo, type, deviceName + "\u8d44\u4ea7\u4fe1\u606f\u5df2\u5b58\u5728"));
            }
            cardList.removeAll(failure);
        }
        if (!cardList.isEmpty()) {
            failure.clear();
            Object var16_15 = null;
            for (Map<String, Object> map : cardList) {
                certList = new ArrayList();
                cardNo = ((String)map.get("cardNo")).toLowerCase();
                type = (Integer)map.get("type");
                deviceName = (String)Constants.ASSET_TYPE.get(type);
                X509Certificate x509Certificate = CertUtil.getCertFromStr((String)((String)map.get("rsaSignCert")));
                if (null == x509Certificate) {
                    failure.add(map);
                    failureDesc.add(this.bulidFailureResult(cardNo, type, deviceName + "RSA\u7b7e\u540d\u8bc1\u4e66\u89e3\u6790\u5931\u8d25"));
                    continue;
                }
                String certSn = CertUtil.getSn((X509Certificate)x509Certificate);
                if (null != local.get(certSn)) {
                    failure.add(map);
                    failureDesc.add(this.bulidFailureResult(cardNo, type, deviceName + "RSA\u7b7e\u540d\u8bc1\u4e66\u4e0e\u672c\u5730\u8bc1\u4e66\u91cd\u590d"));
                    continue;
                }
                local.put(certSn, 1);
                certList.add(certSn);
                X509Certificate x509Certificate2 = CertUtil.getCertFromStr((String)((String)map.get("rsaEncCert")));
                if (null == x509Certificate2) {
                    failure.add(map);
                    failureDesc.add(this.bulidFailureResult(cardNo, type, deviceName + "RSA\u52a0\u5bc6\u8bc1\u4e66\u89e3\u6790\u5931\u8d25"));
                    continue;
                }
                certSn = CertUtil.getSn((X509Certificate)x509Certificate2);
                if (null != local.get(certSn)) {
                    failure.add(map);
                    failureDesc.add(this.bulidFailureResult(cardNo, type, deviceName + "RSA\u52a0\u5bc6\u8bc1\u4e66\u4e0e\u672c\u5730\u8bc1\u4e66\u91cd\u590d"));
                    continue;
                }
                local.put(certSn, 1);
                certList.add(certSn);
                X509Certificate x509Certificate3 = CertUtil.getCertFromStr((String)((String)map.get("sm2SignCert")));
                if (null == x509Certificate3) {
                    failure.add(map);
                    failureDesc.add(this.bulidFailureResult(cardNo, type, deviceName + "SM2\u7b7e\u540d\u8bc1\u4e66\u89e3\u6790\u5931\u8d25"));
                    continue;
                }
                certSn = CertUtil.getSn((X509Certificate)x509Certificate3);
                if (null != local.get(certSn)) {
                    failure.add(map);
                    failureDesc.add(this.bulidFailureResult(cardNo, type, deviceName + "SM2\u7b7e\u540d\u8bc1\u4e66\u4e0e\u672c\u5730\u8bc1\u4e66\u91cd\u590d"));
                    continue;
                }
                local.put(certSn, 1);
                certList.add(certSn);
                X509Certificate x509Certificate4 = CertUtil.getCertFromStr((String)((String)map.get("sm2EncCert")));
                if (null == x509Certificate4) {
                    failure.add(map);
                    failureDesc.add(this.bulidFailureResult(cardNo, type, deviceName + "SM2\u52a0\u5bc6\u8bc1\u4e66\u89e3\u6790\u5931\u8d25"));
                    continue;
                }
                certSn = CertUtil.getSn((X509Certificate)x509Certificate4);
                if (null != local.get(certSn)) {
                    failure.add(map);
                    failureDesc.add(this.bulidFailureResult(cardNo, type, deviceName + "SM2\u52a0\u5bc6\u8bc1\u4e66\u4e0e\u672c\u5730\u8bc1\u4e66\u91cd\u590d"));
                    continue;
                }
                local.put(certSn, 1);
                certList.add(certSn);
                certDatas.put(cardNo, certList);
            }
            cardList.removeAll(failure);
        }
        if (!cardList.isEmpty() && !local.isEmpty()) {
            failure.clear();
            List<String> list = this.assetManagerBusiness.checkCertSnExist(new ArrayList<String>(local.keySet()));
            if (!list.isEmpty()) {
                for (String string : list) {
                    certMap.put(string, 1);
                }
                block4: for (Map<String, Object> map : cardList) {
                    cardNo = ((String)map.get("cardNo")).toLowerCase();
                    type = (Integer)map.get("type");
                    deviceName = (String)Constants.ASSET_TYPE.get(type);
                    certList = (List)certDatas.get(cardNo);
                    for (String tempSn : certList) {
                        if (null == certMap.get(tempSn)) continue;
                        failure.add(map);
                        failureDesc.add(this.bulidFailureResult(cardNo, type, deviceName + "\u6570\u636e\u5e93\u8bc1\u4e66\u91cd\u590d"));
                        continue block4;
                    }
                }
                cardList.removeAll(failure);
            }
        }
        if (!cardList.isEmpty()) {
            for (Map<String, Object> map : cardList) {
                certList = new ArrayList();
                cardNo = ((String)map.get("cardNo")).toLowerCase();
                type = (Integer)map.get("type");
                relationCardNoMap.put(cardNo, type);
            }
        }
    }

    public List<Map<String, Object>> updateSyncAssets(List<Map<String, Object>> cardList, List<Map<String, Object>> mobileList) {
        ArrayList<Map<String, Object>> failureDesc = new ArrayList<Map<String, Object>>();
        HashMap<String, String> cardNoScMap = new HashMap<String, String>();
        HashMap<String, String> relationAndMobileCardMap = new HashMap<String, String>();
        if (!cardList.isEmpty()) {
            this.checkUpdateCardRepeat(cardList, failureDesc, cardNoScMap);
        }
        if (!mobileList.isEmpty()) {
            this.checkUpdateMobileRepeat(mobileList, failureDesc);
        }
        if (cardList.isEmpty() && mobileList.isEmpty()) {
            return failureDesc;
        }
        this.assetManagerBusiness.updateSyncAsset(cardList, mobileList, cardNoScMap, relationAndMobileCardMap);
        if (!cardNoScMap.isEmpty()) {
            try {
                EcssMessage ecssMessage = new EcssMessage("certChange", cardNoScMap.keySet());
                ecssMessage.sendMessage();
            }
            catch (Exception e) {
                this.logger.error("\u81ea\u52a8\u540c\u6b65\u7a0b\u5e8f\u66f4\u65b0\u8d44\u4ea7\u65f6\u53d1\u9001\u8bc1\u4e66\u53d8\u66f4\u6d88\u606f\u5931\u8d25", (Throwable)e);
                throw new RuntimeException("\u81ea\u52a8\u540c\u6b65\u7a0b\u5e8f\u66f4\u65b0\u8d44\u4ea7\u65f6\u53d1\u9001\u8bc1\u4e66\u53d8\u66f4\u6d88\u606f\u5931\u8d25");
            }
        }
        return failureDesc;
    }

    private void checkUpdateMobileRepeat(List<Map<String, Object>> mobileList, List<Map<String, Object>> failureDesc) {
        Map assetInfo;
        String deviceName;
        String imei;
        Integer type;
        String cardNo;
        HashMap<String, Map<String, Object>> tempAssets = new HashMap<String, Map<String, Object>>();
        HashMap<String, Map<String, Object>> tempAssetSn = new HashMap<String, Map<String, Object>>();
        HashMap<String, Map<String, Object>> tempImei = new HashMap<String, Map<String, Object>>();
        HashMap<String, Map<String, Object>> tempRelationCardNos = new HashMap<String, Map<String, Object>>();
        ArrayList<Map> failure = new ArrayList<Map>();
        for (Map<String, Object> map : mobileList) {
            cardNo = ((String)map.get("cardNo")).toLowerCase();
            type = (Integer)map.get("type");
            imei = (String)map.get("imei");
            tempAssets.put(cardNo, map);
            tempImei.put(imei, map);
            if (StringUtils.isNotBlank((CharSequence)((String)map.get("sn")))) {
                tempAssetSn.put((String)map.get("sn"), map);
            }
            if (!StringUtils.isNotBlank((CharSequence)((String)map.get("relationCardNo")))) continue;
            tempRelationCardNos.put(((String)map.get("relationCardNo")).toLowerCase(), map);
        }
        Map<String, String> cardNoList = this.assetManagerBusiness.checkAssetTypeExist(new ArrayList<String>(tempAssets.keySet()));
        for (Map<String, Object> map : mobileList) {
            cardNo = ((String)map.get("cardNo")).toLowerCase();
            imei = (String)map.get("imei");
            type = (Integer)map.get("type");
            deviceName = (String)Constants.ASSET_TYPE.get(type);
            if (cardNoList == null || null == cardNoList.get(cardNo)) {
                tempImei.remove(imei);
                tempAssetSn.remove((String)map.get("sn"));
                if (StringUtils.isNotBlank((CharSequence)((String)map.get("relationCardNo")))) {
                    tempRelationCardNos.remove(((String)map.get("relationCardNo")).toLowerCase());
                }
                failure.add(map);
                failureDesc.add(this.bulidFailureResult(imei, type, deviceName + "\u5bf9\u5e94\u7684\u8d44\u4ea7\u4e0d\u5b58\u5728"));
                continue;
            }
            Integer n = Integer.valueOf(cardNoList.get(cardNo));
            if (type == n) continue;
            tempImei.remove(imei);
            tempAssetSn.remove((String)map.get("sn"));
            if (StringUtils.isNotBlank((CharSequence)((String)map.get("relationCardNo")))) {
                tempRelationCardNos.remove(((String)map.get("relationCardNo")).toLowerCase());
            }
            failure.add(map);
            failureDesc.add(this.bulidFailureResult(imei, type, deviceName + "\u8d44\u4ea7\u7c7b\u578b\u4e0e\u6570\u636e\u5e93\u4e2d\u7684\u8d44\u4ea7\u7c7b\u578b\u4e0d\u4e00\u81f4"));
        }
        mobileList.removeAll(failure);
        if (!mobileList.isEmpty() && !tempRelationCardNos.keySet().isEmpty()) {
            failure.clear();
            Map<String, String> map = this.assetManagerBusiness.checkAssetTypeExist(new ArrayList<String>(tempRelationCardNos.keySet()));
            for (Map<String, Object> map2 : mobileList) {
                cardNo = ((String)map2.get("cardNo")).toLowerCase();
                String relationCardNo = ((String)map2.get("relationCardNo")).toLowerCase();
                type = (Integer)map2.get("type");
                deviceName = (String)Constants.ASSET_TYPE.get(type);
                imei = (String)map2.get("imei");
                if (StringUtils.isNotBlank((CharSequence)relationCardNo) && (map == null || map.get(relationCardNo) == null)) {
                    tempImei.remove(imei);
                    tempAssetSn.remove((String)map2.get("sn"));
                    failure.add(map2);
                    failureDesc.add(this.bulidFailureResult(imei, type, deviceName + "\u5173\u8054\u8d44\u4ea7\u5bf9\u5e94\u7684\u8d44\u4ea7\u4e0d\u5b58\u5728"));
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)relationCardNo) || map == null || map.get(relationCardNo) == null || Integer.valueOf(map.get(relationCardNo)) == 4 || Integer.valueOf(map.get(relationCardNo)) == 5) continue;
                tempImei.remove(imei);
                tempAssetSn.remove((String)map2.get("sn"));
                failure.add(map2);
                failureDesc.add(this.bulidFailureResult(imei, type, deviceName + "\u5173\u8054\u8d44\u4ea7\u5bf9\u5e94\u7684\u8d44\u4ea7\u7c7b\u578b\u975e\u6cd5"));
            }
            mobileList.removeAll(failure);
        }
        if (!mobileList.isEmpty()) {
            failure.clear();
            Map<String, String> map = this.assetManagerBusiness.checkMobileImeiCardNoExist(new ArrayList<String>(tempImei.keySet()));
            for (String string : map.keySet()) {
                assetInfo = (Map)tempImei.get(string);
                if (null == assetInfo || map.get(string).equalsIgnoreCase((String)assetInfo.get("cardNo"))) continue;
                cardNo = (String)assetInfo.get("cardNo");
                type = (Integer)assetInfo.get("type");
                deviceName = (String)Constants.ASSET_TYPE.get(type);
                imei = (String)assetInfo.get("imei");
                tempAssetSn.remove((String)assetInfo.get("sn"));
                failure.add(assetInfo);
                failureDesc.add(this.bulidFailureResult(imei, type, deviceName + "\u8bbe\u5907IMEI\u5df2\u5b58\u5728"));
            }
            mobileList.removeAll(failure);
        }
        if (!mobileList.isEmpty()) {
            failure.clear();
            Map<String, String> map = this.assetManagerBusiness.checkMobileSnCardNoExist(new ArrayList<String>(tempAssetSn.keySet()));
            for (String string : map.keySet()) {
                assetInfo = (Map)tempAssetSn.get(string);
                if (null == assetInfo || map.get(string).equalsIgnoreCase((String)assetInfo.get("cardNo"))) continue;
                cardNo = (String)assetInfo.get("cardNo");
                type = (Integer)assetInfo.get("type");
                deviceName = (String)Constants.ASSET_TYPE.get(type);
                imei = (String)assetInfo.get("imei");
                failure.add(assetInfo);
                failureDesc.add(this.bulidFailureResult(imei, type, deviceName + "\u8bbe\u5907SN\u5df2\u5b58\u5728"));
            }
            mobileList.removeAll(failure);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void checkUpdateCardRepeat(List<Map<String, Object>> cardList, List<Map<String, Object>> failureDesc, Map<String, String> cardNoScMap) {
        List<String> certList;
        String deviceName;
        Integer type;
        String cardNo;
        HashMap<String, Map<String, Object>> tempAssets = new HashMap<String, Map<String, Object>>();
        HashMap<String, Integer> local = new HashMap<String, Integer>();
        HashMap<String, List<String>> certDatas = new HashMap<String, List<String>>();
        ArrayList<Map<String, Object>> failure = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> map : cardList) {
            cardNo = ((String)map.get("cardNo")).toLowerCase();
            tempAssets.put(cardNo, map);
        }
        List<String> cardNoList = this.assetManagerBusiness.checkAssetExist(new ArrayList<String>(tempAssets.keySet()));
        for (Map<String, Object> map : cardList) {
            cardNo = ((String)map.get("cardNo")).toLowerCase();
            if (cardNoList != null && cardNoList.contains(cardNo)) continue;
            type = (Integer)map.get("type");
            deviceName = (String)Constants.ASSET_TYPE.get(type);
            tempAssets.remove(cardNo);
            failure.add(map);
            failureDesc.add(this.bulidFailureResult(cardNo, type, deviceName + "\u5bf9\u5e94\u7684\u8d44\u4ea7\u4e0d\u5b58\u5728"));
        }
        cardList.removeAll(failure);
        if (!cardList.isEmpty()) {
            failure.clear();
            Object var14_12 = null;
            for (Map<String, Object> item : cardList) {
                certList = new ArrayList();
                cardNo = ((String)item.get("cardNo")).toLowerCase();
                type = (Integer)item.get("type");
                deviceName = (String)Constants.ASSET_TYPE.get(type);
                X509Certificate x509Certificate = CertUtil.getCertFromStr((String)((String)item.get("rsaSignCert")));
                if (null == x509Certificate) {
                    failure.add(item);
                    failureDesc.add(this.bulidFailureResult(cardNo, type, deviceName + "RSA\u7b7e\u540d\u8bc1\u4e66\u89e3\u6790\u5931\u8d25"));
                    continue;
                }
                String certSn = CertUtil.getSn((X509Certificate)x509Certificate);
                if (null != local.get(certSn)) {
                    failure.add(item);
                    failureDesc.add(this.bulidFailureResult(cardNo, type, deviceName + "RSA\u7b7e\u540d\u8bc1\u4e66\u4e0e\u672c\u5730\u8bc1\u4e66\u91cd\u590d"));
                    continue;
                }
                local.put(certSn, 1);
                certList.add(certSn);
                X509Certificate x509Certificate2 = CertUtil.getCertFromStr((String)((String)item.get("rsaEncCert")));
                if (null == x509Certificate2) {
                    failure.add(item);
                    failureDesc.add(this.bulidFailureResult(cardNo, type, deviceName + "RSA\u52a0\u5bc6\u8bc1\u4e66\u89e3\u6790\u5931\u8d25"));
                    continue;
                }
                certSn = CertUtil.getSn((X509Certificate)x509Certificate2);
                if (null != local.get(certSn)) {
                    failure.add(item);
                    failureDesc.add(this.bulidFailureResult(cardNo, type, deviceName + "RSA\u52a0\u5bc6\u8bc1\u4e66\u4e0e\u672c\u5730\u8bc1\u4e66\u91cd\u590d"));
                    continue;
                }
                local.put(certSn, 1);
                certList.add(certSn);
                X509Certificate x509Certificate3 = CertUtil.getCertFromStr((String)((String)item.get("sm2SignCert")));
                if (null == x509Certificate3) {
                    failure.add(item);
                    failureDesc.add(this.bulidFailureResult(cardNo, type, deviceName + "SM2\u7b7e\u540d\u8bc1\u4e66\u89e3\u6790\u5931\u8d25"));
                    continue;
                }
                certSn = CertUtil.getSn((X509Certificate)x509Certificate3);
                if (null != local.get(certSn)) {
                    failure.add(item);
                    failureDesc.add(this.bulidFailureResult(cardNo, type, deviceName + "SM2\u7b7e\u540d\u8bc1\u4e66\u4e0e\u672c\u5730\u8bc1\u4e66\u91cd\u590d"));
                    continue;
                }
                local.put(certSn, 1);
                certList.add(certSn);
                X509Certificate x509Certificate4 = CertUtil.getCertFromStr((String)((String)item.get("sm2EncCert")));
                if (null == x509Certificate4) {
                    failure.add(item);
                    failureDesc.add(this.bulidFailureResult(cardNo, type, deviceName + "SM2\u52a0\u5bc6\u8bc1\u4e66\u89e3\u6790\u5931\u8d25"));
                    continue;
                }
                certSn = CertUtil.getSn((X509Certificate)x509Certificate4);
                if (null != local.get(certSn)) {
                    failure.add(item);
                    failureDesc.add(this.bulidFailureResult(cardNo, type, deviceName + "SM2\u52a0\u5bc6\u8bc1\u4e66\u4e0e\u672c\u5730\u8bc1\u4e66\u91cd\u590d"));
                    continue;
                }
                local.put(certSn, 1);
                certList.add(certSn);
                certDatas.put(cardNo, certList);
            }
            cardList.removeAll(failure);
        }
        if (!cardList.isEmpty() && !local.isEmpty()) {
            failure.clear();
            Map<String, String> map = this.assetManagerBusiness.queryCertSn(new ArrayList<String>(local.keySet()));
            if (map == null || map.isEmpty()) {
                HashMap hashMap = new HashMap();
            }
            block3: for (Map<String, Object> item : cardList) {
                cardNo = ((String)item.get("cardNo")).toLowerCase();
                type = (Integer)item.get("type");
                deviceName = (String)Constants.ASSET_TYPE.get(type);
                certList = (List)certDatas.get(cardNo);
                for (String tempSn : certList) {
                    void var14_21;
                    if (null != var14_21.get(tempSn)) {
                        if (cardNo.equalsIgnoreCase((String)var14_21.get(tempSn))) continue;
                        failure.add(item);
                        failureDesc.add(this.bulidFailureResult(cardNo, type, deviceName + "\u6570\u636e\u5e93\u8bc1\u4e66\u91cd\u590d"));
                        continue block3;
                    }
                    cardNoScMap.put(cardNo, "1");
                    continue block3;
                }
            }
            cardList.removeAll(failure);
        }
    }

    private void checkSaveProducts(List<Map<String, Object>> cardList, List<Map<String, Object>> mobileList, List<Map<String, Object>> backupCardList, List<Map<String, Object>> failureDesc, Map<String, String> correctOrderProjectMap, Map<String, String> correctOrderStateMap, Map<String, String> correctOrderCustomerMap, Map<String, String> orderTypeMap, Map<String, Integer> orderCodeMap, Map<String, Integer> correctOrderOriginMap) {
        String deviceName;
        Integer type;
        String cardNo;
        ArrayList<Map<String, Object>> assetList = new ArrayList<Map<String, Object>>();
        assetList.addAll(cardList);
        assetList.addAll(mobileList);
        HashMap<String, Map> tempAssets = new HashMap<String, Map>();
        ArrayList<Map> failure = new ArrayList<Map>();
        if (!assetList.isEmpty()) {
            for (Map map : assetList) {
                cardNo = ((String)map.get("cardNo")).toLowerCase();
                tempAssets.put(cardNo, map);
            }
            List<String> cardNoList = this.assetManagerBusiness.checkAssetExist(new ArrayList<String>(tempAssets.keySet()));
            for (Map<String, Object> item : assetList) {
                cardNo = ((String)item.get("cardNo")).toLowerCase();
                type = (Integer)item.get("type");
                deviceName = (String)Constants.ASSET_TYPE.get(type);
                if (cardNoList != null && cardNoList.contains(cardNo)) continue;
                tempAssets.remove(cardNo);
                failure.add(item);
                failureDesc.add(this.bulidFailureResult(type == 1 || type == 2 ? (String)item.get("imei") : cardNo, type, deviceName + "\u5bf9\u5e94\u7684\u8d44\u4ea7\u4e0d\u5b58\u5728"));
            }
            assetList.removeAll(failure);
            cardList.removeAll(failure);
            mobileList.removeAll(failure);
        }
        if (!assetList.isEmpty()) {
            Map<String, String> assetTypeMap = this.assetManagerBusiness.checkAssetTypeExist(new ArrayList<String>(tempAssets.keySet()));
            for (Map<String, Object> item : assetList) {
                cardNo = ((String)item.get("cardNo")).toLowerCase();
                type = (Integer)item.get("type");
                deviceName = (String)Constants.ASSET_TYPE.get(type);
                if (assetTypeMap != null && String.valueOf(type).equals(assetTypeMap.get(cardNo))) continue;
                tempAssets.remove(cardNo);
                failure.add(item);
                failureDesc.add(this.bulidFailureResult(type == 1 || type == 2 ? (String)item.get("imei") : cardNo, type, deviceName + "\u4e0e\u6570\u636e\u5e93\u4e2d\u7684\u8d44\u4ea7\u7c7b\u578b\u4e0d\u4e00\u81f4"));
            }
            assetList.removeAll(failure);
            cardList.removeAll(failure);
            mobileList.removeAll(failure);
        }
        if (!backupCardList.isEmpty()) {
            tempAssets = new HashMap();
            for (Map map : backupCardList) {
                cardNo = ((String)map.get("cardNo")).toLowerCase();
                tempAssets.put(cardNo, map);
            }
            List<String> bCardList = this.assetManagerBusiness.checkBakcardExist(new ArrayList<String>(tempAssets.keySet()));
            for (Map<String, Object> item : backupCardList) {
                cardNo = ((String)item.get("cardNo")).toLowerCase();
                type = (Integer)item.get("type");
                deviceName = (String)Constants.ASSET_TYPE.get(type);
                if (bCardList != null && bCardList.contains(cardNo)) continue;
                failure.add(item);
                failureDesc.add(this.bulidFailureResult(cardNo, type, deviceName + "\u5bf9\u5e94\u7684\u4fe1\u606f\u4e0d\u5b58\u5728"));
            }
            backupCardList.removeAll(failure);
            assetList.addAll(backupCardList);
        }
        HashMap<String, String> orderProjectMap = new HashMap<String, String>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> orderCustomerMap = new HashMap<String, String>();
        if (!assetList.isEmpty()) {
            String orderDepartment;
            failure.clear();
            if (!correctOrderProjectMap.isEmpty()) {
                this.assetManagerBusiness.queryOrderProject(new ArrayList<String>(correctOrderProjectMap.keySet()), orderProjectMap, hashMap);
                this.assetManagerBusiness.queryOrderCustomer(new ArrayList<String>(correctOrderProjectMap.keySet()), orderCustomerMap);
            }
            Map orderMapU8 = new HashMap();
            for (Map map : assetList) {
                orderDepartment = (String)map.get("orderOrigin");
                if (!orderDepartment.equals("\u6218\u7565\u5e02\u573a\u90e8")) continue;
                orderMapU8 = this.u8AmsInfoService.queryufOrdersDb();
                break;
            }
            for (Map map : assetList) {
                orderDepartment = (String)map.get("orderOrigin");
                type = (Integer)map.get("type");
                String projectName = (String)map.get("project");
                deviceName = (String)Constants.ASSET_TYPE.get(map.get("type"));
                cardNo = ((String)map.get("cardNo")).toLowerCase();
                if (orderDepartment.equals("\u6218\u7565\u5e02\u573a\u90e8")) {
                    String orderCode = ((String)map.get("orderCode")).toUpperCase();
                    if (!orderMapU8.containsKey(orderCode)) {
                        failure.add(map);
                        failureDesc.add(this.bulidFailureResult(type == 1 || type == 2 ? (String)map.get("imei") : cardNo, type, deviceName + "u8\u4e2d\u4e0d\u5b58\u5728\u5bf9\u5e94\u8ba2\u5355"));
                        continue;
                    }
                    if (orderCodeMap.containsKey(orderCode)) continue;
                    orderCodeMap.put(orderCode, 1);
                    continue;
                }
                String orderType = orderTypeMap.get(cardNo.toLowerCase());
                String orderName = projectName.trim().substring(orderType.length(), orderType.length() + (Integer)Constants.CUSTOMER_ORDER_TYPE.get(orderType));
                projectName = projectName.trim().substring(orderType.length() + (Integer)Constants.CUSTOMER_ORDER_TYPE.get(orderType), projectName.trim().indexOf("&"));
                if (orderProjectMap != null && null != orderProjectMap.get(orderName) && !((String)orderProjectMap.get(orderName)).equalsIgnoreCase(correctOrderProjectMap.get(orderName))) {
                    failure.add(map);
                    failureDesc.add(this.bulidFailureResult(type == 1 || type == 2 ? (String)map.get("imei") : cardNo, type, deviceName + "\u6570\u636e\u5e93\u8ba2\u5355\u540d\u79f0-\u9879\u76ee\u540d\u79f0\u5173\u7cfb\u4e0d\u4e00\u81f4"));
                    correctOrderCustomerMap.remove(orderName);
                    correctOrderProjectMap.remove(orderName);
                    correctOrderStateMap.remove(orderName);
                    correctOrderOriginMap.remove(orderName);
                    continue;
                }
                if (hashMap != null && null != hashMap.get(orderName) && !((String)hashMap.get(orderName)).equalsIgnoreCase(correctOrderStateMap.get(orderName))) {
                    failure.add(map);
                    failureDesc.add(this.bulidFailureResult(type == 1 || type == 2 ? (String)map.get("imei") : cardNo, type, deviceName + "\u6570\u636e\u5e93\u8ba2\u5355\u540d\u79f0-\u8ba2\u5355\u6fc0\u6d3b\u7c7b\u578b\u5173\u7cfb\u4e0d\u4e00\u81f4"));
                    correctOrderProjectMap.remove(orderName);
                    correctOrderStateMap.remove(orderName);
                    correctOrderCustomerMap.remove(orderName);
                    correctOrderOriginMap.remove(orderName);
                    continue;
                }
                if (orderCustomerMap == null || null == orderCustomerMap.get(orderName) || ((String)orderCustomerMap.get(orderName)).equalsIgnoreCase(correctOrderCustomerMap.get(orderName))) continue;
                failure.add(map);
                failureDesc.add(this.bulidFailureResult(type == 1 || type == 2 ? (String)map.get("imei") : cardNo, type, deviceName + "\u6570\u636e\u5e93\u8ba2\u5355\u540d\u79f0-\u5ba2\u6237\u540d\u79f0\u4e0d\u4e00\u81f4"));
                correctOrderProjectMap.remove(orderName);
                correctOrderStateMap.remove(orderName);
                correctOrderCustomerMap.remove(orderName);
                correctOrderOriginMap.remove(orderName);
            }
            assetList.removeAll(failure);
            cardList.removeAll(failure);
            mobileList.removeAll(failure);
            backupCardList.removeAll(failure);
        }
    }

    public ImportResultBean formatBakcard(List<String[]> datas) {
        HashMap<String, String[]> temp = new HashMap<String, String[]>();
        ArrayList<String[]> repetitionFail = new ArrayList<String[]>();
        ArrayList<String[]> unExistsAssetFail = new ArrayList<String[]>();
        ArrayList<String[]> unDistinguishKuepFail = new ArrayList<String[]>();
        ArrayList<String[]> isUseBackcardFail = new ArrayList<String[]>();
        this.dataFilterBakcardFormat(datas, temp, repetitionFail, unExistsAssetFail, unDistinguishKuepFail, isUseBackcardFail);
        int failureCount = repetitionFail.size() + unExistsAssetFail.size() + unDistinguishKuepFail.size() + isUseBackcardFail.size();
        if (!datas.isEmpty()) {
            this.assetManagerBusiness.saveBakcardFormats(datas, temp);
        }
        List<AssetImportMsg> failResult = this.createFailureMsg(repetitionFail, "excel\u6570\u636e\u91cd\u590d", 0);
        failResult.addAll(this.createFailureMsg(unExistsAssetFail, "\u6570\u636e\u5e93\u5bf9\u5e94\u7684\u5907\u4efd\u5361\u4e0d\u5b58\u5728", 0));
        failResult.addAll(this.createFailureMsg(unDistinguishKuepFail, "kuep\u4e1a\u52a1\u6570\u636e\u672a\u521d\u59cb\u5316", 0));
        failResult.addAll(this.createFailureMsg(isUseBackcardFail, "\u5907\u4efd\u5361\u5df2\u88ab\u4f7f\u7528\uff0c\u72b6\u6001\u4e0d\u4e3a\u672a\u5907\u4efd", 0));
        ImportResultBean resultBean = new ImportResultBean();
        resultBean.setSucessCount(Integer.valueOf(datas.size()));
        resultBean.setFailCount(Integer.valueOf(failureCount));
        resultBean.setFailCardsMsg(failResult);
        resultBean.setDetail((Object[])new Integer[]{repetitionFail.size(), unExistsAssetFail.size(), unDistinguishKuepFail.size(), isUseBackcardFail.size()});
        return resultBean;
    }

    private void dataFilterBakcardFormat(List<String[]> datas, Map<String, String[]> temp, List<String[]> repetitionFail, List<String[]> unExistsAssetFail, List<String[]> unDistinguishKuepFail, List<String[]> isUseBackcardFail) {
        HashMap<String, Integer> local = new HashMap<String, Integer>();
        Map<Object, Object> tempExistsAsset = new HashMap();
        Map<Object, Object> tempUseBakcard = new HashMap();
        ArrayList<String[]> tempDelete = new ArrayList<String[]>();
        for (String[] item : datas) {
            if (!StringUtils.isBlank((CharSequence)item[0])) continue;
            tempDelete.add(item);
        }
        datas.removeAll(tempDelete);
        for (String[] item : datas) {
            if (null == local.get(item[0].toLowerCase())) {
                local.put(item[0].toLowerCase(), 1);
                temp.put(item[0].toLowerCase(), item);
                continue;
            }
            repetitionFail.add(item);
        }
        datas.removeAll(repetitionFail);
        if (!datas.isEmpty()) {
            tempExistsAsset = this.assetManagerBusiness.queryBakcardByCardNo(new ArrayList<String>(temp.keySet()));
            for (String[] item : datas) {
                if (tempExistsAsset != null && null != tempExistsAsset.get(item[0].toLowerCase())) continue;
                unExistsAssetFail.add(item);
                temp.remove(item[0].toLowerCase());
            }
            datas.removeAll(unExistsAssetFail);
        }
        if (!datas.isEmpty()) {
            tempUseBakcard = this.assetManagerBusiness.queryBakcardUseByCardNo(new ArrayList<String>(temp.keySet()));
            for (String[] item : datas) {
                if (tempUseBakcard == null || null == tempUseBakcard.get(item[0].toLowerCase())) continue;
                isUseBackcardFail.add(item);
                temp.remove(item[0].toLowerCase());
            }
            datas.removeAll(isUseBackcardFail);
        }
    }

    public void updateBackupCardStatus(List<BackupCardScBean> backupCardList) {
        this.assetManagerBusiness.updateBackupCardStatus(backupCardList);
    }

    public List<Map<String, Object>> checkOutProducts(List<Map<String, Object>> cardList, List<Map<String, Object>> mobileList, List<Map<String, Object>> backupCardList) {
        return this.assetManagerBusiness.checkOutProducts(cardList, mobileList, backupCardList);
    }

    public int updateAssetCerts(String cardNo, String rsaSignCert, String rsaEncCert, String sm2SignCert, String sm2EncCert, Integer type) {
        return this.assetManagerBusiness.updateAssetCerts(cardNo, rsaSignCert, rsaEncCert, sm2SignCert, sm2EncCert, type);
    }

    public int checkAssetAuthority(String mangeCardId, String localCardId) {
        return this.assetManagerBusiness.checkAssetAuthority(mangeCardId, localCardId);
    }
}

