/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.cardactivate.dao;

import com.xdja.cssp.ams.cardactivate.bean.ChipBeanCondition;
import com.xdja.cssp.ams.cardactivate.bean.ChipQueryBean;
import com.xdja.cssp.ams.cardactivate.bean.CustomerActivateBean;
import com.xdja.cssp.ams.cardactivate.bean.CustomerActivateStatusBean;
import com.xdja.platform.datacenter.jpa.dao.BaseJpaDao;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ActivateReportDao
extends BaseJpaDao {
    public Map<String, Object> queryCostomerActivate(Long customerId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT ").append(" c.n_id customerId, ").append(" c.c_name customerName, ").append(" COUNT(*) AS chipCount, ").append(" ai.n_status AS assetStatus, ").append(" al.n_activate_status activateStatus ").append(" FROM t_asset_info ai ").append(" LEFT JOIN t_customer c ON c.n_id = ai.n_customer_id ").append(" LEFT JOIN t_activate_log al ON ai.c_card_no = al.c_card_no ");
        MapSqlParameterSource params = new MapSqlParameterSource();
        if (null != customerId) {
            sql.append(" WHERE c.n_id = :customerId ");
            params.addValue("customerId", (Object)customerId);
        }
        sql.append(" GROUP BY c.n_id, ai.n_status, al.n_activate_status ");
        List customerActivates = this.queryForList(sql.toString(), (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(CustomerActivateStatusBean.class));
        for (int i = 0; i < customerActivates.size(); ++i) {
            CustomerActivateStatusBean customerActivateStatusBean = (CustomerActivateStatusBean)customerActivates.get(i);
            if (customerActivateStatusBean.getCustomerId() != null) continue;
            customerActivateStatusBean.setCustomerId(Long.valueOf(100000000000L));
            customerActivateStatusBean.setCustomerName("\u5e73\u53f0\u6d4b\u8bd5\u5ba2\u6237");
        }
        HashMap<String, CustomerActivateBean> customerActivateMap = new HashMap<String, CustomerActivateBean>();
        if (CollectionUtils.isNotEmpty((Collection)customerActivates)) {
            for (CustomerActivateStatusBean cas : customerActivates) {
                CustomerActivateBean customerActivate = (CustomerActivateBean)customerActivateMap.get(String.valueOf(cas.getCustomerId()));
                if (null == customerActivate) {
                    customerActivate = new CustomerActivateBean(cas.getCustomerId(), cas.getCustomerName());
                }
                if (ChipBeanCondition.ENUM_ACTIVATE_STATUS.active.value.equals(cas.getAssetStatus())) {
                    customerActivate.setActivateCount(customerActivate.getActivateCount() + cas.getChipCount());
                } else if (ChipBeanCondition.ENUM_CHIP_STATUS.activateParam.value == cas.getActivateStatus()) {
                    customerActivate.setActivateParamCount(customerActivate.getActivateParamCount() + cas.getChipCount());
                } else {
                    customerActivate.setUnActivateCount(customerActivate.getUnActivateCount() + cas.getChipCount());
                }
                customerActivateMap.put(String.valueOf(cas.getCustomerId()), customerActivate);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.putAll(customerActivateMap);
        return result;
    }

    public List<Map<String, Object>> queryMonthChipsActivate(Long customerId, Integer year, Long projectId, Long orderId) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ").append("COUNT(log.c_card_no) count, ").append(" FROM_unixtime(log.n_time/1000, '%Y-%m') time ").append(" from t_activate_log log ").append(" LEFT JOIN t_asset_info ai on log.c_card_no = ai.c_card_no ");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("activateStatus", (Object)ChipBeanCondition.ENUM_CHIP_STATUS.activate.value);
        params.addValue("status", (Object)ChipBeanCondition.ENUM_ACTIVATE_STATUS.active.value);
        sql.append(" LEFT JOIN t_order_asset oa ON oa.n_asset_id = ai.n_id ").append(" LEFT JOIN t_order o ON o.n_id = oa.n_order_id ");
        sql.append(" WHERE log.n_activate_status = :activateStatus AND ai.n_status = :status ");
        if (null != customerId) {
            sql.append(" AND ai.n_customer_id = :customerId ");
            params.addValue("customerId", (Object)customerId);
        }
        if (null != projectId) {
            sql.append(" AND o.n_project_id = :projectId ");
            params.addValue("projectId", (Object)projectId);
        }
        if (null != orderId) {
            sql.append(" AND o.n_id = :orderId ");
            params.addValue("orderId", (Object)orderId);
        }
        sql.append(" GROUP BY time HAVING time like :year ");
        params.addValue("year", (Object)(year + "%"));
        return this.queryForList(sql.toString(), (SqlParameterSource)params);
    }

    public List<Map<String, Object>> queryMonthChipsFree(Long customerId, Integer year, Long projectId, Long orderId) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ").append("COUNT(asset.c_asset_identify) count,").append(" FROM_unixtime(asset.n_time/1000, '%Y-%m') time").append(" FROM t_asset_info asset ");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("status", (Object)ChipBeanCondition.ENUM_ACTIVATE_STATUS.active.value);
        sql.append(" LEFT JOIN t_order_asset oa ON oa.n_asset_id = asset.n_id ").append(" LEFT JOIN t_order o ON o.n_id = oa.n_order_id ");
        sql.append(" WHERE asset.n_status = :status AND NOT EXISTS (SELECT log.n_id FROM t_activate_log log WHERE log.c_card_no = asset.c_asset_identify) ");
        if (null != customerId) {
            sql.append(" AND asset.n_customer_id = :customerId ");
            params.addValue("customerId", (Object)customerId);
        }
        if (null != projectId) {
            sql.append(" AND o.n_project_id = :projectId ");
            params.addValue("projectId", (Object)projectId);
        }
        if (null != orderId) {
            sql.append(" AND o.n_id = :orderId ");
            params.addValue("orderId", (Object)orderId);
        }
        sql.append(" GROUP BY time HAVING time like :year ");
        params.addValue("year", (Object)(year + "%"));
        return this.queryForList(sql.toString(), (SqlParameterSource)params);
    }

    public List<Map<String, Object>> queryYearChipsActivate(Long customerId, Long projectId, Long orderId) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ").append("COUNT(log.c_card_no) count, ").append(" FROM_unixtime(log.n_time/1000, '%Y') time ").append(" from t_activate_log log ").append(" LEFT JOIN t_asset_info ai on log.c_card_no = ai.c_card_no ");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("activateStatus", (Object)ChipBeanCondition.ENUM_CHIP_STATUS.activate.value);
        params.addValue("status", (Object)ChipBeanCondition.ENUM_ACTIVATE_STATUS.active.value);
        if (null != projectId) {
            sql.append(" LEFT JOIN t_order_asset oa ON oa.n_asset_id = ai.n_id ").append(" LEFT JOIN t_order o ON o.n_id = oa.n_order_id ");
        }
        sql.append(" WHERE log.n_activate_status = :activateStatus AND ai.n_status = :status");
        if (null != customerId) {
            sql.append(" AND ai.n_customer_id = :customerId ");
            params.addValue("customerId", (Object)customerId);
        }
        if (null != projectId) {
            sql.append(" AND o.n_project_id = :projectId ");
            params.addValue("projectId", (Object)projectId);
        }
        if (null != orderId) {
            sql.append(" AND o.n_id = :orderId ");
            params.addValue("orderId", (Object)orderId);
        }
        sql.append(" GROUP BY time ");
        return this.queryForList(sql.toString(), (SqlParameterSource)params);
    }

    public List<Map<String, Object>> queryYearChipsFree(Long customerId, Long projectId, Long orderId) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT COUNT(asset.c_asset_identify) count,").append(" FROM_unixtime(asset.n_time / 1000, '%Y') time").append(" FROM t_asset_info asset ");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("status", (Object)ChipBeanCondition.ENUM_ACTIVATE_STATUS.active.value);
        if (null != projectId) {
            sql.append(" LEFT JOIN t_order_asset oa ON oa.n_asset_id = asset.n_id ").append(" LEFT JOIN t_order o ON o.n_id = oa.n_order_id ");
        }
        sql.append(" WHERE asset.n_status = :status AND NOT EXISTS (SELECT log.n_id FROM t_activate_log log WHERE log.c_card_no = asset.c_asset_identify)");
        if (null != customerId) {
            sql.append(" AND asset.n_customer_id = :customerId ");
            params.addValue("customerId", (Object)customerId);
        }
        if (null != projectId) {
            sql.append(" AND o.n_project_id = :projectId ");
            params.addValue("projectId", (Object)projectId);
        }
        if (null != orderId) {
            sql.append(" AND o.n_id = :orderId ");
            params.addValue("orderId", (Object)orderId);
        }
        sql.append(" AND asset.n_customer_id IS NOT NULL ");
        sql.append(" GROUP BY time ");
        return this.queryForList(sql.toString(), (SqlParameterSource)params);
    }

    public Map<String, Object> queryProjectActivate(Long customerId, Long projectId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT ").append(" tpr.n_id projectId,").append(" tpr.c_name projectName,").append(" COUNT(*) AS chipCount,").append(" ai.n_status AS assetStatus,").append(" al.n_activate_status activateStatus").append(" FROM t_order_asset oa").append(" JOIN t_order tor ON tor.n_id = oa.n_order_id").append(" JOIN t_project tpr ON tpr.n_id = tor.n_project_id").append(" JOIN t_asset_info ai ON oa.n_asset_id = ai.n_id").append(" JOIN t_customer c ON c.n_id = ai.n_customer_id").append(" LEFT JOIN t_activate_log al ON ai.c_card_no = al.c_card_no").append(" WHERE ai.n_customer_id = :customerId");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("customerId", (Object)customerId);
        if (null != projectId) {
            sql.append(" AND tpr.n_id = :projectId");
            params.addValue("projectId", (Object)projectId);
        }
        sql.append(" GROUP BY tpr.n_id, ai.n_status, al.n_activate_status");
        List customerActivates = this.queryForList(sql.toString(), (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(CustomerActivateStatusBean.class));
        HashMap<String, CustomerActivateBean> customerActivateMap = new HashMap<String, CustomerActivateBean>();
        if (CollectionUtils.isNotEmpty((Collection)customerActivates)) {
            for (CustomerActivateStatusBean cas : customerActivates) {
                CustomerActivateBean customerActivate = (CustomerActivateBean)customerActivateMap.get(String.valueOf(cas.getProjectId()));
                if (null == customerActivate) {
                    customerActivate = new CustomerActivateBean(cas.getProjectId(), cas.getProjectName());
                }
                if (ChipBeanCondition.ENUM_ACTIVATE_STATUS.active.value.equals(cas.getAssetStatus())) {
                    customerActivate.setActivateCount(customerActivate.getActivateCount() + cas.getChipCount());
                } else if (ChipBeanCondition.ENUM_CHIP_STATUS.activateParam.value == cas.getActivateStatus()) {
                    customerActivate.setActivateParamCount(customerActivate.getActivateParamCount() + cas.getChipCount());
                } else {
                    customerActivate.setUnActivateCount(customerActivate.getUnActivateCount() + cas.getChipCount());
                }
                customerActivateMap.put(String.valueOf(cas.getProjectId()), customerActivate);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.putAll(customerActivateMap);
        return result;
    }

    public Map<String, Object> queryOrderActivate(Long customerId, Long projectId, Long orderId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT ").append(" tor.n_id orderId,").append(" tor.c_name orderName,").append(" COUNT(*) AS chipCount,").append(" ai.n_status AS assetStatus,").append(" al.n_activate_status activateStatus").append(" FROM t_order_asset oa").append(" JOIN t_order tor ON tor.n_id = oa.n_order_id").append(" JOIN t_project tpr ON tpr.n_id = tor.n_project_id").append(" JOIN t_asset_info ai ON oa.n_asset_id = ai.n_id").append(" JOIN t_customer c ON c.n_id = ai.n_customer_id").append(" LEFT JOIN t_activate_log al ON ai.c_card_no = al.c_card_no").append(" WHERE 1=1 ");
        MapSqlParameterSource params = new MapSqlParameterSource();
        if (null != customerId) {
            sql.append(" AND ai.n_customer_id = :customerId ");
            params.addValue("customerId", (Object)customerId);
        }
        if (null != projectId) {
            sql.append(" AND tpr.n_id = :projectId");
            params.addValue("projectId", (Object)projectId);
        }
        if (null != orderId) {
            sql.append(" AND tor.n_id = :orderId");
            params.addValue("orderId", (Object)orderId);
        }
        sql.append(" GROUP BY tor.n_id, ai.n_status, al.n_activate_status");
        List customerActivates = this.queryForList(sql.toString(), (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(CustomerActivateStatusBean.class));
        HashMap<String, CustomerActivateBean> customerActivateMap = new HashMap<String, CustomerActivateBean>();
        if (CollectionUtils.isNotEmpty((Collection)customerActivates)) {
            for (CustomerActivateStatusBean cas : customerActivates) {
                CustomerActivateBean customerActivate = (CustomerActivateBean)customerActivateMap.get(String.valueOf(cas.getOrderId()));
                if (null == customerActivate) {
                    customerActivate = new CustomerActivateBean(cas.getOrderId(), cas.getOrderName());
                }
                if (ChipBeanCondition.ENUM_ACTIVATE_STATUS.active.value.equals(cas.getAssetStatus())) {
                    customerActivate.setActivateCount(customerActivate.getActivateCount() + cas.getChipCount());
                } else if (ChipBeanCondition.ENUM_CHIP_STATUS.activateParam.value == cas.getActivateStatus()) {
                    customerActivate.setActivateParamCount(customerActivate.getActivateParamCount() + cas.getChipCount());
                } else {
                    customerActivate.setUnActivateCount(customerActivate.getUnActivateCount() + cas.getChipCount());
                }
                customerActivateMap.put(String.valueOf(cas.getOrderId()), customerActivate);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.putAll(customerActivateMap);
        return result;
    }

    public Long statisticChipsCount(ChipQueryBean chipquerybean) {
        StringBuffer sqlBuffer = new StringBuffer();
        MapSqlParameterSource params = new MapSqlParameterSource();
        sqlBuffer.append(" SELECT COUNT(*)").append(" FROM t_asset_info ai ").append(" LEFT JOIN t_activate_log log ON log.c_card_no = ai.c_card_no ").append(" LEFT JOIN t_order_asset oa ON ai.n_id = oa.n_asset_id ").append(" LEFT JOIN t_order o ON o.n_id = oa.n_order_id ").append(" LEFT JOIN t_project p ON p.n_id = o.n_project_id ").append(" LEFT JOIN t_customer c ON c.n_id = ai.n_customer_id ").append(" WHERE 1=1 ");
        if (chipquerybean.getActivateStatus().iterator().next() == ChipBeanCondition.ENUM_CHIP_STATUS.activate) {
            sqlBuffer.append(" AND ((ai.n_status = :assetStatus AND log.n_activate_status = :activateStatus ");
            if (chipquerybean.getStartTime() != null) {
                sqlBuffer.append(" AND log.n_time >= :startTime ");
                params.addValue("startTime", (Object)chipquerybean.getStartTime());
            }
            if (chipquerybean.getEndTime() != null) {
                sqlBuffer.append(" AND log.n_time <= :endTime ");
                params.addValue("endTime", (Object)chipquerybean.getEndTime());
            }
            sqlBuffer.append(") ");
            sqlBuffer.append(" OR (ai.n_status = :assetStatus AND NOT EXISTS (SELECT log.n_id FROM t_activate_log log WHERE log.c_card_no = ai.c_asset_identify) ");
            if (chipquerybean.getStartTime() != null) {
                sqlBuffer.append(" AND ai.n_time >= :startTime ");
                params.addValue("startTime", (Object)chipquerybean.getStartTime());
            }
            if (chipquerybean.getEndTime() != null) {
                sqlBuffer.append(" AND ai.n_time <= :endTime ");
                params.addValue("endTime", (Object)chipquerybean.getEndTime());
            }
            sqlBuffer.append(") )");
            params.addValue("assetStatus", (Object)1);
            params.addValue("activateStatus", (Object)2);
        }
        if (chipquerybean.getActivateStatus().iterator().next() == ChipBeanCondition.ENUM_CHIP_STATUS.unActivate) {
            sqlBuffer.append(" AND ai.n_status = :assetStatus AND NOT EXISTS (SELECT log.n_id FROM t_activate_log log WHERE log.c_card_no = ai.c_asset_identify) ");
            params.addValue("assetStatus", (Object)2);
            if (chipquerybean.getStartTime() != null) {
                sqlBuffer.append(" AND ai.n_time >= :startTime ");
                params.addValue("startTime", (Object)chipquerybean.getStartTime());
            }
            if (chipquerybean.getEndTime() != null) {
                sqlBuffer.append(" AND ai.n_time <= :endTime ");
                params.addValue("endTime", (Object)chipquerybean.getEndTime());
            }
        }
        if (chipquerybean.getActivateStatus().iterator().next() == ChipBeanCondition.ENUM_CHIP_STATUS.activateParam) {
            sqlBuffer.append(" AND log.n_activate_status = :activateStatus AND ai.n_status = :assetStatus ");
            params.addValue("activateStatus", (Object)1);
            params.addValue("assetStatus", (Object)2);
            if (chipquerybean.getStartTime() != null) {
                sqlBuffer.append(" AND log.n_time >= :startTime ");
                params.addValue("startTime", (Object)chipquerybean.getStartTime());
            }
            if (chipquerybean.getEndTime() != null) {
                sqlBuffer.append(" AND log.n_time <= :endTime ");
                params.addValue("endTime", (Object)chipquerybean.getEndTime());
            }
        }
        if (null != chipquerybean.getCustomerId()) {
            sqlBuffer.append(" AND ai.n_customer_id = :customerId ");
            params.addValue("customerId", (Object)chipquerybean.getCustomerId());
        }
        if (null != chipquerybean.getProjectId()) {
            sqlBuffer.append(" AND p.n_id = :projectId ");
            params.addValue("projectId", (Object)chipquerybean.getProjectId());
        }
        if (null != chipquerybean.getOrderId()) {
            sqlBuffer.append(" AND o.n_id = :orderId ");
            params.addValue("orderId", (Object)chipquerybean.getOrderId());
        }
        if (StringUtils.isNotBlank((CharSequence)chipquerybean.getOrderName())) {
            sqlBuffer.append(" AND o.c_name = :orderName ");
            params.addValue("orderName", (Object)chipquerybean.getOrderName());
        }
        if (StringUtils.isNotBlank((CharSequence)chipquerybean.getProjectName())) {
            sqlBuffer.append(" AND p.c_name = :projectName ");
            params.addValue("projectName", (Object)chipquerybean.getProjectName());
        }
        if (StringUtils.isNotBlank((CharSequence)chipquerybean.getCustomerName())) {
            sqlBuffer.append(" AND c.c_name = :customerName ");
            params.addValue("customerName", (Object)chipquerybean.getCustomerName());
        }
        return this.queryForLong(sqlBuffer.toString(), (SqlParameterSource)params);
    }

    public List<ChipBeanCondition> statisticChipsInfo(ChipQueryBean chipquerybean, int index, int length) {
        StringBuffer sqlBuffer = new StringBuffer();
        MapSqlParameterSource params = new MapSqlParameterSource();
        sqlBuffer.append(" SELECT ").append(" ai.c_card_no chipCode, ").append(" ai.c_asset_type type, ").append(" log.n_activate_status activateStatus, ").append(" log.n_time activateTime, ").append(" o.n_id orderId, ").append(" o.c_name orderName, ").append(" o.n_time orderTime, ").append(" ai.n_status assetStatus, ").append(" ai.n_time assetTime ").append(" FROM t_asset_info ai ").append(" LEFT JOIN t_activate_log log ON log.c_card_no = ai.c_card_no ").append(" LEFT JOIN t_order_asset oa ON ai.n_id = oa.n_asset_id ").append(" LEFT JOIN t_order o ON o.n_id = oa.n_order_id ").append(" LEFT JOIN t_project p ON p.n_id = o.n_project_id ").append(" LEFT JOIN t_customer c ON c.n_id = ai.n_customer_id ").append(" WHERE 1=1 ");
        if (chipquerybean.getActivateStatus().iterator().next() == ChipBeanCondition.ENUM_CHIP_STATUS.activate) {
            sqlBuffer.append(" AND ((ai.n_status = :assetStatus AND log.n_activate_status = :activateStatus ");
            if (chipquerybean.getStartTime() != null) {
                sqlBuffer.append(" AND log.n_time >= :startTime ");
                params.addValue("startTime", (Object)chipquerybean.getStartTime());
            }
            if (chipquerybean.getEndTime() != null) {
                sqlBuffer.append(" AND log.n_time <= :endTime ");
                params.addValue("endTime", (Object)chipquerybean.getEndTime());
            }
            sqlBuffer.append(") ");
            sqlBuffer.append(" OR (ai.n_status = :assetStatus AND NOT EXISTS (SELECT log.n_id FROM t_activate_log log WHERE log.c_card_no = ai.c_asset_identify) ");
            if (chipquerybean.getStartTime() != null) {
                sqlBuffer.append(" AND ai.n_time >= :startTime ");
                params.addValue("startTime", (Object)chipquerybean.getStartTime());
            }
            if (chipquerybean.getEndTime() != null) {
                sqlBuffer.append(" AND ai.n_time <= :endTime ");
                params.addValue("endTime", (Object)chipquerybean.getEndTime());
            }
            sqlBuffer.append(") )");
            params.addValue("assetStatus", (Object)1);
            params.addValue("activateStatus", (Object)2);
        }
        if (chipquerybean.getActivateStatus().iterator().next() == ChipBeanCondition.ENUM_CHIP_STATUS.unActivate) {
            sqlBuffer.append(" AND ai.n_status = :assetStatus AND NOT EXISTS (SELECT log.n_id FROM t_activate_log log WHERE log.c_card_no = ai.c_asset_identify) ");
            params.addValue("assetStatus", (Object)2);
            if (chipquerybean.getStartTime() != null) {
                sqlBuffer.append(" AND ai.n_time >= :startTime ");
                params.addValue("startTime", (Object)chipquerybean.getStartTime());
            }
            if (chipquerybean.getEndTime() != null) {
                sqlBuffer.append(" AND ai.n_time <= :endTime ");
                params.addValue("endTime", (Object)chipquerybean.getEndTime());
            }
        }
        if (chipquerybean.getActivateStatus().iterator().next() == ChipBeanCondition.ENUM_CHIP_STATUS.activateParam) {
            sqlBuffer.append(" AND log.n_activate_status = :activateStatus AND ai.n_status = :assetStatus ");
            params.addValue("activateStatus", (Object)1);
            params.addValue("assetStatus", (Object)2);
        }
        if (null != chipquerybean.getCustomerId()) {
            sqlBuffer.append(" AND ai.n_customer_id = :customerId ");
            params.addValue("customerId", (Object)chipquerybean.getCustomerId());
        }
        if (null != chipquerybean.getProjectId()) {
            sqlBuffer.append(" AND p.n_id = :projectId ");
            params.addValue("projectId", (Object)chipquerybean.getProjectId());
        }
        if (null != chipquerybean.getOrderId()) {
            sqlBuffer.append(" AND o.n_id = :orderId ");
            params.addValue("orderId", (Object)chipquerybean.getOrderId());
        }
        if (StringUtils.isNotBlank((CharSequence)chipquerybean.getOrderName())) {
            sqlBuffer.append(" AND o.c_name = :orderName ");
            params.addValue("orderName", (Object)chipquerybean.getOrderName());
        }
        if (StringUtils.isNotBlank((CharSequence)chipquerybean.getProjectName())) {
            sqlBuffer.append(" AND p.c_name = :projectName ");
            params.addValue("projectName", (Object)chipquerybean.getProjectName());
        }
        if (StringUtils.isNotBlank((CharSequence)chipquerybean.getCustomerName())) {
            sqlBuffer.append(" AND c.c_name = :customerName ");
            params.addValue("customerName", (Object)chipquerybean.getCustomerName());
        }
        sqlBuffer.append("ORDER BY ai.n_id DESC LIMIT :index,:length ");
        params.addValue("index", (Object)index);
        params.addValue("length", (Object)length);
        return this.queryForList(sqlBuffer.toString(), (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(ChipBeanCondition.class));
    }
}

