/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.customer.dao;

import com.xdja.cssp.ams.customer.entity.Customer;
import com.xdja.platform.datacenter.jpa.dao.BaseJpaDao;
import com.xdja.platform.datacenter.jpa.page.Pagination;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CustomerDao
extends BaseJpaDao<Customer, Long> {
    public Pagination<Customer> queryCustomers(Customer condition, Integer pageNo, Integer pageSize, String sortName, String sortType) {
        StringBuilder sqlBuilder = new StringBuilder("SELECT n_id AS id, c_name AS name, c_code AS code, n_reg_time AS regTime, ").append("c_role AS role, c_model AS model FROM t_customer WHERE 1=1 ");
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        String name = condition.getName();
        String code = condition.getCode();
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            sqlBuilder.append("AND c_name LIKE :name ESCAPE '/' ");
            name = name.replaceAll("%", "/%");
            name = name.replaceAll("_", "/_");
            sqlParameterSource.addValue("name", (Object)("%" + name + "%"));
        }
        if (StringUtils.isNotEmpty((CharSequence)code)) {
            sqlBuilder.append("AND c_code LIKE :code ESCAPE '/' ");
            name = name.replaceAll("%", "/%");
            name = name.replaceAll("_", "/_");
            sqlParameterSource.addValue("code", (Object)("%" + code + "%"));
        }
        if (StringUtils.isNotEmpty((CharSequence)sortName) && StringUtils.isNotEmpty((CharSequence)sortType)) {
            sqlBuilder.append("ORDER BY " + sortName + " " + sortType);
        } else {
            sqlBuilder.append("ORDER BY regTime DESC ");
        }
        return this.queryForPage(sqlBuilder.toString(), pageSize, pageNo, sqlParameterSource, (RowMapper)BeanPropertyRowMapper.newInstance(Customer.class));
    }

    public List<Customer> queryAllCustomer() {
        String sql = "SELECT n_id id, c_name name FROM t_customer";
        return this.queryForList(sql, (SqlParameterSource)new MapSqlParameterSource(), (RowMapper)BeanPropertyRowMapper.newInstance(Customer.class));
    }
}

