/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.system.dao;

import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import com.xdja.cssp.ams.system.entity.Function;
import com.xdja.cssp.ams.system.entity.TUser;
import com.xdja.platform.datacenter.jpa.dao.BaseJpaDao;
import java.io.Serializable;
import java.util.List;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class FunctionDao
extends BaseJpaDao<Function, Serializable> {
    public List<Function> queryAdminFunctions() {
        Search search = new Search(Function.class);
        search.addFilterEqual("status", (Object)Function.ENUM_FUNCTION_STATUS.normalStatus.value);
        search.addSortAsc("parentId");
        search.addSortAsc("orderNum");
        return this.search((ISearch)search);
    }

    public List<Function> queryAllFunctions() {
        StringBuilder sqlBuilder = new StringBuilder("SELECT n_id AS id, c_name AS name,n_parent_id AS parentId ").append("FROM t_function WHERE n_type = :type AND n_status = :status");
        MapSqlParameterSource sqlParam = new MapSqlParameterSource();
        sqlParam.addValue("type", (Object)Function.ENUM_FUNCTION_TYPE.consumerFunction.value);
        sqlParam.addValue("status", (Object)Function.ENUM_FUNCTION_STATUS.normalStatus.value);
        return this.queryForList(sqlBuilder.toString(), (SqlParameterSource)sqlParam, (RowMapper)BeanPropertyRowMapper.newInstance(Function.class));
    }

    public List<Function> queryUserFunctions(TUser user) {
        StringBuilder sqlBuilder = new StringBuilder("SELECT DISTINCT function.n_id AS id, function.c_name AS name, function.n_parent_id AS parentId, ").append("function.c_obj_name AS objName, function.c_icon AS icon, function.c_link AS link, function.n_order_num AS orderNum ").append("FROM t_user user ").append("INNER JOIN t_user_role userRole ON user.n_id = userRole.n_user_id ").append("INNER JOIN t_role_function roleFunc ON userRole.n_role_id = roleFunc.n_role_id ").append("INNER JOIN t_function function ON function.n_id = roleFunc.n_function_id ").append("WHERE user.n_id = :uId ").append("AND function.n_status = :status ").append(" ORDER BY n_parent_id, n_order_num ");
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        sqlParameterSource.addValue("uId", (Object)user.getId());
        sqlParameterSource.addValue("status", (Object)TUser.ENUM_USER_STATUS.normalStatus.value);
        return this.queryForList(sqlBuilder.toString(), (SqlParameterSource)sqlParameterSource, (RowMapper)BeanPropertyRowMapper.newInstance(Function.class));
    }
}

