package com.xdja.cssp.as.service;

import com.xdja.cssp.as.service.model.Cert;
import com.xdja.cssp.as.service.model.ClientLoginReq;
import com.xdja.cssp.as.service.model.ResultBean;
import com.xdja.platform.rpc.RemoteService;

/**
 * 客户端登录服务相关接口
 * @author wyf
 *
 */
@RemoteService(serviceCode = AS.SERVICE_CODE)
public interface ILoginService {
	
	/**
	 * 根据SN查询名称证书信息
	 * @param sn 证书SN
	 * @param caAlg 算法，1-RSA;2-SM2
	 * @return 证书信息
	 */
	Cert queryCert(String sn, int caAlg);
	
	/**
	 * 单客户端登录
	 * @param req 请求参数
	 * @return 
	 */
	ResultBean singleClientLogin(ClientLoginReq req);

}
