package com.xdja.cssp.restful.auth.exception;

import org.springframework.http.HttpStatus;

/**
 * 加密异常
 * @author yk
 *
 */
public class EncryptException extends AuthException {

	/**
	 * @Fields serialVersionUID:
	 *
	 */
	private static final long serialVersionUID = -6749074349704953943L;

	public static final HttpStatus HTTP_STATUS = HttpStatus.INTERNAL_SERVER_ERROR;
	
	public EncryptException(String hostId,
			String requestId, String errCode, String message) {
		this(hostId, requestId, errCode, message, null);
	}
	
	public EncryptException(String hostId, String requestId, String errCode,
			String message, Throwable cause) {
		super(hostId, requestId, errCode, message, cause);
	}

	@Override
	public int getStatus() {
		return HTTP_STATUS.value();
	}
}
