package com.xdja.cssp.restful.auth.exception;

import org.springframework.http.HttpStatus;

/**
 * 无效的时间异常
 * @author yk
 *
 */
public class InvalidDateException extends AuthException {

	/**
	 * @Fields serialVersionUID:
	 *
	 */
	private static final long serialVersionUID = -4926703811347116508L;
	
	public static final HttpStatus HTTP_STATUS = HttpStatus.PRECONDITION_FAILED;
	
	public InvalidDateException(String hostId,
			String requestId, String errCode, String message) {
		this(hostId, requestId, errCode, message, null);
	}
	
	public InvalidDateException(String hostId, String requestId, String errCode,
			String message, Throwable cause) {
		super(hostId, requestId, errCode, message, cause);
	}

	@Override
	public int getStatus() {
		return HTTP_STATUS.value();
	}
}
