package com.xdja.cssp.restful.auth.exception;

import org.springframework.http.HttpStatus;

/**
 * 不匹配的签名异常
 * @author yk
 *
 */
public class NotMatchSignatureException extends AuthException {

	/**
	 * @Fields serialVersionUID:
	 *
	 */
	private static final long serialVersionUID = 7715738131239784279L;

	public static final HttpStatus HTTP_STATUS = HttpStatus.UNAUTHORIZED;
	
	public NotMatchSignatureException(String hostId,
			String requestId, String errCode, String message) {
		this(hostId, requestId, errCode, message, null);
	}
	
	public NotMatchSignatureException(String hostId, String requestId,
			String errCode, String message, Throwable cause) {
		super(hostId, requestId, errCode, message, cause);
	}

	@Override
	public int getStatus() {
		return HTTP_STATUS.value();
	}
}
