package com.xdja.cssp.restful.auth.exception;

import org.springframework.http.HttpStatus;

/**
 * 不支持的算法异常
 * @author yk
 *
 */
public class NotSupportAlgoException extends AuthException {

	/**
	 * 
	 */
	private static final long serialVersionUID = 5828722368805746792L;
	
	public static final HttpStatus HTTP_STATUS = HttpStatus.PRECONDITION_FAILED;
	
	public NotSupportAlgoException(String hostId,
			String requestId, String errCode, String message) {
		this(hostId, requestId, errCode, message, null);
	}
	
	
	public NotSupportAlgoException(String hostId, String requestId,
			String errCode, String message, Throwable cause) {
		super(hostId, requestId, errCode, message, cause);
	}


	@Override
	public int getStatus() {
		return HTTP_STATUS.value();
	}
}
