package com.xdja.cssp.restful.auth.exception;

import org.springframework.http.HttpStatus;

/**
 * 签名异常
 * @author yk
 *
 */
public class SignException extends AuthException {

	/**
	 * @Fields serialVersionUID:
	 *
	 */
	private static final long serialVersionUID = 2423578674239988601L;
	
	public static final HttpStatus HTTP_STATUS = HttpStatus.INTERNAL_SERVER_ERROR;
	
	public SignException(String hostId,
			String requestId, String errCode, String message) {
		this(hostId, requestId, errCode, message, null);
	}
	
	public SignException(String hostId, String requestId,
			String errCode, String message, Throwable cause) {
		super(hostId, requestId, errCode, message, cause);
	}

	@Override
	public int getStatus() {
		return HTTP_STATUS.value();
	}

}
