package com.xdja.cssp.restful.exception;


/**
 * 错误异常基类
 * @author zhouyj
 *
 */
public abstract class ApiException extends RuntimeException {
	
	//请求参数非法
	public static final String REQUEST_PARAMS_NOT_VALID = "request_params_not_valid";
	
	//请求参数非法
    public static final String REQUEST_PARAMS_ERROR = "request_params_not_valid";

	//服务器内部错误
	public static final String INTERNAL_SERVER_ERROR = "internal_server_error";

	//异常处理错误
	public static final String EXCEPTION_HANDLE_ERROR = "exception_handler_error";
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 6333214505149338388L;
	
	/**
	 * 服务主机标识
	 */
	private String hostId;
	
	/**
	 * 请求id
	 */
	private String requestId;
	
	/**
	 * 错误码
	 */
	private String errCode;
	
	/**
	 * 错误描述
	 */
	private String message;
	
	
	private Throwable cause;


	public String getHostId() {
		return hostId;
	}

	public void setHostId(String hostId) {
		this.hostId = hostId;
	}

	public String getRequestId() {
		return requestId;
	}

	public void setRequestId(String requestId) {
		this.requestId = requestId;
	}

	public String getErrCode() {
		return errCode;
	}

	public void setErrCode(String errCode) {
		this.errCode = errCode;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}
	
	public Throwable getCause() {
		return cause;
	}

	public void setCause(Throwable cause) {
		this.cause = cause;
	}

	public ApiException(String hostId, String requestId,
			String errCode, String message, Throwable cause) {
		super();
		this.hostId = hostId;
		this.requestId = requestId;
		this.errCode = errCode;
		this.message = message;
		this.cause = cause;
	}


	public abstract int getStatus();

	
}
